/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryResponseElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryType;
import com.sun.identity.liberty.ws.idpp.jaxb.ResourceIDElement;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class IDPPUtils {
    public static Debug debug = Debug.getInstance((String)"amLibertyIDPP");
    public static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"amLibertyPersonalProfile");
    private static ObjectFactory idppFactory = new ObjectFactory();
    private static final String idppPrefix = "pp";
    private static HashMap idppElementTypes = new HashMap();
    public static HashMap idppIDSMap = new HashMap();
    private static DocumentBuilderFactory dbf = null;
    private static DocumentBuilder documentBuilder = null;
    private static Marshaller marshaller = null;
    private static Unmarshaller unmarshaller = null;

    private static void getIDPPElementsMap() {
        idppElementTypes.put("PP", new Integer(1));
        idppElementTypes.put("InformalName", new Integer(2));
        idppElementTypes.put("LInformalName", new Integer(3));
        idppElementTypes.put("CommonName", new Integer(4));
        idppElementTypes.put("LegalIdentity", new Integer(5));
        idppElementTypes.put("EmploymentIdentity", new Integer(6));
        idppElementTypes.put("AddressCard", new Integer(7));
        idppElementTypes.put("MsgContact", new Integer(8));
        idppElementTypes.put("Facade", new Integer(9));
        idppElementTypes.put("Demographics", new Integer(10));
        idppElementTypes.put("SignKey", new Integer(11));
        idppElementTypes.put("EncryptKey", new Integer(12));
        idppElementTypes.put("EmergencyContact", new Integer(13));
        idppElementTypes.put("LEmergencyContact", new Integer(14));
        idppElementTypes.put("FN", new Integer(15));
        idppElementTypes.put("SN", new Integer(19));
        idppElementTypes.put("CN", new Integer(17));
        idppElementTypes.put("MN", new Integer(16));
        idppElementTypes.put("AltCN", new Integer(21));
        idppElementTypes.put("PersonalTitle", new Integer(18));
        idppElementTypes.put("AnalyzedName", new Integer(20));
        idppElementTypes.put("InformalName", new Integer(2));
        idppElementTypes.put("LegalName", new Integer(22));
        idppElementTypes.put("DOB", new Integer(23));
        idppElementTypes.put("MaritalStatus", new Integer(25));
        idppElementTypes.put("Gender", new Integer(24));
        idppElementTypes.put("AltID", new Integer(26));
        idppElementTypes.put("IDType", new Integer(27));
        idppElementTypes.put("IDValue", new Integer(28));
        idppElementTypes.put("VAT", new Integer(29));
        idppElementTypes.put("JobTitle", new Integer(30));
        idppElementTypes.put("O", new Integer(31));
        idppElementTypes.put("AltO", new Integer(32));
        idppElementTypes.put("Extension", new Integer(33));
    }

    public static QueryElement createQueryElement(List list, String string, boolean bl) throws JAXBException, IDPPException {
        QueryElement queryElement = idppFactory.createQueryElement();
        if (list == null || string == null || list.size() == 0) {
            debug.error("IDPPUtils:createQueryElement: Either query expressions or resource id is null.");
            throw new IDPPException("ResourceID or query expressions are null");
        }
        queryElement.setResourceID(IDPPUtils.createResourceIDElement(string));
        queryElement.setId(SAMLUtilsCommon.generateID());
        int n = 0;
        while (n < list.size()) {
            QueryType.QueryItemType queryItemType = idppFactory.createQueryTypeQueryItemType();
            queryItemType.setId(SAMLUtilsCommon.generateID());
            queryItemType.setIncludeCommonAttributes(bl);
            queryItemType.setItemID(SAMLUtilsCommon.generateID());
            queryItemType.setSelect(IDPPUtils.addIDPPPrefix((String)list.get(n)));
            queryElement.getQueryItem().add(queryItemType);
            ++n;
        }
        return queryElement;
    }

    public static List getQueryDataElements(QueryResponseElement queryResponseElement) throws JAXBException, IDPPException {
        if (queryResponseElement == null) {
            debug.error("IDPPUtils:getQueryDataElements:response is null");
            throw new IDPPException("response is null");
        }
        return queryResponseElement.getData();
    }

    public static ResourceIDElement createResourceIDElement(String string) throws JAXBException, IDPPException {
        if (string == null) {
            debug.error("IDPPUtils:ResourceIDType: Resource id is null");
            throw new IDPPException("ResourceID is null");
        }
        ResourceIDElement resourceIDElement = idppFactory.createResourceIDElement();
        resourceIDElement.setValue(string);
        return resourceIDElement;
    }

    private static String addIDPPPrefix(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.indexOf("/") == -1) {
            debug.error("IDPPUtils:addIDPPPrefix:Not a valid expression");
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "/pp:" + string2;
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String getExpressionContext(String string) {
        if (string == null || string.indexOf("/") == -1) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf(":")) == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static Map getUserAttributes(SSOToken sSOToken, String string, Set set) throws IDPPException {
        if (sSOToken == null || string == null || set == null) {
            debug.error("IDPPUtils:getUserAttributes: Null values");
            throw new IDPPException("null values.");
        }
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string);
            return aMIdentity.getAttributes(set);
        }
        catch (IdRepoException idRepoException) {
            debug.error("IDPPUtils:getUserAttributes: Error retrieving user attributes.", (Throwable)idRepoException);
            throw new IDPPException(idRepoException);
        }
        catch (SSOException sSOException) {
            debug.error("IDPPUtils:getUserAttributes: Invalid credentials.");
            throw new IDPPException(sSOException);
        }
    }

    public static Map getUserAttributesByteArray(SSOToken sSOToken, String string, Set set) throws IDPPException {
        if (sSOToken == null || string == null || set == null) {
            debug.error("IDPPUtils:getUserByteAttributes: Null values");
            throw new IDPPException("null values.");
        }
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string);
            return aMIdentity.getBinaryAttributes(set);
        }
        catch (IdRepoException idRepoException) {
            debug.error("IDPPUtils:getUserAttributes: Error retrieving user attributes.", (Throwable)idRepoException);
            throw new IDPPException(idRepoException);
        }
        catch (SSOException sSOException) {
            debug.error("IDPPUtils:getUserAttributes: Invalid credentials.");
            throw new IDPPException(sSOException);
        }
    }

    public static void setUserAttributesByteArray(SSOToken sSOToken, String string, Map map) throws IDPPException {
        if (sSOToken == null || string == null || map == null || map.isEmpty()) {
            debug.error("IDPPUtils:setUserAttributesByteArray: Null values");
            throw new IDPPException(bundle.getString("nullValues"));
        }
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string);
            aMIdentity.setBinaryAttributes(map);
            aMIdentity.store();
        }
        catch (IdRepoException idRepoException) {
            debug.error("IDPPUtils:storeUserAttributesByteArray:Error while storing user attributes.", (Throwable)idRepoException);
            throw new IDPPException(idRepoException);
        }
        catch (SSOException sSOException) {
            debug.error("IDPPUtils:storeUserAttributesByteArray:Invalid credentials.");
            throw new IDPPException(sSOException);
        }
    }

    public static void setUserAttributes(SSOToken sSOToken, String string, Map map) throws IDPPException {
        if (sSOToken == null || string == null || map == null || map.isEmpty()) {
            debug.error("IDPPUtils:setUserAttributes: Null values");
            throw new IDPPException("null values.");
        }
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string);
            aMIdentity.setAttributes(map);
            aMIdentity.store();
        }
        catch (IdRepoException idRepoException) {
            debug.error("IDPPUtils:storeUserAttributes:Error while storinguser attributes.", (Throwable)idRepoException);
            throw new IDPPException(idRepoException);
        }
        catch (SSOException sSOException) {
            debug.error("IDPPUtils:storeUserAttributes:Invalid credentials.");
            throw new IDPPException(sSOException);
        }
    }

    public static void removeUserAttributes(SSOToken sSOToken, String string, Set set) throws IDPPException {
        if (sSOToken == null || string == null || set == null || set.isEmpty()) {
            debug.error("IDPPUtils:removeUserAttributes:Null Values");
            throw new IDPPException("null values.");
        }
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string);
            aMIdentity.removeAttributes(set);
        }
        catch (IdRepoException idRepoException) {
            debug.error("IDPPUtils:removeUserAttributes:Error while removinguser attributes.", (Throwable)idRepoException);
            throw new IDPPException(idRepoException);
        }
        catch (SSOException sSOException) {
            debug.error("IDPPUtils:removeUserAttributes:Invalid credentials.");
            throw new IDPPException(sSOException);
        }
    }

    public static boolean checkForUserAttributes(SSOToken sSOToken, String string, Set set) throws IDPPException {
        Map map = IDPPUtils.getUserAttributes(sSOToken, string, set);
        return map != null && !map.isEmpty();
    }

    public static int getIDPPElementType(String string) {
        if (string == null) {
            debug.error("IDPPUtils:getIDPPElementType:InvalidElementType");
            return -1;
        }
        Integer n = (Integer)idppElementTypes.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static boolean isUserExists(SSOToken sSOToken, String string) {
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string);
            return aMIdentity != null;
        }
        catch (IdRepoException idRepoException) {
            if (debug.messageEnabled()) {
                debug.message("IDPPUtils.isUserExists: Userentry is null", (Throwable)idRepoException);
            }
            return false;
        }
    }

    public static ObjectFactory getIDPPFactory() {
        return idppFactory;
    }

    public static Marshaller getMarshaller() {
        return marshaller;
    }

    public static Unmarshaller getUnmarshaller() {
        return unmarshaller;
    }

    public static DocumentBuilder getDocumentBuilder() {
        return documentBuilder;
    }

    public static String getResourceExpression(String string) {
        if (string == null || string.indexOf("/") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("[");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if (string2 == null) continue;
            n = string2.indexOf(":");
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            if (string2 == null) continue;
            stringBuffer.append("/").append(string2);
        }
        return stringBuffer.toString();
    }

    public static String getResourceID(String string) {
        IDPPServiceManager iDPPServiceManager = IDPPServiceManager.getInstance();
        ResourceIDMapper resourceIDMapper = iDPPServiceManager.getResourceIDMapper();
        return resourceIDMapper.getResourceID(iDPPServiceManager.getProviderID(), string);
    }

    static {
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            documentBuilder = dbf.newDocumentBuilder();
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.sun.identity.liberty.ws.idpp.jaxb:com.sun.identity.liberty.ws.idpp.plugin.jaxb:com.sun.identity.liberty.ws.common.jaxb.xmlsig");
            marshaller = jAXBContext.createMarshaller();
            unmarshaller = jAXBContext.createUnmarshaller();
            IDPPUtils.getIDPPElementsMap();
        }
        catch (Exception exception) {
            debug.error("IDPPCommonName:static initialization Failed.", (Throwable)exception);
        }
    }
}

