/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.liberty.ws.dst.DSTModification;
import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPAddressCard;
import com.sun.identity.liberty.ws.idpp.container.IDPPCommonName;
import com.sun.identity.liberty.ws.idpp.container.IDPPDemographics;
import com.sun.identity.liberty.ws.idpp.container.IDPPEmergencyContact;
import com.sun.identity.liberty.ws.idpp.container.IDPPEmploymentIdentity;
import com.sun.identity.liberty.ws.idpp.container.IDPPEncryptKey;
import com.sun.identity.liberty.ws.idpp.container.IDPPExtensionContainer;
import com.sun.identity.liberty.ws.idpp.container.IDPPFacade;
import com.sun.identity.liberty.ws.idpp.container.IDPPInformalName;
import com.sun.identity.liberty.ws.idpp.container.IDPPLegalIdentity;
import com.sun.identity.liberty.ws.idpp.container.IDPPMsgContact;
import com.sun.identity.liberty.ws.idpp.container.IDPPSignKey;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPContainer;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.org.apache.xpath.internal.domapi.XPathEvaluatorImpl;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;

public class PersonalProfile {
    private static final String SLASH = "/";
    private static final String LEFTBR = "[";
    private static final String COLON = ":";
    private static SSOToken adminToken = null;
    private static IDPPServiceManager serviceManager = null;

    public PersonalProfile() {
        IDPPUtils.debug.message("PersonalProfile:Init");
    }

    public Map queryData(Object object, String string, List list, Map map, Document document) throws IDPPException {
        Object object2;
        IDPPUtils.debug.message("PersonalProfile: query init");
        if (object == null || string == null || list == null || document == null) {
            IDPPUtils.debug.error("PersonalProfile:queryData: null input");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            object2 = (SSOToken)object;
            SSOTokenManager.getInstance().validateToken(object2);
        }
        catch (SSOException sSOException) {
            IDPPUtils.debug.error("PersonalProfile:queryData:Invalid WSCcredentials");
            throw new IDPPException(IDPPUtils.bundle.getString("invalidWSCCredentials"));
        }
        object2 = this.getUserDN(string);
        if (object2 == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile: queryData:userDNis null for a given resourceID.");
            }
            throw new IDPPException(IDPPUtils.bundle.getString("noResourceID"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:queryData: userDN=" + (String)object2);
        }
        Map map2 = null;
        try {
            map2 = this.getUserData((String)object2, list);
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("PersonalProfile:queryData:Error whileretrieving user data.", (Throwable)iDPPException);
            throw new IDPPException(iDPPException);
        }
        if (map2 == null || map2.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:queryData:no data:for the requested pp attributes.");
            }
            throw new IDPPException(IDPPUtils.bundle.getString("noData"));
        }
        if (map != null && !map.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile.queryData():  Contents of Interaction Map " + map.toString());
            }
            map2 = this.updateUserDataMap(map2, map);
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:queryData:requested Data " + map2);
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IDPPContainer iDPPContainer;
            DSTQueryItem dSTQueryItem = (DSTQueryItem)iterator.next();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string2 = dSTQueryItem.getSelect();
            String string3 = this.getContainerFromSelect(string2);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:queryData: Containerprocessing:" + string3);
            }
            if (string3 == null || (iDPPContainer = this.getIDPPContainer(string3, (String)object2)) == null) continue;
            Document document2 = null;
            try {
                document2 = iDPPContainer.toXMLDocument(map2);
            }
            catch (IDPPException iDPPException) {
                IDPPUtils.debug.error("PersonalProfile:queryData:Error whileconverting container to an XML document.", (Throwable)iDPPException);
                throw new IDPPException(iDPPException);
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:queryData: Containerxml doc:" + XMLUtils.print((Node)document2.getDocumentElement()));
            }
            Element element = document.getDocumentElement();
            element.setAttribute("xmlns:" + serviceManager.getPPExtensionPrefix(), "http://www.sun.com/identity/liberty/pp");
            XPathEvaluatorImpl xPathEvaluatorImpl = new XPathEvaluatorImpl(document2);
            XPathNSResolver xPathNSResolver = new XPathEvaluatorImpl(document).createNSResolver((Node)element);
            string2 = this.replacePrefix(string2);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:queryData: queryexpression before applying Xpath:" + string2);
            }
            XPathResult xPathResult = null;
            try {
                xPathResult = (XPathResult)xPathEvaluatorImpl.evaluate(string2, document2, xPathNSResolver, (short)7, null);
            }
            catch (DOMException dOMException) {
                IDPPUtils.debug.error("PersonalProfile.queryData:Name space resolving issue.", (Throwable)dOMException);
                continue;
            }
            catch (XPathException xPathException) {
                IDPPUtils.debug.error("PersonalProfile.queryData:Invalid expression.", (Throwable)xPathException);
                continue;
            }
            if (xPathResult == null) {
                IDPPUtils.debug.message("PersonalProfile.queryData:null result");
                continue;
            }
            int n = 0;
            while (n < xPathResult.getSnapshotLength()) {
                Node node = xPathResult.snapshotItem(n);
                try {
                    arrayList.add(IDPPUtils.getUnmarshaller().unmarshal(node));
                }
                catch (JAXBException jAXBException) {
                    IDPPUtils.debug.error("PersonalProfile:queryData:JAXBError while unmarshalling the results.", (Throwable)jAXBException);
                }
                ++n;
            }
            hashMap.put(dSTQueryItem, arrayList);
        }
        return hashMap;
    }

    private String removePPFromExpression(String string) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:removePPExp:Init: orignal expression: " + string);
        }
        String string2 = string;
        int n = string.indexOf(SLASH);
        if (n == -1) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:removePPExp: The query expression is invalid.");
            }
            return string;
        }
        if (string != null) {
            if ((n = (string = string.substring(n + 1)).indexOf(SLASH)) == -1) {
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("PersonalProfile:removePPExp:The expression looks as the top container only.");
                }
                return string2;
            }
            if (string != null) {
                string = string.substring(n);
            }
        }
        return string;
    }

    private String replacePrefix(String string) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:replacePrefix:Select =" + string);
        }
        if (string == null || string.indexOf(SLASH) == -1) {
            IDPPUtils.debug.error("PersonalProfile:replacePrefix:Invalid expression.");
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, SLASH);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(COLON);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            if (string2 != null && string2.indexOf("PPISExtension") != -1) {
                stringBuffer.append(SLASH).append(serviceManager.getPPExtensionPrefix());
                stringBuffer.append(COLON).append(string2);
                continue;
            }
            if (string2 == null) continue;
            stringBuffer.append(SLASH).append(serviceManager.getIDPPPrefix());
            stringBuffer.append(COLON).append(string2);
        }
        return stringBuffer.toString();
    }

    private String getContainerFromSelect(String string) {
        StringTokenizer stringTokenizer;
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:getContainerFromSel:Init: selectexpression: " + string);
        }
        if ((stringTokenizer = new StringTokenizer(string, SLASH)) == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:getContainerFrom Invalid select expression.");
            }
            return string;
        }
        if (stringTokenizer.countTokens() == 1) {
            return "PP";
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        int n = string2.indexOf(LEFTBR);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if (string2 == null) {
            return string;
        }
        n = string2.indexOf(COLON);
        if (n != -1) {
            string2 = string2.substring(n + 1, string2.length());
        }
        return string2;
    }

    private IDPPContainer getIDPPContainer(String string, String string2) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:getIDPPContainer:Init: ContainerType: " + string);
        }
        if (string == null) {
            return null;
        }
        IDPPContainer iDPPContainer = null;
        Map map = serviceManager.getContainerClasses();
        if (map.containsKey(string)) {
            iDPPContainer = (IDPPContainer)map.get(string);
            iDPPContainer.setUserDN(string2);
            return iDPPContainer;
        }
        int n = IDPPUtils.getIDPPElementType(string);
        switch (n) {
            case 1: {
                break;
            }
            case 4: {
                iDPPContainer = new IDPPCommonName();
                break;
            }
            case 2: {
                iDPPContainer = new IDPPInformalName();
                break;
            }
            case 5: {
                iDPPContainer = new IDPPLegalIdentity();
                break;
            }
            case 6: {
                iDPPContainer = new IDPPEmploymentIdentity();
                break;
            }
            case 11: {
                iDPPContainer = new IDPPSignKey();
                break;
            }
            case 12: {
                iDPPContainer = new IDPPEncryptKey();
                break;
            }
            case 33: {
                iDPPContainer = new IDPPExtensionContainer();
                break;
            }
            case 7: {
                iDPPContainer = new IDPPAddressCard();
                break;
            }
            case 8: {
                iDPPContainer = new IDPPMsgContact();
                break;
            }
            case 9: {
                iDPPContainer = new IDPPFacade();
                break;
            }
            case 10: {
                iDPPContainer = new IDPPDemographics();
                break;
            }
            case 13: {
                iDPPContainer = new IDPPEmergencyContact();
                break;
            }
            default: {
                IDPPUtils.debug.error("PersonalProfile:getIDPPContainer:Invalid container type");
            }
        }
        iDPPContainer.setUserDN(string2);
        return iDPPContainer;
    }

    private Map getUserData(String string, List list) throws IDPPException {
        Object object;
        if (string == null || list == null) {
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap();
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IDPPContainer iDPPContainer;
            object = (DSTQueryItem)iterator.next();
            String string2 = ((DSTQueryItem)object).getSelect();
            String string3 = this.getContainerFromSelect(string2);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile:getUserData: Containerprocessing:" + string3);
            }
            if (string3 == null || (iDPPContainer = this.getIDPPContainer(string3, string)) == null) continue;
            Set set = iDPPContainer.getContainerAttributes();
            if (iDPPContainer.hasBinaryAttributes()) {
                Map map = IDPPUtils.getUserAttributesByteArray(adminToken, string, set);
                caseInsensitiveHashMap.putAll(map);
                continue;
            }
            if (set == null || set.isEmpty()) continue;
            hashSet.addAll(set);
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:getUserData: Attributes to be retrieved." + hashSet);
        }
        if (hashSet != null && !hashSet.isEmpty()) {
            object = IDPPUtils.getUserAttributes(adminToken, string, hashSet);
            caseInsensitiveHashMap.putAll(object);
        }
        return caseInsensitiveHashMap;
    }

    public boolean modifyData(Object object, String string, List list, Map map, Document document) throws IDPPException {
        Object object2;
        if (object == null || string == null || list == null || list.isEmpty()) {
            IDPPUtils.debug.error("PersonalProfile:modifyData:null input");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParamters"));
        }
        try {
            object2 = (SSOToken)object;
            SSOTokenManager.getInstance().validateToken(object2);
        }
        catch (SSOException sSOException) {
            IDPPUtils.debug.error("PersonalProfile:queryData:Invalid WSCcredentials");
            throw new IDPPException(IDPPUtils.bundle.getString("invalidWSCCredentials"));
        }
        object2 = this.getUserDN(string);
        if (object2 == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile: modifyData:userDNis null for a given resourceID.");
            }
            throw new IDPPException(IDPPUtils.bundle.getString("noResourceID"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:modifyData:userDN =" + (String)object2);
        }
        Map map2 = new HashMap();
        Map map3 = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DSTModification dSTModification = (DSTModification)iterator.next();
            String string2 = dSTModification.getSelect();
            boolean bl = dSTModification.isOverrideAllowed();
            List list2 = dSTModification.getNewDataValue();
            String string3 = this.getContainerFromSelect(string2);
            IDPPContainer iDPPContainer = this.getIDPPContainer(string3, (String)object2);
            if (iDPPContainer == null) {
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("PersonalProfile:modifyData:The given select expression is not in supported containers");
                }
                return false;
            }
            try {
                if (!bl && IDPPUtils.checkForUserAttributes(adminToken, (String)object2, iDPPContainer.getContainerAttributesForSelect(string2))) {
                    if (IDPPUtils.debug.messageEnabled()) {
                        IDPPUtils.debug.message("PersonalProfile:modifyData:override set to false and data Already exists.");
                    }
                    return false;
                }
                Map map4 = iDPPContainer.getDataMapForSelect(string2, list2);
                if (iDPPContainer.hasBinaryAttributes()) {
                    map3 = map4;
                    continue;
                }
                if (map4 != null) {
                    map2.putAll(map4);
                }
                if (map == null || map.isEmpty()) continue;
                map2 = this.updateUserDataMap(map2, map);
            }
            catch (IDPPException iDPPException) {
                IDPPUtils.debug.error("PersonalProfile:modifyData: error whileconverting the data into a data map.", (Throwable)iDPPException);
                return false;
            }
        }
        if (map3 != null && !map3.isEmpty()) {
            try {
                IDPPUtils.setUserAttributesByteArray(adminToken, (String)object2, map3);
            }
            catch (IDPPException iDPPException) {
                IDPPUtils.debug.error("PersonalProfile:modifyMap:Error whilemodifying the user data.", (Throwable)iDPPException);
                return false;
            }
        }
        if (map2 == null || map2.isEmpty()) {
            IDPPUtils.debug.message("PersonalProfile:modifyData:map is null");
            return !map3.isEmpty();
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile:modifyData:data to be modified" + map2);
        }
        try {
            IDPPUtils.setUserAttributes(adminToken, (String)object2, map2);
            return true;
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("PersonalProfile:modifyMap:Error whilemodifying the user data.", (Throwable)iDPPException);
            return false;
        }
    }

    public boolean isSelectDataSupported(String string) {
        IDPPUtils.debug.message("PersonalProfile:isSelectDataSupported:Init");
        String string2 = this.getContainerFromSelect(string);
        int n = string2.indexOf(LEFTBR);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile.isSelectDataSupported:  Accessing container = " + string2);
        }
        Set set = serviceManager.getSupportedContainers();
        if (string2 == null || set == null || set.isEmpty()) {
            return false;
        }
        return set.contains(string2);
    }

    public boolean isResourceIDValid(String string) {
        IDPPUtils.debug.message("PersonalProfile:isResourceIDValid:Init");
        ResourceIDMapper resourceIDMapper = serviceManager.getResourceIDMapper();
        if (resourceIDMapper == null) {
            if (IDPPUtils.debug.warningEnabled()) {
                IDPPUtils.debug.warning("PersonalProfile.isResourceIDValid.unable to get resoureid mapper");
            }
            return false;
        }
        String string2 = resourceIDMapper.getUserID(serviceManager.getProviderID(), string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PersonalProfile.isResourceIDValid." + string2);
        }
        return IDPPUtils.isUserExists(adminToken, string2);
    }

    public String getAuthZAction(Object object, String string, String string2, Map map) throws IDPPException {
        IDPPUtils.debug.message("PersonalProfile.getAuthorizationMap:Init");
        if (object == null || string == null || string2 == null) {
            IDPPUtils.debug.error("PersonalProfile.getAuthZAction:null vals");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        if (string.equals("QUERY") && !serviceManager.isQueryPolicyEvalRequired()) {
            return "allow";
        }
        if (string.equals("MODIFY") && !serviceManager.isModifyPolicyEvalRequired()) {
            return "allow";
        }
        try {
            Authorizer authorizer = serviceManager.getAuthorizer();
            return (String)authorizer.getAuthorizationDecision(object, string, string2, map);
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PersonalProfile.getAuthZAction:Exception while getting authorization info");
            throw new IDPPException(exception);
        }
    }

    public String getUserDN(String string) {
        IDPPUtils.debug.message("PersonalProfile:getUserDN:Init");
        ResourceIDMapper resourceIDMapper = serviceManager.getResourceIDMapper();
        if (resourceIDMapper == null) {
            return null;
        }
        return resourceIDMapper.getUserID(serviceManager.getProviderID(), string);
    }

    private Map updateUserDataMap(Map map, Map map2) {
        if (map2 == null || map == null || map2.isEmpty() || map.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PersonalProfile.updateUserDataMap:Interacted data or the user data map is empty");
            }
            return map;
        }
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!map.containsKey(string.toLowerCase())) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("PersonalProfile.updateUserDataMap:Interacted key " + string + " isnotPart of the query");
                continue;
            }
            String string2 = (String)map2.get(string);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string2);
            map.put(string.toLowerCase(), hashSet);
        }
        return map;
    }

    static {
        try {
            serviceManager = IDPPServiceManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            adminToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PersonalProfile:Initialization failed", (Throwable)exception);
        }
    }
}

