/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTModification;
import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.dst.service.DSTRequestHandler;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.PPInteractionHelper;
import com.sun.identity.liberty.ws.idpp.PersonalProfile;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.jaxb.ModifyElement;
import com.sun.identity.liberty.ws.idpp.jaxb.ModifyResponseElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryResponseElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryResponseType;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryType;
import com.sun.identity.liberty.ws.idpp.jaxb.StatusType;
import com.sun.identity.liberty.ws.interaction.InteractionManager;
import com.sun.identity.liberty.ws.interaction.InteractionSOAPFaultException;
import com.sun.identity.liberty.ws.interaction.InteractionUtils;
import com.sun.identity.liberty.ws.interaction.JAXBObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryElement;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryType;
import com.sun.identity.liberty.ws.interaction.jaxb.InteractionResponseElement;
import com.sun.identity.liberty.ws.interaction.jaxb.TextElement;
import com.sun.identity.liberty.ws.interfaces.ServiceInstanceUpdate;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.NamespacePrefixMapperImpl;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultDetail;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.ServiceInstanceUpdateHeader;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PPRequestHandler
extends DSTRequestHandler {
    private PersonalProfile pp = new PersonalProfile();
    private String logMsg = null;

    public Object processDSTRequest(Object object, Message message, Message message2) throws SOAPFaultException, DSTException {
        IDPPUtils.debug.message("PPRequestHandler:processRequest:Init");
        try {
            Object object2;
            IDPPServiceManager iDPPServiceManager = IDPPServiceManager.getInstance();
            String string = iDPPServiceManager.getProviderID();
            ProviderHeader providerHeader = new ProviderHeader(string);
            message2.setProviderHeader(providerHeader);
            if (iDPPServiceManager.isServiceInstanceUpdateEnabled()) {
                object2 = this.getServiceInstanceUpdateHeader();
                message2.setServiceInstanceUpdateHeader((ServiceInstanceUpdateHeader)object2);
            }
            if (object instanceof QueryElement) {
                object2 = (QueryElement)object;
                Document document = IDPPUtils.getDocumentBuilder().newDocument();
                IDPPUtils.getMarshaller().setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                IDPPUtils.getMarshaller().marshal(object2, (Node)document);
                return this.processQueryRequest((QueryElement)object2, string, message, document);
            }
            if (object instanceof ModifyElement) {
                object2 = (ModifyElement)object;
                Document document = IDPPUtils.getDocumentBuilder().newDocument();
                IDPPUtils.getMarshaller().setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                IDPPUtils.getMarshaller().marshal(object2, (Node)document);
                return this.processModifyRequest((ModifyElement)object2, string, message, document);
            }
            IDPPUtils.debug.error("PPRequestHandler:processRequest:invalid Request.");
            throw new DSTException(IDPPUtils.bundle.getString("invalidRequest"));
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("PPRequestHandler:processRequest fail", (Throwable)iDPPException);
            throw new DSTException(iDPPException);
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("PPRequestHandler:processRequest fail", (Throwable)jAXBException);
            throw new DSTException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
        catch (SOAPBindingException sOAPBindingException) {
            IDPPUtils.debug.error("PPRequestHandler:processRequest fail", (Throwable)sOAPBindingException);
            throw new DSTException(sOAPBindingException);
        }
    }

    public QueryResponseElement processQueryRequest(QueryElement queryElement, String string, Message message, Document document) throws IDPPException, SOAPFaultException {
        Map map;
        String[] stringArray;
        Object object;
        List list;
        Object object2;
        IDPPUtils.debug.message("PPRequestHandler:processQueryRequest:Init");
        if (queryElement == null || document == null) {
            IDPPUtils.debug.error("PPRequestHandler:processQueryRequest:null values ");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processQueryRequest:request received:" + XMLUtils.print((Node)document.getDocumentElement()));
        }
        if ((object2 = queryElement.getResourceID()) == null) {
            object2 = queryElement.getEncryptedResourceID();
        }
        QueryResponseElement queryResponseElement = this.getQueryResponse(queryElement);
        String string2 = this.getResourceID(object2, string, "urn:liberty:id-sis-pp:2003-08");
        if (string2 == null || !this.pp.isResourceIDValid(string2)) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler:processQueryRequest: resource id is invalid.");
            }
            queryResponseElement.setStatus(this.setStatusType(false, "InvalidResourceID", IDPPUtils.bundle.getString("invalidResourceID"), null));
            return queryResponseElement;
        }
        if (LogUtil.isLogEnabled()) {
            this.logMsg = IDPPUtils.bundle.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + " " + IDPPUtils.bundle.getString("providerID") + "=" + string + " " + IDPPUtils.bundle.getString("resourceID") + "=" + string2 + " " + IDPPUtils.bundle.getString("securityMechID") + "=" + message.getAuthenticationMechanism() + " ";
        }
        if ((list = queryElement.getQueryItem()).size() == 0) {
            if (IDPPUtils.debug.warningEnabled()) {
                IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: The request does not have any query items.");
            }
            queryResponseElement.setStatus(this.setStatusType(false, "UnexpectedError", IDPPUtils.bundle.getString("nullQueryItems"), null));
            return queryResponseElement;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap hashMap2 = new HashMap();
        ArrayList<DSTQueryItem> arrayList = new ArrayList<DSTQueryItem>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object3;
            boolean bl = true;
            object = (QueryType.QueryItemType)list.get(n2);
            stringArray = object.getSelect();
            String string3 = object.getItemID();
            if (string3 == null || string3.equals("")) {
                string3 = object.getId();
            }
            if (stringArray == null || stringArray.length() == 0) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: There is no Select in the request.");
                }
                queryResponseElement.setStatus(this.setStatusType(false, "MissingSelect", IDPPUtils.bundle.getString("missingSelect"), string3));
                bl = false;
            }
            if (!this.pp.isSelectDataSupported((String)stringArray)) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: Data not supported");
                }
                queryResponseElement.setStatus(this.setStatusType(false, "InvalidSelect", IDPPUtils.bundle.getString("invalidSelect"), string3));
                bl = false;
            }
            String string4 = IDPPUtils.getResourceExpression((String)stringArray);
            String string5 = this.pp.getAuthZAction(message.getToken(), "QUERY", string4, this.getPolicyEnvMap(string2, message));
            if (string5 == null || string5.equalsIgnoreCase("deny")) {
                queryResponseElement.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("notAuthorized"), string3));
                if (LogUtil.isLogEnabled()) {
                    object3 = new String[]{string2};
                    LogUtil.error(Level.INFO, "PP_Query_Failure", (String[])object3);
                }
            } else {
                String[] stringArray2;
                if (string5.equalsIgnoreCase("interactForConsent")) {
                    if (this.isInteractionResponseExists(message)) {
                        if (!this.processInteractionConsentResponse(true, message, (String)stringArray)) {
                            if (LogUtil.isLogEnabled()) {
                                object3 = new String[]{string2};
                                LogUtil.error(Level.INFO, "PP_Interaction_Failure", (String[])object3);
                            }
                            queryResponseElement.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("interactionFailed"), string3));
                            bl = false;
                        }
                    } else {
                        hashMap.put(string4, string5);
                    }
                } else if (string5.equalsIgnoreCase("interactForValue")) {
                    if (this.isInteractionResponseExists(message)) {
                        object3 = this.processInteractionValueResponse(true, message, (String)stringArray);
                        if (object3 == null || object3.isEmpty()) {
                            if (LogUtil.isLogEnabled()) {
                                stringArray2 = new String[]{string2};
                                LogUtil.error(Level.INFO, "PP_Interaction_Failure", stringArray2);
                            }
                            queryResponseElement.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("interactionFailed"), string3));
                            bl = false;
                        } else {
                            hashMap2.putAll(object3);
                        }
                    } else {
                        hashMap.put(string4, string5);
                    }
                }
                if (bl) {
                    object3 = object.getChangedSince();
                    stringArray2 = null;
                    if (object3 != null) {
                        stringArray2 = ((Calendar)object3).getTime();
                    }
                    DSTQueryItem dSTQueryItem = new DSTQueryItem((String)stringArray, object.isIncludeCommonAttributes(), (Date)stringArray2, null);
                    dSTQueryItem.setId(object.getId());
                    dSTQueryItem.setItemID(object.getItemID());
                    arrayList.add(dSTQueryItem);
                }
            }
            ++n2;
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            this.initInteraction(true, hashMap, message);
        }
        if ((object = this.getData(map = this.pp.queryData(message.getToken(), string2, arrayList, hashMap2, document))) != null && !object.isEmpty()) {
            queryResponseElement.getData().addAll(object);
        }
        if (LogUtil.isLogEnabled()) {
            stringArray = new String[]{string2};
            LogUtil.access(Level.INFO, "PP_Query_Success", stringArray);
        }
        return queryResponseElement;
    }

    private List getData(Map map) throws IDPPException {
        IDPPUtils.debug.message("PPRequestHandler:getData:Init");
        ArrayList<QueryResponseType.DataType> arrayList = new ArrayList<QueryResponseType.DataType>();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            QueryResponseType.DataType dataType = null;
            try {
                dataType = IDPPUtils.getIDPPFactory().createQueryResponseTypeDataType();
            }
            catch (JAXBException jAXBException) {
                IDPPUtils.debug.error("PPRequestHandler:getData:jaxb fail", (Throwable)jAXBException);
                throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
            }
            DSTQueryItem dSTQueryItem = (DSTQueryItem)iterator.next();
            List list = (List)map.get(dSTQueryItem);
            if (list.isEmpty()) continue;
            dataType.getAny().addAll(list);
            dataType.setItemIDRef(dSTQueryItem.getItemID());
            dataType.setId(dSTQueryItem.getId());
            arrayList.add(dataType);
        }
        return arrayList;
    }

    private StatusType setStatusType(boolean bl, String string, String string2, String string3) throws IDPPException {
        IDPPUtils.debug.message("PPRequestHandler:setStatusType:Init");
        if (string == null) {
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            StatusType statusType = IDPPUtils.getIDPPFactory().createStatusType();
            if (bl) {
                QName qName = new QName("urn:liberty:id-sis-pp:2003-08", string);
                statusType.setCode(qName);
            } else {
                QName qName = new QName("urn:liberty:id-sis-pp:2003-08", "Failed");
                statusType.setCode(qName);
                StatusType statusType2 = IDPPUtils.getIDPPFactory().createStatusType();
                QName qName2 = new QName("urn:liberty:id-sis-pp:2003-08", string);
                statusType2.setCode(qName2);
                if (string2 != null) {
                    statusType2.setComment(string2);
                }
                if (string3 != null) {
                    statusType2.setRef(string3);
                }
                statusType.setStatus(statusType2);
            }
            return statusType;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("PPRequestHandler:setStatusType:jaxb failure:", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public ModifyResponseElement processModifyRequest(ModifyElement modifyElement, String string, Message message, Document document) throws IDPPException, SOAPFaultException {
        String[] stringArray;
        List list;
        String string2;
        IDPPUtils.debug.message("PPRequestHandler:processModifyRequest:Init");
        if (modifyElement == null) {
            IDPPUtils.debug.error("PPRequestHandler:processModifyRequest. null values");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processModifyRequest:request received:" + XMLUtils.print((Node)document.getDocumentElement()));
        }
        HashMap hashMap = new HashMap();
        ModifyResponseElement modifyResponseElement = this.getModifyResponse(modifyElement);
        Object object = modifyElement.getResourceID();
        if (object == null) {
            object = modifyElement.getEncryptedResourceID();
        }
        if ((string2 = this.getResourceID(object, string, "urn:liberty:id-sis-pp:2003-08")) == null || !this.pp.isResourceIDValid(string2)) {
            if (IDPPUtils.debug.warningEnabled()) {
                IDPPUtils.debug.warning("PPRequestHandler:processModifyRequest: resource id is invalid.");
            }
            modifyResponseElement.setStatus(this.setStatusType(false, "InvalidResourceID", IDPPUtils.bundle.getString("invalidResourceID"), null));
            return modifyResponseElement;
        }
        if (LogUtil.isLogEnabled()) {
            this.logMsg = IDPPUtils.bundle.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + " " + IDPPUtils.bundle.getString("providerID") + "=" + string + " " + IDPPUtils.bundle.getString("resourceID") + "=" + string2 + " " + IDPPUtils.bundle.getString("securityMechID") + "=" + message.getAuthenticationMechanism() + " ";
        }
        if ((list = modifyElement.getModification()).size() == 0) {
            IDPPUtils.debug.error("PPRequestHandler:processModifyRequest: Modification elements are null");
            modifyResponseElement.setStatus(this.setStatusType(false, "UnexpectedError", IDPPUtils.bundle.getString("nullModifications"), null));
            return modifyResponseElement;
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        ArrayList<DSTModification> arrayList = new ArrayList<DSTModification>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray2;
            stringArray = (String[])list.get(n2);
            String string3 = stringArray.getSelect();
            String string4 = stringArray.getId();
            if (string3 == null || string3.length() == 0) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PersonalProfileService:processModifyRequest: select is null");
                }
                modifyResponseElement.setStatus(this.setStatusType(false, "MissingSelect", IDPPUtils.bundle.getString("missingSelect"), string4));
                return modifyResponseElement;
            }
            if (!this.pp.isSelectDataSupported(string3)) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PersonalProfileService:processModifyRequest: Data not supported");
                }
                modifyResponseElement.setStatus(this.setStatusType(false, "InvalidSelect", IDPPUtils.bundle.getString("invalidSelect"), string4));
                return modifyResponseElement;
            }
            String string5 = IDPPUtils.getResourceExpression(string3);
            String string6 = this.pp.getAuthZAction(message.getToken(), "MODIFY", string5, this.getPolicyEnvMap(string2, message));
            if (string6 == null || string6.equalsIgnoreCase("deny")) {
                modifyResponseElement.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("notAuthorized"), string4));
                if (LogUtil.isLogEnabled()) {
                    String[] stringArray3 = new String[]{string2};
                    LogUtil.error(Level.INFO, "PP_Modify_Failure", stringArray3);
                }
                return modifyResponseElement;
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.processModifyRequest: Authorization action" + string6);
            }
            if (string6.equalsIgnoreCase("interactForConsent")) {
                if (this.isInteractionResponseExists(message)) {
                    if (!this.processInteractionConsentResponse(false, message, string3)) {
                        if (LogUtil.isLogEnabled()) {
                            String[] stringArray4 = new String[]{string2};
                            LogUtil.error(Level.INFO, "PP_Interaction_Failure", stringArray4);
                        }
                        modifyResponseElement.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("interactionFailed"), string4));
                        return modifyResponseElement;
                    }
                } else {
                    hashMap2.put(string5, string6);
                }
            } else if (string6.equalsIgnoreCase("interactForValue")) {
                if (this.isInteractionResponseExists(message)) {
                    Map map = this.processInteractionValueResponse(false, message, string3);
                    if (map == null || map.isEmpty()) {
                        if (LogUtil.isLogEnabled()) {
                            stringArray2 = new String[]{string2};
                            LogUtil.error(Level.INFO, "PP_Interaction_Failure", stringArray2);
                        }
                        modifyResponseElement.setStatus(this.setStatusType(false, "ActionNotAuthorized", IDPPUtils.bundle.getString("interactionFailed"), string4));
                        return modifyResponseElement;
                    }
                    hashMap.putAll(map);
                } else {
                    hashMap2.put(string5, string6);
                }
            }
            boolean bl = stringArray.isOverrideAllowed();
            stringArray2 = stringArray.getNewData();
            DSTModification dSTModification = new DSTModification();
            dSTModification.setSelect(string3);
            dSTModification.setOverrideAllowed(bl);
            dSTModification.setId(stringArray.getId());
            arrayList.add(dSTModification);
            if (stringArray2 != null && stringArray2.getAny() != null && stringArray2.getAny().size() != 0) {
                dSTModification.setNewDataValue(stringArray2.getAny());
            }
            ++n2;
        }
        if (hashMap2 != null && !hashMap2.isEmpty()) {
            this.initInteraction(false, hashMap2, message);
        }
        if (this.pp.modifyData(message.getToken(), string2, arrayList, hashMap, document)) {
            if (LogUtil.isLogEnabled()) {
                stringArray = new String[]{string2};
                LogUtil.access(Level.INFO, "PP_Modify_Success", stringArray);
            }
            return modifyResponseElement;
        }
        modifyResponseElement.setStatus(this.setStatusType(false, "UnexpectedError", IDPPUtils.bundle.getString("modifyFailed"), null));
        if (LogUtil.isLogEnabled()) {
            stringArray = new String[]{this.logMsg};
            LogUtil.error(Level.INFO, "PP_Modify_Failure", stringArray);
        }
        return modifyResponseElement;
    }

    private Map getPolicyEnvMap(String string, Message message) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("message", message);
        hashMap.put("userID", this.pp.getUserDN(string));
        hashMap.put("authType", message.getAuthenticationMechanism());
        return hashMap;
    }

    public QueryResponseElement getQueryResponse(QueryElement queryElement) throws IDPPException {
        if (queryElement == null) {
            IDPPUtils.debug.error("PPRequestHandler:getQueryResponse:Query is null.");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            QueryResponseElement queryResponseElement = IDPPUtils.getIDPPFactory().createQueryResponseElement();
            queryResponseElement.setStatus(this.setStatusType(true, "OK", null, null));
            queryResponseElement.setId(SAMLUtilsCommon.generateID());
            queryResponseElement.setItemIDRef(queryElement.getItemID());
            return queryResponseElement;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("PPRequestHandler:getQueryResponse:JAXB failure.", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public ModifyResponseElement getModifyResponse(ModifyElement modifyElement) throws IDPPException {
        if (modifyElement == null) {
            IDPPUtils.debug.error("PPRequestHandler:getModifyResponse:Modify is null.");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            ModifyResponseElement modifyResponseElement = IDPPUtils.getIDPPFactory().createModifyResponseElement();
            modifyResponseElement.setStatus(this.setStatusType(true, "OK", null, null));
            modifyResponseElement.setId(SAMLUtilsCommon.generateID());
            modifyResponseElement.setItemIDRef(modifyElement.getItemID());
            return modifyResponseElement;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("PPRequestHandler:getModifyResponse:JAXB failure.", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    private boolean isInteractionResponseExists(Message message) {
        try {
            return InteractionManager.getInstance().getInteractionResponseElement(message) != null;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.isInteractionResponseExists: Exception while getting interaction response.", (Throwable)exception);
            return false;
        }
    }

    private void initInteraction(boolean bl, Map map, Message message) throws SOAPFaultException, IDPPException {
        IDPPUtils.debug.message("PPRequestHandler.initInteraction:Init");
        if (message == null || map == null || map.isEmpty()) {
            IDPPUtils.debug.error("PPRequestHandler.initInteraction:NullInput parameters");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            String[] stringArray;
            String string;
            InquiryElement inquiryElement = JAXBObjectFactory.getObjectFactory().createInquiryElement();
            inquiryElement.setTitle(IDPPUtils.bundle.getString("interactionTitle"));
            List list = inquiryElement.getSelectOrConfirmOrText();
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringArray = (String[])map.get(string);
                if (stringArray.equals("interactForConsent")) {
                    list.add(this.getInteractConfirmElement(bl, string, message));
                    continue;
                }
                if (!stringArray.equals("interactForValue")) continue;
                list.addAll(this.getInteractTextElements(bl, string, message));
            }
            string = this.getLanguage(message);
            if (LogUtil.isLogEnabled()) {
                stringArray = new String[]{this.logMsg};
                LogUtil.access(Level.INFO, "PP_Interaction_Success", stringArray);
            }
            InteractionManager.getInstance().handleInteraction(message, inquiryElement, string);
        }
        catch (InteractionSOAPFaultException interactionSOAPFaultException) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.initInteraction:Interact redirection happened");
            }
            throw interactionSOAPFaultException.getSOAPFaultException();
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.initInteraction:Failed");
            throw new IDPPException(exception);
        }
    }

    private InquiryType.Confirm getInteractConfirmElement(boolean bl, String string, Message message) throws IDPPException {
        if (string == null) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractConfirmElement:Null input:");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        string = IDPPUtils.getExpressionContext(string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.getInteractConfirm:Resource Context:" + string);
        }
        try {
            InquiryType.Confirm confirm = JAXBObjectFactory.getObjectFactory().createInquiryTypeConfirm();
            PPInteractionHelper pPInteractionHelper = new PPInteractionHelper(this.getLanguage(message));
            confirm.setName(string);
            confirm.setLabel(pPInteractionHelper.getInteractForConsentQuestion(bl, string));
            confirm.setHint(pPInteractionHelper.getInteractForConsentQuestion(bl, string));
            return confirm;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractConfirm:Exception while creating interact select.", (Throwable)exception);
            throw new IDPPException(exception);
        }
    }

    private List getInteractTextElements(boolean bl, String string, Message message) throws IDPPException {
        if (string == null) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractText:Null input:");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        string = IDPPUtils.getExpressionContext(string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.getInteractText:Resource Context:" + string);
        }
        try {
            ArrayList<TextElement> arrayList = new ArrayList<TextElement>();
            PPInteractionHelper pPInteractionHelper = new PPInteractionHelper(this.getLanguage(message));
            Map map = pPInteractionHelper.getInteractForValueQuestions(bl, string);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                TextElement textElement = JAXBObjectFactory.getObjectFactory().createTextElement();
                textElement.setName(string2);
                textElement.setLabel((String)map.get(string2));
                textElement.setMinChars(pPInteractionHelper.getTextMinChars(string2));
                textElement.setMaxChars(pPInteractionHelper.getTextMaxChars(string2));
                arrayList.add(textElement);
            }
            return arrayList;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractText:Exception while creating interact text element.", (Throwable)exception);
            throw new IDPPException(exception);
        }
    }

    private boolean processInteractionConsentResponse(boolean bl, Message message, String string) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.processInteractionResponse:Init");
        }
        if (message == null || string == null) {
            IDPPUtils.debug.error("PPRequestHandler:processInteractionResponse:null input params");
            return false;
        }
        string = IDPPUtils.getExpressionContext(string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processInteractionPP Element that was trying to access:" + string);
        }
        try {
            InteractionResponseElement interactionResponseElement = InteractionManager.getInstance().getInteractionResponseElement(message);
            if (interactionResponseElement == null) {
                return false;
            }
            Map map = InteractionUtils.getParameters(interactionResponseElement);
            if (map == null || map.isEmpty()) {
                return false;
            }
            String string2 = (String)map.get(string);
            if (string2 == null || string2.equals("false")) {
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("PPRequestHandler.processInteraction: response is deny");
                }
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.processInteractionResponse: Exception occured.", (Throwable)exception);
            return false;
        }
    }

    private Map processInteractionValueResponse(boolean bl, Message message, String string) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.processInteractionResponse:Init");
        }
        if (message == null || string == null) {
            IDPPUtils.debug.error("PPRequestHandler:processInteractionResponse:null input params");
            return null;
        }
        string = IDPPUtils.getExpressionContext(string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processInteractionPP Element that was trying to access:" + string);
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            InteractionResponseElement interactionResponseElement = InteractionManager.getInstance().getInteractionResponseElement(message);
            if (interactionResponseElement == null) {
                return null;
            }
            Map map = InteractionUtils.getParameters(interactionResponseElement);
            if (map == null || map.isEmpty()) {
                return null;
            }
            String string2 = this.getLanguage(message);
            PPInteractionHelper pPInteractionHelper = new PPInteractionHelper(string2);
            Map map2 = pPInteractionHelper.getInteractForValueQuestions(bl, string);
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)map.get(string3);
                if (string4 == null || string4.equals("")) continue;
                hashMap.put(pPInteractionHelper.getPPAttribute(string3), string4);
            }
            return hashMap;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.processInteractionResponse: Exception occured.", (Throwable)exception);
            return null;
        }
    }

    private String getLanguage(Message message) {
        List list = InteractionUtils.getInteractionLangauge(message);
        if (list == null || list.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.setLanguage: LanguageHeaders are empty in the interaction message.");
            }
            return null;
        }
        String string = (String)list.iterator().next();
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.setLanguage:Lang:" + string);
        }
        return string;
    }

    private ServiceInstanceUpdateHeader getServiceInstanceUpdateHeader() throws SOAPFaultException {
        ServiceInstanceUpdate serviceInstanceUpdate = IDPPServiceManager.getInstance().getServiceInstanceUpdate();
        ServiceInstanceUpdateHeader serviceInstanceUpdateHeader = serviceInstanceUpdate.getServiceInstanceUpdateHeader();
        if (serviceInstanceUpdate.isSOAPFaultNeeded()) {
            QName qName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
            SOAPFaultDetail sOAPFaultDetail = new SOAPFaultDetail(SOAPFaultDetail.ENDPOINT_MOVED, null, null);
            SOAPFault sOAPFault = new SOAPFault(qName, IDPPUtils.bundle.getString("endPointMoved"), null, sOAPFaultDetail);
            Message message = new Message(sOAPFault);
            message.setServiceInstanceUpdateHeader(serviceInstanceUpdateHeader);
            SOAPFaultException sOAPFaultException = new SOAPFaultException(message);
            throw sOAPFaultException;
        }
        return serviceInstanceUpdateHeader;
    }
}

