/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Misc;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.plugin.AttributeMapper;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPContainer;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPExtension;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.interfaces.ServiceInstanceUpdate;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IDPPServiceManager
implements ServiceListener {
    private static IDPPServiceManager instance = null;
    private static Authorizer authorizer = null;
    private static final String authorizerKey = "sunIdentityServerPPAuthorizer";
    private static final String defaultAuthorizer = "com.sun.identity.liberty.ws.idpp.plugin.IDPPAuthorizer";
    private static ResourceIDMapper resourceIDMapper = null;
    private static final String resourceMapperKey = "sunIdentityServerPPResourceIDMapper";
    private static final String defaultResourceIDMapper = "com.sun.identity.liberty.ws.idpp.plugin.IDPPResourceIDMapper";
    private static AttributeMapper attributeMapper = null;
    private static final String attributeMapperKey = "sunIdentityServerPPAttributeMapper";
    private static String defaultAttributeMapper = "com.sun.identity.liberty.ws.idpp.plugin.IDPPAttributeMapper";
    private static String nameScheme = null;
    private static final String nameSchemeKey = "sunIdentityServerPPNameScheme";
    private static final String defaultNameScheme = "urn:liberty:idpp:nameScheme:firstlast";
    private static Set supportedContainers = new HashSet();
    private static Map containerExtensions = new HashMap();
    private static Map containerClasses = new HashMap();
    private static final String supportedContainersKey = "sunIdentityServerPPSupportedContainers";
    private static String idppPrefix = null;
    private static final String idppPrefixKey = "sunIdentityServerPPNameSpacePrefix";
    private static final String defaultPrefix = "pp";
    private static ServiceSchemaManager schemaManager = null;
    private static Map ppDSMap = null;
    private static final String ppDSMapAttributeKey = "sunIdentityServerPPDSAttributeMapList";
    private static final String queryPolicyEvalKey = "sunIdentityServerPPisQueryPolicyEvalRequired";
    private static final String modifyPolicyEvalKey = "sunIdentityServerPPisModifyPolicyEvalRequired";
    private static boolean isQueryPolicyEval = false;
    private static boolean isModifyPolicyEval = false;
    private static final String providerIDKey = "sunIdentityServerPPProviderID";
    private static String providerID = null;
    private static String extensionPrefix = null;
    private static final String extensionPrefixKey = "sunIdentityServerPPExtensionPrefix";
    private static String defaultExtensionPrefix = "ispp";
    private static Set extensionAttributes = null;
    private static final String extensionAttributesKey = "sunIdentityServerPPExtensionAttributes";
    private static ServiceInstanceUpdate serviceInstanceUpdate = null;
    private static String siuClass = "sunIdentityServerPPServiceInstanceUpdateClass";
    private static String defaultSiuClass = "com.sun.identity.liberty.ws.idpp.plugin.IDPPServiceInstanceUpdate";
    private static String altEndPoint = null;
    private static String altEndPointKey = "sunIdentityServerPPAlternateEndPoint";
    private static boolean isSIUEnabled = false;
    private static String isSIUKey = "sunIdentityServerPPServiceInstanceUpdateEnabled";
    private static Set altSecMechs = null;
    private static String altSecMechsKey = "sunIdentityServerPPAlternateSecurityMechs";

    private static void initializeService() throws IDPPException {
        IDPPUtils.debug.message("IDPPServiceManager:initializeService");
        try {
            ServiceSchema serviceSchema = schemaManager.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            if (map == null || map.isEmpty()) {
                throw new IDPPException("Configuration is null");
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPServiceManager:initializeService: service config is " + map);
            }
            nameScheme = Misc.getMapAttr((Map)map, (String)nameSchemeKey, (String)defaultNameScheme);
            Set set = (Set)map.get(supportedContainersKey);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPServiceManager:initializeService: containers are " + set);
            }
            IDPPServiceManager.parseContainers(set);
            idppPrefix = Misc.getMapAttr((Map)map, (String)idppPrefixKey, (String)defaultPrefix);
            extensionPrefix = Misc.getMapAttr((Map)map, (String)extensionPrefixKey, (String)defaultExtensionPrefix);
            extensionAttributes = (Set)map.get(extensionAttributesKey);
            String string = Misc.getMapAttr((Map)map, (String)queryPolicyEvalKey);
            if (string != null) {
                isQueryPolicyEval = Boolean.valueOf(string);
            }
            if ((string = Misc.getMapAttr((Map)map, (String)modifyPolicyEvalKey)) != null) {
                isModifyPolicyEval = Boolean.valueOf(string);
            }
            providerID = Misc.getMapAttr((Map)map, (String)providerIDKey);
            IDPPServiceManager.storePPDSMap(map);
            String string2 = Misc.getMapAttr((Map)map, (String)authorizerKey, (String)defaultAuthorizer);
            Class<?> clazz = Class.forName(string2);
            authorizer = (Authorizer)clazz.newInstance();
            string2 = Misc.getMapAttr((Map)map, (String)resourceMapperKey, (String)defaultResourceIDMapper);
            Class<?> clazz2 = Class.forName(string2);
            resourceIDMapper = (ResourceIDMapper)clazz2.newInstance();
            string2 = Misc.getMapAttr((Map)map, (String)attributeMapperKey, (String)defaultAttributeMapper);
            Class<?> clazz3 = Class.forName(string2);
            attributeMapper = (AttributeMapper)clazz3.newInstance();
            string2 = Misc.getMapAttr((Map)map, (String)siuClass, (String)defaultSiuClass);
            Class<?> clazz4 = Class.forName(string2);
            serviceInstanceUpdate = (ServiceInstanceUpdate)clazz4.newInstance();
            altEndPoint = Misc.getMapAttr((Map)map, (String)altEndPointKey);
            altSecMechs = (Set)map.get(altSecMechsKey);
            string = Misc.getMapAttr((Map)map, (String)isSIUKey);
            if (string != null) {
                isSIUEnabled = Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("IDPPServiceManager:initializeService:Error while initializing services.", (Throwable)exception);
            throw new IDPPException(exception);
        }
    }

    private static void storePPDSMap(Map map) {
        IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap:Init");
        ppDSMap = new HashMap();
        Set set = (Set)map.get(ppDSMapAttributeKey);
        if (set == null || set.isEmpty()) {
            IDPPUtils.debug.message("IDPPServiceManager:attribute map is empty");
            return;
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap: set ofattributes in DS:" + set);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf("=") == -1) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap:Entry does not have = sign. Ignoring:" + string);
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            if (stringTokenizer.countTokens() > 2) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap:Entry is invalid . Ignoring:" + string);
                continue;
            }
            ppDSMap.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPServiceManager:storePPDSMap: mappedattributes:" + ppDSMap);
        }
    }

    private static void parseContainers(Set set) {
        if (set == null || set.size() == 0) {
            IDPPUtils.debug.error("IDPPServiceManager.parseContainers:Container set is empty");
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            Class<?> clazz;
            String string;
            String string2 = (String)iterator.next();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            StringTokenizer stringTokenizer = null;
            String string6 = null;
            if (string2.indexOf("|") != -1) {
                stringTokenizer = new StringTokenizer(string2, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.startsWith("container")) {
                        string3 = string;
                        continue;
                    }
                    if (string.startsWith("extension")) {
                        string4 = string;
                        continue;
                    }
                    if (!string.startsWith("plugin")) continue;
                    string5 = string;
                }
            } else {
                string3 = string2;
            }
            if (string3.indexOf("=") == -1 || !string3.startsWith("container")) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPServiceManager.parseContainers: Invalid entry." + string2);
                continue;
            }
            stringTokenizer = new StringTokenizer(string3, "=");
            if (stringTokenizer.countTokens() != 2) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPServiceManager.parseContainers: Invalid entry." + string2);
                continue;
            }
            stringTokenizer.nextToken();
            string6 = stringTokenizer.nextToken();
            if ((string6 == null || string6.equals("")) && IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPServiceManager.parseContainers: Invalid entry." + string2);
            }
            supportedContainers.add(string6);
            if (string4 != null && !string4.equals("") && string4.indexOf("=") != -1) {
                stringTokenizer = new StringTokenizer(string4, "=");
                stringTokenizer.nextToken();
                try {
                    string = stringTokenizer.nextToken();
                    clazz = Class.forName(string);
                    object = (IDPPExtension)clazz.newInstance();
                    containerExtensions.put(string6, object);
                }
                catch (Exception exception) {
                    IDPPUtils.debug.error("IDPPServiceManager.parseContainers:Error instantiating extension class:", (Throwable)exception);
                }
            }
            if (string5 == null || string5.equals("") || string5.indexOf("=") == -1) continue;
            stringTokenizer = new StringTokenizer(string5, "=");
            stringTokenizer.nextToken();
            try {
                string = stringTokenizer.nextToken();
                clazz = Class.forName(string);
                object = (IDPPContainer)clazz.newInstance();
                containerClasses.put(string6, object);
            }
            catch (Exception exception) {
                IDPPUtils.debug.error("IDPPServiceManager.parseContainers:Error instantiating extension class:", (Throwable)exception);
            }
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPServiceManager.parseContainers:supported containers:" + supportedContainers);
            IDPPUtils.debug.message("IDPPServiceManager.parseContainers:container extensions:" + containerExtensions);
            IDPPUtils.debug.message("IDPPServiceManager.parseContainers:container classes:" + containerClasses);
        }
    }

    private IDPPServiceManager() {
    }

    public static IDPPServiceManager getInstance() {
        if (instance == null) {
            instance = new IDPPServiceManager();
        }
        return instance;
    }

    public Authorizer getAuthorizer() {
        return authorizer;
    }

    public ResourceIDMapper getResourceIDMapper() {
        return resourceIDMapper;
    }

    public AttributeMapper getAttributeMapper() {
        return attributeMapper;
    }

    public String getNameScheme() {
        return nameScheme;
    }

    public Set getSupportedContainers() {
        return supportedContainers;
    }

    public Map getContainerExtensions() {
        return containerExtensions;
    }

    public Map getContainerClasses() {
        return containerClasses;
    }

    public String getIDPPPrefix() {
        return idppPrefix;
    }

    public Map getPPDSMap() {
        return ppDSMap;
    }

    public boolean isQueryPolicyEvalRequired() {
        return isQueryPolicyEval;
    }

    public boolean isModifyPolicyEvalRequired() {
        return isModifyPolicyEval;
    }

    public String getProviderID() {
        return providerID;
    }

    public IDPPExtension getContainerExtension(String string) {
        return (IDPPExtension)containerExtensions.get(string);
    }

    public String getPPExtensionPrefix() {
        return extensionPrefix;
    }

    public Set getExtensionAttributes() {
        return extensionAttributes;
    }

    public ServiceInstanceUpdate getServiceInstanceUpdate() {
        return serviceInstanceUpdate;
    }

    public boolean isServiceInstanceUpdateEnabled() {
        return isSIUEnabled;
    }

    public String getAlternateEndPoint() {
        return altEndPoint;
    }

    public Set getAlternateSecurityMechs() {
        return altSecMechs;
    }

    public void schemaChanged(String string, String string2) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPServiceManager:schemaChanged:");
        }
        try {
            IDPPServiceManager.initializeService();
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("IDPPServiceManager:schemaChanged: Error in updating service configuration.", (Throwable)iDPPException);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    static {
        try {
            String string = AdminUtils.getAdminDN();
            String string2 = new String(AdminUtils.getAdminPassword());
            SSOToken sSOToken = SSOTokenManager.getInstance().createSSOToken((Principal)new AuthPrincipal(string), string2);
            schemaManager = new ServiceSchemaManager("sunIdentityServerLibertyPPService", sSOToken);
            IDPPServiceManager.initializeService();
            instance = new IDPPServiceManager();
            schemaManager.addListener(instance);
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("IDPPServiceManager:Static init failed", (Throwable)exception);
        }
    }
}

