/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.common.DateUtils;
import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.dst.DSTData;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTQueryResponse {
    private Status dstStatus = null;
    private String itemIDRef = null;
    private String id = null;
    private Date dateStamp = null;
    private List data = new ArrayList();
    private List extensions = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTQueryResponse() {
    }

    public DSTQueryResponse(List list, String string) {
        if (list != null) {
            this.data = list;
        }
        this.nameSpaceURI = string;
    }

    public DSTQueryResponse(Element element) throws DSTException {
        NodeList nodeList;
        if (element == null) {
            DSTUtils.debug.error("DSTQueryResponse(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("QueryResponse")) {
            DSTUtils.debug.error("DSTQueryResponse(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryResponse(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemIDRef = element.getAttribute("itemIDRef");
        String string2 = element.getAttribute("timeStamp");
        if (string2 != null && string2.length() != 0) {
            try {
                this.dateStamp = DateUtils.stringToDate((String)string2);
            }
            catch (ParseException parseException) {
                DSTUtils.debug.error("DSTQueryResponse(element): can not parse the date", (Throwable)parseException);
            }
        }
        if ((nodeList = element.getChildNodes()) == null || nodeList.getLength() == 0) {
            DSTUtils.debug.error("DSTQueryResponse(element): Response doesnot have child elements.");
            throw new DSTException(DSTUtils.bundle.getString("noStatus"));
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                String string3 = node.getLocalName();
                if (string3 != null && string3.equals("Status")) {
                    this.dstStatus = DSTUtils.parseStatus((Element)node);
                } else if (string3 != null && string3.equals("Data")) {
                    this.data.add(new DSTData((Element)node));
                } else {
                    DSTUtils.debug.error("DSTQueryResponse(element): Response does have invalid elements.");
                    throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
                }
            }
            ++n;
        }
        if (this.dstStatus == null) {
            DSTUtils.debug.error("DSTQueryResponse(element): Response doesnot have Status element.");
            throw new DSTException(DSTUtils.bundle.getString("noStatus"));
        }
    }

    public Status getStatus() {
        return this.dstStatus;
    }

    public void setStatus(Status status) {
        this.dstStatus = status;
    }

    public Date getTimeStamp() {
        return this.dateStamp;
    }

    public void setTimeStamp(Date date) {
        this.dateStamp = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getItemIDRef() {
        return this.itemIDRef;
    }

    public void setItemIDRef(String string) {
        this.itemIDRef = string;
    }

    public List getData() {
        return this.data;
    }

    public List getExtension() {
        return this.extensions;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    public void setNameSpacePrefix(String string) {
        this.prefix = string;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        if (this.dstStatus == null) {
            DSTUtils.debug.error("DSTQueryResponse.toString: Status is null");
            return "";
        }
        String string = "";
        if (bl) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            string = this.prefix + ":";
        }
        if (bl2 && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryResponse.toString: Name Space is not defined");
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("<").append(string).append("QueryResponse");
        if (this.id != null && this.id.length() != 0) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemIDRef != null && this.itemIDRef.length() != 0) {
            stringBuffer.append(" itemIDRef=\"").append(this.itemIDRef).append("\"");
        }
        if (this.dateStamp != null) {
            stringBuffer.append(" timeStamp=\"").append(DateUtils.toUTCDateFormat((Date)this.dateStamp)).append("\"");
        }
        if (bl2) {
            stringBuffer.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        stringBuffer.append(">").append("\n").append(this.dstStatus.toString());
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            DSTData dSTData = (DSTData)iterator.next();
            stringBuffer.append(dSTData.toString());
        }
        stringBuffer.append("</").append(string).append("QueryResponse").append(">");
        return stringBuffer.toString();
    }
}

