/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DSTQueryItem {
    private String select;
    private boolean includeCommonAttribute;
    private Date changedSince;
    private String itemID = null;
    private String id = null;
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTQueryItem(String string, String string2) {
        this.select = string;
        this.nameSpaceURI = string2;
    }

    public DSTQueryItem(String string, boolean bl, Date date, String string2) {
        this.select = string;
        this.includeCommonAttribute = bl;
        this.changedSince = date;
        this.nameSpaceURI = string2;
    }

    public DSTQueryItem(Element element) throws DSTException {
        NodeList nodeList;
        if (element == null) {
            DSTUtils.debug.error("DSTQueryItem(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("QueryItem")) {
            DSTUtils.debug.error("DSTQueryItem(element):Invalid elementName");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryItem(element): Namespace is null");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        String string2 = element.getAttribute("includeCommonAttributes");
        if (string2 != null) {
            this.includeCommonAttribute = Boolean.valueOf(string2);
        }
        if ((string2 = element.getAttribute("changedSince")) != null && string2.length() != 0) {
            try {
                this.changedSince = DateUtils.stringToDate((String)string2);
            }
            catch (ParseException parseException) {
                DSTUtils.debug.error("DSTQueryItem(element): date can not be parsed.", (Throwable)parseException);
            }
        }
        if ((nodeList = element.getElementsByTagNameNS(this.nameSpaceURI, "Select")).getLength() != 1) {
            DSTUtils.debug.error("DSTQueryItem(element): Select is null or more than one select found.");
            throw new DSTException(DSTUtils.bundle.getString("invalidSelect"));
        }
        this.select = XMLUtils.getElementValue((Element)((Element)nodeList.item(0)));
        if (this.select == null) {
            DSTUtils.debug.error("DSTQueryItem(element): Select is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidSelect"));
        }
    }

    public String getSelect() {
        return this.select;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String string) {
        this.itemID = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public boolean isIncludeCommonAttributes() {
        return this.includeCommonAttribute;
    }

    public Date getChangedSince() {
        return this.changedSince;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    public void setNameSpacePrefix(String string) {
        this.prefix = string;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        if (this.select == null) {
            DSTUtils.debug.error("DSTQueryItem.toString: Select cannot be null");
            return "";
        }
        String string = "";
        if (bl) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            string = this.prefix + ":";
        }
        if (bl2 && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryItem.toString: Name Space is not defined");
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(string).append("QueryItem");
        if (this.id != null && this.id.length() != 0) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        stringBuffer.append(" includeCommonAttributes=\"");
        if (this.includeCommonAttribute) {
            stringBuffer.append("true").append("\"");
        } else {
            stringBuffer.append("false").append("\"");
        }
        if (this.itemID != null && this.itemID.length() != 0) {
            stringBuffer.append(" itemID=\"").append(this.itemID).append("\"");
        }
        if (this.changedSince != null) {
            stringBuffer.append(" changedSince=\"").append(DateUtils.toUTCDateFormat((Date)this.changedSince)).append("\"");
        }
        if (bl2) {
            stringBuffer.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        stringBuffer.append(">").append("<").append(string).append("Select").append(">").append(this.appendPrefix(this.select, this.prefix)).append("</").append(string).append("Select").append(">").append("</").append(string).append("QueryItem").append(">");
        return stringBuffer.toString();
    }

    private String appendPrefix(String string, String string2) {
        if (string.indexOf(":") != -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3 = "/" + string2 + ":" + string3;
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }
}

