/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTModification {
    private String id;
    private String select;
    private Date notChangedSince;
    private boolean overrideAllowed = false;
    private List newData = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTModification() {
    }

    public DSTModification(String string, Date date, String string2) {
        this.select = string;
        this.notChangedSince = date;
        this.nameSpaceURI = string2;
    }

    public DSTModification(Element element) throws DSTException {
        NodeList nodeList;
        if (element == null) {
            DSTUtils.debug.error("DSTModification(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("Modification")) {
            DSTUtils.debug.error("DSTModification(element):Invalid elementName");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        this.prefix = element.getPrefix();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModification(element): Namespace is null");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.id = element.getAttribute("id");
        String string2 = element.getAttribute("overrideAllowed");
        if (string2 != null) {
            this.overrideAllowed = Boolean.valueOf(string2);
        }
        if ((string2 = element.getAttribute("notChangedSince")) != null && string2.length() != 0) {
            try {
                this.notChangedSince = DateUtils.stringToDate((String)string2);
            }
            catch (ParseException parseException) {
                DSTUtils.debug.error("DSTModification(element): date can not be parsed.", (Throwable)parseException);
            }
        }
        if ((nodeList = element.getElementsByTagNameNS(this.nameSpaceURI, "Select")).getLength() != 1) {
            DSTUtils.debug.error("DSTModification(element): Select is null or more than one select found.");
            throw new DSTException(DSTUtils.bundle.getString("invalidSelect"));
        }
        this.select = XMLUtils.getElementValue((Element)((Element)nodeList.item(0)));
        if (this.select == null) {
            DSTUtils.debug.error("DSTModification(element): Select is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidSelect"));
        }
        NodeList nodeList2 = element.getElementsByTagNameNS(this.nameSpaceURI, "NewData");
        if (nodeList2.getLength() != 1) {
            DSTUtils.debug.error("DSTModification(element): Modification cannot have more than one new data elements.");
            throw new DSTException(DSTUtils.bundle.getString("invalidNewData"));
        }
        Node node = nodeList2.item(0);
        NodeList nodeList3 = node.getChildNodes();
        int n = nodeList3.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList3.item(0);
            if (node2.getNodeType() == 1) {
                this.newData.add((Element)node2);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public List getNewDataValue() {
        return this.newData;
    }

    public void setNewDataValue(List list) {
        if (list != null && !list.isEmpty()) {
            this.newData.addAll(list);
        }
    }

    public boolean isOverrideAllowed() {
        return this.overrideAllowed;
    }

    public void setOverrideAllowed(boolean bl) {
        this.overrideAllowed = bl;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String string) {
        this.select = string;
    }

    public Date getNotChangedSince() {
        return this.notChangedSince;
    }

    public void setNotChangedSince(Date date) {
        this.notChangedSince = date;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    public void setNameSpacePrefix(String string) {
        this.prefix = string;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            string = this.prefix + ":";
        }
        if (bl2 && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModification.toString: Name Space is not defined");
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(string).append("Modification");
        if (this.id != null && this.id.length() != 0) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        stringBuffer.append(" overrideAllowed=\"");
        if (this.overrideAllowed) {
            stringBuffer.append("true").append("\"");
        } else {
            stringBuffer.append("false").append("\"");
        }
        if (this.notChangedSince != null) {
            stringBuffer.append(" notChangedSince=\"").append(DateUtils.toUTCDateFormat((Date)this.notChangedSince)).append("\"");
        }
        if (bl2) {
            stringBuffer.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        stringBuffer.append(">").append("<").append(string).append("Select").append(">").append(this.appendPrefix(this.select, this.prefix)).append("</").append(string).append("Select").append(">").append("<").append(string).append("NewData").append(">");
        Iterator iterator = this.newData.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            stringBuffer.append(XMLUtils.print((Node)node));
        }
        stringBuffer.append("</").append(string).append("NewData").append(">").append("</").append(string).append("Modification").append(">");
        return stringBuffer.toString();
    }

    private String appendPrefix(String string, String string2) {
        if (string.indexOf(":") != -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3 = "/" + string2 + ":" + string3;
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }
}

