/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.iplanet.am.util.Debug;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;

public class DefaultHexResourceIDMapper
implements ResourceIDMapper {
    private static Debug debug = Debug.getInstance((String)"amDisco");

    public String getResourceID(String string, String string2) {
        if (string2 == null) {
            debug.error("DefaultHexResourceIDMapper.getResourceID:null userID");
            return null;
        }
        if (string == null || string.equals("")) {
            debug.error("DefaultHexResourceIDMapper.getResourceID:null providerID.");
            return null;
        }
        if (string.endsWith("/")) {
            return string + SAMLUtilsCommon.byteArrayToHexString(SAMLUtils.stringToByteArray(string2));
        }
        return string + "/" + SAMLUtilsCommon.byteArrayToHexString(SAMLUtils.stringToByteArray(string2));
    }

    public String getUserID(String string, String string2) {
        return this.getUserID(string, string2, null);
    }

    public String getUserID(String string, String string2, Message message) {
        if (string2 == null || string2.equals("urn:liberty:isf:implied-resource")) {
            if (debug.messageEnabled()) {
                debug.message("DefaultHexResourceIDMapper.getUserID: used implied resource.");
            }
            if (message == null) {
                debug.error("DefaultHexResourceIDMapper.getUserID:null message");
                return null;
            }
            SecurityAssertion securityAssertion = message.getAssertion();
            if (securityAssertion == null) {
                debug.error("DefaultHexResourceIDMapper.getUserID:no assertion");
                return null;
            }
            Subject subject = securityAssertion.getBearerSubject();
            if (subject == null) {
                debug.error("DefaultHexResourceIDMapper.getUserID:not Bearer Token");
                return null;
            }
            NameIdentifier nameIdentifier = subject.getNameIdentifier();
            if (nameIdentifier == null) {
                debug.error("DefaultHexResourceIDMapper.getUserID:no NameIdentifier");
                return null;
            }
            return nameIdentifier.getName();
        }
        if (string == null || string.equals("")) {
            debug.error("DefaultHexResourceIDMapper.getUserID:null providerID");
            return null;
        }
        if (!string2.startsWith(string)) {
            debug.error("DefaultHexResourceIDMapper.getUserID:resourceID not startsWith providerID:" + string);
            return null;
        }
        if (string.endsWith("/")) {
            return SAMLUtils.byteArrayToString(SAMLUtils.hexStringToByteArray(string2.substring(string.length())));
        }
        return SAMLUtils.byteArrayToString(SAMLUtils.hexStringToByteArray(string2.substring((string + "/").length())));
    }
}

