/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.Debug;
import com.iplanet.services.util.Base64;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLUtils;

public class Default64ResourceIDMapper
implements ResourceIDMapper {
    private static Debug debug = Debug.getInstance((String)"amDisco");

    public String getResourceID(String string, String string2) {
        if (string2 == null) {
            debug.error("Default64ResourceIDMapper.getResourceID:null userID");
            return null;
        }
        if (string == null || string.equals("")) {
            debug.error("Default64ResourceIDMapper.getResourceID:null providerID.");
            return null;
        }
        byte[] byArray = SAMLUtils.stringToByteArray(string2);
        String string3 = null;
        try {
            string3 = Base64.encode((byte[])byArray).trim();
        }
        catch (Exception exception) {
            debug.error("Default64ResourceIDMapper.getResourceID:", (Throwable)exception);
            return null;
        }
        String string4 = null;
        string4 = string.endsWith("/") ? string + AMURLEncDec.encode((String)string3) : string + "/" + AMURLEncDec.encode((String)string3);
        return string4;
    }

    public String getUserID(String string, String string2) {
        return this.getUserID(string, string2, null);
    }

    public String getUserID(String string, String string2, Message message) {
        String string3 = null;
        if (string2 == null || string2.equals("urn:liberty:isf:implied-resource")) {
            if (debug.messageEnabled()) {
                debug.message("Default64ResourceIDMapper.getUserID: used implied resource.");
            }
            if (message == null) {
                debug.error("Default64ResourceIDMapper.getUserID:null message");
                return null;
            }
            SecurityAssertion securityAssertion = message.getAssertion();
            if (securityAssertion == null) {
                debug.error("Default64ResourceIDMapper.getUserID:null assertion");
                return null;
            }
            Subject subject = securityAssertion.getBearerSubject();
            if (subject == null) {
                debug.error("Default64ResourceIDMapper.getUserID:not Bearer Token");
                return null;
            }
            NameIdentifier nameIdentifier = subject.getNameIdentifier();
            if (nameIdentifier == null) {
                debug.error("Default64ResourceIDMapper.getUserID:no NameIdentifier");
                return null;
            }
            return nameIdentifier.getName();
        }
        if (string == null || string.equals("")) {
            debug.error("Default64ResourceIDMapper.getUserID:null providerID.");
            return null;
        }
        if (!string2.startsWith(string)) {
            debug.error("Default64ResourceIDMapper.getUserID:resourceID not startsWith providerID:" + string);
            return null;
        }
        String string4 = null;
        string4 = string.endsWith("/") ? AMURLEncDec.decode((String)string2.substring(string.length())) : AMURLEncDec.decode((String)string2.substring((string + "/").length()));
        try {
            string3 = SAMLUtils.byteArrayToString(Base64.decode((String)string4));
        }
        catch (Exception exception) {
            debug.error("Default64ResourceIDMapper.getUserID:", (Throwable)exception);
            return null;
        }
        return string3;
    }
}

