/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.saml.common.SAMLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryResponse {
    private String id = null;
    private Status status = null;
    private List offerings = null;
    private List creds = null;

    public QueryResponse(Element element) throws DiscoveryException {
        String string;
        if (element == null) {
            DiscoUtils.debug.message("QueryResponse(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String string2 = element.getLocalName();
        if (string2 == null || !string2.equals("QueryResponse") || (string = element.getNamespaceURI()) == null || !string.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("QueryResponse(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = element.getAttribute("id");
        NodeList nodeList = element.getChildNodes();
        boolean bl = false;
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            string2 = node.getLocalName();
            if (string2 != null) {
                string = ((Element)node).getNamespaceURI();
                if (string == null || !string.equals("urn:liberty:disco:2003-08")) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("QueryResponse(Element): invalid namespace for node " + string2);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
                if (string2.equals("Status")) {
                    if (this.status != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("QueryResponse(Element): included more than one Status.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                    }
                    this.status = DiscoUtils.parseStatus((Element)node);
                } else if (string2.equals("ResourceOffering")) {
                    if (this.offerings == null) {
                        this.offerings = new ArrayList();
                    }
                    this.offerings.add(new ResourceOffering((Element)node));
                } else if (string2.equals("Credentials")) {
                    if (bl) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("QueryResponse(Element): included more than one Credentials.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                    }
                    bl = true;
                    this.parseCreds((Element)node);
                } else {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("QueryResponse(Element): invalid node" + string2);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
        if (this.status == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("QueryResponse(Element): missing Status.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingStatus"));
        }
    }

    private void parseCreds(Element element) throws DiscoveryException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            String string = node.getLocalName();
            if (string != null) {
                SecurityAssertion securityAssertion;
                try {
                    securityAssertion = new SecurityAssertion((Element)node);
                }
                catch (SAMLException sAMLException) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("QueryResponse(Element): Exception thrown when parsing Credentials:", (Throwable)sAMLException);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongCredential"));
                }
                if (this.creds == null) {
                    this.creds = new ArrayList();
                }
                this.creds.add(securityAssertion);
            }
            ++n;
        }
    }

    public QueryResponse() {
    }

    public QueryResponse(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List getResourceOffering() {
        return this.offerings;
    }

    public void setResourceOffering(List list) {
        this.offerings = list;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public List getCredentials() {
        return this.creds;
    }

    public void setCredentials(List list) {
        this.creds = list;
    }

    public String toString() {
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("<QueryResponse xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && !this.id.equals("")) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        stringBuffer.append(">");
        if (this.status != null) {
            stringBuffer.append(this.status.toString());
        }
        if (this.offerings != null) {
            iterator = this.offerings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((ResourceOffering)iterator.next()).toString());
            }
        }
        if (this.creds != null) {
            stringBuffer.append("<Credentials xmlns=\"").append("urn:liberty:disco:2003-08").append("\">");
            iterator = this.creds.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append("</Credentials>");
        }
        stringBuffer.append("</QueryResponse>");
        return stringBuffer.toString();
    }
}

