/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.InsertEntry;
import com.sun.identity.liberty.ws.disco.RemoveEntry;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Modify {
    private String id = null;
    private ResourceID resourceID = null;
    private EncryptedResourceID encryptResID = null;
    private List inserts = null;
    private List removes = null;

    public Modify(ResourceID resourceID, List list, List list2) {
        this.resourceID = resourceID;
        this.inserts = list;
        this.removes = list2;
    }

    public Modify(EncryptedResourceID encryptedResourceID, List list, List list2) {
        this.encryptResID = encryptedResourceID;
        this.inserts = list;
        this.removes = list2;
    }

    public Modify() {
    }

    public Modify(Element element) throws DiscoveryException {
        String string;
        if (element == null) {
            DiscoUtils.debug.message("Modify(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String string2 = element.getLocalName();
        if (string2 == null || !string2.equals("Modify") || (string = element.getNamespaceURI()) == null || !string.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("Modify(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = element.getAttribute("id");
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            string2 = node.getLocalName();
            if (string2 != null) {
                string = ((Element)node).getNamespaceURI();
                if (string == null || !string.equals("urn:liberty:disco:2003-08")) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Modify(Element): invalid namespace for node " + string2);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
                if (string2.equals("ResourceID")) {
                    if (this.resourceID != null || this.encryptResID != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("Modify(Element): Included more than one ResourceIDGroup element.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                    }
                    this.resourceID = new ResourceID((Element)node);
                } else if (string2.equals("EncryptedResourceID")) {
                    if (this.resourceID != null || this.encryptResID != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("Modify(Element): Included more than one ResourceIDGroup element.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                    }
                    this.encryptResID = new EncryptedResourceID((Element)node);
                } else if (string2.equals("InsertEntry")) {
                    if (this.inserts == null) {
                        this.inserts = new ArrayList();
                    }
                    this.inserts.add(new InsertEntry((Element)node));
                } else if (string2.equals("RemoveEntry")) {
                    if (this.removes == null) {
                        this.removes = new ArrayList();
                    }
                    this.removes.add(new RemoveEntry(((Element)node).getAttribute("entryID")));
                } else {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Modify(Element): invalid node" + string2);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
        if (this.resourceID == null && this.encryptResID == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Modify(Element): missing ResourceID or EncryptedResourceID element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingResourceIDGroup"));
        }
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptResID;
    }

    public void setEncryptedResourceID(EncryptedResourceID encryptedResourceID) {
        this.encryptResID = encryptedResourceID;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(ResourceID resourceID) {
        this.resourceID = resourceID;
    }

    public String getId() {
        return this.id;
    }

    public List getRemoveEntry() {
        return this.removes;
    }

    public void setRemoveEntry(List list) {
        this.removes = list;
    }

    public List getInsertEntry() {
        return this.inserts;
    }

    public void setInsertEntry(List list) {
        this.inserts = list;
    }

    public String toString() {
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer(1200);
        stringBuffer.append("<Modify xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && !this.id.equals("")) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        stringBuffer.append(">");
        if (this.resourceID != null) {
            stringBuffer.append(this.resourceID.toString());
        } else if (this.encryptResID != null) {
            stringBuffer.append(this.encryptResID.toString());
        }
        if (this.inserts != null) {
            iterator = this.inserts.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((InsertEntry)iterator.next()).toString());
            }
        }
        if (this.removes != null) {
            iterator = this.removes.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((RemoveEntry)iterator.next()).toString());
            }
        }
        stringBuffer.append("</Modify>");
        return stringBuffer.toString();
    }
}

