/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.xmlenc.XMLEncryptionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptedResourceID {
    private Element data = null;
    private Element key = null;
    private String namespaceURI = null;

    public EncryptedResourceID() {
    }

    public EncryptedResourceID(Element element) throws DiscoveryException {
        this.init(element, "urn:liberty:disco:2003-08");
    }

    public EncryptedResourceID(Element element, String string) throws DiscoveryException {
        this.init(element, string);
    }

    private void init(Element element, String string) throws DiscoveryException {
        if (element == null) {
            DiscoUtils.debug.message("EncryptedResourceID(Element):null input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String string2 = null;
        String string3 = null;
        string2 = element.getLocalName();
        if (string2 == null || !string2.equals("EncryptedResourceID") || (string3 = element.getNamespaceURI()) == null || !string3.equals(string)) {
            DiscoUtils.debug.message("EncryptedResourceID(Ele):wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.namespaceURI = string;
        NodeList nodeList = element.getChildNodes();
        String string4 = null;
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            string4 = node.getLocalName();
            if (string4 != null) {
                if (string4.equals("EncryptedData")) {
                    if (this.data != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("EncryptedResourceID(Element):Included more than one EncryptedData.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreEncryptedData"));
                    }
                    this.data = (Element)node;
                } else if (string4.equals("EncryptedKey")) {
                    if (this.key != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("EncryptedResourceID(Element):Included more than one EncryptedKey.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreEncryptedKey"));
                    }
                    this.key = (Element)node;
                } else {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("EncryptedResourceID(Element):invalid node" + string4);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
        if (this.data == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("EncryptedResourceID(Element): missing EncryptedData element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingEncryptedData"));
        }
    }

    public EncryptedResourceID(Element element, Element element2) {
        this.data = element;
        this.key = element2;
    }

    public void setEncryptedData(Element element) {
        this.data = element;
    }

    public Element getEncryptedData() {
        return this.data;
    }

    public Element getEncryptedKey() {
        return this.key;
    }

    public void setEncryptedKey(Element element) {
        this.key = element;
    }

    public static ResourceID getDecryptedResourceID(EncryptedResourceID encryptedResourceID, String string) throws DiscoveryException {
        if (encryptedResourceID == null || string == null) {
            // empty if block
        }
        ResourceID resourceID = null;
        try {
            FSProviderDescriptor fSProviderDescriptor = null;
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            fSProviderDescriptor = fSAllianceManager.getProvider(string);
            XMLEncryptionManager xMLEncryptionManager = XMLEncryptionManager.getInstance();
            Document document = XMLUtils.toDOMDocument((String)encryptedResourceID.toString(), (Debug)DiscoUtils.debug);
            Document document2 = xMLEncryptionManager.decryptAndReplace(document, fSProviderDescriptor.getEncryptionKeyAlias());
            Element element = (Element)document2.getElementsByTagNameNS("urn:liberty:disco:2003-08", "ResourceID").item(0);
            resourceID = new ResourceID(element);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("EncryptedResourceID.getDecryptedResourceID: decryption exception:", (Throwable)exception);
            throw new DiscoveryException(exception);
        }
        return resourceID;
    }

    public static EncryptedResourceID getEncryptedResourceID(ResourceID resourceID, String string) throws DiscoveryException {
        if (resourceID == null || string == null) {
            DiscoUtils.debug.error("EncryptedResourceID.getEncryptedResourceID: null input value");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        EncryptedResourceID encryptedResourceID = null;
        try {
            FSProviderDescriptor fSProviderDescriptor = null;
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            fSProviderDescriptor = fSAllianceManager.getProvider(string);
            Document document = XMLUtils.toDOMDocument((String)resourceID.toString(), (Debug)DiscoUtils.debug);
            XMLEncryptionManager xMLEncryptionManager = XMLEncryptionManager.getInstance();
            Document document2 = xMLEncryptionManager.encryptAndReplaceResourceID(document, document.getDocumentElement(), fSProviderDescriptor.getEncryptionKeyMethod(), fSProviderDescriptor.getEncryptionKeySize(), fSProviderDescriptor.getEncryptionKeyAlias(), string);
            encryptedResourceID = new EncryptedResourceID(document2.getDocumentElement());
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("EncryptedResourceID.getEncryptedResourceID: encryption exception:", (Throwable)exception);
            throw new DiscoveryException(exception);
        }
        return encryptedResourceID;
    }

    public String toString() {
        return this.toString(this.namespaceURI);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<EncryptedResourceID xmlns=\"").append(string).append("\">");
        if (this.data != null) {
            stringBuffer.append(XMLUtils.print((Node)this.data));
        }
        if (this.key != null) {
            stringBuffer.append(XMLUtils.print((Node)this.key));
        }
        stringBuffer.append("</EncryptedResourceID>");
        return stringBuffer.toString();
    }
}

