/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.logging.Level;

public class LogUtil {
    public static final String WS_SUCCESS = "WS_Success";
    public static final String WS_FAILURE = "WS_Failure";
    public static final String AS_OK = "AS_OK";
    public static final String AS_CONTINUE = "AS_Continue";
    public static final String AS_ABORT = "AS_Abort";
    public static final String PP_QUERY_SUCCESS = "PP_Query_Success";
    public static final String PP_QUERY_FAILURE = "PP_Query_Failure";
    public static final String PP_MODIFY_SUCCESS = "PP_Modify_Success";
    public static final String PP_MODIFY_FAILURE = "PP_Modify_Failure";
    public static final String PP_INTERACTION_SUCCESS = "PP_Interaction_Success";
    public static final String PP_INTERACTION_FAILURE = "PP_Interaction_Failure";
    public static final String DS_LOOKUP_SUCCESS = "DS_Lookup_Success";
    public static final String DS_LOOKUP_FAILURE = "DS_Lookup_Failure";
    public static final String DS_UPDATE_SUCCESS = "DS_Update_Success";
    public static final String DS_UPDATE_FAILURE = "DS_Update_Failure";
    public static final String IS_SENDING_MESSAGE = "IS_Sending_Message";
    public static final String IS_RESENDING_MESSAGE = "IS_Resending_Message";
    public static final String IS_RETURNING_RESPONSE_MESSAGE = "IS_Returning_Response_Message";
    public static final String IS_REDIRECTED_USER_AGENT = "IS_Redirected_User_Agent";
    public static final String IS_REDIRECTED_USER_AGENT_BACK = "IS_Redirected_User_Agent_Back";
    public static final String IS_PRESENTED_QUERY_TO_USER_AGENT = "IS_Presented_Query_To_User_Agent";
    public static final String IS_COLLECTED_RESPONSE_FROM_USER_AGENT = "IS_Collected_Response_From_User_Agent";
    public static final String IS_RETURNING_RESPONSE_ELEMENT = "IS_Returning_Response_Element";
    private static final String LIBERTY_LOG = "Liberty";
    private static final String ACCESS_LOG_NAME = "amLiberty.access";
    private static final String ERROR_LOG_NAME = "amLiberty.error";
    private static Debug debug = Debug.getInstance((String)"amLibertyLogUtil");
    private static Logger accessLogger = null;
    private static Logger errorLogger = null;
    private static LogMessageProvider msgProvider = null;
    private static SSOToken authSSOToken = null;
    private static boolean logStatus = false;

    public static void access(Level level, String string, String string2) {
        if (authSSOToken == null) {
            return;
        }
        if (accessLogger.isLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string, authSSOToken);
            accessLogger.log(logRecord, authSSOToken);
        }
    }

    public static void access(Level level, String string, String[] stringArray) {
        LogRecord logRecord;
        if (authSSOToken == null) {
            return;
        }
        if (accessLogger.isLoggable(level) && (logRecord = msgProvider.createLogRecord(string, stringArray, authSSOToken)) != null) {
            accessLogger.log(logRecord, authSSOToken);
        }
    }

    public static void error(Level level, String string, String string2) {
        if (authSSOToken == null) {
            return;
        }
        if (errorLogger.isLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string, authSSOToken);
            errorLogger.log(logRecord, authSSOToken);
        }
    }

    public static void error(Level level, String string, String[] stringArray) {
        LogRecord logRecord;
        if (authSSOToken == null) {
            return;
        }
        if (errorLogger.isLoggable(level) && (logRecord = msgProvider.createLogRecord(string, stringArray, authSSOToken)) != null) {
            errorLogger.log(logRecord, authSSOToken);
        }
    }

    public static boolean isLogEnabled() {
        return logStatus;
    }

    static {
        authSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        accessLogger = (Logger)Logger.getLogger(ACCESS_LOG_NAME);
        errorLogger = (Logger)Logger.getLogger(ERROR_LOG_NAME);
        try {
            msgProvider = MessageProviderFactory.getProvider(LIBERTY_LOG);
        }
        catch (Exception exception) {
            debug.message("Error getting MessageProvider instance");
        }
        String string = SystemProperties.get((String)"com.iplanet.am.logstatus");
        if (string == null) {
            string = "INACTIVE";
        }
        if (string.equalsIgnoreCase("ACTIVE")) {
            logStatus = true;
        }
    }
}

