/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.protocol.Parameter;
import com.sun.identity.liberty.ws.authnsvc.protocol.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class TruncationTransform
extends Transform {
    public TruncationTransform() {
        this.name = "urn:liberty:sa:pw:truncate";
    }

    public TruncationTransform(int n) {
        this.name = "urn:liberty:sa:pw:truncate";
        Parameter parameter = new Parameter("length", "" + n);
        this.parameters = new ArrayList();
        this.parameters.add(parameter);
    }

    public String transform(String string) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("TruncationTransform.transform");
        }
        if (string == null) {
            return null;
        }
        if (this.parameters == null || this.parameters.isEmpty()) {
            if (AuthnSvcUtils.debug.warningEnabled()) {
                AuthnSvcUtils.debug.warning("TruncationTransform.transform: no parameter found");
            }
            return string;
        }
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            block10: {
                Parameter parameter = (Parameter)iterator.next();
                if (!parameter.getName().equals("length")) continue;
                try {
                    int n = Integer.parseInt(parameter.getValue());
                    if (n < string.length() && n >= 0) {
                        return string.substring(0, n);
                    }
                    if (AuthnSvcUtils.debug.messageEnabled()) {
                        AuthnSvcUtils.debug.message("TruncationTransform.transform: parameter length value isn't less than password length");
                    }
                }
                catch (Exception exception) {
                    if (!AuthnSvcUtils.debug.warningEnabled()) break block10;
                    AuthnSvcUtils.debug.warning("TruncationTransform.transform: parameter value is not integer", (Throwable)exception);
                }
            }
            return string;
        }
        if (AuthnSvcUtils.debug.warningEnabled()) {
            AuthnSvcUtils.debug.warning("TruncationTransform.transform: parameter 'name' not found");
        }
        return string;
    }
}

