/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.protocol.GenericTransform;
import com.sun.identity.liberty.ws.authnsvc.protocol.LowercaseTransform;
import com.sun.identity.liberty.ws.authnsvc.protocol.Parameter;
import com.sun.identity.liberty.ws.authnsvc.protocol.SelectTransform;
import com.sun.identity.liberty.ws.authnsvc.protocol.TruncationTransform;
import com.sun.identity.liberty.ws.authnsvc.protocol.UppercaseTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Transform {
    public static final String TRUNCATION_URI = "urn:liberty:sa:pw:truncate";
    public static final String LOWERCASE_URI = "urn:liberty:sa:pw:lowercase";
    public static final String UPPERCASE_URI = "urn:liberty:sa:pw:uppercase";
    public static final String SELECT_URI = "urn:liberty:sa:pw:select";
    private static final String TRANSFORM_CLASSES = "com.sun.identity.liberty.ws.authnsvc.transformClasses";
    private static Map transformClasses = new HashMap();
    protected String name = null;
    protected String id = null;
    protected List parameters = null;

    static Transform getTransform(Element element) throws AuthnSvcException {
        String string = XMLUtils.getNodeAttributeValue((Node)element, (String)"name");
        if (string == null || string.length() == 0) {
            throw new AuthnSvcException("missingNameTF");
        }
        Transform transform = null;
        String string2 = (String)transformClasses.get(string);
        if (string2 != null) {
            try {
                transform = (Transform)Class.forName(string2).newInstance();
            }
            catch (Throwable throwable) {
                if (AuthnSvcUtils.debug.warningEnabled()) {
                    AuthnSvcUtils.debug.warning("Transform.getTransform class = " + string2, throwable);
                }
                transformClasses.remove(string);
            }
        }
        if (transform == null) {
            transform = string.equals(TRUNCATION_URI) ? new TruncationTransform() : (string.equals(LOWERCASE_URI) ? new LowercaseTransform() : (string.equals(UPPERCASE_URI) ? new UppercaseTransform() : (string.equals(SELECT_URI) ? new SelectTransform() : new GenericTransform(string))));
        }
        String string3 = XMLUtils.getNodeAttributeValue((Node)element, (String)"id");
        transform.setId(string3);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Parameter> arrayList = null;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string4 = element2.getLocalName();
                String string5 = element2.getNamespaceURI();
                if ("urn:liberty:sa:2004-04".equals(string5) && "Parameter".equals(string4)) {
                    Parameter parameter = new Parameter(element2);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Parameter>();
                    }
                    arrayList.add(parameter);
                } else {
                    throw new AuthnSvcException("invalidChildTF");
                }
            }
            ++n2;
        }
        transform.setParameters(arrayList);
        return transform;
    }

    public abstract String transform(String var1);

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setParameters(List list) {
        this.parameters = list;
    }

    void addToParent(Element element) throws AuthnSvcException {
        if (this.name == null || this.name.length() == 0) {
            throw new AuthnSvcException("missingNameTF");
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("urn:liberty:sa:2004-04", "sa:Transform");
        element.appendChild(element2);
        element2.setAttributeNS(null, "name", this.name);
        if (this.id != null) {
            element2.setAttributeNS(null, "id", this.id);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            Iterator iterator = this.parameters.iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                parameter.addToParent(element2);
            }
        }
    }

    static {
        String string = SystemProperties.get((String)TRANSFORM_CLASSES);
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                int n = string2.indexOf(124);
                if (n != -1 && n != 0 && n != string2.length() - 1) {
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    if (AuthnSvcUtils.debug.messageEnabled()) {
                        AuthnSvcUtils.debug.message("Transform.static: add " + string2);
                    }
                    transformClasses.put(string3, string4);
                    continue;
                }
                if (!AuthnSvcUtils.debug.warningEnabled()) continue;
                AuthnSvcUtils.debug.warning("Transform.static: Invalid syntax for Transform Classes List: " + string2);
            }
        }
    }
}

