/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.mechanism;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.soapbinding.Message;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class PlainMechanismHandler
implements MechanismHandler {
    private static String defaultOrg = SystemProperties.get((String)"com.iplanet.am.defaultOrg");

    public SASLResponse processSASLRequest(SASLRequest sASLRequest, Message message, String string) {
        String string2;
        boolean bl;
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("PlainMechanismHandler.processSASLRequest: ");
        }
        boolean bl2 = bl = (string2 = sASLRequest.getRefToMessageID()) == null || string2.length() == 0;
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("PlainMechanismHandler.processSASLRequest: refToMessageID = " + string2);
        }
        SASLResponse sASLResponse = null;
        byte[] byArray = sASLRequest.getData();
        if (byArray == null) {
            if (bl) {
                sASLResponse = new SASLResponse("continue");
                sASLResponse.setServerMechanism("PLAIN");
            } else {
                sASLResponse = new SASLResponse("abort");
            }
        } else {
            String string3 = null;
            try {
                string3 = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                AuthnSvcUtils.debug.error("PlainMechanismHandler.processSASLRequest: ", (Throwable)exception);
            }
            sASLResponse = string3 == null ? new SASLResponse("abort") : this.authenticate(string3, message);
            if (bl) {
                sASLResponse.setServerMechanism("PLAIN");
            }
        }
        return sASLResponse;
    }

    private SASLResponse authenticate(String string, Message message) {
        Callback[] callbackArray;
        int n = string.indexOf(0);
        if (n == -1) {
            return new SASLResponse("abort");
        }
        int n2 = string.indexOf(0, n + 1);
        if (n2 == -1) {
            return new SASLResponse("abort");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1);
        if (string3 == null) {
            return new SASLResponse("abort");
        }
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("PlainMechanismHandler.authenticate: authzID = " + string2 + ", authnID = " + string3 + ", password = " + string4);
        }
        AuthContext authContext = null;
        try {
            authContext = new AuthContext(defaultOrg);
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, "LDAP");
        }
        catch (AuthLoginException authLoginException) {
            AuthnSvcUtils.debug.error("PlainMechanismHandler.authenticate: ", (Throwable)authLoginException);
            return new SASLResponse("abort");
        }
        if (authContext.hasMoreRequirements() && (callbackArray = authContext.getRequirements()) != null) {
            PlainMechanismHandler.fillInCallbacks(callbackArray, string3, string4);
            authContext.submitRequirements(callbackArray);
        }
        callbackArray = authContext.getStatus();
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("PlainMechanismHandler.authenticate: login status = " + callbackArray);
        }
        if (callbackArray != AuthContext.Status.SUCCESS) {
            return new SASLResponse("abort");
        }
        try {
            SSOToken sSOToken = authContext.getSSOToken();
            SASLResponse sASLResponse = new SASLResponse("OK");
            if (!AuthnSvcUtils.setResourceOfferingAndCredentials(sASLResponse, message, sSOToken)) {
                return new SASLResponse("abort");
            }
            return sASLResponse;
        }
        catch (Exception exception) {
            AuthnSvcUtils.debug.error("PlainMechanismHandler.authenticate: ", (Throwable)exception);
            return new SASLResponse("abort");
        }
    }

    private static void fillInCallbacks(Callback[] callbackArray, String string, String string2) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("PlainMechanismHandler.fillInCallbacks:");
        }
        int n = 0;
        while (n < callbackArray.length) {
            Callback callback = callbackArray[n];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(string);
            } else if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(string2.toCharArray());
            }
            ++n;
        }
    }
}

