/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AuthnSvcService
implements ServiceListener {
    static final String SERVICE_NAME = "sunIdentityServerAuthnService";
    static final String MECHANISM_HANDLER_LIST_ATTR = "MechanismHandlerList";
    static HashMap handlers = new HashMap();
    private static ServiceSchema serviceSchema = null;

    private AuthnSvcService() {
    }

    public static MechanismHandler getMechanismHandler(String string) {
        return (MechanismHandler)handlers.get(string);
    }

    public void schemaChanged(String string, String string2) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("AuthnSvcService.schemaChanged");
        }
        AuthnSvcService.setValues();
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("AuthnSvcService.globalConfigChanged");
        }
        AuthnSvcService.setValues();
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("AuthnSvcService.organizationConfigChanged");
        }
        AuthnSvcService.setValues();
    }

    private static void setValues() {
        Map map = serviceSchema.getAttributeDefaults();
        handlers.clear();
        Set set = (Set)map.get(MECHANISM_HANDLER_LIST_ATTR);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            String string2 = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.startsWith("key=")) {
                    string2 = string4.substring(4);
                    continue;
                }
                if (!string4.startsWith("class=")) continue;
                string3 = string4.substring(6);
            }
            if (string2 != null && string3 != null) {
                try {
                    handlers.put(string2, (MechanismHandler)Class.forName(string3).newInstance());
                }
                catch (Throwable throwable) {
                    AuthnSvcUtils.debug.error("AuthnSvcService.setValues class = " + string3, throwable);
                }
                continue;
            }
            if (!AuthnSvcUtils.debug.warningEnabled()) continue;
            AuthnSvcUtils.debug.warning("AuthnSvcService.setValues: Invalid syntax for Mechanism Handler List: " + string);
        }
    }

    static {
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(SERVICE_NAME, sSOToken);
            serviceSchema = serviceSchemaManager.getGlobalSchema();
            AuthnSvcService.setValues();
            serviceSchemaManager.addListener(new AuthnSvcService());
        }
        catch (SSOException sSOException) {
            AuthnSvcUtils.debug.error("AuthnSvcService.static: Unable to get sso token", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AuthnSvcUtils.debug.error("AuthnSvcService.static: Unable to access service schema", (Throwable)sMSException);
        }
    }
}

