/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.jaxrpc;

import com.iplanet.am.sdk.remote.AMRemoteException;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.sun.identity.entity.EntityException;
import com.sun.identity.jaxrpc.JAXRPCUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SOAPClient {
    static final Debug debug = Debug.getInstance((String)"amJAXRPC");
    String serviceName;
    String url;
    String[] urls;
    String exceptionClassName;
    String exceptionMessage;
    String exceptionCode;
    String smsExceptionCode;
    int ldapErrorCode;
    String resourceBundleName;
    String errorString;
    Set messageArgs;
    Exception exception;
    boolean isException;
    static final String ENVELOPE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns0=\"http://isp.com/types\" xmlns:ns1=\"http://java.sun.com/jax-rpc-ri/internal\" env:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    static final String HEADSTART = "<env:Header>";
    static final String HEADEND = "</env:Header>";
    static final String ENV_BODY = "<env:Body>";
    static final String SUFFIX = "</env:Body></env:Envelope>\n";
    static final String BODY = "body";
    static final String RESULT = "result";
    static final String TYPE = "xsi:type";
    static final String STRING = "xsd:string";
    static final String INTEGER = "xsd:int";
    static final String BOOLEAN = "xsd:boolean";
    static final String SET = "ns1:hashSet";
    static final String MAP = "ns1:hashMap";
    static final String LIST = "ns1:linkedList";
    static final String MAPENTRY = "ns1:mapEntry";
    static final String ITEM = "item";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String FAULT_STRING = "faultstring";
    static final String MESSAGE = "message";
    static final String ERROR_CODE = "errorCode";
    static final String EXCEPTION_CODE = "exceptionCode";
    static final String LDAP_ERROR_CODE = "LDAPErrorCode";
    static final String ERROR_STRING = "errorString";
    static final String RMIREMOTEEXCEPTION = "java.rmi.RemoteException";
    static final String SSOEXCEPTION = "com.iplanet.sso.SSOException";
    static final String AMREMOTEEXCEPTION = "com.iplanet.am.sdk.remote.AMRemoteException";
    static final String SMSEXCEPTION = "com.sun.identity.sm.SMSException";
    static final String ENTITYEXCEPTION = "com.sun.identity.entity.EntityException";
    static final String SAMLEXCEPTION = "com.sun.identity.common.SAMLException";
    static final String RESOURCE_BUNDLE_NAME = "resourceBundleName";
    static final String MESSAGE_ARGS = "messageArgs";
    static final String HREF = "href";
    static final String ARRAY_OF_ANY_TYPE = "ArrayOfanyType";
    static final String ID = "id";
    static final String DECODE_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns0=\"http://isp.com/types\" xmlns:ns1=\"http://java.sun.com/jax-rpc-ri/internal\" env:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><env:Body><ans1:readResponse xmlns:ans1=\"http://isp.com/wsdl\">";
    static final String DECODE_FOOTER = "</ans1:readResponse></env:Body></env:Envelope>";

    public SOAPClient() throws IOException {
    }

    public SOAPClient(String string) {
        this.serviceName = string;
    }

    public SOAPClient(String[] stringArray) {
        this.urls = stringArray;
    }

    public InputStream call(String string, String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        if (debug.messageEnabled()) {
            debug.message("SOAP Client: Message being sent:" + string);
        }
        InputStream inputStream = null;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            Object var14_15;
            if (this.url == null) {
                if (this.urls != null) {
                    if (n >= this.urls.length) {
                        if (debug.warningEnabled()) {
                            debug.warning("SOAPClient: No vaild server found");
                        }
                        throw new RemoteException("no-server-found");
                    }
                    this.url = this.urls[n++];
                } else {
                    this.url = JAXRPCUtil.getValidURL(this.serviceName);
                }
            }
            serializable = new URL(this.url);
            object3 = (HttpURLConnection)((URL)serializable).openConnection();
            ((URLConnection)object3).setDoOutput(true);
            ((HttpURLConnection)object3).setRequestMethod("POST");
            ((URLConnection)object3).setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            ((URLConnection)object3).setRequestProperty("SOAPAction", "\"\"");
            if (string2 == null) {
                if (SystemProperties.iasGXId != null) {
                    ((URLConnection)object3).setRequestProperty("Cookie", "GX_jst=" + SystemProperties.iasGXId);
                }
            } else {
                if (SystemProperties.iasGXId != null) {
                    string2 = string2 + "; GX_jst=" + SystemProperties.iasGXId;
                }
                ((URLConnection)object3).setRequestProperty("Cookie", string2);
            }
            if ((object2 = ((URL)serializable).getUserInfo()) != null) {
                ((URLConnection)object3).setRequestProperty("Authorization", "Basic " + Base64.encode((byte[])((String)object2).getBytes("UTF-8")));
            }
            object = string.getBytes("UTF-8");
            int n2 = ((Object)object).length;
            ((URLConnection)object3).setRequestProperty("Content-Length", Integer.toString(n2));
            OutputStream outputStream = null;
            try {
                outputStream = ((URLConnection)object3).getOutputStream();
            }
            catch (ConnectException connectException) {
                if (debug.warningEnabled()) {
                    debug.warning("SOAP Client: Connection Exception: " + this.url, (Throwable)connectException);
                }
                JAXRPCUtil.serverFailed(this.url);
                this.url = null;
                continue;
            }
            outputStream.write((byte[])object);
            outputStream.flush();
            try {
                try {
                    inputStream = ((URLConnection)object3).getInputStream();
                }
                catch (IOException iOException) {
                    if (debug.messageEnabled()) {
                        debug.message("SOAP Client: READ Exception", (Throwable)iOException);
                    }
                    inputStream = ((HttpURLConnection)object3).getErrorStream();
                    this.isException = true;
                    var14_15 = null;
                    bl = true;
                    continue;
                }
                var14_15 = null;
                bl = true;
            }
            catch (Throwable throwable) {
                var14_15 = null;
                bl = true;
                throw throwable;
            }
        }
        if (debug.messageEnabled()) {
            serializable = new StringBuffer();
            object2 = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                ((StringBuffer)serializable).append((String)object3).append("\n");
            }
            object = new String((StringBuffer)serializable);
            debug.message("SOAP Client: Input: " + string + "\nOutput: " + (String)object);
            inputStream = new ByteArrayInputStream(((String)object).getBytes("UTF-8"));
        }
        return inputStream;
    }

    public synchronized Object send(String string, Object[] objectArray, String string2) throws Exception {
        return this.send(this.encodeMessage(string, objectArray), string2);
    }

    public synchronized Object send(String string, Object object, String string2) throws Exception {
        return this.send(this.encodeMessage(string, object), string2);
    }

    public synchronized Object send(String string, String string2) throws Exception {
        SOAPContentHandler sOAPContentHandler;
        block7: {
            this.exceptionMessage = null;
            this.exceptionClassName = null;
            this.exceptionCode = null;
            this.resourceBundleName = null;
            this.smsExceptionCode = null;
            this.messageArgs = null;
            this.errorString = null;
            this.ldapErrorCode = 0;
            this.isException = false;
            InputStream inputStream = this.call(string, string2);
            sOAPContentHandler = new SOAPContentHandler();
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                if (debug.warningEnabled()) {
                    sAXParserFactory.setValidating(true);
                } else {
                    sAXParserFactory.setValidating(false);
                }
                XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
                xMLReader.setContentHandler(sOAPContentHandler);
                xMLReader.setErrorHandler(new SOAPErrorHandler());
                xMLReader.parse(new InputSource(inputStream));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (debug.warningEnabled()) {
                    debug.warning("SOAPClient:send parser config exception", (Throwable)parserConfigurationException);
                }
            }
            catch (SAXException sAXException) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("SOAPClient:send SAX exception", (Throwable)sAXException);
            }
        }
        if (this.isException) {
            throw this.exception;
        }
        return sOAPContentHandler.getObject();
    }

    public void setURL(String string) {
        this.url = string;
    }

    void setURLs(String[] stringArray) {
        this.urls = stringArray;
    }

    String encodeString(String string) {
        return this.encodeString("String_1", string);
    }

    String encodeInt(String string, Integer n) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<").append(string);
        stringBuffer.append(" xsi:type=\"xsd:int\">");
        stringBuffer.append(n).append("</").append(string).append(">");
        return stringBuffer.toString();
    }

    String encodeInt(Integer n) {
        return this.encodeInt("int_1", n);
    }

    String encodeBoolean(String string, Boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<").append(string);
        stringBuffer.append(" xsi:type=\"xsd:boolean\">");
        stringBuffer.append(bl).append("</").append(string).append(">");
        return stringBuffer.toString();
    }

    String encodeBoolean(Boolean bl) {
        return this.encodeBoolean("boolean_1", bl);
    }

    String encodeString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<").append(string);
        stringBuffer.append(" xsi:type=\"xsd:string\">");
        String string3 = SMSSchema.escapeSpecialCharacters(string2);
        stringBuffer.append(string3).append("</").append(string).append(">");
        return stringBuffer.toString();
    }

    String encodeSet(Set set) {
        return this.encodeSet("Set_1", set);
    }

    String encodeSet(String string, Set set) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<").append(string);
        stringBuffer.append(" xsi:type=\"ns1:hashSet\" enc:arrayType=\"xsd:anyType[");
        stringBuffer.append(set.size());
        stringBuffer.append("]\">");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.encodeString(ITEM, iterator.next().toString()));
        }
        stringBuffer.append("</").append(string).append(">");
        return stringBuffer.toString();
    }

    String encodeList(List list) {
        return this.encodeList("List_1", list);
    }

    String encodeList(String string, List list) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<").append(string);
        stringBuffer.append(" xsi:type=\"ns1:linkedList\" enc:arrayType=\"xsd:anyType[");
        stringBuffer.append(list.size());
        stringBuffer.append("]\">");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.encodeString(ITEM, iterator.next().toString()));
        }
        stringBuffer.append("</").append(string).append(">");
        return stringBuffer.toString();
    }

    public String encodeMap(Map map) {
        return this.encodeMap("Map_1", map);
    }

    String encodeByteArrayArray(String string, byte[][] byArray) {
        return null;
    }

    public String encodeMap(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<").append(string);
        stringBuffer.append(" xsi:type=\"ns1:hashMap\" enc:arrayType=\"ns1:mapEntry[");
        stringBuffer.append(map.size()).append("]\">");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append("<item xsi:type=\"ns1:mapEntry\">");
            stringBuffer.append(this.encodeString(KEY, entry.getKey().toString()));
            Object v = entry.getValue();
            if (v instanceof Set) {
                stringBuffer.append(this.encodeSet(VALUE, (Set)v));
            } else if (v instanceof Map) {
                stringBuffer.append(this.encodeMap(VALUE, (Map)v));
            } else if (v instanceof List) {
                stringBuffer.append(this.encodeList(VALUE, (List)v));
            } else if (v instanceof String) {
                stringBuffer.append(this.encodeString(VALUE, (String)v));
            } else if (v instanceof byte[][]) {
                stringBuffer.append(this.encodeByteArrayArray(VALUE, (byte[][])v));
            }
            stringBuffer.append("</item>");
        }
        stringBuffer.append("</").append(string).append(">");
        return stringBuffer.toString();
    }

    public Map decodeMap(String string) {
        if (string == null || string.length() == 0) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(DECODE_HEADER);
        stringBuffer.append(string);
        stringBuffer.append(DECODE_FOOTER);
        SOAPContentHandler sOAPContentHandler = new SOAPContentHandler();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(sOAPContentHandler);
            xMLReader.setErrorHandler(new SOAPErrorHandler());
            xMLReader.parse(new InputSource(new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"))));
        }
        catch (Exception exception) {
            if (debug.warningEnabled()) {
                debug.warning("SOAPClient::decodeMap Exception", (Throwable)exception);
            }
            return Collections.EMPTY_MAP;
        }
        return (Map)sOAPContentHandler.getObject();
    }

    public String encodeMessage(String string, Object object) {
        Object[] objectArray = null;
        if (object != null) {
            objectArray = new Object[]{object};
        }
        return this.encodeMessage(string, objectArray);
    }

    public synchronized String encodeMessage(String string, Object[] objectArray) {
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(ENVELOPE).append(HEADSTART).append(HEADEND).append(ENV_BODY);
        stringBuffer.append("<ans1:").append(string).append(" xmlns:ans1=\"http://isp.com/wsdl\">");
        int n2 = 0;
        while (objectArray != null && n2 < objectArray.length) {
            if (objectArray[n2] instanceof String) {
                stringBuffer.append(this.encodeString("String_" + n++, (String)objectArray[n2]));
            } else if (objectArray[n2] instanceof Set) {
                stringBuffer.append(this.encodeSet("Set_" + n++, (Set)objectArray[n2]));
            } else if (objectArray[n2] instanceof Map) {
                stringBuffer.append(this.encodeMap("Map_" + n++, (Map)objectArray[n2]));
            } else if (objectArray[n2] instanceof List) {
                stringBuffer.append(this.encodeList("List_" + n++, (List)objectArray[n2]));
            } else if (objectArray[n2] instanceof Integer) {
                stringBuffer.append(this.encodeInt("int_" + n++, (Integer)objectArray[n2]));
            } else if (objectArray[n2] instanceof Boolean) {
                stringBuffer.append(this.encodeBoolean("boolean_" + n++, (Boolean)objectArray[n2]));
            } else if (objectArray[n2] == null) {
                ++n;
            } else {
                debug.error("SOAPClient: Unknown class: " + objectArray.getClass().getName());
            }
            ++n2;
        }
        stringBuffer.append("</ans1:").append(string).append(">").append(SUFFIX);
        return stringBuffer.toString();
    }

    class SOAPErrorHandler
    implements ErrorHandler {
        private Debug debug = Debug.getInstance((String)"amJAXRPC-XML");

        SOAPErrorHandler() {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            this.debug.error("SOAPClient:PARSER.fatalError", (Throwable)sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            if (this.debug.warningEnabled()) {
                this.debug.warning("SOAPClient:PARSER:error", (Throwable)sAXParseException);
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
        }
    }

    class SOAPContentHandler
    implements ContentHandler {
        Locator locator;
        boolean started;
        List types = new LinkedList();
        List maps = new LinkedList();
        List keys = new LinkedList();
        Object answer;
        String currentType;
        String type;
        StringBuffer currentString;
        Set set;
        Set currentSet;
        Map map;
        List list;
        List currentList;

        protected SOAPContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!this.started && string2.equalsIgnoreCase(SOAPClient.BODY)) {
                this.started = true;
                return;
            }
            if (!SOAPClient.this.isException) {
                if (string2.equalsIgnoreCase(SOAPClient.RESULT)) {
                    this.type = this.currentType = attributes.getValue(attributes.getIndex(SOAPClient.TYPE));
                    if (this.type.equalsIgnoreCase(SOAPClient.SET)) {
                        this.set = this.currentSet = new OrderedSet();
                    } else if (this.type.equalsIgnoreCase(SOAPClient.MAP)) {
                        this.map = new HashMap();
                        this.maps.add(0, this.map);
                    } else if (this.type.equalsIgnoreCase(SOAPClient.LIST)) {
                        this.list = this.currentList = new LinkedList();
                    }
                } else if (string2.equalsIgnoreCase(SOAPClient.ITEM)) {
                    this.types.add(0, this.currentType);
                    this.currentType = attributes.getValue(attributes.getIndex(SOAPClient.TYPE));
                } else if (string2.equalsIgnoreCase(SOAPClient.VALUE)) {
                    this.types.add(0, this.currentType);
                    this.currentType = attributes.getValue(attributes.getIndex(SOAPClient.TYPE));
                    if (this.currentType.equalsIgnoreCase(SOAPClient.SET)) {
                        this.currentSet = new OrderedSet();
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.MAP)) {
                        this.maps.add(0, new HashMap());
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.LIST)) {
                        this.currentList = new LinkedList();
                    }
                }
            } else if (string2.equals(SOAPClient.ARRAY_OF_ANY_TYPE)) {
                SOAPClient.this.messageArgs = new HashSet();
            }
            if (this.currentString == null) {
                this.currentString = new StringBuffer();
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!this.started) {
                return;
            }
            if (string2.equalsIgnoreCase(SOAPClient.ITEM)) {
                if (this.currentType.equalsIgnoreCase(SOAPClient.STRING)) {
                    if (this.currentSet != null) {
                        this.currentSet.add(this.currentString.toString());
                    } else {
                        this.currentList.add(this.currentString.toString());
                    }
                }
                this.currentType = (String)this.types.remove(0);
            } else if (string2.equalsIgnoreCase(SOAPClient.VALUE)) {
                if (this.currentType.equalsIgnoreCase(SOAPClient.SET)) {
                    Map map = (Map)this.maps.get(0);
                    map.put(this.keys.remove(0), this.currentSet);
                } else if (this.currentType.equalsIgnoreCase(SOAPClient.MAP)) {
                    Map map = (Map)this.maps.remove(0);
                    Map map2 = (Map)this.maps.get(0);
                    map2.put(this.keys.remove(0), map);
                } else if (this.currentType.equalsIgnoreCase(SOAPClient.LIST)) {
                    Map map = (Map)this.maps.get(0);
                    map.put(this.keys.remove(0), this.currentList);
                } else if (this.currentType.equalsIgnoreCase(SOAPClient.STRING) && ((String)this.types.get(0)).equalsIgnoreCase(SOAPClient.MAPENTRY)) {
                    this.map.put(this.keys.remove(0), this.currentString.toString());
                }
                this.currentType = (String)this.types.remove(0);
            } else if (string2.equals(SOAPClient.KEY)) {
                this.keys.add(0, this.currentString.toString());
            } else if (string2.equalsIgnoreCase(SOAPClient.RESULT)) {
                if (this.type.equalsIgnoreCase(SOAPClient.SET)) {
                    this.answer = this.set;
                } else if (this.type.equalsIgnoreCase(SOAPClient.MAP)) {
                    this.answer = this.map;
                } else if (this.type.equalsIgnoreCase(SOAPClient.STRING)) {
                    this.answer = this.currentString.toString();
                } else if (this.type.equalsIgnoreCase(SOAPClient.INTEGER)) {
                    try {
                        this.answer = new Integer(this.currentString.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.answer = new Integer(0);
                    }
                } else if (this.type.equalsIgnoreCase(SOAPClient.BOOLEAN)) {
                    this.answer = new Boolean(this.currentString.toString());
                } else if (this.type.equalsIgnoreCase(SOAPClient.LIST)) {
                    this.answer = this.list;
                }
            } else if (string2.equals(SOAPClient.FAULT_STRING)) {
                SOAPClient.this.isException = true;
                SOAPClient.this.exceptionClassName = this.currentString.toString();
            } else if (string2.equals(SOAPClient.MESSAGE)) {
                SOAPClient.this.exceptionMessage = this.currentString.toString();
            } else if (string2.equals(SOAPClient.ERROR_CODE)) {
                SOAPClient.this.exceptionCode = this.currentString.toString();
            } else if (string2.equals(SOAPClient.EXCEPTION_CODE)) {
                SOAPClient.this.smsExceptionCode = this.currentString.toString();
            } else if (string2.equals(SOAPClient.RESOURCE_BUNDLE_NAME)) {
                SOAPClient.this.resourceBundleName = this.currentString.toString();
            } else if (string2.equals(SOAPClient.ITEM)) {
                SOAPClient.this.messageArgs.add(this.currentString.toString());
            } else if (string2.equals(SOAPClient.LDAP_ERROR_CODE)) {
                SOAPClient.this.ldapErrorCode = Integer.parseInt(this.currentString.toString());
            } else if (string2.equals(SOAPClient.ERROR_STRING)) {
                SOAPClient.this.errorString = this.currentString.toString();
            }
            this.currentString = null;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.currentString.append(cArray, n, n2);
        }

        Object getObject() {
            return this.answer;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
            if (SOAPClient.this.isException) {
                if (SOAPClient.this.exceptionClassName.equals(SOAPClient.SSOEXCEPTION)) {
                    SOAPClient.this.exception = SOAPClient.this.resourceBundleName != null ? new SSOException(SOAPClient.this.resourceBundleName, SOAPClient.this.exceptionCode, SOAPClient.this.messageArgs.toArray()) : (SOAPClient.this.exceptionMessage != null ? new SSOException(SOAPClient.this.exceptionMessage) : new SSOException("no message"));
                } else if (SOAPClient.this.exceptionClassName.equals(SOAPClient.SMSEXCEPTION)) {
                    if (SOAPClient.this.resourceBundleName != null) {
                        SOAPClient.this.exception = new SMSException(SOAPClient.this.resourceBundleName, SOAPClient.this.exceptionCode, SOAPClient.this.messageArgs == null ? null : SOAPClient.this.messageArgs.toArray());
                    } else if (SOAPClient.this.exceptionMessage != null && SOAPClient.this.exceptionCode != null) {
                        try {
                            SOAPClient.this.exception = new SMSException(Integer.parseInt(SOAPClient.this.exceptionCode), SOAPClient.this.exceptionMessage);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SOAPClient.this.exception = new SMSException(SOAPClient.this.exceptionMessage);
                        }
                    } else if (SOAPClient.this.smsExceptionCode != null) {
                        try {
                            SOAPClient.this.exception = new SMSException(Integer.parseInt(SOAPClient.this.smsExceptionCode), null);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SOAPClient.this.exception = new SMSException(SOAPClient.this.exceptionCode);
                        }
                    } else {
                        SOAPClient.this.exception = SOAPClient.this.exceptionMessage != null ? new SMSException(SOAPClient.this.exceptionMessage) : new SMSException();
                    }
                } else {
                    SOAPClient.this.exception = SOAPClient.this.exceptionClassName.equals(SOAPClient.AMREMOTEEXCEPTION) ? new AMRemoteException(SOAPClient.this.exceptionMessage, SOAPClient.this.exceptionCode, SOAPClient.this.ldapErrorCode, SOAPClient.this.messageArgs != null ? (String[])SOAPClient.this.messageArgs.toArray() : null) : (SOAPClient.this.exceptionClassName.equals(SOAPClient.ENTITYEXCEPTION) ? (SOAPClient.this.messageArgs != null ? new EntityException(SOAPClient.this.exceptionMessage, SOAPClient.this.exceptionCode, SOAPClient.this.messageArgs.toArray()) : new EntityException(SOAPClient.this.exceptionMessage, SOAPClient.this.exceptionCode)) : (SOAPClient.this.exceptionClassName.equals(SOAPClient.SAMLEXCEPTION) ? (SOAPClient.this.exceptionMessage != null ? new SAMLException(SOAPClient.this.exceptionMessage) : new SAMLException()) : (SOAPClient.this.exceptionClassName.indexOf(SOAPClient.RMIREMOTEEXCEPTION) != -1 ? new RemoteException(SOAPClient.this.exceptionClassName) : (SOAPClient.this.exceptionMessage != null ? new Exception(SOAPClient.this.exceptionMessage) : new Exception("unknown-exception")))));
                }
            }
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }
    }
}

