/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.server;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoServiceListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class IdServicesImpl
implements IdServices {
    private static final String DELEGATION_ATTRS_NAME = "attributes";
    protected static Debug debug = Debug.getInstance((String)"amIdm");
    protected Map idRepoMap = new HashMap();
    protected Set idRepoPlugins;
    protected ServiceSchemaManager idRepoServiceSchemaManager;
    protected ServiceSchema idRepoSubSchema;
    private static HashSet READ_ACTION = new HashSet(2);
    private static HashSet WRITE_ACTION = new HashSet(2);
    private static IdServices _instance;

    protected static synchronized IdServices getInstance() {
        if (_instance == null) {
            IdServicesImpl.getDebug().message("IdServicesImpl.getInstance(): Creating new Instance of IdServicesImpl()");
            _instance = new IdServicesImpl();
        }
        return _instance;
    }

    protected IdServicesImpl() {
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdServicesImpl(): setting up ServiceListener");
        }
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            IdRepoServiceListener idRepoServiceListener = new IdRepoServiceListener();
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, "sunIdentityRepositoryService", "1.0");
            serviceConfigManager.addListener(idRepoServiceListener);
            this.idRepoServiceSchemaManager = new ServiceSchemaManager(sSOToken, "sunIdentityRepositoryService", "1.0");
            this.idRepoSubSchema = this.idRepoServiceSchemaManager.getOrganizationSchema();
            this.idRepoPlugins = this.idRepoSubSchema.getSubSchemaNames();
            this.idRepoServiceSchemaManager.addListener(idRepoServiceListener);
        }
        catch (SMSException sMSException) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl(): Unable to set up a  service listener for IdRepo", (Throwable)sMSException);
            }
        }
        catch (SSOException sSOException) {
            IdServicesImpl.getDebug().error("IdServicesImpl(): Unable to set up a service listener for IdRepo. ", (Throwable)sSOException);
        }
    }

    protected static Debug getDebug() {
        return debug;
    }

    public AMIdentity create(SSOToken sSOToken, IdType idType, String string, Map map, String string2) throws IdRepoException, SSOException {
        Object object;
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, map.keySet(), IdOperation.CREATE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        String string3 = null;
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.CREATE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                object = idRepo.getConfiguration();
                map = this.mapAttributeNames(map, (Map)object);
                String string4 = idRepo.create(sSOToken, idType, string, map);
                if (!idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) continue;
                string3 = string4;
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to create identity in the following repository" + idRepo.getClass().getName() + ":: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Create: Fatal Exception", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to create identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        object = new AMIdentity(sSOToken, string, idType, string2, string3);
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to create identity " + idType.getName() + " :: " + string + "in any of the configured data stores", (Throwable)idRepoException);
            throw idRepoException;
        }
        return object;
    }

    public void delete(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, null, IdOperation.DELETE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.DELETE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null) {
                    idRepo.delete(sSOToken, idType, string3);
                    continue;
                }
                idRepo.delete(sSOToken, idType, string);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to delete identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Delete: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to delete identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to delete identity " + idType.getName() + " :: " + string + "in any of the configured data stores", (Throwable)idRepoException);
            throw idRepoException;
        }
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3, boolean bl) throws IdRepoException, SSOException {
        Map map;
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, set, IdOperation.READ, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string2);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string2, set2, IdOperation.READ, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n = set3.size();
        HashSet<Map> hashSet = new HashSet<Map>();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                map = idRepo.getConfiguration();
                set = this.mapAttributeNames(set, map);
                Map map2 = null;
                map2 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null ? (bl ? idRepo.getAttributes(sSOToken, idType, string3, set) : idRepo.getBinaryAttributes(sSOToken, idType, string, set)) : (bl ? idRepo.getAttributes(sSOToken, idType, string, set) : idRepo.getBinaryAttributes(sSOToken, idType, string, set));
                map2 = this.reverseMapAttributeNames(map2, map);
                hashSet.add(map2);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to read identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("GetAttributes: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to read identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to get attributes for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        map = this.combineAttrMaps(hashSet, bl);
        return map;
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        Map map;
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        HashSet<Map> hashSet = new HashSet<Map>();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                map = idRepo.getConfiguration();
                Map map2 = null;
                map2 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null ? idRepo.getAttributes(sSOToken, idType, string3) : idRepo.getAttributes(sSOToken, idType, string);
                map2 = this.reverseMapAttributeNames(map2, map);
                hashSet.add(map2);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to read identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("GetAttributes: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to read identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to get attributes for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        map = this.combineAttrMaps(hashSet, true);
        return map;
    }

    public Set getMembers(SSOToken sSOToken, IdType idType, String string, String string2, IdType idType2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        HashSet<Set> hashSet = new HashSet<Set>();
        HashSet hashSet2 = new HashSet();
        boolean bl = false;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            if (!idRepo.getSupportedTypes().contains(idType2)) continue;
            try {
                Set set3;
                boolean bl2 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo");
                Set set4 = set3 = bl2 && string3 != null ? idRepo.getMembers(sSOToken, idType, string3, idType2) : idRepo.getMembers(sSOToken, idType, string, idType2);
                if (bl2) {
                    hashSet2.addAll(set3);
                    bl = true;
                    continue;
                }
                hashSet.add(set3);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to read identity members in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Get Members: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to read identity members in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to get members for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        Set set5 = this.combineMembers(sSOToken, hashSet, idType2, string2, bl, hashSet2);
        return set5;
    }

    public Set getMemberships(SSOToken sSOToken, IdType idType, String string, IdType idType2, String string2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        HashSet<Set> hashSet = new HashSet<Set>();
        HashSet hashSet2 = new HashSet();
        boolean bl = false;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            if (!idRepo.getSupportedTypes().contains(idType2)) continue;
            try {
                Set set3;
                boolean bl2 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo");
                Set set4 = set3 = bl2 && string3 != null ? idRepo.getMemberships(sSOToken, idType, string3, idType2) : idRepo.getMemberships(sSOToken, idType, string, idType2);
                if (bl2) {
                    hashSet2.addAll(set3);
                    bl = true;
                    continue;
                }
                hashSet.add(set3);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to get memberships in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Get memberships: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to read identity in the following repository" + idRepo.getClass().getName(), (Throwable)idRepoException2);
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to get members for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        Set set5 = this.combineMembers(sSOToken, hashSet, idType2, string2, bl, hashSet2);
        return set5;
    }

    public boolean isExists(SSOToken sSOToken, IdType idType, String string, String string2) throws SSOException, IdRepoException {
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            bl = idRepo.isExists(sSOToken, idType, string);
            if (!bl) continue;
        }
        return bl;
    }

    public boolean isActive(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws SSOException, IdRepoException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        boolean bl = false;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                bl = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null ? idRepo.isActive(sSOToken, idType, string3) : idRepo.isActive(sSOToken, idType, string);
                if (!bl) continue;
                break;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("IsActive: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to check isActive identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to check if identity is active " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        return bl;
    }

    public void modifyMemberShip(SSOToken sSOToken, IdType idType, String string, Set set, IdType idType2, int n, String string2) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, null, IdOperation.EDIT, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string2);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string2, set2, IdOperation.EDIT, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n2 = set3.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            if (!idRepo.getSupportedTypes().contains(idType2)) continue;
            try {
                idRepo.modifyMemberShip(sSOToken, idType, string, set, idType2, n);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to modify memberships  in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n2;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Modify membership: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("Unable to modify memberships in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n2;
                idRepoException = idRepoException2;
            }
        }
        if (n2 == 0) {
            IdServicesImpl.getDebug().error("Unable to modify members for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
    }

    public void removeAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, set, IdOperation.EDIT, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string2);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string2, set2, IdOperation.EDIT, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n = set3.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                Map map = idRepo.getConfiguration();
                set = this.mapAttributeNames(set, map);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null) {
                    idRepo.removeAttributes(sSOToken, idType, string3, set);
                    continue;
                }
                idRepo.removeAttributes(sSOToken, idType, string, set);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to modify identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Remove attributes: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to remove attributes in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to remove attributes  for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
    }

    public IdSearchResults search(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, int n, int n2, Set set, String string2) throws IdRepoException, SSOException {
        Object object;
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, null, null, IdOperation.READ, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string2);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string2, set2, IdOperation.READ, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n3 = set3.size();
        Object[][] objectArray = new Object[1][2];
        boolean bl2 = false;
        Object[][] objectArray2 = new Object[n3][2];
        int n4 = 0;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                object = idRepo.getConfiguration();
                RepoSearchResults repoSearchResults = idRepo.search(sSOToken, idType, string, map, bl, n, n2, set);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) {
                    objectArray[0][0] = repoSearchResults;
                    objectArray[0][1] = object;
                    bl2 = true;
                    continue;
                }
                objectArray2[n4][0] = repoSearchResults;
                objectArray2[n4][1] = object;
                ++n4;
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to search in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n3;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Search: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to search identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n3;
                idRepoException = idRepoException2;
            }
        }
        if (n3 == 0) {
            IdServicesImpl.getDebug().error("Unable to search for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        object = this.combineSearchResults(sSOToken, objectArray2, n4, idType, string2, bl2, objectArray);
        return object;
    }

    public IdSearchResults search(SSOToken sSOToken, IdType idType, String string, IdSearchControl idSearchControl, String string2) throws IdRepoException, SSOException {
        Object object;
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, null, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object[][] objectArray = new Object[1][2];
        boolean bl = false;
        Object[][] objectArray2 = new Object[n][2];
        int n2 = 0;
        int n3 = idSearchControl.getTimeOut();
        int n4 = idSearchControl.getMaxResults();
        Set set3 = idSearchControl.getReturnAttributes();
        boolean bl2 = idSearchControl.isGetAllReturnAttributesEnabled();
        IdSearchOpModifier idSearchOpModifier = idSearchControl.getSearchModifier();
        int n5 = -1;
        if (idSearchOpModifier.equals(IdSearchOpModifier.AND)) {
            n5 = 1;
        } else if (idSearchOpModifier.equals(IdSearchOpModifier.OR)) {
            n5 = 0;
        }
        Map map = idSearchControl.getSearchModifierMap();
        boolean bl3 = idSearchControl.isRecursive();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                object = idRepo.getConfiguration();
                RepoSearchResults repoSearchResults = idRepo.search(sSOToken, idType, string, n3, n4, set3, bl2, n5, map, bl3);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) {
                    objectArray[0][0] = repoSearchResults;
                    objectArray[0][1] = object;
                    bl = true;
                    continue;
                }
                objectArray2[n2][0] = repoSearchResults;
                objectArray2[n2][1] = object;
                ++n2;
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("Unable to search in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Search: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to search identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to search for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        object = this.combineSearchResults(sSOToken, objectArray2, n2, idType, string2, bl, objectArray);
        return object;
    }

    public IdSearchResults getSpecialIdentities(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        Object[][] objectArray;
        Object object;
        Object object2;
        OrderedSet orderedSet = new OrderedSet();
        IdRepo idRepo = null;
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(string)) {
            object2 = "com.sun.identity.idm.plugins.internal.SpecialRepo";
            object = null;
            objectArray = this.idRepoMap;
            synchronized (objectArray) {
                object = (IdRepo)this.idRepoMap.get(object2);
            }
            if (object == null) {
                try {
                    Class<?> clazz = Class.forName((String)object2);
                    idRepo = (IdRepo)clazz.newInstance();
                    idRepo.initialize(new HashMap());
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("realm", string);
                    IdRepoListener idRepoListener = new IdRepoListener();
                    idRepoListener.setConfigMap(hashMap);
                    idRepo.addListener(sSOToken, idRepoListener);
                    Map map = this.idRepoMap;
                    synchronized (map) {
                        this.idRepoMap.put(object2, idRepo);
                    }
                    Set set = idRepo.getSupportedOperations(idType);
                    if (set != null && set.contains(IdOperation.READ)) {
                        orderedSet.add(idRepo);
                    }
                }
                catch (Exception exception) {
                    IdServicesImpl.getDebug().error("Unable to instantiate plugin: " + (String)object2, (Throwable)exception);
                }
            } else {
                Set set = ((IdRepo)object).getSupportedOperations(idType);
                if (set != null && set.contains(IdOperation.READ)) {
                    orderedSet.add(object);
                }
            }
        }
        if (orderedSet.isEmpty()) {
            return new IdSearchResults(idType, string);
        }
        object2 = (IdRepo)orderedSet.iterator().next();
        object = ((IdRepo)object2).search(sSOToken, idType, "*", 0, 0, Collections.EMPTY_SET, false, 0, Collections.EMPTY_MAP, false);
        objectArray = new Object[1][2];
        objectArray[0][0] = object;
        objectArray[0][1] = Collections.EMPTY_MAP;
        return this.combineSearchResults(sSOToken, objectArray, 1, idType, string, false, null);
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, String string2, String string3, boolean bl2) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, map.keySet(), IdOperation.EDIT, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = map.containsKey("objectclass") ? this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.SERVICE, idType) : this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.EDIT, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                Map map2 = idRepo.getConfiguration();
                map = this.mapAttributeNames(map, map2);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null) {
                    if (bl2) {
                        idRepo.setAttributes(sSOToken, idType, string3, map, bl);
                        continue;
                    }
                    idRepo.setBinaryAttributes(sSOToken, idType, string3, map, bl);
                    continue;
                }
                if (bl2) {
                    idRepo.setAttributes(sSOToken, idType, string, map, bl);
                    continue;
                }
                idRepo.setBinaryAttributes(sSOToken, idType, string, map, bl);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl:setAttributes: Unable to set attributes in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("Set Attributes: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to modify identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to set attributes  for identity " + idType.getName() + "::" + string + " in any configured data" + " store", (Throwable)idRepoException);
            throw idRepoException;
        }
    }

    public Set getAssignedServices(SSOToken sSOToken, IdType idType, String string, Map map, String string2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string2, string, null, IdOperation.SERVICE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.SERVICE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object object = null;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                Set set3 = null;
                set3 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null ? idRepo.getAssignedServices(sSOToken, idType, string3, map) : idRepo.getAssignedServices(sSOToken, idType, string, map);
                if (set3 == null || set3.isEmpty()) continue;
                hashSet.addAll(set3);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.getAssignedServices: Services not supported for repository " + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("GetAssignedServices: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to get services for identity in the following repository" + object.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to get assigned services for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        return hashSet;
    }

    public void assignService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map, String string3, String string4) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string3, string, null, IdOperation.SERVICE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string3);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string3, set, IdOperation.SERVICE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object object = null;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Map map2 = idRepo.getConfiguration();
            try {
                map = this.mapAttributeNames(map, map2);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string4 != null) {
                    idRepo.assignService(sSOToken, idType, string4, string2, schemaType, map);
                    continue;
                }
                idRepo.assignService(sSOToken, idType, string, string2, schemaType, map);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.assignServices: Assign Services not supported for repository " + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("AssignService: FatalException ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("Unable to assign Service identity in the following repository" + object.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to assign service for identity " + idType.getName() + "::" + string + " in any configured data" + " store ", (Throwable)idRepoException);
            throw idRepoException;
        }
    }

    public void unassignService(SSOToken sSOToken, IdType idType, String string, String string2, Map map, String string3, String string4) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        this.checkPermission(sSOToken, string3, string, null, IdOperation.SERVICE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string3);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string3, set, IdOperation.SERVICE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object object = null;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Map map2 = idRepo.getConfiguration();
            try {
                map = this.mapAttributeNames(map, map2);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string4 != null) {
                    idRepo.unassignService(sSOToken, idType, string4, string2, map);
                    continue;
                }
                idRepo.unassignService(sSOToken, idType, string, string2, map);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.assignServices: Assign Services not supported for repository " + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("UnassignService: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to unassign service in the following repository" + object.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to unassign Service for identity " + idType.getName() + "::" + string + " in any configured " + "data store ", (Throwable)idRepoException);
            throw idRepoException;
        }
    }

    public Map getServiceAttributes(SSOToken sSOToken, IdType idType, String string, String string2, Set set, String string3, String string4) throws IdRepoException, SSOException {
        Object object;
        this.checkPermission(sSOToken, string3, string, null, IdOperation.SERVICE, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string3);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string3, set2, IdOperation.SERVICE, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n = set3.size();
        Object object2 = null;
        HashSet<Map> hashSet = new HashSet<Map>();
        IdRepoException idRepoException = null;
        while (iterator.hasNext()) {
            object = (IdRepo)iterator.next();
            Map map = ((IdRepo)object).getConfiguration();
            try {
                Map map2 = null;
                map2 = object.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string4 != null ? ((IdRepo)object).getServiceAttributes(sSOToken, idType, string4, string2, set) : ((IdRepo)object).getServiceAttributes(sSOToken, idType, string, string2, set);
                map2 = this.reverseMapAttributeNames(map2, map);
                hashSet.add(map2);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object2 != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getServiceAttributes: Services not supported for repository " + object.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("GetServiceAttributes: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object2 != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getServiceAttributes: Unable to get service attributes for the repository " + object2.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to get service attributes for identity " + idType.getName() + "::" + string + " in any configured data store", (Throwable)idRepoException);
            throw idRepoException;
        }
        object = this.combineAttrMaps(hashSet, true);
        return object;
    }

    public void modifyService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map, String string3, String string4) throws IdRepoException, SSOException {
        Object[] objectArray;
        this.checkPermission(sSOToken, string3, string, null, IdOperation.SERVICE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string3);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string3, set, IdOperation.SERVICE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object object = null;
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            Map map2 = objectArray.getConfiguration();
            try {
                map = this.mapAttributeNames(map, map2);
                if (objectArray.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string4 != null) {
                    objectArray.modifyService(sSOToken, idType, string4, string2, schemaType, map);
                    continue;
                }
                objectArray.modifyService(sSOToken, idType, string, string2, schemaType, map);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.modifyServices: Modify Services not supported for repository " + objectArray.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                IdServicesImpl.getDebug().error("ModifyService: Fatal Exception ", (Throwable)idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException) {
                if (object != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to modify service in the following repository " + object.getClass().getName() + " :: " + idRepoException.getMessage());
                }
                --n;
            }
        }
        if (n == 0) {
            IdServicesImpl.getDebug().error("Unable to modify service attributes for identity " + idType.getName() + "::" + string + " in any configured data store");
            objectArray = new Object[]{IdOperation.SERVICE.toString()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "302", objectArray);
        }
    }

    public Set getSupportedTypes(SSOToken sSOToken, String string) throws IdRepoException, SSOException {
        HashSet hashSet = new HashSet();
        Set set = this.getIdRepoPlugins(sSOToken, string);
        Set set2 = this.getAllConfiguredPlugins(sSOToken, string, set);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Set set3 = idRepo.getSupportedTypes();
            if (set3 == null || set3.isEmpty()) continue;
            hashSet.addAll(set3);
        }
        hashSet.retainAll(IdUtils.supportedTypes);
        return hashSet;
    }

    public Set getSupportedOperations(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        HashSet hashSet = new HashSet();
        Set set = this.getIdRepoPlugins(sSOToken, string);
        Set set2 = this.getAllConfiguredPlugins(sSOToken, string, set);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Set set3 = idRepo.getSupportedOperations(idType);
            if (set3 == null || set3.isEmpty()) continue;
            hashSet.addAll(set3);
        }
        return hashSet;
    }

    public void clearIdRepoPlugins() {
        Object object;
        Object object2;
        IdServicesImpl.getDebug().message("IdServicesImpl.cleanupIdRepoPlugins(): Cleanup IdRepo Plugins is called...\n. Cleaning up the map.." + this.idRepoMap);
        HashSet hashSet = new HashSet();
        Map map = this.idRepoMap;
        synchronized (map) {
            object2 = this.idRepoMap.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Object v = this.idRepoMap.get(string);
                if (v instanceof IdRepo) {
                    hashSet.add(this.idRepoMap.get(string));
                    continue;
                }
                Map map2 = (Map)v;
                hashSet.addAll(map2.values());
            }
            this.idRepoMap.clear();
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (IdRepo)object2.next();
            ((IdRepo)object).removeListener();
            ((IdRepo)object).shutdown();
        }
    }

    private Set getIdRepoPlugins(SSOToken sSOToken, String string) {
        if (this.idRepoPlugins == null) {
            return Collections.EMPTY_SET;
        }
        if (ServiceManager.isCoexistenceMode() && !this.idRepoPlugins.contains("amSDK")) {
            this.idRepoPlugins.add("amSDK");
        }
        return this.idRepoPlugins;
    }

    public void reloadIdRepoServiceSchema() {
        this.idRepoPlugins = this.idRepoSubSchema.getSubSchemaNames();
    }

    private Set getConfiguredPlugins(SSOToken sSOToken, String string, Set set, IdOperation idOperation, IdType idType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Set set2;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        HashMap<String, String> hashMap;
        Object object11;
        Object object12;
        Object object13;
        Object object14;
        Object object15;
        OrderedSet orderedSet = new OrderedSet();
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(string)) {
            object15 = "com.sun.identity.idm.plugins.internal.SpecialRepo";
            object14 = null;
            object13 = this.idRepoMap;
            synchronized (object13) {
                object14 = (IdRepo)this.idRepoMap.get(object15);
            }
            if (object14 == null) {
                try {
                    object12 = Class.forName((String)object15);
                    object11 = (IdRepo)((Class)object12).newInstance();
                    ((IdRepo)object11).initialize(new HashMap());
                    hashMap = new HashMap<String, String>();
                    hashMap.put("realm", string);
                    object10 = new IdRepoListener();
                    ((IdRepoListener)object10).setConfigMap(hashMap);
                    ((IdRepo)object11).addListener(sSOToken, (IdRepoListener)object10);
                    object9 = this.idRepoMap;
                    synchronized (object9) {
                        this.idRepoMap.put(object15, object11);
                    }
                    object8 = ((IdRepo)object11).getSupportedOperations(idType);
                    if (object8 != null && object8.contains(idOperation)) {
                        orderedSet.add(object11);
                    }
                }
                catch (Exception exception) {
                    IdServicesImpl.getDebug().error("Unable to instantiate plguin: " + (String)object15, (Throwable)exception);
                }
            } else {
                object12 = ((IdRepo)object14).getSupportedOperations(idType);
                if (object12 != null && object12.contains(idOperation)) {
                    orderedSet.add(object14);
                }
            }
        }
        if (ServiceManager.isCoexistenceMode()) {
            object15 = "com.iplanet.am.sdk.AMSDKRepo";
            object14 = string + ":" + "amSDK";
            object13 = null;
            object12 = null;
            object11 = this.idRepoMap;
            synchronized (object11) {
                object13 = this.idRepoMap.get(object14);
            }
            if (object13 != null && object13 instanceof IdRepo) {
                object12 = (IdRepo)object13;
            }
            if (object12 == null) {
                object7 = new HashMap();
                set2 = new HashSet<String>();
                set2.add(DNMapper.realmNameToAMSDKName(string));
                object7.put("amSDKOrgName", set2);
                try {
                    object6 = Class.forName((String)object15);
                    object5 = (IdRepo)((Class)object6).newInstance();
                    ((IdRepo)object5).initialize((Map)object7);
                    object4 = new HashMap<String, String>();
                    object4.put("realm", string);
                    object4.put("amsdk", "true");
                    object3 = new IdRepoListener();
                    ((IdRepoListener)object3).setConfigMap((Map)object4);
                    ((IdRepo)object5).addListener(sSOToken, (IdRepoListener)object3);
                    object2 = this.idRepoMap;
                    synchronized (object2) {
                        this.idRepoMap.put(object14, object5);
                    }
                    object = ((IdRepo)object5).getSupportedOperations(idType);
                    if (object != null && object.contains(idOperation)) {
                        orderedSet.add(object5);
                    }
                }
                catch (Exception exception) {
                    IdServicesImpl.getDebug().error("Unable to instantiate plugin: " + (String)object15, (Throwable)exception);
                }
            } else {
                object7 = ((IdRepo)object12).getSupportedOperations(idType);
                if (object7 != null && object7.contains(idOperation)) {
                    orderedSet.add(object12);
                }
            }
        }
        object15 = set.iterator();
        while (object15.hasNext()) {
            object14 = (String)object15.next();
            object13 = string + ":" + (String)object14;
            object12 = null;
            object11 = null;
            hashMap = this.idRepoMap;
            synchronized (hashMap) {
                object10 = this.idRepoMap.get(object13);
                if (object10 instanceof Map) {
                    object11 = (Map)object10;
                }
            }
            if (object11 != null) {
                object10 = object11.keySet().iterator();
                while (object10.hasNext()) {
                    object9 = (String)object10.next();
                    object12 = (IdRepo)object11.get(object9);
                    object8 = ((IdRepo)object12).getSupportedOperations(idType);
                    if (object8 == null || !object8.contains(idOperation)) continue;
                    orderedSet.add(object12);
                }
                continue;
            }
            object10 = this.getConfiguredPluginNames(string, (String)object14);
            if (object10 == null || object10.isEmpty()) {
                object9 = this.idRepoMap;
                synchronized (object9) {
                    if (!this.idRepoMap.containsKey(object13)) {
                        this.idRepoMap.put(object13, Collections.EMPTY_MAP);
                    }
                    continue;
                }
            }
            object9 = object10.iterator();
            while (object9.hasNext()) {
                object8 = (String)object9.next();
                object7 = this.getConfigMap(string, (String)object14, (String)object8);
                if (object7 == null || object7.isEmpty() || (set2 = (Set)object7.get("sunIdRepoClass")) == null) continue;
                object6 = (String)set2.iterator().next();
                try {
                    object5 = Class.forName((String)object6);
                    object4 = (IdRepo)((Class)object5).newInstance();
                    ((IdRepo)object4).initialize((Map)object7);
                    object3 = new HashMap();
                    object3.put("realm", string);
                    if (((String)object6).equals("com.iplanet.am.sdk.AMSDKRepo")) {
                        object3.put("amsdk", "true");
                    }
                    object3.put("plugin-name", object8);
                    object2 = new IdRepoListener();
                    ((IdRepoListener)object2).setConfigMap((Map)object3);
                    ((IdRepo)object4).addListener(sSOToken, (IdRepoListener)object2);
                    object = this.idRepoMap;
                    synchronized (object) {
                        HashMap<Object, Object> hashMap2 = (HashMap<Object, Object>)this.idRepoMap.get(object13);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap<Object, Object>();
                        }
                        hashMap2.put(object8, object4);
                        this.idRepoMap.put(object13, hashMap2);
                    }
                    if (!((IdRepo)object4).getSupportedOperations(idType).contains(idOperation)) continue;
                    orderedSet.add(object4);
                }
                catch (Exception exception) {
                    IdServicesImpl.getDebug().error("Unable to instantiate plugin: " + (String)object6, (Throwable)exception);
                }
            }
        }
        return orderedSet;
    }

    private Set getAllConfiguredPlugins(SSOToken sSOToken, String string, Set set) {
        HashMap<String, String> hashMap;
        IdRepo idRepo;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        OrderedSet orderedSet = new OrderedSet();
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(string)) {
            object4 = "com.sun.identity.idm.plugins.internal.SpecialRepo";
            object3 = null;
            object2 = this.idRepoMap;
            synchronized (object2) {
                object3 = (IdRepo)this.idRepoMap.get(object4);
            }
            if (object3 == null) {
                try {
                    object = Class.forName((String)object4);
                    idRepo = (IdRepo)((Class)object).newInstance();
                    idRepo.initialize(new HashMap());
                    hashMap = new HashMap<String, String>();
                    hashMap.put("realm", string);
                    IdRepoListener idRepoListener = new IdRepoListener();
                    idRepoListener.setConfigMap(hashMap);
                    idRepo.addListener(sSOToken, idRepoListener);
                    Map map = this.idRepoMap;
                    synchronized (map) {
                        this.idRepoMap.put(object4, idRepo);
                    }
                    orderedSet.add(idRepo);
                }
                catch (Exception exception) {
                    IdServicesImpl.getDebug().error("Unable to instantiate plguin: " + (String)object4, (Throwable)exception);
                }
            } else {
                orderedSet.add(object3);
            }
        }
        if (ServiceManager.isCoexistenceMode()) {
            object4 = "com.iplanet.am.sdk.AMSDKRepo";
            object3 = string + ":amSDK";
            object2 = null;
            object = this.idRepoMap;
            synchronized (object) {
                object2 = (IdRepo)this.idRepoMap.get(object3);
            }
            if (object2 == null) {
                HashMap hashMap2 = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(DNMapper.realmNameToAMSDKName(string));
                hashMap2.put("amSDKOrgName", hashSet);
                try {
                    Class<?> clazz = Class.forName((String)object4);
                    IdRepo idRepo2 = (IdRepo)clazz.newInstance();
                    idRepo2.initialize(hashMap2);
                    HashMap<String, String> hashMap3 = new HashMap<String, String>();
                    hashMap3.put("realm", string);
                    hashMap3.put("amsdk", "true");
                    IdRepoListener idRepoListener = new IdRepoListener();
                    idRepoListener.setConfigMap(hashMap3);
                    idRepo2.addListener(sSOToken, idRepoListener);
                    Map map = this.idRepoMap;
                    synchronized (map) {
                        this.idRepoMap.put(object3, idRepo2);
                    }
                    orderedSet.add(idRepo2);
                }
                catch (Exception exception) {
                    IdServicesImpl.getDebug().error("Unable to instantiate plugin: " + (String)object4, (Throwable)exception);
                }
            } else {
                orderedSet.add(object2);
            }
        }
        object4 = set.iterator();
        while (object4.hasNext()) {
            Object object5;
            Object object6;
            object3 = (String)object4.next();
            object2 = string + ":" + (String)object3;
            object = null;
            idRepo = null;
            hashMap = this.idRepoMap;
            synchronized (hashMap) {
                idRepo = this.idRepoMap.get(object2);
            }
            if (idRepo != null && idRepo instanceof Map) {
                object = (Map)((Object)idRepo);
            }
            if (object != null) {
                object6 = object.keySet().iterator();
                while (object6.hasNext()) {
                    object5 = (IdRepo)object.get(object6.next());
                    orderedSet.add(object5);
                }
                continue;
            }
            object6 = this.getConfiguredPluginNames(string, (String)object3);
            if (object6 == null) {
                object5 = this.idRepoMap;
                synchronized (object5) {
                    this.idRepoMap.put(object2, Collections.EMPTY_MAP);
                    continue;
                }
            }
            object5 = object6.iterator();
            while (object5.hasNext()) {
                Set set2;
                String string2 = (String)object5.next();
                Map map = this.getConfigMap(string, (String)object3, string2);
                if (map == null || map.isEmpty() || (set2 = (Set)map.get("sunIdRepoClass")) == null) continue;
                String string3 = (String)set2.iterator().next();
                try {
                    Class<?> clazz = Class.forName(string3);
                    IdRepo idRepo3 = (IdRepo)clazz.newInstance();
                    idRepo3.initialize(map);
                    HashMap<String, String> hashMap4 = new HashMap<String, String>();
                    hashMap4.put("realm", string);
                    if (string3.equals("com.iplanet.am.sdk.AMSDKRepo")) {
                        hashMap4.put("amsdk", "true");
                    }
                    hashMap4.put("plugin-name", string2);
                    IdRepoListener idRepoListener = new IdRepoListener();
                    idRepoListener.setConfigMap(hashMap4);
                    idRepo3.addListener(sSOToken, idRepoListener);
                    Map map2 = this.idRepoMap;
                    synchronized (map2) {
                        HashMap<String, IdRepo> hashMap5 = (HashMap<String, IdRepo>)this.idRepoMap.get(object2);
                        if (hashMap5 == null) {
                            hashMap5 = new HashMap<String, IdRepo>();
                        }
                        hashMap5.put(string2, idRepo3);
                        this.idRepoMap.put(object2, hashMap5);
                    }
                    orderedSet.add(idRepo3);
                }
                catch (Exception exception) {
                    IdServicesImpl.getDebug().error("Unable to instantiate plugin: " + string3, (Throwable)exception);
                }
            }
        }
        return orderedSet;
    }

    private Set getConfiguredPluginNames(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, "sunIdentityRepositoryService", "1.0");
            if (serviceConfigManager == null) {
                return hashSet;
            }
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
            if (serviceConfig == null) {
                return hashSet;
            }
            ServiceConfig serviceConfig2 = null;
            Set set = serviceConfig.getSubConfigNames();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    serviceConfig2 = serviceConfig.getSubConfig(string3);
                    if (serviceConfig2 == null || !serviceConfig2.getSchemaID().equalsIgnoreCase(string2)) continue;
                    hashSet.add(string3);
                }
            }
            return hashSet;
        }
        catch (SMSException sMSException) {
            if (ServiceManager.isConfigMigratedTo70()) {
                IdServicesImpl.getDebug().error("SM Exception: unable to get plugin information", (Throwable)sMSException);
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            IdServicesImpl.getDebug().error("SSO Exception: ", (Throwable)sSOException);
            return hashSet;
        }
    }

    private Map getConfigMap(String string, String string2, String string3) {
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (ServiceManager.isCoexistenceMode() && string2.equals("amSDK")) {
            HashMap hashMap = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(DNMapper.realmNameToAMSDKName(string));
            hashMap.put("amSDKOrgName", hashSet);
            return hashMap;
        }
        Map map = Collections.EMPTY_MAP;
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, "sunIdentityRepositoryService", "1.0");
            if (serviceConfigManager == null) {
                return map;
            }
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
            if (serviceConfig == null) {
                return map;
            }
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string3);
            if (serviceConfig2 != null && serviceConfig2.getSchemaID().equalsIgnoreCase(string2)) {
                map = serviceConfig2.getAttributes();
            }
            return map;
        }
        catch (SMSException sMSException) {
            IdServicesImpl.getDebug().error("SM Exception: unable to get plugin information", (Throwable)sMSException);
            return map;
        }
        catch (SSOException sSOException) {
            IdServicesImpl.getDebug().error("SSO Exception: ", (Throwable)sSOException);
            return map;
        }
    }

    private Map combineAttrMaps(Set set, boolean bl) {
        AMHashMap aMHashMap = new AMHashMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            if (map == null) continue;
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                String string = (String)iterator2.next();
                if (bl) {
                    object2 = (Set)aMHashMap.get(string);
                    object = (Set)map.get(string);
                    if (object2 != null) {
                        object2.addAll(object);
                        continue;
                    }
                    object2 = new HashSet((Set)map.get(string));
                    aMHashMap.put(string, object2);
                    continue;
                }
                object2 = (byte[][])aMHashMap.get(string);
                object = (byte[][])map.get(string);
                int n = ((Object)object).length;
                if (object2 != null) {
                    n = ((Object)object2).length + ((Object)object).length;
                    byte[][] byArrayArray = new byte[n][];
                    int n2 = 0;
                    while (n2 < ((HashSet<E>)object2).length) {
                        byArrayArray[n2] = (byte[])object2[n2];
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < ((Object)object).length) {
                        byArrayArray[n3] = (byte[])object[n3];
                        ++n3;
                    }
                    object2 = byArrayArray;
                } else {
                    object2 = (byte[][])object.clone();
                }
                aMHashMap.put(string, object2);
            }
        }
        return aMHashMap;
    }

    private Map mapAttributeNames(Map map, Map map2) {
        Map map3;
        if (map == null || map.isEmpty()) {
            return map;
        }
        Map[] mapArray = this.getAttributeNameMap(map2);
        if (mapArray == null) {
            map3 = map;
        } else {
            map3 = new CaseInsensitiveHashMap();
            Map map4 = mapArray[0];
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map4.containsKey(string)) {
                    map3.put((String)map4.get(string), (Set)map.get(string));
                    continue;
                }
                map3.put(string, (Set)map.get(string));
            }
        }
        return map3;
    }

    private Set mapAttributeNames(Set set, Map map) {
        Set set2;
        if (set == null || set.isEmpty()) {
            return set;
        }
        Map[] mapArray = this.getAttributeNameMap(map);
        if (mapArray == null) {
            set2 = set;
        } else {
            set2 = new CaseInsensitiveHashSet();
            Map map2 = mapArray[0];
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map2.containsKey(string)) {
                    set2.add((String)map2.get(string));
                    continue;
                }
                set2.add(string);
            }
        }
        return set2;
    }

    private Map reverseMapAttributeNames(Map map, Map map2) {
        Map map3;
        if (map == null || map.isEmpty()) {
            return map;
        }
        Map[] mapArray = this.getAttributeNameMap(map2);
        if (mapArray == null) {
            map3 = map;
        } else {
            map3 = new CaseInsensitiveHashMap();
            Map map4 = mapArray[1];
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map4.containsKey(string)) {
                    map3.put((String)map4.get(string), (Set)map.get(string));
                    continue;
                }
                map3.put(string, (Set)map.get(string));
            }
        }
        return map3;
    }

    private Set combineMembers(SSOToken sSOToken, Set set, IdType idType, String string, boolean bl, Set set2) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        HashSet<Object> hashSet = new HashSet<Object>();
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap();
        if (bl && set2 != null) {
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = object3;
                if (DN.isDN(object3)) {
                    object2 = new DN(object3).explodeDN(true)[0];
                }
                object = new AMIdentity(sSOToken, (String)object2, idType, string, (String)object3);
                hashSet.add(object);
                caseInsensitiveHashMap.put(object2, object);
            }
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = (Set)iterator.next();
            if (object3 == null) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                String string2 = object;
                if (DN.isDN((String)object)) {
                    string2 = new DN((String)object).explodeDN(true)[0];
                }
                if (caseInsensitiveHashMap.containsKey(string2)) continue;
                AMIdentity aMIdentity = new AMIdentity(sSOToken, string2, idType, string, null);
                hashSet.add(aMIdentity);
                caseInsensitiveHashMap.put(string2, aMIdentity);
            }
        }
        return hashSet;
    }

    private IdSearchResults combineSearchResults(SSOToken sSOToken, Object[][] objectArray, int n, IdType idType, String string, boolean bl, Object[][] objectArray2) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        Object object5;
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap();
        CaseInsensitiveHashMap caseInsensitiveHashMap2 = new CaseInsensitiveHashMap();
        int n2 = 0;
        if (bl) {
            RepoSearchResults repoSearchResults = (RepoSearchResults)objectArray2[0][0];
            object5 = (Map)objectArray2[0][1];
            object4 = repoSearchResults.getSearchResults();
            iterator = repoSearchResults.getResultAttributes();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                string2 = new DN((String)object2).explodeDN(true)[0];
                caseInsensitiveHashMap.put(string2, object2);
                object = new HashSet();
                object.add((Map)iterator.get(object2));
                caseInsensitiveHashMap2.put(string2, object);
            }
            n2 = repoSearchResults.getErrorCode();
        }
        int n3 = 0;
        while (n3 < n) {
            object5 = (RepoSearchResults)objectArray[n3][0];
            object4 = (Map)objectArray[n3][1];
            iterator = ((RepoSearchResults)object5).getSearchResults().iterator();
            object3 = ((RepoSearchResults)object5).getResultAttributes();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                string2 = object2;
                object = (Map)object3.get(object2);
                if (DN.isDN((String)object2)) {
                    string2 = new DN((String)object2).explodeDN(true)[0];
                }
                object = this.reverseMapAttributeNames((Map)object, (Map)object4);
                HashSet<Object> hashSet = (HashSet<Object>)caseInsensitiveHashMap2.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<Object>();
                }
                hashSet.add(object);
                caseInsensitiveHashMap2.put(string2, hashSet);
            }
            ++n3;
        }
        object5 = new IdSearchResults(idType, string);
        object4 = caseInsensitiveHashMap2.keySet().iterator();
        while (object4.hasNext()) {
            iterator = (String)object4.next();
            object3 = this.combineAttrMaps((Set)caseInsensitiveHashMap2.get(iterator), true);
            object2 = new AMIdentity(sSOToken, (String)((Object)iterator), idType, string, (String)caseInsensitiveHashMap.get(iterator));
            ((IdSearchResults)object5).addResult((AMIdentity)object2, (Map)object3);
        }
        ((IdSearchResults)object5).setErrorCode(n2);
        return object5;
    }

    private Map[] getAttributeNameMap(Map map) {
        Set set = (Set)map.get("sunIdRepoAttributeMapping");
        if (set == null || set.isEmpty()) {
            return null;
        }
        Map[] mapArray = new Map[2];
        int n = set.size();
        mapArray[0] = new CaseInsensitiveHashMap(n);
        mapArray[1] = new CaseInsensitiveHashMap(n);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.indexOf(61);
            if (n2 > -1) {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                mapArray[0].put(string2, string3);
                mapArray[1].put(string3, string2);
                continue;
            }
            mapArray[0].put(string, string);
            mapArray[1].put(string, string);
        }
        return mapArray;
    }

    private boolean checkPermission(SSOToken sSOToken, String string, String string2, Set set, IdOperation idOperation, IdType idType) throws IdRepoException, SSOException {
        if (!ServiceManager.isConfigMigratedTo70()) {
            return true;
        }
        HashSet hashSet = null;
        hashSet = idOperation.equals(IdOperation.READ) ? READ_ACTION : WRITE_ACTION;
        try {
            DelegationEvaluator delegationEvaluator = new DelegationEvaluator();
            String string3 = idType.getName();
            if (string2 != null) {
                string3 = string3 + "/" + string2;
            }
            DelegationPermission delegationPermission = new DelegationPermission(string, "sunIdentityRepositoryService", "1.0", "application", string3, hashSet, Collections.EMPTY_MAP);
            HashMap<String, Set> hashMap = Collections.EMPTY_MAP;
            if (set != null) {
                hashMap = new HashMap<String, Set>();
                hashMap.put(DELEGATION_ATTRS_NAME, set);
            }
            if (!delegationEvaluator.isAllowed(sSOToken, delegationPermission, hashMap)) {
                Object[] objectArray = new Object[]{idOperation.getName(), sSOToken.getPrincipal().getName()};
                throw new IdRepoException("amIdRepo", "402", objectArray);
            }
            return true;
        }
        catch (DelegationException delegationException) {
            IdServicesImpl.getDebug().error("IdServicesImpl.checkPermission Got Delegation Exception: ", (Throwable)((Object)delegationException));
            Object[] objectArray = new Object[]{idOperation.getName(), sSOToken.getPrincipal().getName()};
            throw new IdRepoException("amIdRepo", "402", objectArray);
        }
    }

    static {
        READ_ACTION.add("READ");
        WRITE_ACTION.add("MODIFY");
    }
}

