/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.server;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdCachedServices;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.common.IdCacheBlock;
import com.sun.identity.idm.server.IdServicesImpl;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;

public class IdCachedServicesImpl
extends IdServicesImpl
implements IdCachedServices {
    private static int maxSize = 10000;
    private static IdServices instance = null;
    static final String CACHE_MAX_SIZE_KEY = "com.iplanet.am.sdk.cache.maxSize";
    private Cache idRepoCache;

    private static void initializeParams() {
        String string = SystemProperties.get((String)CACHE_MAX_SIZE_KEY, (String)"10000");
        try {
            maxSize = Integer.parseInt(string);
            if (maxSize < 1) {
                maxSize = 10000;
            }
            if (IdServicesImpl.getDebug().messageEnabled()) {
                IdServicesImpl.getDebug().message("IdCachedServicesImpl.intializeParams() Caching size set to: " + maxSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            maxSize = 10000;
            IdServicesImpl.getDebug().warning("IdCachedServicesImpl.initializeParams() - invalid value for cache size specified. Setting to default value: " + maxSize);
        }
    }

    private IdCachedServicesImpl() {
        this.initializeCache();
    }

    private void initializeCache() {
        this.idRepoCache = new Cache(maxSize);
    }

    public int getSize() {
        return this.idRepoCache.size();
    }

    protected static synchronized IdServices getInstance() {
        if (instance == null) {
            IdServicesImpl.getDebug().message("IdCachedServicesImpl.getInstance(): Creating new Instance of IdCachedServicesImpl()");
            instance = new IdCachedServicesImpl();
        }
        return instance;
    }

    protected static int getMaxSize() {
        return maxSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n<<<<<<< BEGIN SDK CACHE CONTENTS >>>>>>>>");
        if (!this.idRepoCache.isEmpty()) {
            Enumeration enumeration = this.idRepoCache.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                IdCacheBlock idCacheBlock = (IdCacheBlock)this.idRepoCache.get((Object)string);
                stringBuffer.append("\nSDK Cache Block: ").append(string);
                stringBuffer.append(idCacheBlock.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        stringBuffer.append("\n<<<<<<< END SDK CACHE CONTENTS >>>>>>>>");
        return stringBuffer.toString();
    }

    private void removeCachedAttributes(String string, Set set) {
        Enumeration enumeration = this.idRepoCache.keys();
        while (enumeration.hasMoreElements()) {
            IdCacheBlock idCacheBlock;
            int n;
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.regionMatches(true, (n2 = string2.length()) - (n = string.length()), string, 0, n) || (idCacheBlock = (IdCacheBlock)this.idRepoCache.get((Object)string2)) == null || idCacheBlock.hasExpiredAndUpdated() || !idCacheBlock.isExists()) continue;
            idCacheBlock.removeAttributes(set);
        }
    }

    private void clearCachedEntries(String string) {
        Enumeration enumeration = this.idRepoCache.keys();
        while (enumeration.hasMoreElements()) {
            IdCacheBlock idCacheBlock;
            int n;
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.regionMatches(true, (n2 = string2.length()) - (n = string.length()), string, 0, n) || (idCacheBlock = (IdCacheBlock)this.idRepoCache.get((Object)string2)) == null) continue;
            idCacheBlock.clear();
        }
    }

    public synchronized void clearCache() {
        this.idRepoCache.clear();
        this.initializeCache();
    }

    public void dirtyCache(String string, int n, boolean bl, boolean bl2, Set set) {
        String string2 = string;
        string = MiscUtils.formatToRFC(string);
        switch (n) {
            case 1: {
                IdCacheBlock idCacheBlock = this.getFromCache(string);
                if (idCacheBlock != null) {
                    idCacheBlock.setExists(true);
                }
                if (!bl) break;
                this.removeCachedAttributes(string, set);
                break;
            }
            case 2: {
                IdCacheBlock idCacheBlock = (IdCacheBlock)this.idRepoCache.remove((Object)string);
                if (idCacheBlock != null) {
                    idCacheBlock.clear();
                }
                if (!bl) break;
                this.removeCachedAttributes(string, set);
                break;
            }
            case 8: {
                IdCacheBlock idCacheBlock = (IdCacheBlock)this.idRepoCache.remove((Object)string);
                if (idCacheBlock != null) {
                    idCacheBlock.clear();
                }
                if (!bl) break;
                this.removeCachedAttributes(string, set);
                break;
            }
            case 4: {
                IdCacheBlock idCacheBlock = this.getFromCache(string);
                if (idCacheBlock != null) {
                    idCacheBlock.clear();
                }
                if (bl) {
                    this.removeCachedAttributes(string, set);
                    break;
                }
                if (!bl2) break;
                this.clearCachedEntries(string);
            }
        }
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdCachedServicesImpl.dirtyCache(): Cache dirtied because of Event Notification. Parameters - eventType: " + n + ", cosType: " + bl + ", aciChange: " + bl2 + ", fullDN: " + string2 + "; rfcDN =" + string);
        }
    }

    private void updateCache(SSOToken sSOToken, String string, Map map, Map map2) throws SSOException {
        String string2 = MiscUtils.formatToRFC(string);
        IdCacheBlock idCacheBlock = (IdCacheBlock)this.idRepoCache.get((Object)string2);
        if (idCacheBlock != null && !idCacheBlock.hasExpiredAndUpdated() && idCacheBlock.isExists()) {
            String string3 = MiscUtils.getPrincipalDN(sSOToken);
            idCacheBlock.replaceAttributes(string3, map, map2);
        }
    }

    private void dirtyCache(String string) {
        String string2 = MiscUtils.formatToRFC(string);
        IdCacheBlock idCacheBlock = this.getFromCache(string2);
        if (idCacheBlock != null) {
            idCacheBlock.clear();
        }
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3) throws IdRepoException, SSOException {
        AMIdentity aMIdentity = new AMIdentity(sSOToken, string, idType, string2, string3);
        String string4 = IdUtils.getUniversalId(aMIdentity).toLowerCase();
        AMIdentity aMIdentity2 = IdUtils.getIdentity(sSOToken);
        String string5 = IdUtils.getUniversalId(aMIdentity2).toLowerCase();
        IdCacheBlock idCacheBlock = (IdCacheBlock)this.idRepoCache.get((Object)string4);
        if (set == null || set.isEmpty()) {
            return this.getAttributes(sSOToken, idType, string, string2, string3);
        }
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("In IdCachedServicesImpl.getAttributes(SSOToken type, name, attrNames, amOrgName, amsdkDN) (" + string5 + ", " + string4 + ", " + set + " ," + string2 + " , " + string3 + " method.");
        }
        if (idCacheBlock == null) {
            if (IdServicesImpl.getDebug().messageEnabled()) {
                IdServicesImpl.getDebug().message("IdCachedServicesImpl.getAttributes(): NO entry found in Cachefor key = " + string4 + ". Getting all these attributes from DS: " + set);
            }
            AMHashMap aMHashMap = (AMHashMap)super.getAttributes(sSOToken, idType, string, set, string2, string3, true);
            Set set2 = aMHashMap.getMissingAndEmptyKeys(set);
            idCacheBlock = new IdCacheBlock(string4, true);
            idCacheBlock.putAttributes(string5, aMHashMap, set2, false, false);
            this.idRepoCache.put((Object)string4, (Object)idCacheBlock);
            return aMHashMap;
        }
        AMHashMap aMHashMap = (AMHashMap)idCacheBlock.getAttributes(string5, set, false);
        Set set3 = aMHashMap.getMissingKeys(set);
        if (!set3.isEmpty()) {
            if (IdServicesImpl.getDebug().messageEnabled()) {
                IdServicesImpl.getDebug().message("IdCachedServicesImpl.getAttributes(): Trying to gett these missing attributes from DS: " + set3);
            }
            AMHashMap aMHashMap2 = (AMHashMap)super.getAttributes(sSOToken, idType, string, set, string2, string3, true);
            aMHashMap.putAll(aMHashMap2);
            Set set4 = aMHashMap2.getMissingAndEmptyKeys(set3);
            idCacheBlock.putAttributes(string5, aMHashMap2, set4, false, false);
        } else if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdCachedServicesImpl.getAttributes(): " + string3 + " found all attributes in Cache.");
        }
        return aMHashMap;
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        AMHashMap aMHashMap;
        AMIdentity aMIdentity = new AMIdentity(sSOToken, string, idType, string2, string3);
        String string4 = IdUtils.getUniversalId(aMIdentity).toLowerCase();
        AMIdentity aMIdentity2 = IdUtils.getIdentity(sSOToken);
        String string5 = IdUtils.getUniversalId(aMIdentity2).toLowerCase();
        IdCacheBlock idCacheBlock = (IdCacheBlock)this.idRepoCache.get((Object)string4);
        if (idCacheBlock != null) {
            if (idCacheBlock.hasCompleteSet(string5)) {
                if (IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdCachedServicesImpl.getAttributes(): DN: " + string4 + " found all attributes in Cache.");
                }
                aMHashMap = (AMHashMap)idCacheBlock.getAttributes(string5, false);
            } else {
                if (IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdCachedServicesImpl.getAttributes(): " + string4 + " complete attribute" + " set NOT found in cache. Getting from DS.");
                }
                aMHashMap = (AMHashMap)super.getAttributes(sSOToken, idType, string, string2, string3);
                idCacheBlock.putAttributes(string5, aMHashMap, null, true, false);
            }
        } else {
            aMHashMap = (AMHashMap)super.getAttributes(sSOToken, idType, string, string2, string3);
            idCacheBlock = new IdCacheBlock(string4, true);
            idCacheBlock.putAttributes(string5, aMHashMap, null, true, false);
            this.idRepoCache.put((Object)string4, (Object)idCacheBlock);
            if (IdServicesImpl.getDebug().messageEnabled()) {
                IdServicesImpl.getDebug().message("IdCachedServicesImpl.getAttributes(): attributes NOT found in cache. Fetched from DS.");
            }
        }
        return aMHashMap;
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, String string2, String string3) throws IdRepoException, SSOException {
        super.setAttributes(sSOToken, idType, string, map, bl, string2, string3, true);
        AMIdentity aMIdentity = new AMIdentity(sSOToken, string, idType, string2, string3);
        String string4 = IdUtils.getUniversalId(aMIdentity).toLowerCase();
        if (idType.equals(IdType.USER)) {
            this.updateCache(sSOToken, string4, map, null);
        } else {
            this.dirtyCache(string4);
        }
    }

    private IdCacheBlock getFromCache(String string) {
        int n;
        IdCacheBlock idCacheBlock = (IdCacheBlock)this.idRepoCache.get((Object)string);
        if (idCacheBlock == null && (n = string.indexOf("amsdkdn=")) > -1) {
            String string2 = string.substring(0, n);
            idCacheBlock = (IdCacheBlock)this.idRepoCache.get((Object)string2);
        }
        return idCacheBlock;
    }

    static {
        IdCachedServicesImpl.initializeParams();
    }
}

