/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.ldapv3;

import com.iplanet.am.util.Debug;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3EventService;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3EventServicePolling;
import java.util.Random;

class LDAPv3TimeOut
implements Runnable {
    private Thread _serviceThread;
    private long _timeOut;
    private Object _monitor;
    private boolean _exitStatus = false;
    private Debug debug = LDAPv3EventService.debugger;
    private int randomID = 0;
    private LDAPv3EventServicePolling _serviceInstance;

    LDAPv3TimeOut(LDAPv3EventServicePolling lDAPv3EventServicePolling, long l, Object object) {
        Random random = new Random();
        this.randomID = random.nextInt();
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3TimeOut.run() - constructor. randomID=" + this.randomID);
        }
        this.setServiceInstance(lDAPv3EventServicePolling);
        this.setServiceThread(this.getServiceInstance().getServiceThread());
        this.setTimeOutValue(l);
        this.setMonitor(object);
    }

    public void run() {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3TimeOut.run() - thread started. randomID=" + this.randomID);
        }
        while (!this.shouldExit()) {
            try {
                long l = this.getTimeOutValue();
                if (this.debug.messageEnabled()) {
                    this.debug.message("LDAPv3TimeOut.run() - Sleeping for " + l + " milliseconds." + " randomID=" + this.randomID);
                }
                Thread.sleep(l);
                Object object = this._monitor;
                synchronized (object) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("LDAPv3TimeOut.run() - Notifying LDAPv3EventServicePolling thread about timeout randomID=" + this.randomID);
                    }
                    this.getServiceThread().interrupt();
                    if (this.debug.messageEnabled()) {
                        this.debug.message("LDAPv3TimeOut.run() - Waiting for LDAPv3EventServicePolling thread to notify randomID=" + this.randomID);
                    }
                    this._monitor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                if (!this.debug.messageEnabled()) continue;
                this.debug.message("LDAPv3TimeOut.run() - Received interrupt ", (Throwable)interruptedException);
                this.debug.message("    randomID=" + this.randomID);
            }
        }
        this.debug.error("LDAPv3TimeOut.run() - thread stopped as notified by LDAPv3EventServicePolling thread. randomID=" + this.randomID);
    }

    private void setServiceInstance(LDAPv3EventServicePolling lDAPv3EventServicePolling) {
        this._serviceInstance = lDAPv3EventServicePolling;
    }

    private LDAPv3EventServicePolling getServiceInstance() {
        return this._serviceInstance;
    }

    protected synchronized void setTimeOutValue(long l) {
        this._timeOut = l;
    }

    private synchronized long getTimeOutValue() {
        return this._timeOut;
    }

    private void setServiceThread(Thread thread) {
        this._serviceThread = thread;
    }

    private Thread getServiceThread() {
        return this._serviceThread;
    }

    protected synchronized void setExitStatus(boolean bl) {
        this._exitStatus = bl;
    }

    private synchronized boolean shouldExit() {
        return this._exitStatus || !this.getServiceThread().isAlive();
    }

    private void setMonitor(Object object) {
        this._monitor = object;
    }
}

