/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.ldapv3;

import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3EventService;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3TimeOut;
import com.sun.identity.idm.plugins.ldapv3.Request;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPMessage;

public class LDAPv3EventServicePolling
extends LDAPv3EventService {
    private LDAPv3TimeOut _timeOut = null;
    private Thread _timeOutThread = null;
    private Object _monitor;
    private final int IS_MESSAGE_PROCESSED = 0;

    public synchronized void removeListener(LDAPv3Repo lDAPv3Repo) {
        if (LDAPv3EventService.debugger.messageEnabled()) {
            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.removeListener called");
        }
        super.removeListener(lDAPv3Repo);
        this._timeOutThread.interrupt();
    }

    public synchronized String addListener(SSOToken sSOToken, IdRepoListener idRepoListener, String string, int n, String string2, int n2, Map map, LDAPv3Repo lDAPv3Repo) throws LDAPException, IdRepoException {
        String string3 = super.addListener(sSOToken, idRepoListener, string, n, string2, n2, map, lDAPv3Repo);
        this.startTimeOutThread();
        return string3;
    }

    public void run() {
        if (LDAPv3EventService.debugger.messageEnabled()) {
            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.run(): Event Thread is running! Idle timeout = " + this._idleTimeOut + " minutes." + " randomID=" + this.randomID);
        }
        boolean bl = true;
        LDAPMessage lDAPMessage = null;
        boolean[] blArray = new boolean[1];
        while (bl) {
            block12: {
                try {
                    try {
                        if (LDAPv3EventService.debugger.messageEnabled()) {
                            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.run(): Waiting for response. randomID=" + this.randomID);
                        }
                        lDAPMessage = null;
                        blArray[0] = false;
                        lDAPMessage = this._msgQueue.getResponse();
                        bl = this.processResponse(lDAPMessage, blArray);
                    }
                    catch (LDAPInterruptedException lDAPInterruptedException) {
                        bl = this.processLDAPInterruptedException(lDAPInterruptedException, lDAPMessage, blArray);
                    }
                    catch (LDAPException lDAPException) {
                        bl = this.processLDAPException(lDAPException);
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InterruptedException) {
                        bl = this.processInterruptedException(lDAPMessage, blArray, bl);
                    }
                    if (LDAPv3EventService.debugger.warningEnabled()) {
                        LDAPv3EventService.debugger.warning("LDAPv3EventServicePolling.run(): Unknown exception caught. Ignoring.. randomID=" + this.randomID, throwable);
                    }
                    if (this._requestList.size() <= 0) break block12;
                    this.sleepRetryInterval();
                }
            }
            if (LDAPv3EventService.debugger.warningEnabled()) {
                LDAPv3EventService.debugger.warning("LDAPv3EventServicePolling.run(). _requestList.size()=" + this._requestList.size());
            }
            if (this._requestList.size() != 0) continue;
            bl = false;
        }
        this._timeOut.setExitStatus(true);
        if (LDAPv3EventService.debugger.warningEnabled()) {
            LDAPv3EventService.debugger.error("LDAPv3EventServicePolling.run() - Monitor thread is terminating! Persistent Searches will no longer be operational.  randomID=" + this.randomID);
        }
    }

    protected LDAPv3EventServicePolling(Map map) throws LDAPException {
        super(map);
        if (LDAPv3EventService.debugger.messageEnabled()) {
            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.constructor() exit. randomID=" + this.randomID);
        }
    }

    protected String getName() {
        return "LDAPv3EventServicePolling";
    }

    protected boolean processResponse(LDAPMessage lDAPMessage, boolean[] blArray) {
        Object object = this._monitor;
        synchronized (object) {
            boolean bl = true;
            bl = super.processResponse(lDAPMessage);
            blArray[0] = true;
            lDAPMessage = null;
            boolean bl2 = bl;
            return bl2;
        }
    }

    protected boolean resetAllSearches(boolean bl) {
        boolean bl2 = super.resetAllSearches(bl);
        this.interruptTimeOutThread(!bl2, this._idleTimeOutMills);
        return bl2;
    }

    private synchronized boolean resetTimedOutConnections() {
        HashSet<Request> hashSet = new HashSet<Request>();
        long l = this._idleTimeOutMills;
        long l2 = System.currentTimeMillis();
        if (LDAPv3EventService.debugger.messageEnabled()) {
            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.resetTimedOutConnections(): determining timed out connections. randomID=" + this.randomID);
        }
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            long l3 = request.getLastUpdatedTime();
            if (this.checkIfTimedOut(l2, l3)) {
                if (LDAPv3EventService.debugger.messageEnabled()) {
                    LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.resetTimedOutConnections(): the following request: " + request.getListener() + " has timed" + " out. Current Time: " + l2 + " Last " + "updated time: " + request.getLastUpdatedTime() + " randomID=" + this.randomID);
                }
                hashSet.add(request);
                continue;
            }
            long l4 = l3 + this._idleTimeOutMills - l2;
            long l5 = l = l4 < l ? l4 : l;
        }
        boolean bl = true;
        bl = l == this._idleTimeOutMills ? this.resetAllSearches(false) : this.resetTimedOutSearches(hashSet, l);
        return bl;
    }

    private synchronized boolean resetTimedOutSearches(Set set, long l) {
        boolean bl;
        block9: {
            if (LDAPv3EventService.debugger.messageEnabled()) {
                LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.resetAllSearches(): " + set.size() + " connections (searches) timed out!" + " randomID=" + this.randomID);
            }
            bl = true;
            long l2 = this._idleTimeOutMills;
            try {
                try {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Request request = (Request)iterator.next();
                        this.removeListener(request);
                        this.addListener(request.getRequester(), request.getListener(), request.getBaseDn(), request.getScope(), request.getFilter(), request.getOperations(), request.getPluginConfig(), request.getOwner());
                        this._requestList.remove(request.getRequestID());
                    }
                    l2 = l;
                }
                catch (IdRepoException idRepoException) {
                    if (LDAPv3EventService.debugger.messageEnabled()) {
                        LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.resetAllSearches():  IdRepException occurred while re-establishinglisteners.  randomID=" + this.randomID, (Throwable)idRepoException);
                    }
                    int n = 87;
                    bl = this.processExceptionErrorCodes(idRepoException, n, false);
                    Object var11_11 = null;
                    this.interruptTimeOutThread(!bl, l2);
                    break block9;
                }
                catch (LDAPException lDAPException) {
                    if (LDAPv3EventService.debugger.messageEnabled()) {
                        LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.resetAllSearches(): LDAPException occurred, while trying to re-establish persistent searches. randomID=" + this.randomID, (Throwable)lDAPException);
                    }
                    int n = lDAPException.getLDAPResultCode();
                    bl = this.processExceptionErrorCodes((Exception)((Object)lDAPException), n, false);
                    Object var11_12 = null;
                    this.interruptTimeOutThread(!bl, l2);
                }
                Object var11_10 = null;
                this.interruptTimeOutThread(!bl, l2);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.interruptTimeOutThread(!bl, l2);
                throw throwable;
            }
        }
        return bl;
    }

    private boolean checkIfTimedOut(long l, long l2) {
        boolean bl = false;
        long l3 = l - l2;
        long l4 = l3 / 60000L;
        long l5 = (long)this._idleTimeOut - l4;
        if (l5 <= 1L) {
            bl = true;
        }
        return bl;
    }

    private boolean processExceptionErrorCodes(Exception exception, int n, boolean bl) {
        boolean bl2 = true;
        if (this._retryErrorCodes.contains(Integer.toString(n))) {
            bl2 = super.resetAllSearches(true);
            if (bl) {
                this.interruptTimeOutThread(!bl2, this._idleTimeOutMills);
            }
        } else {
            this.processNetworkError(exception);
        }
        return bl2;
    }

    private boolean processLDAPException(LDAPException lDAPException) {
        Object object = this._monitor;
        synchronized (object) {
            if (LDAPv3EventService.debugger.warningEnabled()) {
                LDAPv3EventService.debugger.warning("LDAPv3EventServicePolling.processLDAPException() - LDAPException received:  randomID=" + this.randomID, (Throwable)lDAPException);
            }
            boolean bl = true;
            int n = lDAPException.getLDAPResultCode();
            boolean bl2 = bl = this.processExceptionErrorCodes((Exception)((Object)lDAPException), n, true);
            return bl2;
        }
    }

    private boolean processInterruptedException(LDAPMessage lDAPMessage, boolean[] blArray, boolean bl) {
        if (LDAPv3EventService.debugger.messageEnabled()) {
            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.processInterruptedException() - Message present: " + (lDAPMessage != null) + " Processed earlier: " + blArray[0] + " randomID=" + this.randomID);
        }
        boolean bl2 = bl;
        if (!blArray[0]) {
            bl2 = this.processResponse(lDAPMessage, blArray);
        }
        if (bl2) {
            bl2 = this.resetTimedOutConnections();
        }
        return bl2;
    }

    private boolean processLDAPInterruptedException(LDAPInterruptedException lDAPInterruptedException, LDAPMessage lDAPMessage, boolean[] blArray) {
        if (LDAPv3EventService.debugger.messageEnabled()) {
            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.processLDAPInterruptedException(): Received an interrupted Exception - resetting searches. Message present: " + (lDAPMessage != null) + "message proccessed: " + blArray[0] + " randomID=" + this.randomID, (Throwable)lDAPInterruptedException);
        }
        boolean bl = true;
        if (lDAPMessage != null && !blArray[0]) {
            bl = this.processResponse(lDAPMessage, blArray);
        }
        if (bl) {
            bl = this.resetTimedOutConnections();
        }
        return bl;
    }

    private void initialize(LDAPMessage lDAPMessage, boolean[] blArray) {
        lDAPMessage = null;
        blArray[0] = false;
    }

    private void startTimeOutThread() {
        if (this._timeOutThread == null || !this._timeOutThread.isAlive()) {
            this._monitor = new Object();
            this._timeOut = new LDAPv3TimeOut(this, this._idleTimeOutMills, this._monitor);
            this._timeOutThread = new Thread((Runnable)this._timeOut, "LDAPv3TimeOut");
            this._timeOutThread.setDaemon(true);
            this._timeOutThread.start();
        }
    }

    private void interruptTimeOutThread(boolean bl, long l) {
        if (LDAPv3EventService.debugger.messageEnabled()) {
            LDAPv3EventService.debugger.message("LDAPv3EventServicePolling.interruptTimeOutThread():  Interrupting TimeOut thread with exit status: " + bl + " time out: " + l + " randomID=" + this.randomID);
        }
        this._timeOut.setTimeOutValue(l);
        this._timeOut.setExitStatus(bl);
        this._timeOutThread.interrupt();
    }

    protected Thread getServiceThread() {
        return this._monitorThread;
    }
}

