/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.common;

import com.iplanet.am.sdk.common.CacheBlockBase;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;

public class IdCacheBlock
extends CacheBlockBase {
    protected static final String ENTRY_EXPIRATION_ENABLED_KEY = "com.sun.identity.idm.cache.entry.expire.enabled";
    protected static final String ENTRY_USER_EXPIRE_TIME_KEY = "com.sun.identity.idm.cache.entry.user.expire.time";
    protected static final String ENTRY_DEFAULT_EXPIRE_TIME_KEY = "com.sun.identity.idm.cache.entry.default.expire.time";
    protected static boolean ENTRY_EXPIRATION_ENABLED_FLAG = false;
    protected static long ENTRY_USER_EXPIRE_TIME;
    protected static long ENTRY_DEFAULT_EXPIRE_TIME;
    private Debug debug = Debug.getInstance((String)"amIdm");

    private static void initializeExpirationParms() {
        IdCacheBlock.setEntryExpirationEnabledFlag();
        if (ENTRY_EXPIRATION_ENABLED_FLAG) {
            IdCacheBlock.setUserEntryExpirationTime();
            IdCacheBlock.setDefaultEntryExpirationTime();
        }
    }

    private static void setEntryExpirationEnabledFlag() {
        String string = SystemProperties.get((String)ENTRY_EXPIRATION_ENABLED_KEY, (String)"false");
        ENTRY_EXPIRATION_ENABLED_FLAG = new Boolean(string);
    }

    private static void setUserEntryExpirationTime() {
        ENTRY_USER_EXPIRE_TIME = IdCacheBlock.getPropertyIntValue(ENTRY_USER_EXPIRE_TIME_KEY, 15) * 60000;
    }

    private static void setDefaultEntryExpirationTime() {
        ENTRY_DEFAULT_EXPIRE_TIME = IdCacheBlock.getPropertyIntValue(ENTRY_DEFAULT_EXPIRE_TIME_KEY, 30) * 60000;
    }

    private static int getPropertyIntValue(String string, int n) {
        int n2 = n;
        String string2 = SystemProperties.get((String)string);
        if (string2 != null && string2.trim().length() > 0) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        }
        return n2;
    }

    public boolean isEntryExpirationEnabled() {
        return ENTRY_EXPIRATION_ENABLED_FLAG;
    }

    public long getUserEntryExpirationTime() {
        return ENTRY_USER_EXPIRE_TIME;
    }

    public long getDefaultEntryExpirationTime() {
        return ENTRY_DEFAULT_EXPIRE_TIME;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public IdCacheBlock(String string, boolean bl) {
        super(string, bl);
    }

    public IdCacheBlock(String string, String string2, boolean bl) {
        super(string, string2, bl);
    }

    static {
        IdCacheBlock.initializeExpirationParms();
    }
}

