/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoBundle;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public final class IdUtils {
    private static Debug debug = AMIdentityRepository.debug;
    private static Map mapSupportedTypes = new CaseInsensitiveHashMap(10);
    public static Set supportedTypes = new HashSet();
    private static Map mapTypesToServiceNames = new CaseInsensitiveHashMap();
    protected static Map typesCanBeMemberOf = new CaseInsensitiveHashMap();
    protected static Map typesCanHaveMembers = new CaseInsensitiveHashMap();
    protected static Map typesCanAddMembers = new CaseInsensitiveHashMap();
    private static Map orgIdentifierToOrgName = new CaseInsensitiveHashMap();
    private static ServiceConfigManager serviceConfigManager;

    public static AMIdentity getIdentity(SSOToken sSOToken) throws IdRepoException, SSOException {
        String string = sSOToken.getProperty("sun.am.UniversalIdentifier");
        if (string == null) {
            String string2 = sSOToken.getPrincipal().getName();
            if (string2 == null || !DN.isDN((String)string2)) {
                Object[] objectArray = new Object[]{string};
                throw new IdRepoException(IdRepoBundle.getString("215", objectArray), "215", objectArray);
            }
            string = "id=" + new DN(string2).explodeDN(true)[0] + ",ou=" + IdType.USER.getName() + "," + sSOToken.getProperty("Organization") + ",amsdkdn=" + string2;
        }
        return IdUtils.getIdentity(sSOToken, string);
    }

    public static String getUniversalId(AMIdentity aMIdentity) {
        return aMIdentity.getUniversalId();
    }

    public static AMIdentity getIdentity(SSOToken sSOToken, String string) throws IdRepoException {
        if (string.startsWith("id=")) {
            String string2 = string;
            String string3 = null;
            if (!DN.isDN((String)string)) {
                Object[] objectArray = new Object[]{string};
                throw new IdRepoException("amIdRepo", "215", objectArray);
            }
            int n = string.indexOf(",amsdkdn=");
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 9);
            }
            DN dN = new DN(string2);
            String[] stringArray = dN.explodeDN(true);
            String string4 = stringArray[0];
            if (!IdUtils.supportedType(stringArray[1])) {
                Object[] objectArray = new Object[]{string};
                throw new IdRepoException("amIdRepo", "215", objectArray);
            }
            IdType idType = new IdType(stringArray[1]);
            String string5 = dN.getParent().getParent().toRFCString();
            return new AMIdentity(sSOToken, string4, idType, string5, string3);
        }
        return IdUtils.getIdentity(sSOToken, string, DNMapper.orgNameToDN("/"));
    }

    public static AMIdentity getIdentity(SSOToken sSOToken, String string, String string2) throws IdRepoException {
        block12: {
            if (string == null || !DN.isDN((String)string)) {
                return null;
            }
            try {
                if (ServiceManager.isCoexistenceMode()) {
                    AMIdentity aMIdentity = IdUtils.getIdentityFromAMSDKDN(sSOToken, string, string2);
                    return aMIdentity;
                }
                ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string2, null);
                if (serviceConfig != null) {
                    Iterator iterator = serviceConfig.getSubConfigNames().iterator();
                    while (iterator.hasNext()) {
                        ServiceConfig serviceConfig2 = serviceConfig.getSubConfig((String)iterator.next());
                        if (!serviceConfig2.getSchemaID().equalsIgnoreCase("amSDK")) continue;
                        return IdUtils.getIdentityFromAMSDKDN(sSOToken, string, string2);
                    }
                }
            }
            catch (AMException aMException) {
                if (debug.messageEnabled()) {
                    debug.message("IdUtils.getIdentity: Unable to resolve AMSDK DN: " + string, (Throwable)aMException);
                }
            }
            catch (SSOException sSOException) {
                if (debug.messageEnabled()) {
                    debug.message("IdUtils.getIdentity: Unable to resolve AMSDK DN. Got SSOException", (Throwable)sSOException);
                }
            }
            catch (IdRepoException idRepoException) {
                if (debug.messageEnabled()) {
                    debug.message("IdUtils.getIdentity: Unable to resolve AMSDK DN. Got IdRepoException", (Throwable)idRepoException);
                }
            }
            catch (SMSException sMSException) {
                if (!debug.messageEnabled()) break block12;
                debug.message("IdUtils.getIdentity: Unable to resolve AMSDK DN. Got SMSException", (Throwable)sMSException);
            }
        }
        return null;
    }

    public static String getServiceName(IdType idType) {
        return (String)mapTypesToServiceNames.get(idType.getName());
    }

    public static IdType getType(String string) throws IdRepoException {
        IdType idType = (IdType)mapSupportedTypes.get(string);
        if (idType == null) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "217", objectArray);
        }
        return idType;
    }

    public static String getDN(AMIdentity aMIdentity) {
        if (aMIdentity.getDN() != null) {
            return aMIdentity.getDN();
        }
        return aMIdentity.getUniversalId();
    }

    public static String getOrganization(SSOToken sSOToken, String string) throws IdRepoException, SSOException {
        String string2 = null;
        string2 = (String)orgIdentifierToOrgName.get(string);
        if (string2 != null) {
            return string2;
        }
        if (debug.messageEnabled()) {
            debug.message("IdUtils:getOrganization Input orgname: " + string);
        }
        if (string == null || string.length() == 0 || string.equals("/")) {
            string2 = DNMapper.orgNameToDN("/");
        } else if (string.startsWith("/")) {
            string2 = DNMapper.orgNameToDN(string);
        } else if (DN.isDN((String)string)) {
            string2 = string;
        } else {
            if (ServiceManager.isCoexistenceMode()) {
                if (debug.messageEnabled()) {
                    debug.message("IdUtils.getOrganization: getting from AMSDK");
                }
                try {
                    AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
                    string2 = aMStoreConnection.getOrganizationDN(string, null);
                }
                catch (AMException aMException) {
                    if (debug.messageEnabled()) {
                        debug.message("IdUtils.getOrganization Exception in getting org name from AMSDK", (Throwable)aMException);
                    }
                    throw IdUtils.convertAMException(aMException);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("IdUtils.getOrganization: getting from SMS realms");
            }
            try {
                Object[] objectArray;
                Object object;
                ServiceManager serviceManager = new ServiceManager(sSOToken);
                OrganizationConfigManager organizationConfigManager = serviceManager.getOrganizationConfigManager("/");
                Set set = organizationConfigManager.getSubOrganizationNames(string, true);
                if (set != null && !set.isEmpty()) {
                    int n = set.size();
                    if (n == 1) {
                        string2 = DNMapper.orgNameToDN((String)set.iterator().next());
                    } else {
                        object = set.iterator();
                        block4: while (object.hasNext()) {
                            objectArray = (Object[])object.next();
                            StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray, "/");
                            while (stringTokenizer.hasMoreTokens()) {
                                if (!stringTokenizer.nextToken().equalsIgnoreCase(string)) continue;
                                string2 = DNMapper.orgNameToDN((String)objectArray);
                                continue block4;
                            }
                        }
                    }
                }
                if (string2 == null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add(string);
                    object = serviceManager.searchOrganizationNames("sunIdentityRepositoryService", "sunOrganizationAliases", hashSet);
                    if (object == null || object.isEmpty()) {
                        if (debug.messageEnabled()) {
                            debug.message("IdUtils.getOrganization Unable to find Org name for: " + string);
                        }
                        objectArray = new Object[]{string};
                        throw new IdRepoException("amIdRepo", "401", objectArray);
                    }
                    objectArray = (String)object.iterator().next();
                    string2 = DNMapper.orgNameToDN((String)objectArray);
                }
            }
            catch (SMSException sMSException) {
                if (debug.messageEnabled()) {
                    debug.message("IdUtils.getOrganization Exception in getting org name from SMS", (Throwable)sMSException);
                }
                Object[] objectArray = new Object[]{string};
                throw new IdRepoException("amIdRepo", "401", objectArray);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("IdUtils: Returning base DN: " + string2);
        }
        orgIdentifierToOrgName.put(string, string2);
        return string2;
    }

    protected static void clearOrganizationNamesCache() {
        orgIdentifierToOrgName = new CaseInsensitiveHashMap();
        if (debug.messageEnabled()) {
            debug.message("IdUtils.clearOrganizationNamesCache called");
        }
    }

    public static boolean isOrganizationActive(SSOToken sSOToken, String string) throws IdRepoException, SSOException {
        boolean bl = true;
        if (!ServiceManager.isCoexistenceMode()) {
            try {
                OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string);
                if (organizationConfigManager == null) {
                    Object[] objectArray = new Object[]{string};
                    throw new IdRepoException("amIdRepo", "401", objectArray);
                }
                Map map = organizationConfigManager.getAttributes("sunIdentityRepositoryService");
                Set set = (Set)map.get("sunOrganizationStatus");
                if (set == null || set.isEmpty()) {
                    bl = true;
                }
                String string2 = (String)set.iterator().next();
                bl = string2.equalsIgnoreCase("Active");
            }
            catch (SMSException sMSException) {
                Object[] objectArray = new Object[]{string};
                throw new IdRepoException("amIdRepo", "401", objectArray);
            }
        } else {
            try {
                AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
                AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
                bl = aMOrganization.isActivated();
            }
            catch (AMException aMException) {
                throw IdUtils.convertAMException(aMException);
            }
        }
        return bl;
    }

    private static AMIdentity getIdentityFromAMSDKDN(SSOToken sSOToken, String string, String string2) throws AMException, SSOException, IdRepoException {
        IDirectoryServices iDirectoryServices = AMDirectoryAccessFactory.getDirectoryServices();
        iDirectoryServices.getAttributes(sSOToken, string, 1);
        int n = iDirectoryServices.getObjectType(sSOToken, string);
        IdType idType = IdUtils.getType(AMStoreConnection.getObjectName(n));
        String string3 = new DN(string).explodeDN(true)[0];
        if (ServiceManager.isCoexistenceMode()) {
            string2 = iDirectoryServices.getOrganizationDN(sSOToken, string);
        }
        return new AMIdentity(sSOToken, string3, idType, string2, string);
    }

    public static IdRepoException convertAMException(AMException aMException) {
        Object[] objectArray = aMException.getMessageArgs();
        String string = aMException.getErrorCode();
        if (objectArray == null) {
            return new IdRepoException("amProfile", string, null);
        }
        return new IdRepoException("amProfile", aMException.getErrorCode(), objectArray);
    }

    private static boolean supportedType(String string) {
        return mapSupportedTypes.get(string) != null;
    }

    private static void loadDefaultTypes() {
        supportedTypes.add(IdType.AGENT);
        supportedTypes.add(IdType.USER);
        supportedTypes.add(IdType.ROLE);
        supportedTypes.add(IdType.GROUP);
        supportedTypes.add(IdType.FILTEREDROLE);
        mapSupportedTypes.put(IdType.USER.getName(), IdType.USER);
        mapSupportedTypes.put(IdType.ROLE.getName(), IdType.ROLE);
        mapSupportedTypes.put(IdType.FILTEREDROLE.getName(), IdType.FILTEREDROLE);
        mapSupportedTypes.put(IdType.AGENT.getName(), IdType.AGENT);
        mapSupportedTypes.put(IdType.GROUP.getName(), IdType.GROUP);
        HashSet<IdType> hashSet = new HashSet<IdType>();
        hashSet.add(IdType.ROLE);
        hashSet.add(IdType.GROUP);
        hashSet.add(IdType.FILTEREDROLE);
        typesCanBeMemberOf.put(IdType.USER.getName(), hashSet);
        HashSet<IdType> hashSet2 = new HashSet<IdType>();
        hashSet2.add(IdType.USER);
        typesCanHaveMembers.put(IdType.ROLE.getName(), hashSet2);
        typesCanHaveMembers.put(IdType.GROUP.getName(), hashSet2);
        typesCanHaveMembers.put(IdType.FILTEREDROLE.getName(), hashSet2);
        typesCanAddMembers.put(IdType.GROUP.getName(), hashSet2);
        typesCanAddMembers.put(IdType.ROLE.getName(), hashSet2);
    }

    private static Set getMemberSet(Set set) {
        HashSet<IdType> hashSet = new HashSet<IdType>(set.size() * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashSet.add(new IdType(string));
        }
        return hashSet;
    }

    static {
        if (ServiceManager.isConfigMigratedTo70()) {
            try {
                SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                serviceConfigManager = new ServiceConfigManager(sSOToken, "sunIdentityRepositoryService", "1.0");
                ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
                Set set = serviceConfig.getSubConfigNames("*", "SupportedIdentities");
                if (set == null || set.isEmpty()) {
                    IdUtils.loadDefaultTypes();
                } else {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Set set2;
                        String string = (String)iterator.next();
                        IdType idType = new IdType(string);
                        supportedTypes.add(idType);
                        mapSupportedTypes.put(idType.getName(), idType);
                        ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
                        Map map = serviceConfig2.getAttributes();
                        Set set3 = (Set)map.get("servicename");
                        Set set4 = (Set)map.get("canBeMemberOf");
                        Set set5 = (Set)map.get("canHaveMembers");
                        Set set6 = (Set)map.get("canAddMembers");
                        if (set3 != null && !set3.isEmpty()) {
                            mapTypesToServiceNames.put(string, (String)set3.iterator().next());
                        }
                        if (set4 != null && !set4.isEmpty()) {
                            set2 = IdUtils.getMemberSet(set4);
                            typesCanBeMemberOf.put(string, set2);
                        }
                        if (set5 != null && !set5.isEmpty()) {
                            set2 = IdUtils.getMemberSet(set5);
                            typesCanHaveMembers.put(string, set2);
                        }
                        if (set6 == null || set6.isEmpty()) continue;
                        set2 = IdUtils.getMemberSet(set6);
                        typesCanAddMembers.put(string, set2);
                    }
                }
            }
            catch (SMSException sMSException) {
                debug.error("IdUtils: Loading default types. Caught exception..", (Throwable)sMSException);
                IdUtils.loadDefaultTypes();
            }
            catch (SSOException sSOException) {
                debug.error("IdUtils: Loading default types. Caught exception..", (Throwable)sSOException);
                IdUtils.loadDefaultTypes();
            }
        } else {
            IdUtils.loadDefaultTypes();
        }
    }
}

