/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCrypt;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesFactory;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public final class AMIdentity {
    private String univId;
    private SSOToken token;
    private String name;
    private IdType type;
    private String orgName;
    private AMHashMap modMap = new AMHashMap(false);
    private AMHashMap binaryModMap = new AMHashMap(true);
    private Debug debug = Debug.getInstance((String)"amIdm");
    protected String DN = null;

    protected AMIdentity(SSOToken sSOToken, String string) {
        this.univId = string;
        DN dN = new DN(this.univId);
        String[] stringArray = dN.explodeDN(true);
        this.name = stringArray[0];
        this.type = new IdType(stringArray[1]);
        this.orgName = dN.getParent().getParent().toRFCString();
        this.token = sSOToken;
    }

    public AMIdentity(SSOToken sSOToken, String string, IdType idType, String string2, String string3) {
        this.name = string;
        this.type = idType;
        this.orgName = string2;
        this.token = sSOToken;
        this.DN = string3;
        this.univId = string3 == null ? "id=" + string + ",ou=" + idType.getName() + "," + string2 : "id=" + string + ",ou=" + idType.getName() + "," + string2 + ",amsdkdn=" + string3;
    }

    public String getName() {
        return this.name;
    }

    public IdType getType() {
        return this.type;
    }

    public String getRealm() {
        return this.orgName;
    }

    public boolean isActive() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.isActive(this.token, this.type, this.name, this.orgName, this.DN);
    }

    public Map getAttributes() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Map map = idServices.getAttributes(this.token, this.type, this.name, this.orgName, this.DN);
        if (this.debug.messageEnabled()) {
            this.debug.message("AMIdentity.getAttributes all: attrs=" + map);
        }
        return map;
    }

    public Map getAttributes(Set set) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Map map = idServices.getAttributes(this.token, this.type, this.name, set, this.orgName, this.DN, true);
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap(map);
        CaseInsensitiveHashMap caseInsensitiveHashMap2 = new CaseInsensitiveHashMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!caseInsensitiveHashMap.containsKey((Object)string)) continue;
            caseInsensitiveHashMap2.put((Object)string, caseInsensitiveHashMap.get((Object)string));
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("AMIdentity.getAttributes 6: attrNames=" + set + ";  resultMap=" + caseInsensitiveHashMap2 + "; attrs=" + map);
        }
        return caseInsensitiveHashMap2;
    }

    public Map getBinaryAttributes(Set set) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.getAttributes(this.token, this.type, this.name, set, this.orgName, this.DN, false);
    }

    public Set getAttribute(String string) throws IdRepoException, SSOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Map map = idServices.getAttributes(this.token, this.type, this.name, hashSet, this.orgName, this.DN, true);
        return (Set)map.get(string);
    }

    public void setAttributes(Map map) throws IdRepoException, SSOException {
        this.modMap.copy(map);
    }

    public void setBinaryAttributes(Map map) throws IdRepoException, SSOException {
        this.binaryModMap.copy(map);
    }

    public void removeAttributes(Set set) throws IdRepoException, SSOException {
        if (set == null || set.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.modMap.put(string, Collections.EMPTY_SET);
        }
    }

    public void store() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        if (this.modMap != null && !this.modMap.isEmpty()) {
            idServices.setAttributes(this.token, this.type, this.name, this.modMap, false, this.orgName, this.DN, true);
            this.modMap.clear();
        }
        if (this.binaryModMap != null && !this.binaryModMap.isEmpty()) {
            idServices.setAttributes(this.token, this.type, this.name, this.binaryModMap, false, this.orgName, this.DN, false);
            this.binaryModMap.clear();
        }
    }

    public Set getAssignedServices() throws IdRepoException, SSOException {
        Set set;
        block4: {
            ServiceManager serviceManager;
            try {
                serviceManager = new ServiceManager(this.token);
            }
            catch (SMSException sMSException) {
                throw new IdRepoException("amIdRepo", "106", null);
            }
            Map map = serviceManager.getServiceNamesAndOCs(this.type.getName());
            IdServices idServices = IdServicesFactory.getDataStoreServices();
            set = Collections.EMPTY_SET;
            try {
                set = idServices.getAssignedServices(this.token, this.type, this.name, map, this.orgName, this.DN);
            }
            catch (IdRepoException idRepoException) {
                if (idRepoException.getErrorCode().equals("402")) break block4;
                throw idRepoException;
            }
        }
        return set;
    }

    public Set getAssignableServices() throws IdRepoException, SSOException {
        ServiceManager serviceManager;
        try {
            serviceManager = new ServiceManager(this.token);
        }
        catch (SMSException sMSException) {
            throw new IdRepoException("amIdRepo", "106", null);
        }
        Map map = serviceManager.getServiceNamesAndOCs(this.type.getName());
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set set = Collections.EMPTY_SET;
        try {
            set = idServices.getAssignedServices(this.token, this.type, this.name, map, this.orgName, this.DN);
        }
        catch (IdRepoException idRepoException) {
            if (!idRepoException.getErrorCode().equals("402")) {
                throw idRepoException;
            }
            return set;
        }
        Set set2 = map.keySet();
        set2.removeAll(set);
        return set2;
    }

    public void assignService(String string, Map map) throws IdRepoException, SSOException {
        SchemaType schemaType;
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set set = this.getServiceOCs(this.token, string);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        hashMap.put(string, set);
        Set set2 = idServices.getAssignedServices(this.token, this.type, this.name, hashMap, this.orgName, this.DN);
        if (set2.contains(string)) {
            Object[] objectArray = new Object[]{string, this.type.getName()};
            throw new IdRepoException("amIdRepo", "105", objectArray);
        }
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(this.type.getName());
            if (serviceSchema != null) {
                map = serviceSchema.validateAndInheritDefaults(map, this.orgName, true);
                map = AMCommonUtils.removeEmptyValues(map);
                schemaType = serviceSchema.getServiceType();
            } else {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                if (serviceSchema == null) {
                    Object[] objectArray = new Object[]{string};
                    throw new IdRepoException("amIdRepo", "102", objectArray);
                }
                if (map == null) {
                    try {
                        map = this.getServiceConfig(this.token, string, SchemaType.DYNAMIC);
                    }
                    catch (SMSException sMSException) {
                        Object[] objectArray = new Object[]{string, this.type.getName()};
                        throw new IdRepoException("amIdRepo", "451", objectArray);
                    }
                } else {
                    map = serviceSchema.validateAndInheritDefaults(map, this.orgName, true);
                }
                map = AMCommonUtils.removeEmptyValues(map);
                schemaType = SchemaType.DYNAMIC;
            }
            map = AMCrypt.encryptPasswords(map, serviceSchema);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "101", objectArray);
        }
        map.put("objectclass", set);
        idServices.assignService(this.token, this.type, this.name, string, schemaType, map, this.orgName, this.DN);
    }

    public void unassignService(String string) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set set = this.getServiceOCs(this.token, string);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        hashMap.put(string, set);
        Set set2 = idServices.getAssignedServices(this.token, this.type, this.name, hashMap, this.orgName, this.DN);
        if (!set2.contains(string)) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "101", objectArray);
        }
        HashMap<String, Set> hashMap2 = new HashMap<String, Set>();
        Set set3 = this.getAttribute("objectclass");
        if (set3 != null && !set3.isEmpty()) {
            Set set4 = AMCommonUtils.updateAndGetRemovableOCs(set3, set);
            try {
                Set set5 = new HashSet();
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(this.type.getName());
                if (serviceSchema != null) {
                    set5 = serviceSchema.getAttributeSchemaNames();
                }
                Iterator iterator = set5.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    hashMap2.put(string2, Collections.EMPTY_SET);
                }
            }
            catch (SMSException sMSException) {
                // empty catch block
            }
            hashMap2.put("objectclass", set4);
        }
        idServices.unassignService(this.token, this.type, this.name, string, hashMap2, this.orgName, this.DN);
    }

    public Map getServiceAttributes(String string) throws IdRepoException, SSOException {
        Object object;
        Set set = Collections.EMPTY_SET;
        try {
            set = new HashSet();
            object = new ServiceSchemaManager(string, this.token);
            ServiceSchema serviceSchema = ((ServiceSchemaManager)object).getSchema(this.type.getName());
            if (serviceSchema != null) {
                set = serviceSchema.getAttributeSchemaNames();
            }
            if ((serviceSchema = ((ServiceSchemaManager)object).getDynamicSchema()) != null) {
                set.addAll(serviceSchema.getAttributeSchemaNames());
            }
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
        object = IdServicesFactory.getDataStoreServices();
        return object.getServiceAttributes(this.token, this.type, this.name, string, set, this.orgName, this.DN);
    }

    public void modifyService(String string, Map map) throws IdRepoException, SSOException {
        SchemaType schemaType;
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set set = this.getServiceOCs(this.token, string);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        hashMap.put(string, set);
        Set set2 = idServices.getAssignedServices(this.token, this.type, this.name, hashMap, this.orgName, this.DN);
        if (!set2.contains(string)) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "101", objectArray);
        }
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(this.type.getName());
            if (serviceSchema != null) {
                map = serviceSchema.validateAndInheritDefaults(map, false);
                schemaType = serviceSchema.getServiceType();
            } else {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                if (serviceSchema == null) {
                    Object[] objectArray = new Object[]{string};
                    throw new IdRepoException("amIdRepo", "102", objectArray);
                }
                map = serviceSchema.validateAndInheritDefaults(map, false);
                schemaType = SchemaType.DYNAMIC;
            }
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "103", objectArray);
        }
        idServices.modifyService(this.token, this.type, this.name, string, schemaType, map, this.orgName, this.DN);
    }

    public boolean isMember(AMIdentity aMIdentity) throws IdRepoException, SSOException {
        IdRepoException idRepoException;
        boolean bl;
        block16: {
            Object object;
            Object object2;
            Object object3;
            String string;
            Set set;
            IdServices idServices;
            block15: {
                bl = false;
                idRepoException = null;
                idServices = IdServicesFactory.getDataStoreServices();
                try {
                    set = idServices.getMemberships(this.token, this.getType(), this.getName(), aMIdentity.getType(), this.orgName, this.getDN());
                    if (set != null && set.contains(aMIdentity)) {
                        bl = true;
                    } else if (set != null && (string = aMIdentity.getDN()) != null) {
                        object3 = set.iterator();
                        while (object3.hasNext()) {
                            object2 = (AMIdentity)object3.next();
                            object = ((AMIdentity)object2).getDN();
                            if (object == null || !((String)object).equalsIgnoreCase(string)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (bl || set == null || set.isEmpty()) break block15;
                    string = aMIdentity.getUniversalId();
                    object3 = aMIdentity.getDN();
                    if (object3 != null) {
                        string = string.substring(0, string.indexOf((String)object3) - 9);
                    }
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        object = (AMIdentity)object2.next();
                        String string2 = ((AMIdentity)object).getUniversalId();
                        String string3 = ((AMIdentity)object).getDN();
                        if (string3 != null) {
                            string2 = string2.substring(0, string2.indexOf(string3) - 9);
                        }
                        if (!string2.equalsIgnoreCase(string)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (IdRepoException idRepoException2) {
                    idRepoException = idRepoException2;
                }
            }
            if (!bl && aMIdentity.getType().equals(IdType.GROUP)) {
                try {
                    set = idServices.getMembers(this.token, aMIdentity.getType(), aMIdentity.getName(), aMIdentity.orgName, this.getType(), aMIdentity.getDN());
                    if (set != null && set.contains(this)) {
                        bl = true;
                        break block16;
                    }
                    if (set == null || (string = this.getDN()) == null) break block16;
                    object3 = set.iterator();
                    while (object3.hasNext()) {
                        object2 = (AMIdentity)object3.next();
                        object = ((AMIdentity)object2).getDN();
                        if (object == null || !((String)object).equalsIgnoreCase(string)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (idRepoException != null) {
            throw idRepoException;
        }
        return bl;
    }

    public void addMember(AMIdentity aMIdentity) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(aMIdentity.getName());
        idServices.modifyMemberShip(this.token, this.type, this.name, hashSet, aMIdentity.getType(), 1, this.orgName);
    }

    public void removeMember(AMIdentity aMIdentity) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(aMIdentity.getName());
        idServices.modifyMemberShip(this.token, this.type, this.name, hashSet, aMIdentity.getType(), 2, this.orgName);
    }

    public void removeMembers(Set set) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMIdentity aMIdentity = (AMIdentity)iterator.next();
            hashSet.add(aMIdentity.getName());
            idServices.modifyMemberShip(this.token, this.type, this.name, hashSet, aMIdentity.getType(), 2, this.orgName);
            hashSet = new HashSet();
        }
    }

    public Set getMembers(IdType idType) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.getMembers(this.token, this.type, this.name, this.orgName, idType, this.getDN());
    }

    public Set getMemberships(IdType idType) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.getMemberships(this.token, this.type, this.name, idType, this.orgName, this.getDN());
    }

    public boolean equals(Object object) {
        if (object instanceof AMIdentity) {
            String string;
            AMIdentity aMIdentity = (AMIdentity)object;
            if (this.univId.equalsIgnoreCase(aMIdentity.univId)) {
                return true;
            }
            if (this.DN != null && (string = aMIdentity.getDN()) != null && string.equalsIgnoreCase(this.DN)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.DN != null) {
            return this.DN.toLowerCase().hashCode();
        }
        return this.univId.toLowerCase().hashCode();
    }

    public void setDN(String string) {
        this.DN = string;
    }

    public String getDN() {
        return this.DN;
    }

    public String getUniversalId() {
        return this.univId;
    }

    private Set getServiceOCs(SSOToken sSOToken, String string) throws SSOException {
        HashSet hashSet = new HashSet();
        try {
            Map map;
            Set set;
            if (this.serviceHasSubSchema(sSOToken, string, SchemaType.GLOBAL) && (set = (Set)(map = this.getServiceConfig(sSOToken, string, SchemaType.GLOBAL)).get("serviceObjectClasses")) != null) {
                hashSet.addAll(set);
            }
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
        return hashSet;
    }

    private Map getServiceConfig(SSOToken sSOToken, String string, SchemaType schemaType) throws SMSException, SSOException {
        Map map = null;
        if (schemaType != SchemaType.POLICY) {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
            map = serviceSchema.getAttributeDefaults();
        }
        return map;
    }

    private boolean serviceHasSubSchema(SSOToken sSOToken, String string, SchemaType schemaType) throws SMSException, SSOException {
        boolean bl;
        block3: {
            bl = false;
            try {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
                Set set = serviceSchemaManager.getSchemaTypes();
                if (this.debug.messageEnabled()) {
                    this.debug.message("AMServiceUtils.serviceHasSubSchema() SchemaTypes types for " + string + " are: " + set);
                }
                bl = set.contains(schemaType);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                if (!this.debug.warningEnabled()) break block3;
                this.debug.warning("AMServiceUtils.serviceHasSubSchema() Service does not exist : " + string);
            }
        }
        return bl;
    }
}

