/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.iplanet.am.util.AMURLEncDec;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureException;
import com.sun.identity.federation.services.util.FSSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FSSignatureUtil {
    public static String signAndReturnQueryString(String string, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: Called");
        }
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: " + FSUtils.bundle.getString("nullInput"));
            return null;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: certAlias: " + string2);
        }
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: " + FSUtils.bundle.getString("nullInput"));
            return null;
        }
        FSSignatureManager fSSignatureManager = FSSignatureManager.getInstance();
        String string3 = "SHA1withRSA";
        if (fSSignatureManager.getKeyProvider().getPrivateKey(string2).getAlgorithm().equals("RSA")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: private key algorithm is: RSA");
            }
            string3 = "SHA1withRSA";
        } else if (fSSignatureManager.getKeyProvider().getPrivateKey(string2).getAlgorithm().equals("DSA")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: private key algorithm is: DSA");
            }
            string3 = "SHA1withDSA";
        } else {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: private key algorithm is not supported");
            return null;
        }
        byte[] byArray = null;
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        if (string3 == null || string3.equals("")) {
            string3 = "SHA1withRSA";
        }
        if (string.charAt(string.length() - 1) != '&') {
            string = string + "&";
        }
        String string4 = null;
        if (string3.equals("SHA1withDSA")) {
            string4 = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if (string3.equals("SHA1withRSA")) {
            string4 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: Invalid signature algorithim");
            return null;
        }
        string = string + "SigAlg=" + AMURLEncDec.encode((String)string4);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString: Querystring to be signed: " + string);
        }
        try {
            byArray = fSSignatureManager.signBuffer(string, string2, string3);
        }
        catch (FSSignatureException fSSignatureException) {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: FSSignatureException occured while signing query string: " + fSSignatureException.getMessage());
            return null;
        }
        if (byArray == null) {
            FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: Signature generated is null");
            return null;
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string5 = bASE64Encoder.encode(byArray);
        string = string + "&" + "Signature=" + AMURLEncDec.encode((String)string5);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.signAndReturnQueryString:Signed Querystring: " + string);
        }
        return string;
    }

    public static boolean verifyRequestSignature(HttpServletRequest httpServletRequest, String string) {
        FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: Called");
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: couldn't obtain this site's cert alias.");
                }
                throw new FSException("cannotFindCertAlias", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: Provider's certAlias is found: " + string);
            }
            String string2 = httpServletRequest.getParameter("SigAlg");
            FSUtils.debug.message("sigAlg : " + string2);
            String string3 = httpServletRequest.getParameter("Signature");
            FSUtils.debug.message("encSig : " + string3);
            if (string2 == null || string2.equals("") || string3 == null || string3.equals("")) {
                return false;
            }
            String string4 = null;
            if (string2.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                string4 = "SHA1withDSA";
            } else if (string2.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                string4 = "SHA1withRSA";
            } else {
                FSUtils.debug.error("FSSignatureUtil.signAndReturnQueryString: Invalid signature algorithim");
                return false;
            }
            String string5 = httpServletRequest.getQueryString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature:queryString to be verifed:" + string5);
            }
            int n = string5.indexOf("&Signature");
            String string6 = string5.substring(0, n);
            byte[] byArray = null;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: Signature: " + string3);
            }
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byArray = bASE64Decoder.decodeBuffer((InputStream)new ByteArrayInputStream(string3.getBytes()));
            FSSignatureManager fSSignatureManager = FSSignatureManager.getInstance();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSignatureUtil.verifyRequestSignature: String to be verified: " + string6);
            }
            return fSSignatureManager.verifySignature(string6, byArray, string4, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSignatureUtil.verifyRequestSignature: Exception occured while verifying SP's signature:" + exception.getMessage());
            return false;
        }
    }

    private static String cleanMetaAlias(HttpServletRequest httpServletRequest) {
        FSUtils.debug.message("FSSignatureUtil.cleanMetaAlias: Called");
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string = new String();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("metaAlias")) {
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("FSSignatureUtil.cleanMetaAlias: found metaAlias");
                continue;
            }
            String string3 = httpServletRequest.getParameter(string2);
            string = string == null || string.length() < 1 ? string2 + "=" + AMURLEncDec.encode((String)string3) : string + "&" + string2 + "=" + AMURLEncDec.encode((String)string3);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSignatureUtil.cleanMetaAlias:  returning with " + string);
        }
        return string;
    }
}

