/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FSServiceUtils
implements ServiceListener {
    private static final String attachmentRef = "href";
    private static MessageFactory fac = null;
    private static FSAllianceManager allianceInstance = null;
    private static ServiceSchemaManager schemaManager = null;
    private static boolean libertyEnabled = false;
    private static ServiceSchemaManager platfromServiceSchemaManager = null;
    private static List cookieList = null;
    private static boolean signingOn = false;
    private static boolean signingOptional = false;
    private static SSOToken internalToken = null;
    static /* synthetic */ Class class$com$sun$identity$federation$alliance$FSAllianceManager;

    private FSServiceUtils() {
    }

    public static synchronized boolean isLibertyEnabled() {
        return libertyEnabled;
    }

    private static void retrieveValue() throws SMSException {
        Set set;
        AttributeSchema attributeSchema;
        libertyEnabled = false;
        ServiceSchema serviceSchema = schemaManager.getGlobalSchema();
        if (serviceSchema != null && (attributeSchema = serviceSchema.getAttributeSchema("iplanet-am-admin-console-liberty-enabled")) != null && (set = attributeSchema.getDefaultValues()) != null) {
            String string;
            Iterator iterator;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceUtils::retrieveValue()read console service successfully");
            }
            if ((iterator = set.iterator()) != null && iterator.hasNext() && (string = (String)iterator.next()) != null && string.equalsIgnoreCase("true")) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSServiceUtils::retrieveValue() Have read true");
                }
                libertyEnabled = true;
            }
        }
    }

    public synchronized void schemaChanged(String string, String string2) {
        if (string.equalsIgnoreCase("iPlanetAMAdminConsoleService") && string2.equalsIgnoreCase("1.0")) {
            try {
                FSServiceUtils.retrieveValue();
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSServiceUtils::schemaChanged Exception caught", (Throwable)exception);
                libertyEnabled = false;
            }
        } else if (string.equalsIgnoreCase("iPlanetAMPlatformService") && string2.equalsIgnoreCase("1.0")) {
            try {
                FSServiceUtils.retrieveCookieList();
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSServiceUtils::schemaChanged Exception caught", (Throwable)exception);
                cookieList = null;
            }
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    public static boolean isSigningOn() {
        return signingOn;
    }

    public static boolean isSigningOptional() {
        return signingOptional;
    }

    public static String getCommonLoginPageURL(String string, String string2, String string3, HttpServletRequest httpServletRequest, String string4) {
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSServiceUtils.getCommonLoginPageURL: metaAlias is null");
            return null;
        }
        FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
        try {
            fSLocalConfigurationDescriptor = FSServiceUtils.getAllianceInstance().getHostedProviderByMetaAlias(string).getLocalConfiguration();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSServiceUtils.getCommonLoginPageURL: Could not obtain local config");
            return null;
        }
        String string5 = fSLocalConfigurationDescriptor.getProviderCommonLoginPageURL(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer(string5);
        if (string5.indexOf(63) == -1) {
            stringBuffer.append("?");
        } else {
            stringBuffer.append("&");
        }
        stringBuffer.append("metaAlias").append("=").append(string).append("&");
        String string6 = string4 + "/postLogin";
        StringBuffer stringBuffer2 = new StringBuffer(string6);
        if (string6.indexOf(63) == -1) {
            stringBuffer2.append("?");
        } else {
            stringBuffer2.append("&");
        }
        stringBuffer2.append("metaAlias").append("=").append(string).append("&");
        if (string2 != null && !string2.equals("")) {
            stringBuffer2.append("RelayState").append("=").append(AMURLEncDec.encode((String)string2));
            stringBuffer.append("RelayState").append("=").append(AMURLEncDec.encode((String)string2)).append("&");
        }
        stringBuffer.append("goto").append("=").append(AMURLEncDec.encode((String)stringBuffer2.toString()));
        Set set = fSLocalConfigurationDescriptor.getAuthDomainURLList();
        if (set != null && !set.isEmpty()) {
            String string7 = (String)set.iterator().next();
            stringBuffer.append("&").append("org").append("=").append(AMURLEncDec.encode((String)string7));
        }
        if (string3 != null && !string3.equals("")) {
            stringBuffer.append("&").append("RequestID").append("=").append(AMURLEncDec.encode((String)string3));
        }
        FSUtils.debug.message("FSServiceUtils.getCommonLoginPageURL: List LoginPage: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public static FSAllianceManager getAllianceInstance() {
        if (allianceInstance == null) {
            Class clazz = class$com$sun$identity$federation$alliance$FSAllianceManager == null ? (class$com$sun$identity$federation$alliance$FSAllianceManager = FSServiceUtils.class$("com.sun.identity.federation.alliance.FSAllianceManager")) : class$com$sun$identity$federation$alliance$FSAllianceManager;
            synchronized (clazz) {
                try {
                    FSAllianceManager fSAllianceManager = allianceInstance = new FSAllianceManager(internalToken);
                    return fSAllianceManager;
                }
                catch (Exception exception) {
                    FSUtils.debug.error("FSServiceUtils.getHostedProviderID:  Could not create Alliance Manager" + exception.getMessage());
                    FSAllianceManager fSAllianceManager = null;
                    return fSAllianceManager;
                }
            }
        }
        return allianceInstance;
    }

    public static String getHostedProviderID(HttpServletRequest httpServletRequest) {
        FSUtils.debug.message("FSServiceUtils.getHostedProviderID: Called");
        if (httpServletRequest == null) {
            FSUtils.debug.error("FSServiceUtils.getHostedProviderID: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        String string = FSServiceUtils.getMetaAlias(httpServletRequest);
        if (string == null) {
            string = httpServletRequest.getParameter("metaAlias");
        }
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSServiceUtils.getHostedProviderID: Could not find MetaAlias on the queryString");
            return null;
        }
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        if (fSAllianceManager != null) {
            try {
                return fSAllianceManager.getHostedProviderByMetaAlias(string).getProviderID();
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSServiceUtils.getHostedProviderID:  Exception: " + fSAllianceManagementException.getMessage());
                return null;
            }
        }
        return null;
    }

    public static String getBaseURL() {
        String string = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
        String string2 = SystemProperties.get((String)"com.iplanet.am.server.protocol");
        String string3 = SystemProperties.get((String)"com.iplanet.am.server.host");
        String string4 = SystemProperties.get((String)"com.iplanet.am.server.port");
        String string5 = string2 + "://" + string3 + ":" + string4 + string;
        return string5;
    }

    public static Map getSessionAttributes() {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMSessionService", internalToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getDynamicSchema();
            Map map = serviceSchema.getAttributeDefaults();
            String string = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-session-time", (String)"120");
            String string2 = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-idle-time", (String)"30");
            String string3 = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-caching-time", (String)"3");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("SESSION_TIME", string);
            hashMap.put("IDLE_TIME", string);
            hashMap.put("CACHING_TIME", string);
            return hashMap;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceUtils.getSessionAttributes:  Exception: " + exception.getMessage());
            return null;
        }
    }

    public static String getMetaAlias(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        String string = stringBuffer.toString();
        FSUtils.debug.message("FSServiceUtil.getMetaAlias request = " + string);
        int n = string.indexOf("metaAlias");
        if (n == -1 && (string = httpServletRequest.getQueryString()) != null) {
            n = string.indexOf("metaAlias");
        }
        if (n != -1) {
            n = n + "metaAlias".length() + 1;
            String string2 = string.substring(n);
            byte[] byArray = string2.getBytes();
            int n2 = 0;
            while (n2 < string2.length()) {
                if (byArray[n2] == 47 || byArray[n2] == 63 || byArray[n2] == 38) break;
                ++n2;
            }
            String string3 = string2.substring(0, n2);
            FSUtils.debug.message("FSServiceUtil.getMetaAlias returning " + string3);
            return string3;
        }
        FSUtils.debug.message("FSServiceUtil.getMetaAlias no metaAlias in request");
        return null;
    }

    public static String getLocale(HttpServletRequest httpServletRequest) {
        Locale locale;
        if (httpServletRequest == null) {
            FSUtils.debug.error("FSServiceUtil.getLocale. Request param is null returning null");
            return null;
        }
        String string = SystemProperties.get((String)"com.iplanet.am.cookie.name");
        String string2 = httpServletRequest.getParameter(string);
        SSOTokenManager sSOTokenManager = null;
        SSOToken sSOToken = null;
        if (string2 != null) {
            try {
                sSOTokenManager = SSOTokenManager.getInstance();
                sSOToken = sSOTokenManager.createSSOToken(string2);
                String string3 = sSOToken.getProperty("Locale");
                FSUtils.debug.message("FSServiceUtil.getLocale returning locale from token " + string3);
                return string3;
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSServiceUtil::getLocale():SSOException:" + sSOException.getMessage());
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSServiceUtil::getLocale():Exception:" + exception.getMessage());
            }
        }
        if ((locale = httpServletRequest.getLocale()) != null) {
            String string4 = locale.toString();
            FSUtils.debug.message("FSServiceUtil.getLocale returning locale from request " + string4);
            return string4;
        }
        FSUtils.debug.message("FSServiceUtil.getLocale Not able to get locale from request either from token for header returning null ");
        return null;
    }

    public static String getServicesBaseURL(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getScheme();
        String string2 = httpServletRequest.getServerName();
        int n = httpServletRequest.getServerPort();
        String string3 = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
        String string4 = string + "://" + string2 + ":" + n + string3;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceUtil.getServicesBaseURL hostString is " + string4);
        }
        return string4;
    }

    public static String getBaseURL(HttpServletRequest httpServletRequest) {
        int n;
        int n2;
        String string = httpServletRequest.getScheme();
        String string2 = string + "://" + httpServletRequest.getHeader("Host") + "/";
        String string3 = httpServletRequest.getRequestURL().toString();
        String string4 = null;
        string4 = string.equals("http") ? string3.substring(8) : string3.substring(9);
        String string5 = string4.substring(n2 = string4.indexOf("/") + 1);
        String string6 = string5.substring(0, n = string5.indexOf("/"));
        if (string6 != null && string6 != "") {
            String string7 = string2 + string6;
            return string7;
        }
        return string2;
    }

    public static String printDocument(Node node) throws TransformerException, TransformerConfigurationException, FileNotFoundException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    public static Node createSOAPDOM(SOAPMessage sOAPMessage) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            String string = byteArrayOutputStream.toString();
            System.out.println("Intermediate xml str: " + string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            return document;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceUtils.createSOAPDOM: Exception: " + exception.getMessage());
            return null;
        }
    }

    public static SOAPMessage convertDOMToSOAP(Document document) {
        try {
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            return fac.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(FSServiceUtils.printDocument(document).getBytes()));
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceUtils.convertDOMToSOAP: Exception: " + exception.getMessage());
            return null;
        }
    }

    public static boolean isLECPProfile(HttpServletRequest httpServletRequest) {
        String string;
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            String string2 = httpServletRequest.getHeader(string);
            FSUtils.debug.message("header " + string + " val " + string2);
        }
        string = httpServletRequest.getHeader("Liberty-Enabled");
        FSUtils.debug.message(" value of lecp in header " + string);
        if (string == null) {
            string = httpServletRequest.getHeader("Liberty-Enabled".toLowerCase());
        }
        return string != null;
    }

    public static synchronized List getCookieDomainList() {
        return cookieList;
    }

    private static void retrieveCookieList() throws SMSException {
        Set set;
        AttributeSchema attributeSchema;
        cookieList = new ArrayList();
        ServiceSchema serviceSchema = platfromServiceSchemaManager.getGlobalSchema();
        if (serviceSchema != null && (attributeSchema = serviceSchema.getAttributeSchema("iplanet-am-platform-cookie-domains")) != null && (set = attributeSchema.getDefaultValues()) != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceUtils::retrieveCookieiList()read platform service successfully");
            }
            Iterator iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                cookieList.add(iterator.next());
            }
            FSUtils.debug.message("FSServiceUtils::retrieveCookieiList()" + cookieList);
        }
    }

    public static String getAffiliationID(String string) {
        try {
            Set set = FSServiceUtils.getAllianceInstance().getAffiliateEntity(string);
            if (set != null && !set.isEmpty()) {
                FSAffiliationDescriptor fSAffiliationDescriptor = (FSAffiliationDescriptor)set.iterator().next();
                return fSAffiliationDescriptor.getAffiliationID();
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSServiceUtils.getAffiliationID: Error inretrieving affiliation for provider:" + string, (Throwable)((Object)fSAllianceManagementException));
        }
        return null;
    }

    public static AMIdentity getAMIdentity(String string) throws IdRepoException {
        return IdUtils.getIdentity(internalToken, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            fac = MessageFactory.newInstance();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceUtils::static block) could not get factory instance");
            exception.printStackTrace();
        }
        try {
            internalToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            schemaManager = new ServiceSchemaManager("iPlanetAMAdminConsoleService", internalToken);
            if (schemaManager != null) {
                schemaManager.addListener(new FSServiceUtils());
                FSServiceUtils.retrieveValue();
            } else {
                FSUtils.debug.error("FSServiceUtils::isLibertyEnabled() Could not read console Service Schema");
            }
            platfromServiceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", internalToken);
            if (platfromServiceSchemaManager != null) {
                platfromServiceSchemaManager.addListener(new FSServiceUtils());
                FSServiceUtils.retrieveCookieList();
            } else {
                FSUtils.debug.error("FSServiceUtils::getCookieList() Could not read console Service Schema");
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSServiceUtils::staticBlock SSOException while reading", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSServiceUtils::staticBlock SMSException while reading", (Throwable)sMSException);
        }
        String string = SystemProperties.get((String)"com.sun.identity.federation.services.signingOn", (String)"optional");
        if (string.equalsIgnoreCase("true")) {
            signingOn = true;
        } else if (string.equalsIgnoreCase("optional")) {
            signingOptional = true;
        }
    }
}

