/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSKeyStoreException;
import com.sun.identity.federation.services.util.FSKeyStoreProvider;
import com.sun.identity.federation.services.util.FSKeyStoreSpi;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;

public class FSKeyStoreManager {
    private static final String X_509 = "X.509";
    private static FSKeyStoreManager instance = null;
    private FSKeyStoreSpi sp = null;
    static /* synthetic */ Class class$com$sun$identity$federation$services$util$FSKeyStoreManager;

    protected FSKeyStoreManager() throws FSKeyStoreException {
        this.sp = new FSKeyStoreProvider();
    }

    protected FSKeyStoreManager(FSKeyStoreSpi fSKeyStoreSpi) {
        this.sp = fSKeyStoreSpi;
    }

    public static FSKeyStoreManager getInstance() throws FSKeyStoreException {
        if (instance == null) {
            Class clazz = class$com$sun$identity$federation$services$util$FSKeyStoreManager == null ? (class$com$sun$identity$federation$services$util$FSKeyStoreManager = FSKeyStoreManager.class$("com.sun.identity.federation.services.util.FSKeyStoreManager")) : class$com$sun$identity$federation$services$util$FSKeyStoreManager;
            synchronized (clazz) {
                if (instance == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Constructing a new instance of FSKeyStoreManager");
                    }
                    instance = new FSKeyStoreManager();
                }
            }
        }
        return instance;
    }

    public static FSKeyStoreManager getInstance(FSKeyStoreSpi fSKeyStoreSpi) {
        return new FSKeyStoreManager(fSKeyStoreSpi);
    }

    public void savePKCS7FormattedCertificate(String string, String string2) throws FSKeyStoreException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X_509);
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(fileInputStream);
            Iterator<? extends Certificate> iterator = collection.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                this.sp.addX509Certificate(x509Certificate, string2);
                FSUtils.debug.message("Certificate-" + x509Certificate);
            }
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Exception in savePKCS7FormattedCertificate: " + iOException);
            throw new FSKeyStoreException(iOException.getMessage());
        }
        catch (CertificateException certificateException) {
            FSUtils.debug.error("Exception in savePKCS7FormattedCertificate: " + certificateException);
            throw new FSKeyStoreException(certificateException.getMessage());
        }
    }

    public void saveBASE64EncodedCertificate(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X_509);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            while (byteArrayInputStream.available() > 0) {
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                this.sp.addX509Certificate(x509Certificate, string2);
                FSUtils.debug.message("Certificate-" + x509Certificate);
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error(exception.getMessage());
        }
    }

    public void addX509Certificate(X509Certificate x509Certificate, String string) throws FSKeyStoreException {
        this.sp.addX509Certificate(x509Certificate, string);
    }

    public void addX509Certificate(String string, String string2) throws FSKeyStoreException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X_509);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(string.getBytes()));
            this.sp.addX509Certificate(x509Certificate, string2);
        }
        catch (CertificateException certificateException) {
            FSUtils.debug.error("Exception in addX509Certificate: " + certificateException);
            throw new FSKeyStoreException(certificateException.getMessage());
        }
    }

    public void removeX509Certificate(String string) throws FSKeyStoreException {
        this.sp.removeX509Certificate(string);
    }

    public boolean containsAlias(String string) {
        try {
            return this.sp.containsAlias(string);
        }
        catch (KeyStoreException keyStoreException) {
            FSUtils.debug.message("KeyStoreException: " + keyStoreException);
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

