/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.common.SAMLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class FSAttributeStatementHelper {
    public static AttributeStatement getAutoFedAttributeStatement(String string, FSSubject fSSubject, SSOToken sSOToken) throws FSException {
        Collection<Object> collection;
        Object object;
        FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
        try {
            fSLocalConfigurationDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(string).getLocalConfiguration();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAttributeStatementHelper.getAutoFedAttributeStatement: AllianceException ", (Throwable)((Object)fSAllianceManagementException));
            throw new FSException((Exception)((Object)fSAllianceManagementException));
        }
        String string2 = fSLocalConfigurationDescriptor.getAutoFedAttribute();
        if (string2 == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAttributeStatementHelper.getAutoFed:AttributeStatement: AutoFederate Attribute is null");
            }
            return null;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        try {
            object = FSServiceUtils.getAMIdentity(sSOToken.getProperty("sun.am.UniversalIdentifier"));
            collection = ((AMIdentity)object).getAttribute(string2);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(FSAttributeStatementHelper.getAttributeValue((String)iterator.next()));
            }
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAttributeStatementHelper.getAutoFedAttributeStatement: IdRepoException ", (Throwable)idRepoException);
            throw new FSException(idRepoException);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAttributeStatementHelper.getAutoFedAttributeStatement: SSOException ", (Throwable)sSOException);
            throw new FSException((Exception)((Object)sSOException));
        }
        if (arrayList == null || arrayList.size() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAtributeStatementHelper.getAuto:FedAttributeStatement. No values for autofed attribute");
            }
            return null;
        }
        try {
            object = new Attribute("AutoFederateAttribute", "urn:oasis:names:tc:SAML:1.0:assertion", arrayList);
            collection = new ArrayList();
            collection.add(object);
            return new AttributeStatement(fSSubject, (List)collection);
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSAttributeStatementHelper.getAutoFedAttributeStatement: SAMLException ", (Throwable)sAMLException);
            throw new FSException(sAMLException);
        }
    }

    private static Element getAttributeValue(String string) throws FSException {
        if (string == null) {
            throw new FSException("nullInputParameter", null);
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append("saml:").append("AttributeValue").append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"").append(">").append(string).append("</").append("saml:").append("AttributeValue>");
        try {
            return XMLUtils.toDOMDocument((String)stringBuffer.toString(), (Debug)FSUtils.debug).getDocumentElement();
        }
        catch (Exception exception) {
            throw new FSException(exception);
        }
    }
}

