/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.iplanet.am.util.AMURLEncDec;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSTerminationRequestServlet
extends HttpServlet {
    private static FSAllianceManager instAlliance = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSTerminationRequestServlet Init");
        }
        instAlliance = FSServiceUtils.getAllianceInstance();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSHostedProviderDescriptor fSHostedProviderDescriptor;
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSTerminationRequestServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            String[] stringArray = new String[]{FSUtils.bundle.getString("notLibertyEnabled")};
            LogUtil.error(Level.INFO, "LIBERTY_NOT_ENABLED", stringArray);
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string = FSServiceUtils.getMetaAlias(httpServletRequest);
        if (string == null || string.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (instAlliance == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        try {
            fSHostedProviderDescriptor = instAlliance.getHostedProviderByMetaAlias(string);
            if (fSHostedProviderDescriptor == null) {
                throw new FSAllianceManagementException(null);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        String string2 = null;
        try {
            if (instAlliance != null) {
                string2 = fSHostedProviderDescriptor.getLocalConfiguration().getErrorPageURL(httpServletRequest);
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("Unable to get local configuration", (Throwable)exception);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("commonErrorPage : " + string2);
        }
        FSFederationTerminationNotification fSFederationTerminationNotification = new FSFederationTerminationNotification();
        try {
            fSFederationTerminationNotification = FSFederationTerminationNotification.parseURLEncodedRequest(httpServletRequest);
        }
        catch (FSMsgException fSMsgException) {
            this.showBadRequestErrorPage(httpServletResponse, string2);
            return;
        }
        catch (SAMLException sAMLException) {
            this.showBadRequestErrorPage(httpServletResponse, string2);
            return;
        }
        if (fSFederationTerminationNotification == null) {
            this.showBadRequestErrorPage(httpServletResponse, string2);
        } else {
            this.doRequestProcessing(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, fSFederationTerminationNotification, string2);
        }
    }

    private void doRequestProcessing(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor, FSFederationTerminationNotification fSFederationTerminationNotification, String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSTerminationRequestServlet::doRequestProcessing");
        }
        String string2 = fSFederationTerminationNotification.getProviderId();
        String string3 = fSHostedProviderDescriptor.getProviderRole();
        String string4 = string3.equals("SP") ? "IDP" : "SP";
        String string5 = null;
        string5 = string4.equals("SP") ? string2 + "|SP" : string2 + "|IDP";
        FSProviderDescriptor fSProviderDescriptor = null;
        try {
            fSProviderDescriptor = instAlliance.getProvider(string2, string4);
            if (fSProviderDescriptor == null) {
                fSProviderDescriptor = instAlliance.getProvider(string2);
                string5 = string2;
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSTerminationRequestServlet.doRequest Processing: Can not retrieve remote provider data." + string5);
            String[] stringArray = new String[]{string5};
            LogUtil.error(Level.INFO, "INVALID_PROVIDER", stringArray);
            this.returnToSource(httpServletResponse, string5, string);
            return;
        }
        boolean bl = true;
        if (FSServiceUtils.isSigningOn()) {
            try {
                if (fSProviderDescriptor == null) {
                    FSUtils.debug.error("Remote provider metadata not found.");
                    String[] stringArray = new String[]{string5};
                    LogUtil.error(Level.INFO, "INVALID_PROVIDER", stringArray);
                    this.returnToSource(httpServletResponse, string5, string);
                    return;
                }
                FSUtils.debug.message("Calling verifyTerminationSignature");
                bl = this.verifyTerminationSignature(httpServletRequest, fSProviderDescriptor, string);
            }
            catch (FSException fSException) {
                FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Signature on termination request is invalidCannot proceed federation termination");
                String[] stringArray = new String[]{FSUtils.bundle.getString("termination-invalid-signature")};
                LogUtil.error(Level.INFO, "INVALID_SIGNATURE", stringArray);
                this.returnToSource(httpServletResponse, string5, string);
                return;
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Signature on termination request is invalidCannot proceed federation termination");
                String[] stringArray = new String[]{FSUtils.bundle.getString("termination-invalid-signature")};
                LogUtil.error(Level.INFO, "INVALID_SIGNATURE", stringArray);
                this.returnToSource(httpServletResponse, string5, string);
                return;
            }
        }
        if (bl) {
            Set set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders();
            if (set != null) {
                if (set.contains(string2)) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSFedTerminationHandler fSFedTerminationHandler = fSServiceManager.getFedTerminationHandler(fSFederationTerminationNotification, fSHostedProviderDescriptor);
                        if (fSFedTerminationHandler != null) {
                            fSFedTerminationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                            fSFedTerminationHandler.setRemoteDescriptor(fSProviderDescriptor);
                            fSFedTerminationHandler.processTerminationRequest(httpServletRequest, httpServletResponse, fSFederationTerminationNotification);
                            return;
                        }
                        FSUtils.debug.error("Unable to get termination handler. User account Not valid");
                    } else {
                        FSUtils.debug.error("FSServiceManager instance is null Cannot process termination request");
                    }
                } else {
                    FSUtils.debug.error("Remote provider not in trusted list");
                }
            } else {
                FSUtils.debug.error("Remote provider not in trusted list");
                FSUtils.debug.error("Trusted provider list is empty.");
            }
        } else {
            FSUtils.debug.error("FSTerminationRequestServlet::doRequestProcesing Signature on termination request is invalidCannot proceed federation termination");
            String[] stringArray = new String[]{FSUtils.bundle.getString("termination-invalid-signature")};
            LogUtil.error(Level.INFO, "INVALID_SIGNATURE", stringArray);
        }
        this.returnToSource(httpServletResponse, string5, string);
    }

    private void returnToSource(HttpServletResponse httpServletResponse, String string, String string2) {
        try {
            String string3 = "";
            if (instAlliance != null) {
                string3 = instAlliance.getProvider(string).getFederationTerminationServiceReturnURL();
                if (string3 == null || string3.length() < 1) {
                    FSUtils.debug.message("returnToSource returns sendErroras source provider is unknown");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string2);
                    char c = string2.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("termination-invalid-federation")));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("metadata-error-check")));
                    FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                    return;
                }
                FSUtils.debug.message("returnToSource returns URL : " + string3);
                httpServletResponse.sendRedirect(string3);
                return;
            }
            FSUtils.debug.message("Alliance Manager instance is null");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("unableToReturnToSource"));
            return;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2);
                char c = string2.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("federror");
                stringBuffer.append('=');
                stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("termination-invalid-federation")));
                stringBuffer.append('&');
                stringBuffer.append("fedremark");
                stringBuffer.append('=');
                stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("metadata-error-check")));
                FSUtils.debug.error("Redirecting to Error page : " + stringBuffer.toString());
                httpServletResponse.sendRedirect(stringBuffer.toString());
                return;
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Redirect/sendError failed. Control halted");
            }
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect/sendError failed. Control halted" + iOException.getMessage());
        }
    }

    private boolean verifyTerminationSignature(HttpServletRequest httpServletRequest, FSProviderDescriptor fSProviderDescriptor, String string) throws SAMLException, FSException {
        boolean bl;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::verifyTerminationSignature");
        }
        String string2 = "";
        string2 = fSProviderDescriptor.getSigningKeyAlias();
        if (string2 == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler.signTerminationRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("The certAlias is : " + string2);
        }
        if (!(bl = FSSignatureUtil.verifyRequestSignature(httpServletRequest, string2))) {
            FSUtils.debug.error("Termination request is not properly signed");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Termination request is properly signed");
        }
        return true;
    }

    private void showBadRequestErrorPage(HttpServletResponse httpServletResponse, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        char c = string.indexOf(63) < 0 ? (char)'?' : '&';
        stringBuffer.append(c);
        stringBuffer.append("federror");
        stringBuffer.append('=');
        stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("termination-request-improper")));
        stringBuffer.append('&');
        stringBuffer.append("fedremark");
        stringBuffer.append('=');
        stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("termination-failed-locally")));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
        }
        try {
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Failed to redirect to error page");
        }
    }
}

