/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.IdRepoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSTerminationInitiationServlet
extends HttpServlet {
    private static FSAllianceManager instAlliance = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSTerminationInitiationServlet Init");
        }
        instAlliance = FSServiceUtils.getAllianceInstance();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSHostedProviderDescriptor fSHostedProviderDescriptor;
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSFedTermination: " + FSUtils.bundle.getString("notLibertyEnabled"));
            String[] stringArray = new String[]{FSUtils.bundle.getString("notLibertyEnabled")};
            LogUtil.error(Level.INFO, "LIBERTY_NOT_ENABLED", stringArray);
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string = httpServletRequest.getParameter("metaAlias");
        if (string == null || string.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (instAlliance == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        try {
            fSHostedProviderDescriptor = instAlliance.getHostedProviderByMetaAlias(string);
            if (fSHostedProviderDescriptor == null) {
                throw new FSAllianceManagementException(null);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request", (Throwable)((Object)fSAllianceManagementException));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        String string2 = null;
        String string3 = null;
        try {
            if (instAlliance != null) {
                string2 = fSHostedProviderDescriptor.getLocalConfiguration().getTerminationDonePageURL(httpServletRequest);
                string3 = fSHostedProviderDescriptor.getLocalConfiguration().getErrorPageURL(httpServletRequest);
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("Unable to get local configuration", (Throwable)exception);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("TERMINATION_DONE_URL : " + string2);
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + string3);
        }
        this.doFederationInitiation(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, string2, string3);
    }

    private SSOToken getValidToken(HttpServletRequest httpServletRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSTerminationInitiationServlet::getValidToken");
        }
        SSOTokenManager sSOTokenManager = null;
        SSOToken sSOToken = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                FSUtils.debug.error("SSOToken is not valid, redirecting for authentication");
                return null;
            }
            return sSOToken;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("SSOException caught: " + sSOException.getMessage());
            return null;
        }
    }

    private void doFederationInitiation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor, String string, String string2) {
        FSUtils.debug.message("Entered FSTerminationInitiationServlet::doFederationInitiation");
        try {
            SSOToken sSOToken = this.getValidToken(httpServletRequest);
            if (sSOToken != null) {
                String string3 = httpServletRequest.getParameter("_liberty_id");
                if (string3 == null || string3.length() < 1) {
                    FSUtils.debug.error("Provider Id not found, display error page");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string2);
                    char c = string2.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("termination-no-provider")));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("contact-admin")));
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    }
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                    return;
                }
                FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                if (fSServiceManager != null) {
                    FSFedTerminationHandler fSFedTerminationHandler;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager Instance not null");
                    }
                    String string4 = "SP";
                    if (fSHostedProviderDescriptor.getProviderRole().equalsIgnoreCase("SP")) {
                        string4 = "IDP";
                    }
                    if ((fSFedTerminationHandler = fSServiceManager.getFedTerminationHandler(string3, string4, FSServiceUtils.getAMIdentity(sSOToken.getProperty("sun.am.UniversalIdentifier")))) != null) {
                        fSFedTerminationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                        boolean bl = fSFedTerminationHandler.handleFederationTermination(httpServletRequest, httpServletResponse, sSOToken);
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("handleFederationTermination status is : " + bl);
                        }
                        return;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Unable to get termination handler. User account Not valid");
                    }
                } else if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSServiceManager Instance null");
                }
                this.returnLocallyAfterTermination(httpServletResponse, false, string);
                return;
            }
            this.redirectForAuthentication(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor);
            return;
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.message("IdRepoException doFederationInitiation" + idRepoException.getMessage());
        }
        catch (IOException iOException) {
            FSUtils.debug.message("IOException in doFederationInitiation" + iOException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.message("IOException in doFederationInitiation" + sSOException.getMessage());
        }
        this.returnLocallyAfterTermination(httpServletResponse, false, string);
    }

    private void redirectForAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws IOException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSTerminationInitiationServlet::redirectForAuthentication");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FSServiceUtils.getBaseURL(httpServletRequest));
            stringBuffer.append("/preLogin");
            char c = stringBuffer.toString().indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("metaAlias");
            stringBuffer.append('=');
            stringBuffer.append(fSHostedProviderDescriptor.getLocalConfiguration().getProviderAlias());
            String string = this.getParameterString(httpServletRequest);
            if (string != null && string.length() > 0) {
                stringBuffer.append('&').append(string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Redirecting for authentication to: " + stringBuffer.toString());
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Error when redirecting : " + iOException.getMessage());
            return;
        }
    }

    private String getParameterString(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                stringBuffer.append(string).append('=').append(stringArray[n]).append('&');
                ++n;
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Parameter String: " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void returnLocallyAfterTermination(HttpServletResponse httpServletResponse, boolean bl, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            char c = string.indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("termStatus");
            stringBuffer.append('=');
            if (bl) {
                stringBuffer.append("termSuccess");
            } else {
                stringBuffer.append("termFailure");
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect failed. Control halted" + iOException.getMessage());
            return;
        }
    }
}

