/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.namemapping;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSNameIdentifierMappingResponse;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSNameMappingHandler {
    private FSAllianceManager allianceMgr;
    private FSAccountManager accountMgr;
    private String hostedProviderID;
    private FSHostedProviderDescriptor hostedProviderDesc;

    public FSNameMappingHandler(String string) {
        this.hostedProviderID = string;
        this.allianceMgr = FSServiceUtils.getAllianceInstance();
        FSUtils.debug.message("FSNameMappingHandler: entering constructor");
        try {
            this.accountMgr = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSNameMappingHandler: " + FSUtils.bundle.getString("federation-failed-account-instance"));
        }
        try {
            this.hostedProviderDesc = this.allianceMgr.getHostedProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSNameMappingHandler: " + (Object)((Object)fSAllianceManagementException));
        }
        catch (Throwable throwable) {
            FSUtils.debug.error("FSNameMappingHandler: " + throwable);
        }
    }

    public NameIdentifier getNameIdentifier(AMIdentity aMIdentity, String string, boolean bl) throws FSAccountMgmtException, SAMLException {
        FSAccountFedInfo fSAccountFedInfo = this.accountMgr.readAccountFedInfo(aMIdentity, string);
        NameIdentifier nameIdentifier = null;
        if (bl) {
            NameIdentifier nameIdentifier2;
            nameIdentifier = fSAccountFedInfo.getLocalNameIdentifier();
            if (nameIdentifier == null && (nameIdentifier2 = fSAccountFedInfo.getRemoteNameIdentifier()) != null) {
                nameIdentifier = new NameIdentifier(nameIdentifier2.getName(), this.hostedProviderID, nameIdentifier2.getFormat());
            }
        } else {
            NameIdentifier nameIdentifier3;
            nameIdentifier = fSAccountFedInfo.getRemoteNameIdentifier();
            if (nameIdentifier == null && (nameIdentifier3 = fSAccountFedInfo.getLocalNameIdentifier()) != null) {
                nameIdentifier = new NameIdentifier(nameIdentifier3.getName(), string, nameIdentifier3.getFormat());
            }
        }
        if (nameIdentifier != null && (nameIdentifier.getFormat().equals("") || nameIdentifier.getFormat() == null)) {
            nameIdentifier.setFormat("urn:liberty:iff:nameid:federated");
        }
        return nameIdentifier;
    }

    public NameIdentifier getNameIdentifier(NameIdentifier nameIdentifier, String string, boolean bl) throws FSAccountMgmtException, SAMLException {
        String string2 = this.hostedProviderDesc.getLocalConfiguration().getAssociatedOrgDN();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameMappingHandler.getNameIdentifier(): NameId=" + nameIdentifier + ", orgDN=" + string2);
        }
        AMIdentity aMIdentity = this.accountMgr.getAMIdentity(nameIdentifier, string2);
        return this.getNameIdentifier(aMIdentity, string, bl);
    }

    public static boolean verifyNameIdMappingResponseSignature(Element element, SOAPMessage sOAPMessage) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameMappingHandler.verifyNameIdMappingResponseSignature: Called");
        }
        try {
            FSNameIdentifierMappingResponse fSNameIdentifierMappingResponse = new FSNameIdentifierMappingResponse(element);
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.error("FSNameMappingHandler.verifyNameIdMappingResponseSignature: Unable to get alliance manager");
                return false;
            }
            String string = fSAllianceManager.getProvider(fSNameIdentifierMappingResponse.getProviderID()).getSigningKeyAlias();
            if (string == null) {
                FSUtils.debug.error("FSNameMappingHandler.verifyNameIdMappingResponseSignature: couldn't obtain the cert alias for signature verification.");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameMappingHandler.verifyNameIdMappingResponseSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("FSNameMappingHandler.verifyNameIdMappingResponseSignature: xmlString to be verified: " + XMLUtils.print((Node)element));
            }
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameMappingHandler.verifyNameIdMappingResponseSignature: Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }
}

