/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.iplanet.am.util.AMURLEncDec;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSingleLogoutServlet
extends HttpServlet {
    FSAllianceManager allianceInst = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSingleLogoutServlet Initializing...");
        }
        this.allianceInst = FSServiceUtils.getAllianceInstance();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSingleLogoutServlet doGetPost...");
        }
        String string = "";
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSSingleLogoutServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            String[] stringArray = new String[]{FSUtils.bundle.getString("notLibertyEnabled")};
            LogUtil.error(Level.INFO, "LIBERTY_NOT_ENABLED", stringArray);
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        string = httpServletRequest.getParameter("metaAlias");
        if (string == null || string.length() < 1) {
            string = FSServiceUtils.getMetaAlias(httpServletRequest);
        }
        if (string == null || string.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        httpServletRequest.setAttribute("logoutSource", (Object)"local");
        stringBuffer.append("/ProcessLogout");
        stringBuffer.append("/");
        stringBuffer.append("metaAlias");
        stringBuffer.append("/");
        stringBuffer.append(string);
        FSUtils.debug.message("About to get RequestDispatcher for " + stringBuffer.toString());
        RequestDispatcher requestDispatcher = this.getServletConfig().getServletContext().getRequestDispatcher(stringBuffer.toString());
        if (requestDispatcher == null) {
            FSUtils.debug.message("RequestDispatcher is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Unable to find " + stringBuffer);
            }
            FSUtils.debug.message("calling sendErrorPage ");
            this.sendErrorPage(httpServletRequest, httpServletResponse, string);
            return;
        }
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void sendErrorPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        String string2 = FSServiceUtils.getLocale(httpServletRequest);
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            String string3 = "";
            if (this.allianceInst != null) {
                fSHostedProviderDescriptor = this.allianceInst.getHostedProviderByMetaAlias(string);
                string3 = fSHostedProviderDescriptor.getLocalConfiguration().getLogoutDonePageURL(httpServletRequest);
                if (string3 == null || string3.length() < 1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(fSHostedProviderDescriptor.getLocalConfiguration().getErrorPageURL(httpServletRequest));
                    char c = stringBuffer.toString().indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("logout-failed")));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("metadata-error-check")));
                    FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string3);
                    char c = string3.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("logoutStatus");
                    stringBuffer.append('=');
                    stringBuffer.append("logoutFailure");
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                }
                return;
            }
            FSUtils.debug.error("Alliance manager instance is null");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failedToReadDataStore"));
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("IOException caught : FSSingleLogoutServlet " + iOException.getMessage());
            return;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException caught :FSSingleLogoutServlet " + fSAllianceManagementException.getMessage());
            return;
        }
    }
}

