/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.saml.assertion.NameIdentifier;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSingleLogoutHandler {
    protected HttpServletResponse response = null;
    protected HttpServletRequest request = null;
    protected String locale = null;
    protected FSLogoutNotification reqLogout = null;
    protected FSSessionPartner currentPartner = null;
    protected AMIdentity amId = null;
    protected String sessionIndex = "";
    protected boolean isWMLAgent = false;
    protected String relayState = null;
    protected String isSourceIDP = null;
    protected boolean isCurrentProviderIDPRole;
    protected FSAllianceManager allianceInst = null;
    protected FSAccountManager accountInst = null;
    protected FSAccountFedInfo currentAccount = null;
    protected FSProviderDescriptor remoteDescriptor = null;
    protected FSHostedProviderDescriptor hostedDescriptor = null;
    protected String hostedProviderId = "";
    protected static final char QUESTION_MARK = '?';
    protected static final char AMPERSAND = '&';
    protected static final char EQUAL_TO = '=';
    protected static String LOGOUT_DONE_URL = null;
    protected static String COMMON_ERROR_URL = null;
    protected static final String RELAY_STATE = "RelayState";
    protected String remoteProviderId = "";
    protected String remoteEntityId = "";
    protected String hostedEntityId = "";

    public FSSingleLogoutHandler() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSingleLogoutHandler::Constructor");
        }
        this.allianceInst = FSServiceUtils.getAllianceInstance();
        try {
            this.accountInst = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            this.accountInst = null;
        }
    }

    protected void setLogoutURL() {
        LOGOUT_DONE_URL = this.hostedDescriptor.getLocalConfiguration().getLogoutDonePageURL(this.request);
        COMMON_ERROR_URL = this.hostedDescriptor.getLocalConfiguration().getErrorPageURL(this.request);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("LOGOUT_DONE_URL : " + LOGOUT_DONE_URL);
            FSUtils.debug.message("COMMON_ERROR_URL : " + COMMON_ERROR_URL);
        }
    }

    public FSLogoutStatus handleSingleLogout(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, FSSessionPartner fSSessionPartner, AMIdentity aMIdentity, String string, boolean bl) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSingleLogoutHandler::Begin  handleSingleLogout...");
        }
        this.response = httpServletResponse;
        this.request = httpServletRequest;
        this.locale = FSServiceUtils.getLocale(httpServletRequest);
        this.setLogoutURL();
        this.currentPartner = fSSessionPartner;
        this.amId = aMIdentity;
        this.sessionIndex = string;
        this.isWMLAgent = bl;
        if (fSSessionPartner != null) {
            this.setRemoteDescriptor(this.getRemoteDescriptor(fSSessionPartner.getPartner()));
            this.isCurrentProviderIDPRole = fSSessionPartner.getIsRoleIDP();
        }
        return new FSLogoutStatus("samlp:Success");
    }

    protected FSLogoutStatus processSingleLogoutRequest(FSLogoutNotification fSLogoutNotification, FSSessionPartner fSSessionPartner, AMIdentity aMIdentity, String string, boolean bl, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSingleLogoutHandler :: processSingleLogoutRequest...");
        }
        this.reqLogout = fSLogoutNotification;
        this.currentPartner = fSSessionPartner;
        if (fSSessionPartner != null) {
            this.setRemoteDescriptor(this.getRemoteDescriptor(fSSessionPartner.getPartner()));
            this.isCurrentProviderIDPRole = fSSessionPartner.getIsRoleIDP();
        }
        this.amId = aMIdentity;
        this.sessionIndex = string;
        this.isWMLAgent = bl;
        this.isSourceIDP = string2;
        return new FSLogoutStatus("samlp:Success");
    }

    protected boolean processSingleLogoutRequest(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, FSLogoutNotification fSLogoutNotification, FSSessionPartner fSSessionPartner, AMIdentity aMIdentity, String string, boolean bl, String string2, String string3) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSingleLogoutHandler :: processSingleLogoutRequest...");
        }
        this.response = httpServletResponse;
        this.request = httpServletRequest;
        this.locale = FSServiceUtils.getLocale(httpServletRequest);
        this.setLogoutURL();
        this.reqLogout = fSLogoutNotification;
        this.currentPartner = fSSessionPartner;
        if (fSSessionPartner != null) {
            this.setRemoteDescriptor(this.getRemoteDescriptor(fSSessionPartner.getPartner()));
            this.isCurrentProviderIDPRole = fSSessionPartner.getIsRoleIDP();
        }
        this.amId = aMIdentity;
        this.sessionIndex = string;
        this.isWMLAgent = bl;
        this.relayState = string2;
        this.isSourceIDP = string3;
        return true;
    }

    public void setHostedDescriptor(FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        this.hostedDescriptor = fSHostedProviderDescriptor;
        this.hostedProviderId = fSHostedProviderDescriptor.getProviderID();
        this.hostedEntityId = fSHostedProviderDescriptor.getEntityID();
    }

    public void setRemoteDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        this.remoteDescriptor = fSProviderDescriptor;
        this.remoteProviderId = fSProviderDescriptor.getProviderID();
        this.remoteEntityId = fSProviderDescriptor.getEntityID();
    }

    protected FSProviderDescriptor getRemoteDescriptor(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        FSUtils.debug.message("FSSingleLogoutHandler :: getRemoteDescriptor...");
        try {
            FSProviderDescriptor fSProviderDescriptor = this.allianceInst.getProvider(string);
            return fSProviderDescriptor;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSSPFedTerminationHandler:: getRemoteDescriptor failed");
            FSUtils.debug.error("FSAllianceManagementException " + fSAllianceManagementException.getMessage());
            return null;
        }
    }

    protected String getProfileToCommunicateLogout(String string) {
        FSUtils.debug.message("FSSingleLogoutHandler ::  getProfileToCommunicateLogout...");
        String string2 = "";
        try {
            if (this.allianceInst != null) {
                if (this.isCurrentProviderIDPRole) {
                    FSUtils.debug.message("Local provider is SP");
                    string2 = this.hostedDescriptor.getSLOProtocolProfile();
                } else {
                    FSUtils.debug.message("Local provider is IDP");
                    string2 = this.allianceInst.getProvider(string).getSLOProtocolProfile();
                }
                FSUtils.debug.message("Profile for " + string + " is : " + string2);
                return string2;
            }
            return null;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSSingleLogoutHandler::getProfileToCommunicateLogout failed");
            FSUtils.debug.error("FSAllianceManagementException " + fSAllianceManagementException.getMessage());
            return null;
        }
    }

    protected boolean sendPost(HttpServletResponse httpServletResponse, String string, FSLogoutNotification fSLogoutNotification) {
        FSUtils.debug.message("FSSingleLogoutHandler:sendPost: Called");
        try {
            String string2;
            httpServletResponse.setContentType("text/html");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<HTML>");
            printWriter.println("<BODY Onload=\"document.forms[0].submit()\">");
            printWriter.println("<FORM METHOD=\"POST\" ACTION=\"" + string + "\">");
            String string3 = fSLogoutNotification.getRequestID();
            if (string3 == null || string3.equals("")) {
                FSUtils.debug.error("FSSingleLogoutHandler.sendPost: couldn't  generate RequestID.");
                throw new FSException("errorGenerateID", null);
            }
            String string4 = fSLogoutNotification.getProviderId();
            if (string4 == null || string4.equals("")) {
                FSUtils.debug.error("FSSingleLogoutHandler.sendPost: providerId is null in the request with requestId:" + string3);
                throw new FSException("logout-request-no-provider", null);
            }
            StringBuffer stringBuffer = new StringBuffer(300);
            stringBuffer.append("<INPUT TYPE=\"HIDDEN\" NAME=\"").append("RequestID").append("\" ");
            stringBuffer.append("VALUE=\"").append(string3).append("\">");
            stringBuffer.append("<INPUT TYPE=\"HIDDEN\" NAME=\"").append("MajorVersion").append("\" ");
            stringBuffer.append("VALUE=\"").append(fSLogoutNotification.getMajorVersion()).append("\">");
            stringBuffer.append("<INPUT TYPE=\"HIDDEN\" NAME=\"").append("MinorVersion").append("\" ");
            stringBuffer.append("VALUE=\"").append(fSLogoutNotification.getMinorVersion()).append("\">");
            stringBuffer.append("<INPUT TYPE=\"HIDDEN\" NAME=\"").append("ProviderID").append("\" ");
            stringBuffer.append("VALUE=\"").append(string4).append("\">");
            NameIdentifier nameIdentifier = fSLogoutNotification.getNameIdentifier();
            if (nameIdentifier != null) {
                if (nameIdentifier.getName() != null) {
                    stringBuffer.append("<INPUT TYPE=\"HIDDEN\" NAME=\"").append("Name").append("\" ");
                    stringBuffer.append("VALUE=\"").append(nameIdentifier.getName()).append("\">");
                }
                if (nameIdentifier.getNameQualifier() != null && nameIdentifier.getNameQualifier().length() != 0) {
                    stringBuffer.append("<INPUT TYPE=\"HIDDEN\" NAME=\"").append("NameQualifier").append("\" ");
                    stringBuffer.append("VALUE=\"").append(nameIdentifier.getNameQualifier()).append("\">");
                }
            }
            if ((string2 = fSLogoutNotification.getSessionIndex()) != null) {
                stringBuffer.append("<INPUT TYPE=\"HIDDEN\" NAME=\"").append("SessionIndex").append("\" ");
                stringBuffer.append("VALUE=\"").append(string2).append("\">");
            }
            FSUtils.debug.message("FSSingleLogoutHandler:sendPost: Input string in the body of the response: " + stringBuffer.toString());
            printWriter.println(stringBuffer.toString());
            printWriter.println("</BODY></HTML>");
            printWriter.close();
            FSUtils.debug.message("FSSingleLogoutHandler:sendPost: LogoutRequest sent successfully to: " + string);
            return true;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("FSSingleLogoutHandler:sendHTMLPost:FSException " + iOException.getMessage());
            return false;
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSSingleLogoutHandler:sendHTMLPost:FSException " + fSException.getMessage());
            return false;
        }
    }

    protected boolean sendWMLPost(HttpServletResponse httpServletResponse, String string, FSLogoutNotification fSLogoutNotification) {
        FSUtils.debug.message("FSSingleLogoutHandler:sendPost: Called");
        try {
            String string2;
            httpServletResponse.setContentType("text/vnd.wap.wml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1");
            printWriter.println("//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
            printWriter.println("<wml>");
            printWriter.println("<card id=redirect title=Log In>");
            printWriter.println("<onenterforward>");
            printWriter.println("<go method=post href=" + string + ">");
            String string3 = fSLogoutNotification.getRequestID();
            if (string3 == null || string3.equals("")) {
                FSUtils.debug.error("FSSingleLogoutHandler.sendPost: couldn'tgenerate RequestID.");
                throw new FSException("errorGenerateID", null);
            }
            String string4 = fSLogoutNotification.getProviderId();
            if (string4 == null || string4.equals("")) {
                FSUtils.debug.error("FSSingleLogoutHandler.sendPost:providerIdis null in the request with requestId:" + string3);
                throw new FSException("logout-request-no-provider", null);
            }
            StringBuffer stringBuffer = new StringBuffer(300);
            stringBuffer.append("<postfield name=").append("RequestID ").append("Value=").append(string3).append(">");
            stringBuffer.append("<postfield name=").append("MajorVersion ").append("Value=").append(fSLogoutNotification.getMajorVersion()).append(">");
            stringBuffer.append("<postfield name=").append("MinorVersion ").append("Value=").append(fSLogoutNotification.getMinorVersion()).append(">");
            stringBuffer.append("<postfield name=").append("ProviderID ").append("Value=").append(string4).append(">");
            NameIdentifier nameIdentifier = fSLogoutNotification.getNameIdentifier();
            if (nameIdentifier != null) {
                if (nameIdentifier.getName() != null) {
                    stringBuffer.append("<postfield name=").append("Name ").append("Value=").append(nameIdentifier.getName()).append(">");
                }
                if (nameIdentifier.getNameQualifier() != null && nameIdentifier.getNameQualifier().length() != 0) {
                    stringBuffer.append("<postfield name=").append("NameQualifier ").append("Value=").append(nameIdentifier.getNameQualifier()).append(">");
                }
            }
            if ((string2 = fSLogoutNotification.getSessionIndex()) != null) {
                stringBuffer.append("<postfield name=").append("SessionIndex ").append("Value=").append(string2).append(">");
            }
            FSUtils.debug.message("FSSingleLogoutHandler:sendPost: Input string in the body of the response: " + stringBuffer.toString());
            printWriter.println(stringBuffer.toString());
            printWriter.println("</go>");
            printWriter.println("</onenterforward>");
            printWriter.println("<onenterbackward>");
            printWriter.println("<prev/>");
            printWriter.println("</onenterbackward>");
            printWriter.println("<onenterbackward>");
            printWriter.println("<p>");
            printWriter.println("logout initiated ...");
            printWriter.println("</p>");
            printWriter.println("</card>");
            printWriter.println("</wml>");
            printWriter.close();
            FSUtils.debug.message("FSSingleLogoutHandler:sendPost: Logout Request sent successfully to: " + string);
            return true;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("FSSingleLogoutHandler:sendWMLPost:FSException " + iOException.getMessage());
            return false;
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSSingleLogoutHandler:sendWMLPost:FSException " + fSException.getMessage());
            return false;
        }
    }
}

