/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class FSLogoutUtil {
    static FSAllianceManager allianceInst = null;
    static FSAccountManager accountInst = null;

    protected static boolean destroyPrincipalSession(String string, String string2, String string3) {
        Vector vector;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered destroyPrincipalSession for user : " + string + " SessionIndex = " + string3);
        }
        if ((vector = FSLogoutUtil.getSessionObjectList(string, string2, string3)) == null) {
            return false;
        }
        FSLogoutUtil.invalidateActiveSessionIds(vector);
        FSSession fSSession = null;
        if (string3 != null && vector.size() == 1) {
            fSSession = (FSSession)vector.elementAt(0);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("To call cleanSessionMap for user : " + string);
        }
        FSLogoutUtil.cleanSessionMap(string, string2, fSSession);
        return true;
    }

    protected static boolean destroyLocalSession(SSOToken sSOToken) {
        try {
            FSUtils.debug.message("FSLogoutUtil.destroyLocalSession, enter");
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            if (sSOTokenManager.isValidToken(sSOToken)) {
                sSOTokenManager.destroyToken(sSOToken);
            }
            FSUtils.debug.message("FSLogoutUtil.destroyLocalSession, deleted");
            return true;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.message("SSOException in destroyLocalSession", (Throwable)sSOException);
            return false;
        }
    }

    protected static void invalidateActiveSessionIds(Vector vector) {
        FSUtils.debug.message("FSLogoutUtil.invalidateActiveSessionIds, start");
        if (vector != null && !vector.isEmpty()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message(vector.size() + " Active Session exists");
            }
            int n = 0;
            while (n < vector.size()) {
                String string = ((FSSession)vector.elementAt(n)).getSessionID();
                if (string != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("To Invalidate session : " + string);
                    }
                    SSOToken sSOToken = null;
                    try {
                        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                        sSOToken = sSOTokenManager.createSSOToken(string);
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Destroying token : " + sSOToken.getPrincipal().toString());
                        }
                        sSOTokenManager.destroyToken(sSOToken);
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Completed Destroying token for sessionID :" + string);
                        }
                    }
                    catch (SSOException sSOException) {
                        FSUtils.debug.error("invalidateActiveSessionIds : " + string + " - " + sSOException.getMessage());
                    }
                }
                ++n;
            }
        } else {
            FSUtils.debug.message("No active Session exists");
        }
    }

    protected static Vector getSessionObjectList(String string, String string2, String string3) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered getSessionObjectList for user : " + string);
        }
        Vector<FSSession> vector = new Vector<FSSession>();
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string2));
        synchronized (fSSessionManager2) {
            List list = fSSessionManager.getSessionList(string);
            if (list != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Session list is not null");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    if (string3 != null && string3.equals(fSSession.getSessionIndex())) {
                        Vector<FSSession> vector2 = new Vector<FSSession>();
                        vector2.addElement(fSSession);
                        Vector<FSSession> vector3 = vector2;
                        return vector3;
                    }
                    vector.addElement(fSSession);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Returning session list with number of elements = " + vector.size());
                }
                Vector<FSSession> vector4 = vector;
                return vector4;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Session list is null");
            }
            Vector vector5 = null;
            return vector5;
        }
    }

    public static void cleanSessionMapPartnerList(String string, String string2, String string3, FSSession fSSession) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("In cleanSessionMapPartnerList for user : " + string + "and provider : " + string2);
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string3));
        fSSessionManager.removeProvider(string, string2, fSSession);
    }

    protected static void cleanSessionWithNoPartners(String string, String string2, String string3) {
        FSSessionManager fSSessionManager;
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string3));
        synchronized (fSSessionManager2) {
            List list = fSSessionManager.getSessionList(string);
            if (list != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Session list is not null");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    if (!fSSession.getSessionPartners().isEmpty()) continue;
                    fSSessionManager.removeSession(string, fSSession);
                }
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Session list is null");
            }
        }
    }

    protected static boolean cleanSessionMap(String string, String string2, FSSession fSSession) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered cleanSessionMap");
        }
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string2));
        synchronized (fSSessionManager2) {
            if (fSSession == null) {
                fSSessionManager.removeSessionList(string);
            } else {
                fSSessionManager.removeSession(string, fSSession);
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Leaving cleanSessionMap");
        }
        return true;
    }

    protected static SSOToken getValidToken(HttpServletRequest httpServletRequest) {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("SSOToken is not valid,redirecting for authentication" + sSOToken.getTokenID());
                }
                return null;
            }
            return sSOToken;
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SSOException caught: " + (Object)((Object)sSOException));
            }
            return null;
        }
    }

    protected static FSAccountFedInfo getCurrentWorkingAccount(AMIdentity aMIdentity, String string) {
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string2 = fSAllianceManager.getProvider(string).getEntityID();
            if (accountInst != null) {
                Object object;
                block10: {
                    try {
                        object = FSServiceUtils.getAllianceInstance().getAffiliateEntity(string2);
                        if (object != null && !object.isEmpty()) {
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                FSAffiliationDescriptor fSAffiliationDescriptor = (FSAffiliationDescriptor)iterator.next();
                                String string3 = fSAffiliationDescriptor.getAffiliationID();
                                FSAccountFedInfo fSAccountFedInfo = accountInst.readAccountFedInfo(aMIdentity, string3);
                                if (fSAccountFedInfo == null || !fSAccountFedInfo.isFedStatusActive()) continue;
                                return fSAccountFedInfo;
                            }
                        } else if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSLogoutUtil.getCurrentWorkingAccount: No affiliations");
                        }
                    }
                    catch (Exception exception) {
                        if (!FSUtils.debug.messageEnabled()) break block10;
                        FSUtils.debug.message("FSLogoutUtil.getCurrentWorkingAccount. No Affiliation for:" + string, (Throwable)exception);
                    }
                }
                object = accountInst.readAccountFedInfo(aMIdentity, string2);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSPFedTerminationHandler::getCurrentWorkingAccount after readAccountFedInfo");
                }
                return object;
            }
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLogoutUtil::getCurrentWorkingAccount readAccountFedInfo failed" + exception.getMessage());
            return null;
        }
    }

    protected static HashMap getCurrentProvider(String string, String string2) {
        return FSLogoutUtil.getCurrentProvider(string, string2, null);
    }

    protected static HashMap getCurrentProvider(String string, String string2, SSOToken sSOToken) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered getCurrentProvider for user : " + string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            String string3 = "";
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string2));
            FSSession fSSession = fSSessionManager.getSession(sSOToken);
            if (fSSession != null) {
                List list = fSSession.getSessionPartners();
                if (list != null && !list.isEmpty()) {
                    Iterator iterator = list.iterator();
                    FSSessionPartner fSSessionPartner = (FSSessionPartner)iterator.next();
                    hashMap.put("PartnerSession", fSSessionPartner);
                    hashMap.put("SessionIndex", fSSession.getSessionIndex());
                    return hashMap;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLogoutUtil.getCurrentProvider:No more session partners");
                }
                return null;
            }
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLogoutUtil.getCurrentProvider:: Exception in getting the current provider", (Throwable)exception);
            return null;
        }
    }

    public static boolean getCurrentProviderRole(String string, String string2, String string3) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered getCurrentProviderRole for user : " + string);
        }
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string3));
        synchronized (fSSessionManager2) {
            List list = fSSessionManager.getSessionList(string);
            if (list != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("sessionList is not null");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    List list2 = fSSession.getSessionPartners();
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        FSSessionPartner fSSessionPartner = (FSSessionPartner)iterator2.next();
                        if (!fSSessionPartner.isEquals(string2)) continue;
                        boolean bl = fSSessionPartner.getIsRoleIDP();
                        return bl;
                    }
                }
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("sessionList is null");
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    protected static boolean liveConnectionsExist(String string, String string2) {
        FSSessionManager fSSessionManager;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered liveConnectionsExist for user : " + string);
        }
        FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string2));
        synchronized (fSSessionManager2) {
            List list;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("About to call getSessionList");
            }
            if ((list = fSSessionManager.getSessionList(string)) != null && !list.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("List is not empty");
                }
                Iterator iterator = list.iterator();
                FSSession fSSession = null;
                while (iterator.hasNext()) {
                    fSSession = (FSSession)iterator.next();
                    if (fSSession.getSessionPartners().isEmpty()) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("List is  empty");
            }
            boolean bl = false;
            return bl;
        }
    }

    protected static boolean cleanSessionMapProviders(String string, Vector vector, String string2) {
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("cleaning provider " + (String)vector.elementAt(n) + " from session map");
                }
                FSLogoutUtil.cleanSessionMapPartnerList(string, (String)vector.elementAt(n), string2, null);
                ++n;
            }
        }
        return true;
    }

    protected static HashMap getLogoutGETProviders(String string, String string2, String string3, String string4) {
        try {
            FSSessionManager fSSessionManager;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSLogoutUtil::getLogoutGETProviders");
            }
            HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
            Vector<String> vector = new Vector<String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            vector.addElement(string2);
            hashMap2.put(string2, string3);
            FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string4));
            synchronized (fSSessionManager2) {
                Object object;
                List list;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("About to call getSessionList");
                }
                if ((list = fSSessionManager.getSessionList(string)) != null && !list.isEmpty()) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Session List is not empty");
                    }
                    object = list.iterator();
                    while (object.hasNext()) {
                        FSSession fSSession = (FSSession)object.next();
                        if (fSSession.getSessionPartners().isEmpty()) continue;
                        String string5 = fSSession.getSessionIndex();
                        List list2 = fSSession.getSessionPartners();
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            String string6;
                            FSSessionPartner fSSessionPartner = (FSSessionPartner)iterator.next();
                            if (fSSessionPartner.getIsRoleIDP() || !allianceInst.getProvider(string6 = fSSessionPartner.getPartner()).getSLOProtocolProfile().equals("http://projectliberty.org/profiles/slo-idp-http-get")) continue;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("provider " + string6 + " Added for GET");
                            }
                            vector.addElement(string6);
                            hashMap2.put(string6, string5);
                        }
                    }
                } else if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Session List is  empty, returning current provider from getLogoutGETProviders");
                }
                hashMap.put("Provider", vector);
                hashMap.put("SessionIndex", hashMap2);
                object = hashMap;
                return object;
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException in function  getLogoutGETProviders");
            return null;
        }
    }

    public static AMIdentity getAMIdentity(FSLogoutNotification fSLogoutNotification, String string) {
        String string2 = "";
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        String string3 = null;
        try {
            fSHostedProviderDescriptor = allianceInst.getHostedProvider(string);
            string3 = fSHostedProviderDescriptor.getEntityID();
            string2 = fSHostedProviderDescriptor.getLocalConfiguration().getAssociatedOrgDN();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("OrgDN : " + string2 + ", providerID : " + string + ", entityID : " + string3);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.message("In FSAllianceManagementException :: cannot get hosted provider information " + fSAllianceManagementException.getMessage());
            return null;
        }
        try {
            String string4 = fSLogoutNotification.getNameIdentifier().getName().trim();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name : " + string4);
            }
            String string5 = fSLogoutNotification.getNameIdentifier().getNameQualifier().trim();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name Qualifier : " + string5);
            }
            if (string5 == null || string5.length() == 0 || string5.equals(fSLogoutNotification.getProviderId())) {
                string5 = string3;
            }
            FSAccountFedInfoKey fSAccountFedInfoKey = null;
            String string6 = fSHostedProviderDescriptor.getProviderRole();
            fSAccountFedInfoKey = string6.equalsIgnoreCase("SP") ? new FSAccountFedInfoKey(string5, string4) : new FSAccountFedInfoKey(fSLogoutNotification.getProviderId(), string4);
            AMIdentity aMIdentity = accountInst.getAMIdentity(fSAccountFedInfoKey, string2);
            if (aMIdentity == null) {
                fSAccountFedInfoKey = string6.equalsIgnoreCase("SP") ? new FSAccountFedInfoKey(fSLogoutNotification.getProviderId(), string4) : new FSAccountFedInfoKey(string5, string4);
                aMIdentity = accountInst.getAMIdentity(fSAccountFedInfoKey, string2);
            }
            if (aMIdentity == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("UserDn is null");
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user id is " + aMIdentity);
            }
            return aMIdentity;
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.message("In FSAccountMgmtException :: " + fSAccountMgmtException.getMessage());
            return null;
        }
    }

    public static void removeTokenFromSession(SSOToken sSOToken, String string) {
        FSSessionManager fSSessionManager;
        FSSession fSSession;
        String string2 = "";
        String string3 = "";
        try {
            string2 = sSOToken.getProperty("sun.am.UniversalIdentifier");
            string3 = sSOToken.getTokenID().toString();
        }
        catch (SSOException sSOException) {
            FSUtils.debug.warning("SSOException in removeTokenFromSession", (Throwable)sSOException);
            return;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered removeTokenFromSession for user: " + string2);
        }
        if ((fSSession = (fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string))).getSession(string2, string3)) != null) {
            fSSessionManager.removeSession(string2, fSSession);
        }
    }

    static {
        try {
            accountInst = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("Failed to get Account Manager Instance");
        }
        allianceInst = FSServiceUtils.getAllianceInstance();
    }
}

