/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import sun.misc.BASE64Encoder;

public class FSSSOBrowserPostProfileHandler
extends FSSSOAndFedHandler {
    protected FSSSOBrowserPostProfileHandler() {
    }

    public FSSSOBrowserPostProfileHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor, String string) {
        super(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string);
        FSUtils.debug.message("FSSSOBrowserPostProfileHandler: Handler created to handle AuthnRequest");
    }

    protected void sendAuthnResponse(FSAuthnResponse fSAuthnResponse) {
        FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: Called");
        try {
            Object object;
            String string;
            Object object2;
            BASE64Encoder bASE64Encoder;
            Object object3;
            fSAuthnResponse.setProviderId(this.hostEntityId);
            Document document = XMLUtils.toDOMDocument((String)fSAuthnResponse.toXMLString(true, true), (Debug)FSUtils.debug);
            if (FSServiceUtils.isSigningOn() || FSServiceUtils.isSigningOptional()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: start signing assertions");
                }
                if ((object3 = fSAuthnResponse.getAssertion()) != null) {
                    bASE64Encoder = object3.iterator();
                    while (bASE64Encoder.hasNext()) {
                        object2 = (FSAssertion)bASE64Encoder.next();
                        string = ((FSAssertion)object2).getID();
                        FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: id attr is" + string);
                        object = FSServiceUtils.getAllianceInstance();
                        if (object == null) {
                            FSUtils.debug.error("FSSSOBrowserPostProfileHandler.doSingleSignOn: could not create alliance instance");
                            return;
                        }
                        String string2 = ((FSAllianceManager)object).getProvider(this.hostProviderId).getSigningKeyAlias();
                        if (string2 == null) {
                            FSUtils.debug.error("SOAPReceiver.onMessage: couldn't obtain this site's cert alias.");
                            return;
                        }
                        FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: Site's certAlias is " + string2);
                        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
                        int n = ((FSAssertion)object2).getMinorVersion();
                        if (n == 0) {
                            xMLSignatureManager.signXML(document, string2, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), "id", ((FSAssertion)object2).getID(), false);
                        } else if (n == 2 || n == 2) {
                            xMLSignatureManager.signXML(document, string2, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), "AssertionID", ((AssertionBase)object2).getAssertionID(), false);
                        } else if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("invalid minor version.");
                        }
                        FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: SignatureManager finished signing ");
                    }
                }
            }
            object3 = FSServiceUtils.printDocument(document);
            FSUtils.debug.message("FSSSOBrowserPostProfileHandler.sendAuthnResponse: Signed AuthnResponse: " + (String)object3);
            bASE64Encoder = new BASE64Encoder();
            object2 = bASE64Encoder.encode(((String)object3).getBytes());
            string = this.authnRequest.getAssertionConsumerServiceID();
            if (string == null || string.equals("")) {
                string = this.spDescriptor.getAssertionConsumerServiceURL();
            }
            this.response.setContentType("text/html");
            object = this.response.getWriter();
            ((PrintWriter)object).println("<HTML>");
            ((PrintWriter)object).println("<BODY Onload=\"document.Response.submit()\">");
            ((PrintWriter)object).println("<FORM NAME=\"Response\" METHOD=\"POST\" ACTION=\"" + string + "\">");
            ((PrintWriter)object).println("<INPUT TYPE=\"HIDDEN\" NAME=\"LARES\" VALUE=\"" + (String)object2 + "\"/>");
            ((PrintWriter)object).println("</FORM>");
            ((PrintWriter)object).println("</BODY></HTML>");
            ((PrintWriter)object).close();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserPostProfileHandler:sendAuthnResponse: AuthnResponse sent successfully to: " + string);
            }
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOBrowserPostProfileHandler:sendAuthnResponse:", (Throwable)exception);
            return;
        }
    }

    protected boolean doSingleSignOn(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        FSUtils.debug.message("FSSSOBrowserPostProfileHandler.doSingleSignOn: Called");
        FSAuthnResponse fSAuthnResponse = this.createAuthnResponse(sSOToken, string, nameIdentifier, nameIdentifier2);
        try {
            FSUtils.debug.message("FSSSOBrowserPostProfileHandler.doSingleSignOn: AuthnResponse created: " + fSAuthnResponse.toXMLString());
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSSSOBrowserPostProfileHandler.doSingleSignOn: Created AuthnResponse is not valid: " + fSException.getMessage());
            return false;
        }
        if (fSAuthnResponse == null) {
            FSUtils.debug.error("FSSSOBrowserPostProfileHandler.doSingleSignOn: No valid AuthnResponse could be created. Sending error AuthnResponse");
            return false;
        }
        this.sendAuthnResponse(fSAuthnResponse);
        return true;
    }
}

