/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.AMURLEncDec;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSRedirectException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSProxyHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSIDPFinderService
extends HttpServlet {
    private static Map requestCotSetMap = Collections.synchronizedMap(new HashMap());

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        String string2;
        String string3;
        block11: {
            if (httpServletRequest == null || httpServletResponse == null) {
                FSUtils.debug.error("FSIDPFinderService.doGet:: Null Input");
                return;
            }
            if (!FSServiceUtils.isLibertyEnabled()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIDPFinderService.doGet:: Liberty is not enabled");
                }
                return;
            }
            FSUtils.debug.message("FSIDPFinderService.doGet::Init");
            string3 = httpServletRequest.getParameter("ProviderID");
            string2 = httpServletRequest.getParameter("RequestID");
            if (string3 == null || string2 == null) {
                FSUtils.debug.error("FSIDPFinderService.doGet:: Request is missingeither providerID or the request id");
                throw new ServletException("invalidRequest");
            }
            string = null;
            try {
                string = this.getCommonDomainIDP(httpServletRequest, httpServletResponse, string3, string2);
            }
            catch (FSRedirectException fSRedirectException) {
                if (!FSUtils.debug.messageEnabled()) break block11;
                FSUtils.debug.message("FSIDPFinderService.doGet:Redirection has happened", (Throwable)((Object)fSRedirectException));
                return;
            }
        }
        if (string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.doGet:: Preferred IDP from the common domain is null.");
            }
            string = this.getDefaultPreferredIDP(string2, string3);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIDPFinderService.doGet:IDP to be proxied:" + string);
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string3));
        FSAuthnRequest fSAuthnRequest = fSSessionManager.getAuthnRequest(string2);
        try {
            FSProxyHandler fSProxyHandler = new FSProxyHandler(httpServletRequest, httpServletResponse);
            fSProxyHandler.setHostProviderId(string3);
            fSProxyHandler.sendProxyAuthnRequest(fSAuthnRequest, string);
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSIDPFinderService.doGet:: Failure in sending the proxy authentication request.", (Throwable)((Object)fSException));
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private String getCommonDomainIDP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws FSRedirectException, IOException {
        Object object;
        Object object2;
        String string3 = FSUtils.findPreferredIDP(httpServletRequest);
        if (string3 != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.getCommonDomainIDP:Preferred IDP found from the common domain." + string3);
            }
            if (requestCotSetMap.containsKey(string2)) {
                requestCotSetMap.remove(string2);
            }
            return string3;
        }
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        HashSet hashSet = (HashSet)requestCotSetMap.get(string2);
        if (hashSet == null) {
            try {
                object2 = fSAllianceManager.getProvider(string);
                if (object2 == null) {
                    FSUtils.debug.error("FSIDPFinderService.getCommonDomainIDP::Could not get provider descriptor.");
                    return null;
                }
                object = ((FSProviderDescriptor)object2).getListOfCOTs();
                if (object != null) {
                    hashSet = new HashSet();
                    hashSet.addAll(object);
                }
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSIDPFinderService.getCommonDomainIDP::Unable to retrieve circle of trusts", (Throwable)((Object)fSAllianceManagementException));
                return null;
            }
        }
        if (hashSet == null || hashSet.isEmpty()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.getCommonDomainIDP::No more Cots.");
            }
            if (requestCotSetMap.containsKey(string2)) {
                requestCotSetMap.remove(string2);
            }
            return null;
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            object2.remove();
            requestCotSetMap.put(string2, hashSet);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.getCommonDomainIDP: Trying Cot: " + (String)object);
            }
            String string4 = null;
            try {
                string4 = fSAllianceManager.getCircleOfTrust((String)object).getReaderServiceURL();
            }
            catch (FSException fSException) {
                FSUtils.debug.error("FSIDPFinderService.getCommonDomainIDP:Unable to retrieve reader service url.", (Throwable)((Object)fSException));
            }
            if (string4 == null) continue;
            String string5 = FSServiceUtils.getBaseURL(httpServletRequest);
            StringBuffer stringBuffer = new StringBuffer(300);
            stringBuffer.append(string5).append("/idpfinder").append("?").append("RequestID").append("=").append(AMURLEncDec.encode((String)string2)).append("&").append("ProviderID=").append(AMURLEncDec.encode((String)string));
            StringBuffer stringBuffer2 = new StringBuffer(300);
            stringBuffer2.append(string4).append("?").append("RelayState").append("=").append(AMURLEncDec.encode((String)stringBuffer.toString()));
            String string6 = stringBuffer2.toString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.getCommonDomainIDP:Redirection URL:" + string6);
            }
            httpServletResponse.setHeader("Location", string6);
            httpServletResponse.sendRedirect(string6);
            throw new FSRedirectException(FSUtils.bundle.getString("Redirection_Happened"));
        }
        return null;
    }

    private String getDefaultPreferredIDP(String string, String string2) {
        FSUtils.debug.message("FSIDPFinderService.getDefaultPreferredIDP:Init");
        try {
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string2));
            FSAuthnRequest fSAuthnRequest = fSSessionManager.getAuthnRequest(string);
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(fSAuthnRequest.getProviderId());
            Set set = fSProviderDescriptor.getProxyIDPs();
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("FSIDPFinderService.getDefaultPreferredIDP:Preferred IDPs are null.");
                return null;
            }
            return (String)set.iterator().next();
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSIDPFinderService.getDefaultPreferredIDP: Exception in retrieving the preferred IDP", (Throwable)((Object)fSException));
            return null;
        }
    }
}

