/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSRequest;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSAssertionArtifactHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import sun.misc.BASE64Decoder;

public class FSAssertionConsumerService
extends HttpServlet {
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        if (httpServletRequest == null || httpServletResponse == null) {
            httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
            return;
        }
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSAssertionConsumerService: " + FSUtils.bundle.getString("notLibertyEnabled"));
            String[] stringArray = new String[]{FSUtils.bundle.getString("notLibertyEnabled")};
            LogUtil.error(Level.INFO, "LIBERTY_NOT_ENABLED", stringArray);
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
        FSRequest fSRequest = null;
        String string2 = null;
        FSUtils.debug.message("FSAssertionConsumerService.doGet(): called");
        String string3 = httpServletRequest.getParameter("RelayState");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doGet():Resource URL: " + string3);
        }
        String string4 = "SAMLart";
        String[] stringArray = httpServletRequest.getParameterValues(string4);
        String string5 = FSServiceUtils.getBaseURL(httpServletRequest);
        String string6 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), string3, null, httpServletRequest, string5);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService: CommonLoginPage: " + string6);
        }
        if (stringArray == null || stringArray.length < 0 || stringArray[0] == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: AuthnRequest Processing Failed at the IDP Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string6);
        }
        ArrayList<FSAssertionArtifact> arrayList = new ArrayList<FSAssertionArtifact>();
        try {
            object = new FSAssertionArtifact(stringArray[0]);
            string2 = ((AssertionArtifact)object).getSourceID();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: SourceID within the Artifact is " + string2);
            }
            arrayList.add((FSAssertionArtifact)object);
            int n = 1;
            while (n < stringArray.length) {
                FSAssertionArtifact fSAssertionArtifact = new FSAssertionArtifact(stringArray[n]);
                String string7 = fSAssertionArtifact.getSourceID();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionConsumerService.doGet: SourceID within the Artifact is " + string7);
                }
                if (!string7.equals(string2)) {
                    FSUtils.debug.error("FSAssertionConsumerService.doGet: Received multiple artifacts have different source id");
                    FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string6);
                    return;
                }
                arrayList.add(fSAssertionArtifact);
                ++n;
            }
            fSRequest = new FSRequest(null, arrayList);
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: " + sAMLException.getMessage());
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string6);
            return;
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: " + fSMsgException.getMessage());
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string6);
            return;
        }
        try {
            FSAssertionArtifactHandler fSAssertionArtifactHandler;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: Trying to get BrowserArtifactHandler");
            }
            if ((fSAssertionArtifactHandler = ((FSServiceManager)(object = FSServiceManager.getInstance())).getBrowserArtifactHandler(httpServletRequest, httpServletResponse, string2, fSRequest, string3)) == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doGet: " + FSUtils.bundle.getString("internalError"));
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string6);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: BrowserArtifactHandler created");
            }
            fSAssertionArtifactHandler.setHostProviderId(string);
            fSAssertionArtifactHandler.processSAMLRequest();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: Exception occured :" + exception.getMessage());
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string6);
            return;
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String[] stringArray;
        Object object;
        FSUtils.debug.message("FSAssertionConsumerService.doPost : called");
        Document document = null;
        if (httpServletRequest == null || httpServletResponse == null) {
            httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
            return;
        }
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSAssertionConsumerService: " + FSUtils.bundle.getString("notLibertyEnabled"));
            String[] stringArray2 = new String[]{FSUtils.bundle.getString("notLibertyEnabled")};
            LogUtil.error(Level.INFO, "LIBERTY_NOT_ENABLED", stringArray2);
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
        String string2 = httpServletRequest.getParameter("LARES");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: BASE64 encoded AuthnResponse: " + string2);
        }
        if (string2 == null) {
            String[] stringArray3 = new String[]{FSUtils.bundle.getString("missingAuthnResponse")};
            LogUtil.error(Level.INFO, "MISSING_AUTHN_RESPONSE", stringArray3);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("missingAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string3 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string4 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string3);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string4);
            return;
        }
        string2 = string2.replace(' ', '\n');
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: BASE64 encoded AuthnResponse2: " + string2);
        }
        FSAuthnResponse fSAuthnResponse = null;
        try {
            object = new BASE64Decoder();
            stringArray = new String(object.decodeBuffer((InputStream)new ByteArrayInputStream(string2.getBytes())));
            FSUtils.debug.message("Decoded authnResponse" + (String)stringArray);
            document = XMLUtils.toDOMDocument((String)stringArray, (Debug)FSUtils.debug);
            string2 = string2.replace(' ', '\n');
            fSAuthnResponse = FSAuthnResponse.parseBASE64EncodedString(string2);
            if (fSAuthnResponse == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. Can't parse BASE64 encoded AuthnResponse");
                String[] stringArray4 = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
                LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray4);
                FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                String string5 = FSServiceUtils.getBaseURL(httpServletRequest);
                String string6 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string5);
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string6);
                return;
            }
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. FSException occured while parsing BASE64 encoded AuthnResponse: " + fSException.getMessage());
            String[] stringArray5 = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray5);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string7 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string8 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string7);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string8);
            return;
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. SAMLException occured while parsing BASE64 encoded AuthnResponse: " + sAMLException.getMessage());
            String[] stringArray6 = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray6);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string9 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string10 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string9);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string10);
            return;
        }
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doPost: AuthnResponse received is valid: " + fSAuthnResponse.toXMLString());
            }
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. FSException occured while calling AuthnResponse.toXMLString(): " + fSException.getMessage());
            stringArray = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string11 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string12 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string11);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string12);
            return;
        }
        object = null;
        stringArray = fSAuthnResponse.getInResponseTo();
        if (stringArray == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. AuthnResponse received does not have inResponseTo attribute");
            String[] stringArray7 = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray7);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string13 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string14 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string13);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string14);
            return;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: AuthnResponse received is against requestID: " + (String)stringArray);
        }
        if ((object = this.getInResponseToRequest((String)stringArray, string)) == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. AuthnResponse received does not have an associated AuthnRequest");
            String[] stringArray8 = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
            LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray8);
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string15 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string16 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string15);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string16);
            return;
        }
        String string17 = FSServiceUtils.getBaseURL(httpServletRequest);
        String string18 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), ((FSAuthnRequest)object).getRelayState(), null, httpServletRequest, string17);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: inResponseTo validation is successful");
        }
        try {
            FSAssertionArtifactHandler fSAssertionArtifactHandler;
            Object object2;
            FSProviderDescriptor fSProviderDescriptor = null;
            if (!((FSAuthnRequest)object).getProtocolProfile().equals("http://projectliberty.org/profiles/lecp")) {
                fSProviderDescriptor = this.getProvider(fSAuthnResponse.getInResponseTo(), string);
                if (fSProviderDescriptor == null) {
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. Sender information not found for the received AuthnResponse");
                    String[] stringArray9 = new String[]{FSUtils.bundle.getString("invalidAuthnResponse")};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray9);
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string18);
                    return;
                }
                if ((FSServiceUtils.isSigningOn() || FSServiceUtils.isSigningOptional() && ((FSAuthnRequest)object).getProtocolProfile().equals("http://projectliberty.org/profiles/brws-post")) && !this.verifyAuthnResponseSignature(document, fSProviderDescriptor.getProviderID())) {
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: Signature verification failed");
                    FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string18);
                    return;
                }
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionConsumerService.doPost: LECP Profile identified. IDP info is unknown so farGet providerId from the response");
                }
                object2 = FSServiceUtils.getAllianceInstance();
                fSProviderDescriptor = ((FSAllianceManager)object2).getProvider(fSAuthnResponse.getProviderId());
            }
            if ((fSAssertionArtifactHandler = ((FSServiceManager)(object2 = FSServiceManager.getInstance())).getAssertionArtifactHandler(httpServletRequest, httpServletResponse, (FSAuthnRequest)object, fSAuthnResponse, fSProviderDescriptor)) == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doPost: could not create AssertionArtifactHandler");
                String[] stringArray10 = new String[]{FSUtils.bundle.getString("requestProcessingFailed")};
                LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", stringArray10);
                FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("requestProcessingFailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string18);
                return;
            }
            String string19 = FSServiceUtils.getHostedProviderID(httpServletRequest);
            fSAssertionArtifactHandler.setHostProviderId(string19);
            fSAssertionArtifactHandler.processAuthnResponse(fSAuthnResponse);
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Exception: " + exception.getMessage());
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("requestProcessingFailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string18);
            return;
        }
    }

    private FSAuthnRequest getInResponseToRequest(String string, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.getInResponseToRequest: Called");
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string2));
        return fSSessionManager.getAuthnRequest(string);
    }

    private FSProviderDescriptor getProvider(String string, String string2) {
        FSUtils.debug.message("FSAssertionConsumerService.getProvider: Called");
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string2));
        return fSSessionManager.getProviderDescriptor(string);
    }

    private boolean verifyAuthnResponseSignature(Document document, String string) {
        FSUtils.debug.message("FSAssertionConsumerService.verifyAuthnResponseSignature: Called");
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.error("FSAssertionConsumerService.verifyAuthnResponseSignature: Unable to get alliance manager");
                return false;
            }
            String string2 = fSAllianceManager.getProvider(string).getSigningKeyAlias();
            if (string2 == null) {
                FSUtils.debug.error("FSAssertionConsumerService.verifyAuthnResponseSignature: couldn't obtain this site's cert alias.");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.verifyAuthnResponseSignature: Provider's certAlias is found: " + string2);
            }
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionConsumerService.verifyAuthnResponseSignature: Exception occured while verifying signature: ", (Throwable)exception);
            return false;
        }
    }
}

