/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSAttributeMapper;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.fednsso.FSProxyHandler;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.logout.FSTokenListener;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.servlet.POSTCleanUpThread;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.sm.CookieUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSAssertionArtifactHandler {
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected FSProviderDescriptor idpDescriptor = null;
    protected FSAuthnRequest authnRequest = null;
    protected String relayState = null;
    protected static Map idTimeMap = new HashMap();
    protected static Thread cThread = new POSTCleanUpThread(idTimeMap);
    protected boolean doFederate = false;
    protected String nameIDPolicy = null;
    protected String hostProviderId = null;
    protected FSLocalConfigurationDescriptor localConfig = null;
    private String idpSessionIndex = null;
    private Date reAuthnOnOrAfterDate = null;
    private AuthnContext authnContextStmt = null;
    private List cookieDomainList = FSServiceUtils.getCookieDomainList();
    protected AttributeStatement bootStrapStatement = null;
    protected AttributeStatement _autoFedStatement = null;
    protected Map autoFedSearchMap = null;
    protected List securityAssertions = null;
    protected SSOToken ssoToken = null;
    protected FSAuthnResponse authnResponse = null;
    protected Response samlResponse = null;
    protected Element samlResponseElt = null;
    protected List attrStatements = new ArrayList();
    protected String hostEntityId = null;
    protected static String ANONYMOUS_PRINCIPAL = "anonymous";
    protected static FSAttributeMapper attributeMapper = null;
    protected static FederationSPAdapter spAdapter = null;

    public void setHostProviderId(String string) {
        this.hostProviderId = string;
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId);
            this.localConfig = fSHostedProviderDescriptor.getLocalConfiguration();
            this.hostEntityId = fSHostedProviderDescriptor.getEntityID();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAssertionArtifactHandler.setHostProviderId: Could not obtain local config");
        }
    }

    public String getHostProviderId() {
        return this.hostProviderId;
    }

    public FSAuthnRequest getAuthnRequest() {
        return this.authnRequest;
    }

    public void setAuthnRequest(FSAuthnRequest fSAuthnRequest) {
        this.authnRequest = fSAuthnRequest;
    }

    protected FSAssertionArtifactHandler() {
    }

    public FSAssertionArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSProviderDescriptor fSProviderDescriptor, boolean bl, String string, String string2) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (string2 != null) {
            this.relayState = string2;
        }
        if (fSProviderDescriptor != null) {
            this.idpDescriptor = fSProviderDescriptor;
        }
        this.doFederate = bl;
        this.nameIDPolicy = string;
    }

    public FSAssertionArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSProviderDescriptor fSProviderDescriptor, FSAuthnRequest fSAuthnRequest, boolean bl, String string) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (string != null) {
            this.relayState = string;
        }
        if (fSProviderDescriptor != null) {
            this.idpDescriptor = fSProviderDescriptor;
        }
        if (fSAuthnRequest != null) {
            this.authnRequest = fSAuthnRequest;
            this.nameIDPolicy = fSAuthnRequest.getNameIDPolicy();
        }
        this.doFederate = bl;
    }

    public FSAssertionArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string, String string2) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (string2 != null) {
            this.relayState = string2;
        }
        this.doFederate = bl;
        this.nameIDPolicy = string;
    }

    public void processAuthnResponse(FSAuthnResponse fSAuthnResponse) {
        block32: {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.ProcessAuthnResponse: Called");
            }
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
            this.authnResponse = fSAuthnResponse;
            try {
                fSLocalConfigurationDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId).getLocalConfiguration();
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: Could not obtain local config");
                return;
            }
            String string = "RequestID";
            String string2 = FSServiceUtils.getBaseURL(this.request);
            String string3 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(this.request), this.authnRequest.getRelayState(), null, this.request, string2);
            try {
                int n;
                boolean bl;
                if (fSAuthnResponse == null) {
                    String[] stringArray = new String[]{FSUtils.bundle.getString("missingAuthnResponse")};
                    LogUtil.error(Level.INFO, "MISSING_AUTHN_RESPONSE", stringArray);
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("missingAuthnResponse") + " AuthnRequest Processing Failed at the IDP " + "Redirecting to the Framed Login Page");
                    this.response.sendRedirect(string3);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doPost: Received " + fSAuthnResponse.toXMLString());
                }
                if (!(bl = this.verifyResponseStatus(fSAuthnResponse))) {
                    FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.getHostProviderId());
                    String string4 = fSAuthnResponse.getInResponseTo();
                    fSSessionManager.removeAuthnRequest(string4);
                    String[] stringArray = new String[]{fSAuthnResponse.toXMLString()};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray);
                    FSUtils.debug.warning("FSAssertionArtifactHandler. processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostProviderId, this.request, this.response, this.authnRequest, fSAuthnResponse, null)) {
                        this.response.sendRedirect(string3);
                    }
                    return;
                }
                List list = fSAuthnResponse.getAssertion();
                FSSubject fSSubject = (FSSubject)this.validateAssertions(list);
                if (fSSubject == null) {
                    String[] stringArray = new String[]{FSUtils.bundle.getString("invalidAssertion")};
                    LogUtil.error(Level.INFO, "INVALID_ASSERTION", stringArray);
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("InvalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(string3);
                    return;
                }
                FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
                if (this.doFederate) {
                    NameIdentifier nameIdentifier;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Initiate Account Federation");
                    }
                    if ((nameIdentifier = fSSubject.getIDPProvidedNameIdentifier()) == null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: IDPProvided NameIdentifier is null");
                        }
                        nameIdentifier = fSSubject.getNameIdentifier();
                    }
                    if (nameIdentifier != null) {
                        if (this.doAccountFederation(nameIdentifier)) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Account federation successful");
                            }
                            String string5 = fSAuthnResponse.getInResponseTo();
                            fSSessionManager.removeAuthnRequest(string5);
                            fSSessionManager.removeLocalSSOToken(string5);
                            return;
                        }
                        String[] stringArray = new String[]{FSUtils.bundle.getString("AccountFederationFailed")};
                        LogUtil.error(Level.INFO, "ACCOUNT_FEDERATION_FAILED", stringArray);
                        FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("AccountFederationFailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                        if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostProviderId, this.request, this.response, this.authnRequest, fSAuthnResponse, (FSResponse)this.samlResponse)) {
                            this.response.sendRedirect(string3);
                        }
                        break block32;
                    }
                    throw new FSException("missingNIofSubject", null);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Initiate SingleSign-On");
                }
                NameIdentifier nameIdentifier = fSSubject.getIDPProvidedNameIdentifier();
                NameIdentifier nameIdentifier2 = fSSubject.getNameIdentifier();
                if (nameIdentifier == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: IDPProvided NameIdentifier is null");
                    }
                    nameIdentifier = nameIdentifier2;
                }
                if (nameIdentifier == null || nameIdentifier2 == null) {
                    String[] stringArray = new String[]{FSUtils.bundle.getString("invalidResponse")};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray);
                    FSUtils.debug.error("FSAssertionArtifactHandler. processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(string3);
                    return;
                }
                String string6 = nameIdentifier.getName();
                String string7 = nameIdentifier2.getName();
                if (string6 == null || string7 == null) {
                    String[] stringArray = new String[]{FSUtils.bundle.getString("invalidResponse")};
                    LogUtil.error(Level.INFO, "INVALID_AUTHN_RESPONSE", stringArray);
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(string3);
                    return;
                }
                if (string6.equals(string7)) {
                    nameIdentifier2 = nameIdentifier;
                    n = 1;
                } else {
                    n = 0;
                }
                String string8 = fSLocalConfigurationDescriptor.getAssociatedOrgDN();
                if (this.doSingleSignOn(nameIdentifier2, n, string8, nameIdentifier)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Accountfederation successful");
                    }
                    String string9 = fSAuthnResponse.getInResponseTo();
                    fSSessionManager.removeAuthnRequest(string9);
                    if (this.isIDPProxyEnabled(string9)) {
                        this.sendProxyResponse(string9);
                        return;
                    }
                    String[] stringArray = new String[]{this.relayState};
                    LogUtil.access(Level.INFO, "ACCESS_GRANTED_REDIRECT_TO", stringArray);
                    if (spAdapter == null || !spAdapter.postSSOFederationSuccess(this.hostProviderId, this.request, this.response, this.ssoToken, this.authnRequest, fSAuthnResponse, null)) {
                        this.response.setHeader("Location", this.relayState);
                        this.redirectToResource(this.relayState);
                    }
                    return;
                }
                String[] stringArray = new String[]{FSUtils.bundle.getString("SSOfailed")};
                LogUtil.error(Level.INFO, "SINGLE_SIGNON_FAILED", stringArray);
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                if (spAdapter == null || !spAdapter.postSSOFederationFailure(this.hostProviderId, this.request, this.response, this.authnRequest, fSAuthnResponse, null)) {
                    this.response.sendRedirect(string3);
                }
                return;
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: Exception Occured: ", (Throwable)exception);
                try {
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(string3);
                }
                catch (IOException iOException) {
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: IOException Occured: " + iOException.getMessage());
                    return;
                }
                return;
            }
        }
    }

    protected boolean verifyResponseStatus(Response response) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.verifyResponseStatus: Called");
        }
        if (!response.getStatus().getStatusCode().getValue().endsWith(":Success")) {
            FSUtils.debug.warning("FSAssertionArtifactHandler.verifyResponse: Incorrect StatusCode value.");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.verifyResponse: StatusCode value verified.");
        }
        return true;
    }

    protected Subject validateAssertions(List list) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertions: Called");
        }
        FSSubject fSSubject = null;
        Iterator iterator = list.iterator();
        FSAssertion fSAssertion = null;
        String string = null;
        String string2 = null;
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        String string3 = null;
        try {
            fSHostedProviderDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId);
            string3 = fSHostedProviderDescriptor.getEntityID();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertions: ProviderID of the site is:" + string3);
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertions:" + exception.getMessage());
            return null;
        }
        Iterator iterator2 = null;
        Statement statement = null;
        int n = -1;
        Object var12_13 = null;
        SubjectConfirmation subjectConfirmation = null;
        Set set = null;
        String string4 = null;
        Date date = null;
        long l = System.currentTimeMillis() + 180000L;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            fSAssertion = (FSAssertion)iterator.next();
            if (!this.authnRequest.getRequestID().equals(fSAssertion.getInResponseTo())) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion does not correspond to any valid request");
                return null;
            }
            if (FSServiceUtils.isSigningOn() && !this.verifyAssertionSignature(fSAssertion)) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion signature verification failed");
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Assertion signature verified");
            }
            if (idTimeMap.containsKey(string = fSAssertion.getAssertionID())) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion: " + string + " is used");
                return null;
            }
            string2 = fSAssertion.getIssuer();
            try {
                object2 = FSServiceUtils.getAllianceInstance();
                FSProviderDescriptor fSProviderDescriptor = ((FSAllianceManager)object2).getProvider(string2);
                if (fSProviderDescriptor == null) {
                    FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not on the trust list");
                    return null;
                }
                if (this.idpDescriptor != null) {
                    if (!this.idpDescriptor.getEntityID().equals(string2)) {
                        FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not the entity where AuthnRequest was sent originally.");
                        return null;
                    }
                } else {
                    FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is: " + string2);
                    this.setProviderDescriptor(fSProviderDescriptor);
                }
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not on the trust list");
                return null;
            }
            if (!fSAssertion.isTimeValid()) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion's time is not valid.");
                return null;
            }
            object2 = fSAssertion.getConditions();
            if (!this.forThisServer((Conditions)object2, string3)) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion is not issued for this site.");
                return null;
            }
            boolean bl = false;
            if (fSAssertion.getStatement() != null) {
                iterator2 = fSAssertion.getStatement().iterator();
                while (iterator2.hasNext()) {
                    statement = (Statement)iterator2.next();
                    n = statement.getStatementType();
                    if (n == 1) {
                        block36: {
                            object = (FSAuthenticationStatement)statement;
                            bl = true;
                            try {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: validating AuthenticationStatement:" + ((FSAuthenticationStatement)object).toXMLString());
                                }
                            }
                            catch (FSException fSException) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Exception. Invalid AuthenticationStatement: " + fSException.getMessage());
                                return null;
                            }
                            this.reAuthnOnOrAfterDate = ((FSAuthenticationStatement)object).getReauthenticateOnOrAfter();
                            this.idpSessionIndex = ((FSAuthenticationStatement)object).getSessionIndex();
                            this.authnContextStmt = ((FSAuthenticationStatement)object).getAuthnContext();
                            fSSubject = (FSSubject)((SubjectStatement)object).getSubject();
                            if (fSSubject == null) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Subject is null");
                                return null;
                            }
                            try {
                                if (!FSUtils.debug.messageEnabled()) break block36;
                                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: found Authentication Statement. Subject = " + fSSubject.toXMLString());
                            }
                            catch (FSException fSException) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion:  Exception. Invalid subject: " + fSException.getMessage());
                                continue;
                            }
                        }
                        subjectConfirmation = fSSubject.getSubjectConfirmation();
                        if (subjectConfirmation == null || (set = subjectConfirmation.getConfirmationMethod()) == null || set.size() != 1) {
                            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: missing or extra ConfirmationMethod.");
                            return null;
                        }
                        string4 = (String)set.iterator().next();
                        if (string4 == null || !string4.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer") && !string4.equals(SAMLConstants.CONFIRMATION_METHOD_ARTIFACT) && !string4.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01")) {
                            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: wrong ConfirmationMethod");
                            return null;
                        }
                        if (!FSUtils.debug.messageEnabled()) continue;
                        FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Confirmation method: " + string4);
                        continue;
                    }
                    if (n != 3 || this.checkForAttributeStatement((AttributeStatement)(object = (AttributeStatement)statement))) continue;
                    this.attrStatements.add(object);
                }
            }
            if (!bl) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: No Authentication statement found in the Assertion. User is not authenticated by the IDP");
                }
                return null;
            }
            date = ((Conditions)object2).getNotOnorAfter();
            if (date != null) {
                l = date.getTime();
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Adding " + string + " to idTimeMap.");
            }
            object = idTimeMap;
            synchronized (object) {
                idTimeMap.put(string, new Long(l));
            }
            this.securityAssertions = fSAssertion.getDiscoveryCredential();
        }
        if (fSSubject == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: couldn't find Subject.");
            return null;
        }
        return fSSubject;
    }

    private boolean checkForAttributeStatement(AttributeStatement attributeStatement) {
        List list = attributeStatement.getAttribute();
        if (list == null || list.size() == 0) {
            return false;
        }
        Iterator iterator = list.iterator();
        Attribute attribute = (Attribute)iterator.next();
        if (attribute.getAttributeName().equals("DiscoveryResourceOffering")) {
            this.bootStrapStatement = attributeStatement;
            return true;
        }
        if (attribute.getAttributeName().equals("AutoFederateAttribute")) {
            Object object;
            this._autoFedStatement = attributeStatement;
            List list2 = null;
            try {
                list2 = attribute.getAttributeValue();
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSAssertionArtifactHandler.checkForAttributeStatement: ", (Throwable)sAMLException);
            }
            String string = null;
            if (list2 != null && list2.size() != 0) {
                object = list2.iterator();
                Element element = (Element)object.next();
                string = XMLUtils.getElementValue((Element)element);
            }
            if (this.localConfig.isAutoFedEnabled() && string != null) {
                this.autoFedSearchMap = new HashMap();
                object = new HashSet();
                object.add(string);
                this.autoFedSearchMap.put(this.localConfig.getAutoFedAttribute(), object);
            }
            return true;
        }
        return false;
    }

    protected boolean verifyAssertionSignature(FSAssertion fSAssertion) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: Called");
        }
        try {
            if (!fSAssertion.isSigned()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: Assertion is not signed");
                }
                return false;
            }
            String string = this.idpDescriptor.getSigningKeyAlias();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: Provider's certAlias is found: " + string);
            }
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            if (this.authnResponse != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHander.verifyAssertionSignature:  xml string to be verified:" + XMLUtils.print((Node)this.authnResponse.getDOMElement().getOwnerDocument()));
                }
                return xMLSignatureManager.verifyXMLSignature(this.authnResponse.getDOMElement().getOwnerDocument(), string);
            }
            if (this.samlResponseElt != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHander.verifyAssertionSignature:  xml string to be verified:" + XMLUtils.print((Node)this.samlResponseElt.getOwnerDocument()));
                }
                return xMLSignatureManager.verifyXMLSignature(this.samlResponseElt.getOwnerDocument(), string);
            }
            return false;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.verifyAssertionSignature: Exception occured while verifying IDP's signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean forThisServer(Conditions conditions, String string) {
        FSUtils.debug.message("FSAssertionArtifactHandler.forThisServer: Called");
        if (conditions == null || string == null || string.equals("")) {
            return true;
        }
        Set set = conditions.getAudienceRestrictionCondition();
        if (set == null || set.isEmpty()) {
            return true;
        }
        boolean bl = false;
        Iterator iterator = set.iterator();
        AudienceRestrictionCondition audienceRestrictionCondition = null;
        Object var7_7 = null;
        Object var8_8 = null;
        while (iterator.hasNext()) {
            audienceRestrictionCondition = (AudienceRestrictionCondition)iterator.next();
            if (!audienceRestrictionCondition.containsAudience(string)) continue;
            bl = true;
            if (!FSUtils.debug.messageEnabled()) break;
            FSUtils.debug.message("FSAssertionArtifactHandler.forThisServer: Assertion is validated to befor this server");
            break;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean generateToken(NameIdentifier var1_1, int var2_2, String var3_3, NameIdentifier var4_4) {
        FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: Called");
        if (var1_1 == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Invalid userDN input");
            return false;
        }
        if (var3_3 == null || var3_3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.generateToken:Invalid orgDN input using default orgDN");
            }
            var3_3 = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        }
        try {
            block42: {
                block43: {
                    block44: {
                        block40: {
                            block41: {
                                var5_5 = var1_1.getName();
                                var6_7 = var1_1.getNameQualifier();
                                if (var6_7 == null || var6_7.length() == 0) {
                                    var6_7 = this.hostEntityId;
                                }
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: Trying to get userDN for opaqueHandle= " + var5_5 + " ,securityDomain= " + var6_7 + " And HandleType=" + var2_2);
                                }
                                var7_8 = this.authnRequest.getAffiliationID();
                                var8_9 = new FSAccountFedInfoKey(var6_7, var5_5);
                                var9_10 = FSAccountManager.getInstance();
                                var10_11 = var9_10.getAMIdentity(var8_9, var3_3);
                                if (var10_11 != null) ** GOTO lbl74
                                if (var4_4 == null || !var6_7.equals(var7_8)) break block40;
                                var8_9 = new FSAccountFedInfoKey(var7_8, var4_4.getName());
                                var10_11 = var9_10.getAMIdentity(var8_9, var3_3);
                                if (var10_11 == null) break block41;
                                var11_12 = var9_10.readAccountFedInfo(var10_11, var7_8);
                                if (var11_12 != null) {
                                    var9_10.removeAccountFedInfo(var10_11, (FSAccountFedInfo)var11_12);
                                }
                                var12_13 = new FSAccountFedInfo(this.idpDescriptor.getEntityID(), var1_1, var4_4, true);
                                var12_13.setAffiliation(true);
                                var8_9 = new FSAccountFedInfoKey(var6_7, var5_5);
                                var9_10.writeAccountFedInfo(var10_11, var8_9, (FSAccountFedInfo)var12_13);
                                break block42;
                            }
                            FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle. fedKey=" + var8_9.toString());
                            return false;
                        }
                        var11_12 = new FSAccountFedInfoKey(this.idpDescriptor.getEntityID(), var5_5);
                        if (var11_12 == null) ** GOTO lbl72
                        var10_11 = var9_10.getAMIdentity((FSAccountFedInfoKey)var11_12, var3_3);
                        if (var10_11 == null) break block43;
                        var12_13 = var9_10.readAccountFedInfo(var10_11, this.idpDescriptor.getEntityID());
                        if (var12_13 == null || !var12_13.isFedStatusActive()) break block44;
                        var13_14 = var12_13.getLocalNameIdentifier();
                        if (var13_14 != null) {
                            var13_14.setNameQualifier(this.hostEntityId);
                        }
                        var9_10.removeAccountFedInfo(var10_11, (FSAccountFedInfo)var12_13);
                        var14_16 = var12_13.getRemoteNameIdentifier();
                        if (var14_16 != null) {
                            var14_16.setNameQualifier(this.hostEntityId);
                        }
                        var15_17 = new FSAccountFedInfo(this.idpDescriptor.getEntityID(), (NameIdentifier)var13_14, (NameIdentifier)var14_16, true);
                        var9_10.removeAccountFedInfoKey(var10_11, (FSAccountFedInfoKey)var11_12);
                        var16_18 /* !! */  = new FSAccountFedInfoKey(this.hostEntityId, var5_5);
                        var9_10.writeAccountFedInfo(var10_11, (FSAccountFedInfoKey)var16_18 /* !! */ , (FSAccountFedInfo)var15_17);
                        break block42;
                    }
                    FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle.");
                    return false;
                }
                if (!this.localConfig.isAutoFedEnabled() || this._autoFedStatement == null) ** GOTO lbl70
                var10_11 = var9_10.getAMIdentity(var3_3, this.autoFedSearchMap);
                if (var10_11 != null) {
                    var12_13 = new FSAccountFedInfoKey(this.hostEntityId, var5_5);
                    var13_14 = new FSAccountFedInfo(this.idpDescriptor.getEntityID(), null, var1_1, true);
                    var9_10.writeAccountFedInfo(var10_11, (FSAccountFedInfoKey)var12_13, (FSAccountFedInfo)var13_14);
                } else {
                    FSUtils.debug.error("FSAssertionArtifactHandler. generateToken: Can't dereference handle.");
                    return false;
lbl70:
                    // 1 sources

                    FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle.");
                    return false;
lbl72:
                    // 1 sources

                    FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle.");
                    return false;
lbl74:
                    // 1 sources

                    var11_12 = null;
                    var11_12 = var7_8 != null ? var9_10.readAccountFedInfo(var10_11, var7_8) : var9_10.readAccountFedInfo(var10_11, this.idpDescriptor.getEntityID());
                    if (var11_12 == null) {
                        FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: User's account is not federated, id=" + var10_11);
                        return false;
                    }
                }
            }
            var11_12 = SystemProperties.get((String)"com.iplanet.am.cookie.name");
            var12_13 = null;
            var13_15 = 0;
            var14_16 = this.localConfig.getSPAuthContextInfo();
            if (this.authnContextStmt != null && this.authnContextStmt.getAuthnContextClassRef() != null && !this.authnContextStmt.getAuthnContextClassRef().equals("")) {
                var12_13 = this.authnContextStmt.getAuthnContextClassRef();
                if (var12_13 != null && !var12_13.equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: AuthnContextClassRef found in AuthenticationStatement:" + (String)var12_13);
                    }
                    if ((var15_17 = (FSSPAuthenticationContextInfo)var14_16.get(var12_13)) != null) {
                        var13_15 = var15_17.getAuthenticationLevel();
                    } else {
                        FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Could not find AuthnContextClassInfo for authnContextClassRef: " + (String)var12_13 + "Using default authnContextClass");
                        var12_13 = null;
                    }
                }
            } else {
                FSUtils.debug.warning("FSAssertionArtifactHandler.generateToken: Could not find AuthnContextClassRef in the AuthenticationStatement. Using default authnContextClass");
            }
            if (var12_13 == null || var12_13.equals("")) {
                var12_13 = this.localConfig.getDefaultAuthenticationContext();
                var15_17 = (FSSPAuthenticationContextInfo)var14_16.get(var12_13);
                if (var15_17 != null) {
                    var13_15 = var15_17.getAuthenticationLevel();
                } else {
                    FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Could not find authentication level for default authentication context class");
                    return false;
                }
            }
            var15_17 = AuthUtils.getAuthContext(var3_3);
            var15_17.login(AuthContext.IndexType.USER, var10_11.getName(), true);
            var16_18 /* !! */  = var15_17.getSSOToken();
            var16_18 /* !! */ .setProperty("AuthLevel", new Integer(var13_15).toString());
            var16_18 /* !! */ .setProperty("authInstant", this.getAuthInstant());
            var16_18 /* !! */ .addSSOTokenListener((SSOTokenListener)new FSTokenListener(this.hostProviderId));
            var17_19 = var16_18 /* !! */ .getTokenID().toString();
            this.request.setAttribute((String)var11_12, (Object)var17_19);
            var18_20 = SystemProperties.get((String)"com.sun.identity.cookieRewritingInPath", (String)"false");
            if (Boolean.valueOf(var18_20).booleanValue()) {
                this.relayState = SessionEncodeURL.encodeURL((String)SessionEncodeURL.createCookieString((String)var11_12, (String)var17_19), (String)this.relayState, (short)0, (boolean)true);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler. generateTokenSetting SSOToken as cookie: CookieName=" + (String)var11_12 + " And cookie value= " + var17_19 + " And relayState=" + this.relayState);
            }
            this.ssoToken = var16_18 /* !! */ ;
            var19_21 = null;
            var20_22 = null;
            if (this.cookieDomainList != null) {
                var19_21 = this.cookieDomainList.iterator();
                while (var19_21 != null && var19_21.hasNext()) {
                    var20_22 = CookieUtils.newCookie((String)var11_12, var17_19, "/", (String)var19_21.next());
                    this.response.addCookie(var20_22);
                }
            } else {
                var20_22 = CookieUtils.newCookie((String)var11_12, var17_19, "/");
                this.response.addCookie(var20_22);
            }
            var21_23 = SystemProperties.get((String)"com.sun.identity.federation.fedCookieName");
            var22_24 = "yes";
            var23_25 = null;
            if (this.cookieDomainList != null) {
                var19_21 = this.cookieDomainList.iterator();
                while (var19_21 != null && var19_21.hasNext()) {
                    var23_25 = CookieUtils.newCookie(var21_23, var22_24, 31536000, "/", (String)var19_21.next());
                    this.response.addCookie(var23_25);
                }
            } else {
                var23_25 = CookieUtils.newCookie(var21_23, var22_24, 31536000, "/", null);
                this.response.addCookie(var23_25);
            }
            if ((var25_27 = (var24_26 = FSSessionManager.getInstance(this.hostEntityId)).getSession(IdUtils.getUniversalId(var10_11), var17_19)) != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: No existing session found  for userDN:" + var10_11 + " And SessionID: " + var17_19 + " Creating a new Session");
                }
                var25_27.addSessionPartner(new FSSessionPartner(this.idpDescriptor.getProviderID(), true));
                var25_27.setSessionIndex(this.idpSessionIndex);
                var24_26.addSession(IdUtils.getUniversalId(var10_11), var25_27);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: An Existing session foundfor userDN:" + var10_11 + " And SessionID: " + var17_19 + " Adding partner to the Session");
                }
                var25_27 = new FSSession(var17_19);
                var25_27.addSessionPartner(new FSSessionPartner(this.idpDescriptor.getProviderID(), true));
                if (this.idpSessionIndex != null) {
                    var25_27.setSessionIndex(this.idpSessionIndex);
                }
                var24_26.addSession(IdUtils.getUniversalId(var10_11), var25_27);
            }
            if (this.bootStrapStatement != null) {
                var25_27.setBootStrapAttributeStatement(this.bootStrapStatement);
            }
            if (this._autoFedStatement != null) {
                var25_27.setAutoFedStatement(this._autoFedStatement);
            }
            if (this.attrStatements.size() != 0) {
                var25_27.setAttributeStatements(this.attrStatements);
                FSAssertionArtifactHandler.attributeMapper = FSAssertionArtifactHandler.getAttributeMapper();
                if (FSAssertionArtifactHandler.attributeMapper != null) {
                    this.setAttributeMap(this.ssoToken, FSAssertionArtifactHandler.attributeMapper.getAttributes(this.attrStatements, this.hostEntityId, this.idpDescriptor.getEntityID(), this.ssoToken));
                }
            }
            if (this.securityAssertions != null) {
                var25_27.setBootStrapCredential(this.securityAssertions);
            }
            return true;
        }
        catch (Exception var5_6) {
            FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Exception Occured ", (Throwable)var5_6);
            return false;
        }
    }

    protected void processSAMLRequest() {
    }

    protected boolean doSingleSignOn(NameIdentifier nameIdentifier, int n, String string, NameIdentifier nameIdentifier2) {
        FSUtils.debug.message("FSAssertionArtifactHandler.doSingleSignOn: Called");
        boolean bl = true;
        try {
            bl = this.generateToken(nameIdentifier, n, string, nameIdentifier2);
            if (!bl) {
                String[] stringArray = new String[]{FSUtils.bundle.getString("failGenerateSSOToken")};
                LogUtil.error(Level.INFO, "FAILED_SSO_TOKEN_GENERATION", stringArray);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doSingleSignOn", (Throwable)exception);
            return false;
        }
    }

    protected void redirectToResource(String string) throws FSException {
    }

    protected boolean doAccountFederation(NameIdentifier nameIdentifier) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray;
        Object object5;
        Object object6;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation:Called");
        }
        if (nameIdentifier == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation:" + FSUtils.bundle.getString("invalidInput"));
            return false;
        }
        try {
            object6 = SSOTokenManager.getInstance();
            this.ssoToken = object6.createSSOToken(this.request);
            if (this.ssoToken == null || !object6.isValidToken(this.ssoToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: couldn't obtain ssoToken from cookie");
                }
                this.ssoToken = null;
            }
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: exception when getting ssoToken from cookie:");
            }
            this.ssoToken = null;
        }
        object6 = null;
        String string = SystemProperties.get((String)"com.sun.identity.cookieRewritingInPath", (String)"false");
        if (Boolean.valueOf(string).booleanValue() && this.ssoToken == null) {
            try {
                object6 = FSSessionManager.getInstance(this.hostEntityId);
                this.ssoToken = ((FSSessionManager)object6).getLocalSSOToken(this.authnRequest.getRequestID());
                object5 = SSOTokenManager.getInstance();
                if (this.ssoToken == null || !object5.isValidToken(this.ssoToken)) {
                    FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation: " + FSUtils.bundle.getString("failGenerateSSOToken"));
                    String[] stringArray2 = new String[]{FSUtils.bundle.getString("failGenerateSSOToken")};
                    LogUtil.error(Level.INFO, "FAILED_SSO_TOKEN_GENERATION", stringArray2);
                    return false;
                }
                this.relayState = this.ssoToken.encodeURL(this.relayState);
                this.request.setAttribute(SystemProperties.get((String)"com.iplanet.am.cookie.name"), (Object)this.ssoToken.getTokenID().toString());
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation: " + FSUtils.bundle.getString("failGenerateSSOToken"), (Throwable)exception);
                String[] stringArray3 = new String[]{FSUtils.bundle.getString("failGenerateSSOToken")};
                LogUtil.error(Level.INFO, "FAILED_SSO_TOKEN_GENERATION", stringArray3);
                return false;
            }
        }
        if (this.ssoToken == null && this.nameIDPolicy != null && this.nameIDPolicy.equals("onetime")) {
            this.ssoToken = this.generateAnonymousToken(this.response);
        }
        if (this.ssoToken == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation:Account federation failed. Invalid ssotoken");
            return false;
        }
        object5 = null;
        try {
            stringArray = nameIdentifier.getName();
            object5 = FSServiceUtils.getAMIdentity(this.ssoToken.getProperty("sun.am.UniversalIdentifier"));
            object4 = nameIdentifier.getNameQualifier();
            if (object4 == null || ((String)object4).length() == 0) {
                object4 = this.hostEntityId;
            }
            object3 = new FSAccountFedInfo(this.idpDescriptor.getEntityID(), null, nameIdentifier, true);
            object2 = FSAccountManager.getInstance();
            object = null;
            String string2 = this.authnRequest.getAffiliationID();
            if (string2 != null) {
                object = new FSAccountFedInfoKey(string2, (String)stringArray);
                ((FSAccountFedInfo)object3).setAffiliation(true);
            } else {
                object = new FSAccountFedInfoKey((String)object4, (String)stringArray);
            }
            if (this.nameIDPolicy == null || !this.nameIDPolicy.equals("onetime")) {
                ((FSAccountManager)object2).writeAccountFedInfo((AMIdentity)object5, (FSAccountFedInfoKey)object, (FSAccountFedInfo)object3);
            }
            if (object6 == null) {
                object6 = FSSessionManager.getInstance(this.hostEntityId);
            }
            String string3 = this.ssoToken.getTokenID().toString();
            FSSession fSSession = ((FSSessionManager)object6).getSession(IdUtils.getUniversalId((AMIdentity)object5), string3);
            if (fSSession != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: No existing session found  for userDN:" + object5 + " And SessionID: " + string3 + " Creating a new Session");
                }
                fSSession.addSessionPartner(new FSSessionPartner(this.idpDescriptor.getProviderID(), true));
                fSSession.setSessionIndex(this.idpSessionIndex);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: An Existing session foundfor userDN:" + object5 + " And SessionID: " + string3 + " Adding partner to the Session");
                }
                fSSession = new FSSession(string3);
                fSSession.addSessionPartner(new FSSessionPartner(this.idpDescriptor.getProviderID(), true));
                if (this.idpSessionIndex != null) {
                    fSSession.setSessionIndex(this.idpSessionIndex);
                }
            }
            if (this.nameIDPolicy != null && this.nameIDPolicy.equals("onetime")) {
                fSSession.setOneTime(true);
                fSSession.setAccountFedInfo((FSAccountFedInfo)object3);
                fSSession.setUserDN(this.ssoToken.getProperty("sun.am.UniversalIdentifier"));
            }
            if (this.bootStrapStatement != null) {
                fSSession.setBootStrapAttributeStatement(this.bootStrapStatement);
            }
            if (this.attrStatements.size() != 0 && (attributeMapper = FSAssertionArtifactHandler.getAttributeMapper()) != null) {
                this.setAttributeMap(this.ssoToken, attributeMapper.getAttributes(this.attrStatements, this.hostEntityId, this.idpDescriptor.getEntityID(), this.ssoToken));
            }
            ((FSSessionManager)object6).addSession(IdUtils.getUniversalId((AMIdentity)object5), fSSession);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation:" + FSUtils.bundle.getString("ExceptionOccured"), (Throwable)exception);
            return false;
        }
        stringArray = new String[]{this.relayState};
        LogUtil.access(Level.INFO, "ACCESS_GRANTED_REDIRECT_TO", stringArray);
        this.response.setHeader("Location", this.relayState);
        if (this.nameIDPolicy == null || !this.nameIDPolicy.equals("onetime")) {
            object4 = SystemProperties.get((String)"com.sun.identity.federation.fedCookieName");
            object3 = "yes";
            object2 = null;
            object = null;
            if (this.cookieDomainList != null) {
                object = this.cookieDomainList.iterator();
                while (object != null && object.hasNext()) {
                    object2 = CookieUtils.newCookie((String)object4, (String)object3, 31536000, "/", (String)object.next());
                    this.response.addCookie((Cookie)object2);
                }
            } else {
                object2 = CookieUtils.newCookie((String)object4, (String)object3, 31536000, "/", null);
                this.response.addCookie((Cookie)object2);
            }
        }
        try {
            object4 = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId);
            if (((FSProviderDescriptor)object4).getNameRegistrationIndicator()) {
                object3 = FSServiceManager.getInstance();
                object2 = ((FSServiceManager)object3).getNameRegistrationHandler(this.idpDescriptor.getProviderID(), "IDP");
                if (object2 != null) {
                    ((FSNameRegistrationHandler)object2).setHostedDescriptor((FSHostedProviderDescriptor)object4);
                    ((FSNameRegistrationHandler)object2).handleRegistrationAfterFederation(this.relayState, this.response);
                }
                if (!this.isRegisProfileSOAP((AMIdentity)object5, this.idpDescriptor.getProviderID(), (FSHostedProviderDescriptor)object4, this.idpDescriptor)) {
                    return true;
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            // empty catch block
        }
        try {
            if (spAdapter == null || !spAdapter.postSSOFederationSuccess(this.hostProviderId, this.request, this.response, this.ssoToken, this.authnRequest, this.authnResponse, (FSResponse)this.samlResponse)) {
                this.redirectToResource(this.relayState);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected SSOToken generateAnonymousToken(HttpServletResponse httpServletResponse) {
        FSUtils.debug.message("FSAssertionArtifactHandler.generateAnonymous");
        try {
            AuthContextLocal authContextLocal = AuthUtils.getAuthContext(this.localConfig.getAssociatedOrgDN());
            authContextLocal.login(AuthContext.IndexType.USER, ANONYMOUS_PRINCIPAL, true);
            SSOToken sSOToken = authContextLocal.getSSOToken();
            sSOToken.setProperty("authInstant", this.getAuthInstant());
            sSOToken.addSSOTokenListener((SSOTokenListener)new FSTokenListener(this.hostProviderId));
            String string = sSOToken.getTokenID().toString();
            Cookie cookie = null;
            String string2 = SystemProperties.get((String)"com.iplanet.am.cookie.name");
            if (this.cookieDomainList != null) {
                Iterator iterator = this.cookieDomainList.iterator();
                while (iterator.hasNext()) {
                    cookie = CookieUtils.newCookie(string2, string, "/", (String)iterator.next());
                    httpServletResponse.addCookie(cookie);
                }
            } else {
                cookie = CookieUtils.newCookie(string2, string, "/");
                httpServletResponse.addCookie(cookie);
            }
            return sSOToken;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.generateAnonymousToken failed.", (Throwable)exception);
            return null;
        }
    }

    protected FSAuthnRequest getInResponseToRequest(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.getInResponseToRequest: Called");
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
        this.authnRequest = fSSessionManager.getAuthnRequest(string);
        return this.authnRequest;
    }

    protected FSProviderDescriptor getProvider(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.getProvider: Called");
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
        return fSSessionManager.getProviderDescriptor(string);
    }

    public void setProviderDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        this.idpDescriptor = fSProviderDescriptor;
    }

    private String DNtoName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        int n2 = string.indexOf(",");
        string2 = n2 == -1 ? string.substring(n + 1).trim() : string.substring(n + 1, n2).trim();
        return string2;
    }

    public String getAuthInstant() {
        return DateUtils.toUTCDateFormat((Date)new Date());
    }

    private boolean isRegisProfileSOAP(AMIdentity aMIdentity, String string, FSHostedProviderDescriptor fSHostedProviderDescriptor, FSProviderDescriptor fSProviderDescriptor) {
        FSAccountFedInfo fSAccountFedInfo = null;
        try {
            fSAccountFedInfo = FSAccountManager.getInstance().readAccountFedInfo(aMIdentity, string);
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.message("in excpetion" + fSAccountMgmtException.getMessage());
            return true;
        }
        FSUtils.debug.message("host profile is " + fSHostedProviderDescriptor.getNameRegistrationProfile());
        FSUtils.debug.message("remote profile is " + fSProviderDescriptor.getNameRegistrationProfile());
        if (fSAccountFedInfo.isRoleIDP()) {
            if (fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                return true;
            }
            if (fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") || fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                return false;
            }
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
            return true;
        }
        if (fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
            return true;
        }
        if (fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") || fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
            return false;
        }
        FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
        return true;
    }

    protected boolean isIDPProxyEnabled(String string) {
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
        return fSSessionManager.getProxySPDescriptor(string) != null;
    }

    protected void sendProxyResponse(String string) {
        Object object;
        Object object2;
        FSUtils.debug.message("FSAssertionArtifactHandler.sendProxyResponse::");
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
        FSAuthnRequest fSAuthnRequest = fSSessionManager.getProxySPAuthnRequest(string);
        if (FSUtils.debug.messageEnabled()) {
            try {
                FSUtils.debug.message("FSAssertionHandler.sendProxyResponse:" + fSAuthnRequest.toXMLString());
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSAssertionHandler.sendProxyResponse:toString(): Failed.", (Throwable)exception);
            }
        }
        FSProviderDescriptor fSProviderDescriptor = fSSessionManager.getProxySPDescriptor(string);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.sendProxyResponse:Original requesting service provider id:" + fSProviderDescriptor.getProviderID());
        }
        FSSession fSSession = fSSessionManager.getSession(this.ssoToken);
        if (this.authnContextStmt != null) {
            object2 = this.authnContextStmt.getAuthnContextClassRef();
            fSSession.setAuthnContext((String)object2);
        }
        fSSession.addSessionPartner(new FSSessionPartner(FSUtils.appendProviderSuffix(fSAuthnRequest.getProviderId(), "SP"), false));
        object2 = fSSession.getSessionPartners().iterator();
        while (object2.hasNext()) {
            object = (FSSessionPartner)object2.next();
            FSUtils.debug.message("PARTNERS" + ((FSSessionPartner)object).getPartner());
        }
        object = new FSProxyHandler(this.request, this.response, fSAuthnRequest, fSProviderDescriptor, fSAuthnRequest.getRelayState(), this.ssoToken);
        ((FSSSOAndFedHandler)object).setHostProviderId(this.hostProviderId);
        ((FSSSOAndFedHandler)object).processAuthnRequest(fSAuthnRequest, true);
    }

    private void setAttributeMap(SSOToken sSOToken, Map map) {
        if (map == null || map.isEmpty()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.setAttributeMap: Attribute map is empty");
            }
            return;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.setAttributeMap: Attribute map populated to ssotoken:" + map);
        }
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                sSOToken.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            catch (SSOException sSOException) {
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("FSAssertionArtifactHandler.setAttributeMapper: Can not attributes", (Throwable)sSOException);
            }
        }
    }

    private static FSAttributeMapper getAttributeMapper() {
        if (attributeMapper != null) {
            return attributeMapper;
        }
        String string = SystemProperties.get((String)"com.sun.identity.liberty.fed.attributemapper", (String)"com.sun.identity.federation.services.FSDefaultAttributeMapper");
        try {
            Class<?> clazz = Class.forName(string);
            attributeMapper = (FSAttributeMapper)clazz.newInstance();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionConsumerService.static init failed for attribute mapper.", (Throwable)exception);
        }
        return attributeMapper;
    }

    static {
        cThread.start();
        try {
            String string = SystemProperties.get((String)"com.sun.identity.federation.spadapter", (String)"com.sun.identity.federation.plugins.FSDefaultSPAdapter");
            Class<?> clazz = Class.forName(string);
            spAdapter = (FederationSPAdapter)clazz.newInstance();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler:Static Init Failed", (Throwable)exception);
        }
    }
}

