/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSRequest;
import com.sun.identity.federation.services.fednsso.FSAssertionArtifactHandler;
import com.sun.identity.federation.services.fednsso.FSBrowserArtifactConsumerHandler;
import com.sun.identity.federation.services.fednsso.FSBrowserPostConsumerHandler;
import com.sun.identity.federation.services.fednsso.FSLECPConsumerHandler;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserArtifactProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserPostProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOLECPProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOWMLPostProfileHandler;
import com.sun.identity.federation.services.fednsso.FSWMLPostConsumerHandler;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.Request;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSServiceManager {
    private static FSServiceManager instance = null;
    static /* synthetic */ Class class$com$sun$identity$federation$services$FSServiceManager;

    private FSServiceManager() {
        FSUtils.debug.message("FSServiceManager(): Called");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public FSAssertionArtifactHandler getAssertionArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSAuthnResponse fSAuthnResponse, FSProviderDescriptor fSProviderDescriptor) {
        void var6_10;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceManager.getAssertionArtifactHandler: Called");
        }
        if (httpServletRequest == null || httpServletResponse == null || fSAuthnRequest == null || fSAuthnResponse == null) {
            FSUtils.debug.error("FSServiceManager.getAssertionArtifactHandler: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        Object var6_6 = null;
        String string = fSAuthnRequest.getProtocolProfile();
        boolean bl = fSAuthnRequest.getFederate();
        String string2 = fSAuthnResponse.getRelayState();
        if (string == null) {
            FSUtils.debug.error("FSServiceManager.getAssertionArtifactHandler: No protocol profile in the Request");
            return null;
        }
        if (string.equals("http://projectliberty.org/profiles/brws-post")) {
            FSBrowserPostConsumerHandler fSBrowserPostConsumerHandler = new FSBrowserPostConsumerHandler(httpServletRequest, httpServletResponse, fSProviderDescriptor, fSAuthnRequest, bl, string2);
            return var6_10;
        }
        if (string.equals("http://projectliberty.org/profiles/wml-post")) {
            FSWMLPostConsumerHandler fSWMLPostConsumerHandler = new FSWMLPostConsumerHandler(httpServletRequest, httpServletResponse, fSProviderDescriptor, fSAuthnRequest, bl, string2);
            return var6_10;
        }
        if (string.equals("http://projectliberty.org/profiles/lecp")) {
            FSLECPConsumerHandler fSLECPConsumerHandler = new FSLECPConsumerHandler(httpServletRequest, httpServletResponse, fSProviderDescriptor, fSAuthnRequest, bl, string2);
            return var6_10;
        }
        FSUtils.debug.error("FSServiceManager.getAssertionArtifactHandler: Unknown Protocol profile request");
        return null;
    }

    public FSAssertionArtifactHandler getBrowserArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, FSRequest fSRequest, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceManager.getBrowserArtifactHandler: Called");
        }
        if (httpServletRequest == null || httpServletResponse == null || string == null || fSRequest == null) {
            FSUtils.debug.error("FSServiceManager.getBrowserArtifactHandler: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        try {
            Object var6_6 = null;
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            string = SAMLUtilsCommon.byteArrayToHexString(string.getBytes("ISO-8859-1"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceManager.getBrowserArtifactHandler: IDP's succintId as hex string: " + string);
            }
            FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProviderBySuccinctID(string);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceManager.getBrowserArtifactHandler: IDP Id of the provider to communicate: " + fSProviderDescriptor.getProviderID());
            }
            return new FSBrowserArtifactConsumerHandler(httpServletRequest, httpServletResponse, fSProviderDescriptor, string2, fSRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceManager.getBrowserArtifactHandler: Exception Occured: " + exception.getMessage());
            return null;
        }
    }

    public FSSSOAndFedHandler getSSOAndFedHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest) {
        FSUtils.debug.message("FSServiceManager.getSSOAndFedHandler: Called ");
        if (httpServletRequest == null || httpServletResponse == null || fSAuthnRequest == null) {
            FSUtils.debug.error("FSServiceManager.getSSOAndFedHandler: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        try {
            FSSSOAndFedHandler fSSSOAndFedHandler = null;
            String string = fSAuthnRequest.getProtocolProfile();
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(fSAuthnRequest.getProviderId(), "SP");
            String string2 = fSAuthnRequest.getRelayState();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceManager.getSSOAndFedHandler:  Browser Art prof: http://projectliberty.org/profiles/brws-art");
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceManager.getSSOAndFedHandler: Profile in the request: " + string);
            }
            if (string != null) {
                if (string.equals("http://projectliberty.org/profiles/brws-art")) {
                    fSSSOAndFedHandler = new FSSSOBrowserArtifactProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string2);
                } else if (string.equals("http://projectliberty.org/profiles/brws-post")) {
                    fSSSOAndFedHandler = new FSSSOBrowserPostProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string2);
                } else if (string.equals("http://projectliberty.org/profiles/wml-post")) {
                    fSSSOAndFedHandler = new FSSSOWMLPostProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string2);
                } else if (string.equals("http://projectliberty.org/profiles/lecp")) {
                    fSSSOAndFedHandler = new FSSSOLECPProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string2);
                } else {
                    FSUtils.debug.error("FSServiceManager.getSSOAndFedHandler: Unknown Protocol profile request");
                    fSSSOAndFedHandler = new FSSSOBrowserArtifactProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string2);
                }
            } else {
                FSUtils.debug.message("FSServiceManager.getSSOAndFedHandler: No protocol profile in the Request");
                fSSSOAndFedHandler = new FSSSOBrowserArtifactProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string2);
            }
            return fSSSOAndFedHandler;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSServiceManager.getSSOAndFedHandler: " + fSAllianceManagementException.getMessage());
            return null;
        }
    }

    public FSSSOAndFedHandler getBrowserArtifactSSOAndFedHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Request request) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceManager:: getBrowserArtifactSSOAndFedHandler: Called");
        }
        if (httpServletRequest == null || httpServletResponse == null || request == null) {
            FSUtils.debug.error("FSServiceManager.getSSOAndFedHandler: " + FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        return new FSSSOBrowserArtifactProfileHandler(httpServletRequest, httpServletResponse, request);
    }

    public FSSSOLECPProfileHandler getLECPProfileHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSServiceManager.getLECPProfileHandler:  Called");
        }
        try {
            if (httpServletRequest == null || httpServletResponse == null || fSAuthnRequest == null) {
                FSUtils.debug.error("FSServiceManager.getLECPProfileHandler: " + FSUtils.bundle.getString("nullInputParameter"));
                return null;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(fSAuthnRequest.getProviderId());
            String string = fSAuthnRequest.getRelayState();
            return new FSSSOLECPProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSServiceManager.getLECPProfileHandler: " + fSAllianceManagementException.getMessage());
            return null;
        }
    }

    public FSNameRegistrationHandler getNameRegistrationHandler(String string, String string2) {
        FSNameRegistrationHandler fSNameRegistrationHandler = new FSNameRegistrationHandler();
        if (fSNameRegistrationHandler != null) {
            try {
                FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                if (fSAllianceManager == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::getSPNameIdentifier failed to get Alliance Manager instance");
                    }
                    return null;
                }
                FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(string, string2);
                if (fSProviderDescriptor == null) {
                    fSProviderDescriptor = fSAllianceManager.getProvider(string);
                }
                if (fSProviderDescriptor != null) {
                    fSNameRegistrationHandler.setRemoteDescriptor(fSProviderDescriptor);
                    return fSNameRegistrationHandler;
                }
                return null;
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::Failed to get remote descriptor");
                }
                return null;
            }
        }
        return fSNameRegistrationHandler;
    }

    public FSNameRegistrationHandler getNameRegistrationHandler(FSNameRegistrationRequest fSNameRegistrationRequest, FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        try {
            FSNameRegistrationHandler fSNameRegistrationHandler;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSServicemanager:: getNameRegistrationHandler");
            }
            if ((fSNameRegistrationHandler = new FSNameRegistrationHandler()) != null) {
                fSNameRegistrationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                String string = "SP";
                if (fSHostedProviderDescriptor.getProviderRole().equalsIgnoreCase("SP")) {
                    string = "IDP";
                }
                try {
                    FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                    String string2 = fSNameRegistrationRequest.getProviderId();
                    FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(string2, string);
                    if (fSProviderDescriptor == null) {
                        fSProviderDescriptor = fSAllianceManager.getProvider(string2);
                    }
                    if (fSProviderDescriptor != null) {
                        fSNameRegistrationHandler.setRemoteDescriptor(fSProviderDescriptor);
                        return fSNameRegistrationHandler;
                    }
                    return null;
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    FSUtils.debug.error("FSNameRegistrationHandler::Failed to get remote descriptor");
                    return null;
                }
            }
            return fSNameRegistrationHandler;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceManager::getNameRegistrationHandlerfailed to get registration handler");
            return null;
        }
    }

    public FSFedTerminationHandler getFedTerminationHandler(FSFederationTerminationNotification fSFederationTerminationNotification, FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        try {
            FSAccountFedInfo fSAccountFedInfo;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSServicemanager:: getFedTerminationHandler");
            }
            FSFedTerminationHandler fSFedTerminationHandler = null;
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSAccountManager fSAccountManager = FSAccountManager.getInstance();
            if (fSAllianceManager == null || fSAccountManager == null) {
                FSUtils.debug.error("Error in retrieving alliance, account manager");
                return null;
            }
            String string = fSFederationTerminationNotification.getProviderId();
            NameIdentifier nameIdentifier = fSFederationTerminationNotification.getNameIdentifier();
            String string2 = fSHostedProviderDescriptor.getLocalConfiguration().getAssociatedOrgDN();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Remote provider : " + string + ", Name Qualifier : " + nameIdentifier.getNameQualifier() + ", Name : " + nameIdentifier.getName() + ", OrgDN : " + string2);
            }
            String string3 = nameIdentifier.getNameQualifier();
            String string4 = fSHostedProviderDescriptor.getProviderID();
            if (string3 != null && !string3.equals(string)) {
                string4 = string3;
            }
            FSAccountFedInfoKey fSAccountFedInfoKey = null;
            String string5 = fSHostedProviderDescriptor.getProviderRole();
            fSAccountFedInfoKey = string5.equalsIgnoreCase("SP") ? new FSAccountFedInfoKey(fSHostedProviderDescriptor.getEntityID(), nameIdentifier.getName()) : new FSAccountFedInfoKey(string, nameIdentifier.getName());
            AMIdentity aMIdentity = fSAccountManager.getAMIdentity(fSAccountFedInfoKey, string2);
            if (aMIdentity == null && (aMIdentity = fSAccountManager.getAMIdentity(fSAccountFedInfoKey = string5.equalsIgnoreCase("SP") ? new FSAccountFedInfoKey(string, nameIdentifier.getName()) : new FSAccountFedInfoKey(fSHostedProviderDescriptor.getEntityID(), nameIdentifier.getName()), string2)) == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("UserDn is null");
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user dn is " + aMIdentity);
            }
            if ((fSAccountFedInfo = fSAccountManager.readAccountFedInfo(aMIdentity, string)) == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Account federation with provider " + string + " does not exist");
                }
                return null;
            }
            String string6 = "SP";
            if (string5.equalsIgnoreCase("SP")) {
                string6 = "IDP";
            }
            if ((fSFedTerminationHandler = new FSFedTerminationHandler()) != null) {
                FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(string, string6);
                if (fSProviderDescriptor == null) {
                    fSProviderDescriptor = fSAllianceManager.getProvider(string);
                }
                fSFedTerminationHandler.setRemoteDescriptor(fSProviderDescriptor);
                fSFedTerminationHandler.setUserDN(aMIdentity);
                fSFedTerminationHandler.setAccountInfo(fSAccountFedInfo);
                return fSFedTerminationHandler;
            }
            FSUtils.debug.message("Termination Handler is null");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceManager::getFedTerminationHandler failed to get termination handler");
            return null;
        }
    }

    public FSPreLogoutHandler getPreLogoutHandler() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSServicemanager:: getPreLogoutHandler");
        }
        try {
            FSPreLogoutHandler fSPreLogoutHandler = null;
            fSPreLogoutHandler = new FSPreLogoutHandler();
            if (fSPreLogoutHandler != null) {
                return fSPreLogoutHandler;
            }
            FSUtils.debug.message("PreLogoutHandler is null");
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceManager::getSingleLogoutHandler failed to get logout handler");
        }
        return null;
    }

    public FSFedTerminationHandler getFedTerminationHandler(String string, String string2, AMIdentity aMIdentity) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSServicemanager:: getFedTerminationHandler");
            }
            FSFedTerminationHandler fSFedTerminationHandler = null;
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSAccountManager fSAccountManager = FSAccountManager.getInstance();
            if (fSAllianceManager == null || fSAccountManager == null) {
                FSUtils.debug.message("Error in retrieving alliance, account manager");
                return null;
            }
            FSAccountFedInfo fSAccountFedInfo = fSAccountManager.readAccountFedInfo(aMIdentity, string);
            if (fSAccountFedInfo == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Account federation with provider " + string + " does not exist");
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSServiceManager.getFedTerminationHandler: remoteEntityID = " + string + " remoteProviderRole = " + string2);
            }
            if ((fSFedTerminationHandler = new FSFedTerminationHandler()) != null) {
                FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(string, string2);
                if (fSProviderDescriptor == null) {
                    fSProviderDescriptor = fSAllianceManager.getProvider(string);
                }
                fSFedTerminationHandler.setRemoteDescriptor(fSProviderDescriptor);
                fSFedTerminationHandler.setUserDN(aMIdentity);
                fSFedTerminationHandler.setAccountInfo(fSAccountFedInfo);
                return fSFedTerminationHandler;
            }
            FSUtils.debug.message("Termination Handler is null");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceManager::getFedTerminationHandler failed to get termination handler");
            return null;
        }
    }

    public FSNameRegistrationHandler getNameRegistrationHandler(String string, String string2, AMIdentity aMIdentity) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSServiceManager:: getNameRegistrationHandler");
            }
            FSNameRegistrationHandler fSNameRegistrationHandler = null;
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSAccountManager fSAccountManager = FSAccountManager.getInstance();
            if (fSAllianceManager == null || fSAccountManager == null) {
                FSUtils.debug.message("Error in retrieving alliance, account manager");
                return null;
            }
            FSAccountFedInfo fSAccountFedInfo = fSAccountManager.readAccountFedInfo(aMIdentity, string);
            if (fSAccountFedInfo == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Account federation with provider " + string + " does not exist");
                }
                return null;
            }
            fSNameRegistrationHandler = new FSNameRegistrationHandler();
            if (fSNameRegistrationHandler != null) {
                FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(string, string2);
                if (fSProviderDescriptor == null) {
                    fSProviderDescriptor = fSAllianceManager.getProvider(string);
                }
                fSNameRegistrationHandler.setRemoteDescriptor(fSProviderDescriptor);
                fSNameRegistrationHandler.setUserDN(aMIdentity);
                fSNameRegistrationHandler.setAccountInfo(fSAccountFedInfo);
                return fSNameRegistrationHandler;
            }
            FSUtils.debug.message("Registration Handler is null");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSServiceManager::getNameRegistrationHandler failed to get registration handler");
            return null;
        }
    }

    public static FSServiceManager getInstance() {
        FSUtils.debug.message("FSServiceManager.getInstance: Called ");
        if (instance == null) {
            Class clazz = class$com$sun$identity$federation$services$FSServiceManager == null ? (class$com$sun$identity$federation$services$FSServiceManager = FSServiceManager.class$("com.sun.identity.federation.services.FSServiceManager")) : class$com$sun$identity$federation$services$FSServiceManager;
            synchronized (clazz) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSServiceManager.getInstance:  Creating a new instance of ServiceManager");
                }
                instance = new FSServiceManager();
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

