/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.FSNameIdentifierMappingRequest;
import com.sun.identity.federation.message.FSNameIdentifierMappingResponse;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSAMLRequest;
import com.sun.identity.federation.message.common.EncryptedNameIdentifier;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSAssertionManagerClient;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserArtifactProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOLECPProfileHandler;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.namemapping.FSNameMappingHandler;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AbstractResponse;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSSOAPReceiver
extends JAXMServlet {
    private static MessageFactory msgFactory = null;
    private static FSSOAPService soapService;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        soapService = FSSOAPService.getInstance();
        try {
            msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            FSUtils.debug.error("FSSOAPReceiver:Unable to get message factory", (Throwable)sOAPException);
            throw new ServletException(sOAPException.getMessage());
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSUtils.debug.message("FSSOAPReceiver.doPost: Called");
        FSUtils.checkHTTPRequestLength(httpServletRequest);
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSSOAPReceiver: notLibertyEnabled");
            String[] stringArray = new String[]{FSUtils.bundle.getString("notLibertyEnabled")};
            LogUtil.error(Level.INFO, "LIBERTY_NOT_ENABLED", stringArray);
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        try {
            MimeHeaders mimeHeaders = JAXMServlet.getHeaders((HttpServletRequest)httpServletRequest);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            SOAPMessage sOAPMessage = msgFactory.createMessage(mimeHeaders, (InputStream)servletInputStream);
            this.onMessage(httpServletRequest, httpServletResponse, sOAPMessage);
            return;
        }
        catch (SOAPException sOAPException) {
            throw new ServletException((Throwable)sOAPException);
        }
    }

    public void onMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SOAPMessage sOAPMessage) {
        block84: {
            FSUtils.debug.message("FSSOAPReceiver.onMessage: Called");
            try {
                Element element = soapService.parseSOAPMessage(sOAPMessage);
                if (element == null) {
                    FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing saml:Request. Invalid SOAPMessage");
                    httpServletResponse.setStatus(500);
                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                    return;
                }
                String string = element.getTagName().trim();
                String string2 = element.getNamespaceURI().trim();
                String string3 = element.getLocalName().trim();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver.onMessage: tagName: " + string + " namespaceUri: " + string2 + " localName: " + string3);
                }
                if (string3.equalsIgnoreCase("Request") && string2.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:protocol")) {
                    SOAPMessage sOAPMessage2 = null;
                    try {
                        FSSAMLRequest fSSAMLRequest = new FSSAMLRequest(element);
                        FSResponse fSResponse = this.handleSAMLRequest(httpServletRequest, httpServletResponse, fSSAMLRequest, element, sOAPMessage);
                        if (fSResponse != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver.onMessage: SAML Response created: " + fSResponse.toXMLString());
                            }
                        } else {
                            FSUtils.debug.error("FSSOAPReceiver.onMessage: SAML Response is null");
                            httpServletResponse.setStatus(500);
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                            return;
                        }
                        sOAPMessage2 = soapService.bindSAMLResponse(fSResponse);
                        if (FSServiceUtils.isSigningOn()) {
                            List list = fSResponse.getAssertion();
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                FSAssertion fSAssertion = (FSAssertion)iterator.next();
                                String string4 = fSAssertion.getID();
                                Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage2);
                                FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                                if (fSAllianceManager == null) {
                                    FSUtils.debug.error("FSSOAPReceiver.onMessage: could not create alliance instance");
                                    httpServletResponse.setStatus(500);
                                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                                    return;
                                }
                                String string5 = fSAllianceManager.getProvider(FSServiceUtils.getHostedProviderID(httpServletRequest)).getSigningKeyAlias();
                                if (string5 == null) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("SOAPReceiver.onMessage: couldn't obtain this site's cert alias.");
                                    }
                                    throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
                                }
                                XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
                                int n = fSAssertion.getMinorVersion();
                                if (n == 0) {
                                    xMLSignatureManager.signXML(document, string5, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), "id", string4, false);
                                } else if (n == 2 || n == 2) {
                                    xMLSignatureManager.signXML(document, string5, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), "AssertionID", fSAssertion.getAssertionID(), false);
                                } else {
                                    FSUtils.debug.error("invalid minor version.");
                                }
                                sOAPMessage2 = FSServiceUtils.convertDOMToSOAP(document);
                            }
                        }
                        if (sOAPMessage2 == null) {
                            FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing saml:Request");
                            httpServletResponse.setStatus(500);
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                            return;
                        }
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing saml:Request:", (Throwable)sAMLException);
                        httpServletResponse.setStatus(500);
                        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                        return;
                    }
                    this.returnSOAPMessage(sOAPMessage2, httpServletResponse);
                    return;
                }
                if (string3.equalsIgnoreCase("AuthnRequest") && (string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12") || string2.equalsIgnoreCase("urn:liberty:iff:2003-08"))) {
                    SOAPMessage sOAPMessage3 = null;
                    try {
                        FSAuthnRequest fSAuthnRequest = new FSAuthnRequest(element);
                        String string6 = FSServiceUtils.getHostedProviderID(httpServletRequest);
                        FSSessionManager fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string6));
                        fSSessionManager.setAuthnRequest(fSAuthnRequest.getRequestID(), fSAuthnRequest);
                        this.handleLECPRequest(httpServletRequest, httpServletResponse, fSAuthnRequest);
                        sOAPMessage3 = null;
                    }
                    catch (FSException fSException) {
                        FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing lecp AuthnRequest:" + fSException.getMessage());
                        httpServletResponse.setStatus(500);
                        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                        return;
                    }
                    this.returnSOAPMessage(sOAPMessage3, httpServletResponse);
                    return;
                }
                if (string3.equalsIgnoreCase("RegisterNameIdentifierRequest") && (string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12") || string2.equalsIgnoreCase("urn:liberty:iff:2003-08"))) {
                    SOAPMessage sOAPMessage4 = null;
                    boolean bl = false;
                    FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
                    try {
                        Object object;
                        FSAllianceManager fSAllianceManager;
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSOAPReceiver.onMessage: Handling NameRegistrationRequest");
                        }
                        if ((fSAllianceManager = FSServiceUtils.getAllianceInstance()) == null) {
                            FSUtils.debug.message("Unable to get alliance manager");
                            bl = true;
                        } else {
                            object = FSServiceUtils.getMetaAlias(httpServletRequest);
                            if (object == null || ((String)object).length() < 1) {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("Unable to retrieve aliasHosted Provider. Cannot process request");
                                }
                                bl = true;
                            }
                            try {
                                fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias((String)object);
                                if (fSHostedProviderDescriptor == null) {
                                    throw new FSAllianceManagementException(null);
                                }
                            }
                            catch (FSAllianceManagementException fSAllianceManagementException) {
                                FSUtils.debug.error("Unable to find Hosted Provider. Cannot process request");
                                bl = true;
                            }
                        }
                        if (bl || fSHostedProviderDescriptor == null) {
                            this.returnSOAPMessage(sOAPMessage4, httpServletResponse);
                            return;
                        }
                        object = this.handleRegistrationRequest(element, sOAPMessage, fSHostedProviderDescriptor);
                        if (object == null) {
                            FSUtils.debug.error("Error in creating NameRegistration Response");
                            httpServletResponse.setStatus(500);
                            sOAPMessage4 = soapService.FormSOAPError("Server", "cannotProcessRequest", null);
                        } else {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver.onMessage: Completed creating response");
                            }
                            sOAPMessage4 = soapService.bindRegistrationResponse((FSNameRegistrationResponse)object);
                            FSUtils.debug.message("Completed bindRegistrationResponse");
                            if (sOAPMessage4 == null) {
                                FSUtils.debug.error("Error in processing NameRegistration Response");
                                httpServletResponse.setStatus(500);
                                sOAPMessage4 = soapService.FormSOAPError("Server", "cannotProcessRequest", null);
                            } else if (FSServiceUtils.isSigningOn()) {
                                try {
                                    int n = ((FSNameRegistrationResponse)object).getMinorVersion();
                                    if (n == 0) {
                                        sOAPMessage4 = this.signRegistrationResponse(sOAPMessage4, "id", ((FSNameRegistrationResponse)object).getID(), fSHostedProviderDescriptor);
                                    } else if (n == 2) {
                                        sOAPMessage4 = this.signRegistrationResponse(sOAPMessage4, "ResponseID", ((AbstractResponse)object).getResponseID(), fSHostedProviderDescriptor);
                                    } else if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("invalid minor version.");
                                    }
                                }
                                catch (SAMLException sAMLException) {
                                    FSUtils.debug.error("FSNameRegistrationHandler::signRegistrationResponse failed", (Throwable)sAMLException);
                                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                                    return;
                                }
                                catch (FSMsgException fSMsgException) {
                                    FSUtils.debug.error("FSNameRegistrationHandler::signRegistrationResponse failed", (Throwable)((Object)fSMsgException));
                                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                                    return;
                                }
                            }
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            object = null;
                            String string7 = null;
                            object = new ByteArrayOutputStream();
                            sOAPMessage4.writeTo((OutputStream)object);
                            string7 = ((ByteArrayOutputStream)object).toString("UTF-8");
                            FSUtils.debug.message("return SOAP message:" + string7);
                        }
                        this.returnSOAPMessage(sOAPMessage4, httpServletResponse);
                        return;
                    }
                    catch (Exception exception) {
                        FSUtils.debug.error("Error in processing Name Registration request" + exception.getMessage());
                        httpServletResponse.setStatus(500);
                        sOAPMessage4 = soapService.FormSOAPError("Server", "cannotProcessRequest", null);
                        this.returnSOAPMessage(sOAPMessage4, httpServletResponse);
                        break block84;
                    }
                }
                if (string3.equalsIgnoreCase("NameIdentifierMappingRequest") && (string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12") || string2.equalsIgnoreCase("urn:liberty:iff:2003-08"))) {
                    String string8;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSOAPReceiver:handling Name Identifier Mapping Request");
                    }
                    if (FSServiceUtils.isSigningOn()) {
                        if (this.verifyNameMappingSignature(element, sOAPMessage)) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver: Success in verifying Name Identifier Mapping Request");
                            }
                        } else {
                            FSUtils.debug.error("Failed verifying Name Identifier Mapping Request");
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                            return;
                        }
                    }
                    FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                    String string9 = FSServiceUtils.getMetaAlias(httpServletRequest);
                    FSHostedProviderDescriptor fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias(string9);
                    String string10 = fSHostedProviderDescriptor.getProviderID();
                    FSNameIdentifierMappingRequest fSNameIdentifierMappingRequest = new FSNameIdentifierMappingRequest(element);
                    String string11 = fSNameIdentifierMappingRequest.getTargetNamespace();
                    String string12 = fSNameIdentifierMappingRequest.getRequestID();
                    Status status = new Status(new StatusCode("samlp:Success"));
                    FSNameMappingHandler fSNameMappingHandler = new FSNameMappingHandler(string10);
                    NameIdentifier nameIdentifier = fSNameIdentifierMappingRequest.getNameIdentifier();
                    NameIdentifier nameIdentifier2 = fSNameMappingHandler.getNameIdentifier(nameIdentifier, string11, false);
                    if (fSHostedProviderDescriptor.getNameIdentifierEncryption()) {
                        nameIdentifier2 = EncryptedNameIdentifier.getEncryptedNameIdentifier(nameIdentifier2, string11);
                    }
                    FSNameIdentifierMappingResponse fSNameIdentifierMappingResponse = new FSNameIdentifierMappingResponse(string10, string12, status, nameIdentifier2);
                    if (FSServiceUtils.isSigningOn()) {
                        string8 = fSHostedProviderDescriptor.getSigningKeyAlias();
                        fSNameIdentifierMappingResponse.signXML(string8);
                    }
                    string8 = soapService.bindNameMappingResponse(fSNameIdentifierMappingResponse);
                    this.returnSOAPMessage((SOAPMessage)string8, httpServletResponse);
                    return;
                }
                if (string3.equalsIgnoreCase("FederationTerminationNotification") && (string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12") || string2.equalsIgnoreCase("urn:liberty:iff:2003-08"))) {
                    try {
                        boolean bl;
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("calling FSSOAPReceiver::handleTerminationRequest");
                        }
                        if (bl = this.handleTerminationRequest(element, sOAPMessage, httpServletRequest)) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("Completed sucessful processing terminationRequest");
                            }
                            this.returnTerminationStatus(httpServletResponse);
                            return;
                        }
                        FSUtils.debug.message("Failed processing terminationRequest");
                        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                        return;
                    }
                    catch (Exception exception) {
                        FSUtils.debug.error("Error in processing Federation Termination Request", (Throwable)exception);
                        String[] stringArray = new String[]{"termination-request-processing-failed"};
                        LogUtil.error(Level.INFO, "TERMINATION_REQUEST_PROCESSING_FAILED", stringArray);
                        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                        return;
                    }
                }
                if (!string3.equalsIgnoreCase("LogoutRequest") || !string2.equalsIgnoreCase("http://projectliberty.org/schemas/core/2002/12") && !string2.equalsIgnoreCase("urn:liberty:iff:2003-08")) break block84;
                try {
                    Object object;
                    Object object2;
                    FSAllianceManager fSAllianceManager;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("calling FSSOAPReceiver::handleLogoutRequest");
                    }
                    FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
                    String string13 = null;
                    String string14 = null;
                    try {
                        fSAllianceManager = FSServiceUtils.getAllianceInstance();
                        string13 = FSServiceUtils.getMetaAlias(httpServletRequest);
                        fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias(string13);
                        string14 = fSHostedProviderDescriptor.getEntityID();
                    }
                    catch (Exception exception) {
                        FSUtils.debug.error("FSSOAPReceiver, provider", (Throwable)exception);
                    }
                    fSAllianceManager = this.handleLogoutRequest(element, sOAPMessage, httpServletRequest, fSHostedProviderDescriptor);
                    FSLogoutNotification fSLogoutNotification = new FSLogoutNotification(element);
                    String string15 = SAMLUtilsCommon.generateID();
                    String string16 = fSLogoutNotification.getRequestID();
                    String string17 = FSServiceUtils.getHostedProviderID(httpServletRequest);
                    String string18 = fSLogoutNotification.getRelayState();
                    FSLogoutResponse fSLogoutResponse = null;
                    if (fSAllianceManager == null) {
                        object2 = new StatusCode("samlp:Failure");
                        object = new Status((StatusCode)object2);
                        fSLogoutResponse = new FSLogoutResponse(string15, string16, (Status)object, string14, string18);
                    } else {
                        object2 = fSAllianceManager.getSOAPPart();
                        object = object2.getEnvelope();
                        SOAPBody sOAPBody = object.getBody();
                        if (sOAPBody.hasFault()) {
                            StatusCode statusCode = new StatusCode("lib:Unsupported");
                            StatusCode statusCode2 = new StatusCode("samlp:Failure", statusCode);
                            Status status = new Status(statusCode2);
                            fSLogoutResponse = new FSLogoutResponse(string15, string16, status, string14, string18);
                        } else {
                            StatusCode statusCode = new StatusCode("samlp:Success");
                            Status status = new Status(statusCode);
                            fSLogoutResponse = new FSLogoutResponse(string15, string16, status, string14, string18);
                        }
                    }
                    fSLogoutResponse.setID("logout-sig-ID");
                    fSLogoutResponse.setMinorVersion(fSLogoutNotification.getMinorVersion());
                    fSAllianceManager = soapService.bindFSLogoutResponse(fSLogoutResponse);
                    if (FSServiceUtils.isSigningOn()) {
                        try {
                            int n = fSLogoutResponse.getMinorVersion();
                            if (n == 0) {
                                fSAllianceManager = this.signLogoutResponse((SOAPMessage)fSAllianceManager, "id", fSLogoutResponse.getID(), fSHostedProviderDescriptor);
                            } else if (n == 2) {
                                fSAllianceManager = this.signLogoutResponse((SOAPMessage)fSAllianceManager, "ResponseID", fSLogoutResponse.getResponseID(), fSHostedProviderDescriptor);
                            } else {
                                FSUtils.debug.error("invalid minor version.");
                            }
                        }
                        catch (SAMLException sAMLException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("LogoutResponse failed", (Throwable)sAMLException);
                            }
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                            return;
                        }
                        catch (FSMsgException fSMsgException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("LogoutResponse failed", (Throwable)((Object)fSMsgException));
                            }
                            this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.returnSOAPMessage((SOAPMessage)fSAllianceManager, httpServletResponse);
                    return;
                }
                catch (Exception exception) {
                    FSUtils.debug.error("Error in processing logout Request", (Throwable)exception);
                    String[] stringArray = new String[]{FSUtils.bundle.getString("logout-request-processing-failed")};
                    LogUtil.error(Level.INFO, "LOGOUT_REQUEST_PROCESSING_FAILED", stringArray);
                    this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                    return;
                }
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSSOAPReceiver.onMessage: Error in processing Request: Exception occured: ", (Throwable)exception);
                httpServletResponse.setStatus(500);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(byteArrayOutputStream));
                FSUtils.debug.error(byteArrayOutputStream.toString());
                this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
                return;
            }
        }
        this.returnSOAPMessage(soapService.FormSOAPError("Server", "cannotProcessRequest", null), httpServletResponse);
    }

    private FSNameRegistrationResponse handleRegistrationRequest(Element element, SOAPMessage sOAPMessage, FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return null;
            }
            FSNameRegistrationRequest fSNameRegistrationRequest = new FSNameRegistrationRequest(element);
            FSProviderDescriptor fSProviderDescriptor = null;
            String string = fSNameRegistrationRequest.getProviderId();
            String string2 = null;
            try {
                string2 = fSHostedProviderDescriptor.getProviderRole().equalsIgnoreCase("SP") ? "IDP" : "SP";
                fSProviderDescriptor = fSAllianceManager.getProvider(string, string2);
                if (fSProviderDescriptor == null) {
                    fSAllianceManager.getProvider(string);
                }
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("Unable to find Hosted Provider. Cannot process request");
                return null;
            }
            String string3 = fSProviderDescriptor.getSigningKeyAlias();
            if (!FSServiceUtils.isSigningOn() || this.verifyRegistrationSignature(element, sOAPMessage, string3)) {
                FSUtils.debug.message("Registration Signature successfully passed");
                Set set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders();
                if (set != null && set.contains(string)) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSNameRegistrationHandler fSNameRegistrationHandler = fSServiceManager.getNameRegistrationHandler(fSNameRegistrationRequest, fSHostedProviderDescriptor);
                        fSNameRegistrationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                        fSNameRegistrationHandler.setRemoteDescriptor(fSProviderDescriptor);
                        FSNameRegistrationResponse fSNameRegistrationResponse = fSNameRegistrationHandler.processRegistrationRequest(fSNameRegistrationRequest);
                        return fSNameRegistrationResponse;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager instance is null. Cannot process registration request");
                    }
                    return null;
                }
                FSUtils.debug.error("Remote provider not in trusted list");
                return null;
            }
            FSUtils.debug.message("Registration Signature failed verification");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameRegistrationHandler.doPost.doGet: Exception occured ", (Throwable)exception);
            return null;
        }
    }

    private boolean handleTerminationRequest(Element element, SOAPMessage sOAPMessage, HttpServletRequest httpServletRequest) {
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor;
            String string = FSServiceUtils.getMetaAlias(httpServletRequest);
            if (string == null || string.length() < 1) {
                FSUtils.debug.error("Unable to retrieve alias, Hosted Provider.Cannot process  the termination request");
                return false;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.error("Unable to get alliance manager");
                return false;
            }
            FSFederationTerminationNotification fSFederationTerminationNotification = new FSFederationTerminationNotification(element);
            FSProviderDescriptor fSProviderDescriptor = null;
            String string2 = fSFederationTerminationNotification.getProviderId();
            String string3 = null;
            try {
                fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias(string);
                string3 = fSHostedProviderDescriptor.getProviderRole().equalsIgnoreCase("SP") ? "IDP" : "SP";
                fSProviderDescriptor = fSAllianceManager.getProvider(string2, string3);
                if (fSProviderDescriptor == null) {
                    fSProviderDescriptor = fSAllianceManager.getProvider(string2);
                }
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("Unable to find Hosted Provider. Cannot process request");
                return false;
            }
            String string4 = fSProviderDescriptor.getSigningKeyAlias();
            if (!FSServiceUtils.isSigningOn() || this.verifyTerminationSignature(element, sOAPMessage, string4)) {
                FSUtils.debug.message("Termination Signature successfully verified");
                Set set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders();
                if (set != null && set.contains(string2)) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSFedTerminationHandler fSFedTerminationHandler = fSServiceManager.getFedTerminationHandler(fSFederationTerminationNotification, fSHostedProviderDescriptor);
                        if (fSFedTerminationHandler != null) {
                            fSFedTerminationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                            fSFedTerminationHandler.setRemoteDescriptor(fSProviderDescriptor);
                            boolean bl = fSFedTerminationHandler.processTerminationRequest(fSFederationTerminationNotification);
                            return bl;
                        }
                        FSUtils.debug.error("Unable to get Termination Handler");
                        return false;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager instance is null. Cannot process termination request");
                    }
                    return false;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return false;
            }
            FSUtils.debug.message("Termination Signature failed verification");
            return false;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPService::handleTerminationRequest failed ", (Throwable)exception);
            return false;
        }
    }

    private SOAPMessage handleLogoutRequest(Element element, SOAPMessage sOAPMessage, HttpServletRequest httpServletRequest, FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSLogoutNotification fSLogoutNotification = new FSLogoutNotification(element);
            FSProviderDescriptor fSProviderDescriptor = null;
            String string = fSLogoutNotification.getProviderId();
            String string2 = null;
            string2 = fSHostedProviderDescriptor.getProviderRole().equalsIgnoreCase("SP") ? "IDP" : "SP";
            fSProviderDescriptor = fSAllianceManager.getProvider(string, string2);
            if (fSProviderDescriptor == null) {
                fSProviderDescriptor = fSAllianceManager.getProvider(string);
            }
            String string3 = fSProviderDescriptor.getSigningKeyAlias();
            if (!FSServiceUtils.isSigningOn() || this.verifyLogoutSignature(element, sOAPMessage, string3)) {
                Set set;
                FSUtils.debug.message("Logout Signature successfully verified");
                String string4 = FSServiceUtils.getMetaAlias(httpServletRequest);
                if (string4 == null || string4.length() < 1) {
                    FSUtils.debug.message("Unable to retrieve alias, Hosted Provider Cannot process logout request");
                    return null;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest: Completed forming request FSLogoutNotification");
                }
                if ((set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders()) != null && set.contains(string)) {
                    Object object;
                    StringBuffer stringBuffer;
                    Object object2;
                    Object object3;
                    Object object4;
                    AMIdentity aMIdentity = FSLogoutUtil.getAMIdentity(fSLogoutNotification, fSHostedProviderDescriptor.getProviderID());
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest found user Id = " + aMIdentity);
                    }
                    if (aMIdentity == null) {
                        return null;
                    }
                    String string5 = IdUtils.getUniversalId(aMIdentity);
                    if (!this.isUserExists(string5, fSHostedProviderDescriptor.getProviderID())) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest: User does not exist locally. Finding remotely");
                        }
                        if ((object4 = WebtopNaming.getPlatformServerList()) == null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestplatformList is null");
                            }
                            return null;
                        }
                        object3 = ((AbstractList)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            stringBuffer = new StringBuffer((String)object2);
                            stringBuffer.append(SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor"));
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestremoteServerURL = " + (String)object2 + " and self serverUrl =" + FSServiceUtils.getBaseURL());
                            }
                            if (FSServiceUtils.getBaseURL().equalsIgnoreCase(((String)object2).toString()) || !((FSAssertionManagerClient)(object = new FSAssertionManagerClient(fSHostedProviderDescriptor.getEntityID(), this.getFullServiceURL((String)object2)))).isUserExists(string5, fSHostedProviderDescriptor.getProviderID())) continue;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestuser found here =" + (String)object2);
                            }
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer2.append(((String)object2).toString());
                            stringBuffer2.append(SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor"));
                            stringBuffer2.append("/SOAPReceiver");
                            stringBuffer2.append("/");
                            stringBuffer2.append("metaAlias");
                            stringBuffer2.append("/");
                            stringBuffer2.append(string4);
                            FSSOAPService fSSOAPService = FSSOAPService.getInstance();
                            SOAPMessage sOAPMessage2 = null;
                            if (fSSOAPService != null) {
                                try {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("Forwarding logout request to " + stringBuffer2.toString());
                                    }
                                    sOAPMessage2 = fSSOAPService.sendLogoutMessage(sOAPMessage, stringBuffer2.toString());
                                    return sOAPMessage2;
                                }
                                catch (SOAPException sOAPException) {
                                    FSUtils.debug.error("FSSOAPException in doSOAPProfile Cannot send request", (Throwable)sOAPException);
                                    return sOAPMessage2;
                                }
                            }
                            return null;
                        }
                    }
                    if ((object4 = FSServiceManager.getInstance()) != null) {
                        object3 = ((FSServiceManager)object4).getPreLogoutHandler();
                        if (object3 != null) {
                            ((FSPreLogoutHandler)object3).setHostedDescriptor(fSHostedProviderDescriptor);
                            ((FSPreLogoutHandler)object3).setRemoteDescriptor(fSProviderDescriptor);
                            ((FSPreLogoutHandler)object3).setLogoutRequest(fSLogoutNotification);
                            object2 = ((FSPreLogoutHandler)object3).processSingleLogoutRequest(fSLogoutNotification);
                            if (((FSLogoutStatus)object2).getStatus().equalsIgnoreCase("samlp:Success")) {
                                stringBuffer = MessageFactory.newInstance();
                                object = stringBuffer.createMessage();
                                return object;
                            }
                            if (((FSLogoutStatus)object2).getStatus().equalsIgnoreCase("lib:Unsupported")) {
                                return soapService.getLogoutSOAPFault();
                            }
                            return null;
                        }
                        FSUtils.debug.error("Unable to get PreLogoutHandler");
                        FSUtils.debug.error("Cannot process request");
                        return null;
                    }
                    FSUtils.debug.message("FSServiceManager instance isnull. Cannot process termination request");
                    return null;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return null;
            }
            FSUtils.debug.error("Logout Signature failed verification");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPService::handleLogoutRequest failed", (Throwable)exception);
            return null;
        }
    }

    private FSResponse handleSAMLRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSSAMLRequest fSSAMLRequest, Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("FSSOAPReceiver.handleSAMLRequest: Called");
        try {
            Object object;
            String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
            if (string == null) {
                object = FSServiceUtils.getMetaAlias(httpServletRequest);
                string = FSServiceUtils.getAllianceInstance().getHostedProviderByMetaAlias((String)object).getProviderID();
            }
            object = FSServiceManager.getInstance();
            FSSSOBrowserArtifactProfileHandler fSSSOBrowserArtifactProfileHandler = (FSSSOBrowserArtifactProfileHandler)((FSServiceManager)object).getBrowserArtifactSSOAndFedHandler(httpServletRequest, httpServletResponse, fSSAMLRequest);
            fSSSOBrowserArtifactProfileHandler.setSOAPMessage(sOAPMessage);
            fSSSOBrowserArtifactProfileHandler.setSAMLRequestElement(element);
            fSSSOBrowserArtifactProfileHandler.setHostProviderId(string);
            return fSSSOBrowserArtifactProfileHandler.processSAMLRequest(fSSAMLRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Exception occured " + exception.getMessage());
            return null;
        }
    }

    private void handleLECPRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest) {
        FSUtils.debug.message("FSSOAPReceiver.handleLECPRequest: Called");
        try {
            String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
            FSSSOLECPProfileHandler fSSSOLECPProfileHandler = fSServiceManager.getLECPProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest);
            fSSSOLECPProfileHandler.setHostProviderId(string);
            fSSSOLECPProfileHandler.processLECPAuthnRequest(fSAuthnRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Exception occured " + exception.getMessage());
            return;
        }
    }

    protected boolean verifyRegistrationSignature(Element element, SOAPMessage sOAPMessage, String string) {
        FSUtils.debug.message("Name Registration.verifyRegistrationSignature: Called");
        try {
            FSNameRegistrationRequest fSNameRegistrationRequest = new FSNameRegistrationRequest(element);
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Registration.verifyRegistrationSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("NameRegistration.verifyRegistrationSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("Request : " + fSNameRegistrationRequest.toXMLString(true, true));
            }
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("NameRegistration.verifyRegistrationSignature: Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean verifyNameMappingSignature(Element element, SOAPMessage sOAPMessage) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSOAPReceiver.verifyNameMappingSignature: Called");
        }
        try {
            FSNameIdentifierMappingRequest fSNameIdentifierMappingRequest = new FSNameIdentifierMappingRequest(element);
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Unable to get alliance manager");
                }
                return false;
            }
            String string = fSAllianceManager.getProvider(fSNameIdentifierMappingRequest.getProviderID()).getSigningKeyAlias();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver.verifyNameMappingSignature: couldn't obtain the cert alias for signature verification.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSOAPReceiver.verifyNameMappingSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("FSSOAPReceiver.verifyNameMappingSignature: xmlString to be verified: " + XMLUtils.print((Node)element));
            }
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPReceiver.verifyNameMappingSignature: Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean verifyTerminationSignature(Element element, SOAPMessage sOAPMessage, String string) {
        FSUtils.debug.message("Federation Termination.verifyTerminationSignature: Called");
        try {
            FSFederationTerminationNotification fSFederationTerminationNotification = new FSFederationTerminationNotification(element);
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Federation Termination.verifyTerminationSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Federation Termination.verifyTerminationSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("Federation Termination.verifyTerminationSignature: xmlString to be verified: " + XMLUtils.print((Node)element));
            }
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("Federation Termination.verifyTerminationSignature: Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean verifyLogoutSignature(Element element, SOAPMessage sOAPMessage, String string) {
        FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature: Called");
        try {
            FSLogoutNotification fSLogoutNotification = new FSLogoutNotification(element);
            if (string == null) {
                FSUtils.debug.error("FSSOAPReceiver.verifyLogoutSignature: couldn't obtain this site's cert alias.");
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature : Provider's certAlias is found : " + string);
            FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature: xmlString to be verified: " + XMLUtils.print((Node)element));
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOPAReceiver::verifyLogoutSignature  Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected SOAPMessage signRegistrationResponse(SOAPMessage sOAPMessage, String string, String string2, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws SAMLException, FSMsgException {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::signRegistrationResponse");
        String string3 = fSHostedProviderDescriptor.getSigningKeyAlias();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::signRegistrationResponse: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("FSNameRegistrationHandler::RegistrationResponse:Provider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), string, string2, false, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    protected SOAPMessage signLogoutResponse(SOAPMessage sOAPMessage, String string, String string2, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws SAMLException, FSMsgException {
        FSUtils.debug.message("SOAPReceiver::Entered signLogoutResponse::");
        String string3 = fSHostedProviderDescriptor.getSigningKeyAlias();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("signLogoutResponse::signRegistrationResponse: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("signLogoutResponse::Provider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), string, string2, false, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    private void returnSOAPMessage(SOAPMessage sOAPMessage, HttpServletResponse httpServletResponse) {
        try {
            if (sOAPMessage != null) {
                JAXMServlet.putHeaders((MimeHeaders)sOAPMessage.getMimeHeaders(), (HttpServletResponse)httpServletResponse);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
                return;
            }
            httpServletResponse.flushBuffer();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPReceiver.returnSOAPMessage: Exception::" + exception.getMessage());
            return;
        }
    }

    private void returnTerminationStatus(HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.setStatus(204);
            httpServletResponse.flushBuffer();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPReceiver.returnFedTerminationStatus: Exception::" + exception.getMessage());
            return;
        }
    }

    private boolean isUserExists(String string, String string2) {
        try {
            FSSessionManager fSSessionManager;
            FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(string2));
            synchronized (fSSessionManager2) {
                List list;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("About to call getSessionList");
                }
                if ((list = fSSessionManager.getSessionList(string)) == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("AMC:isUserExists:List is empty");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AMC:isUserExists: List is not emptyUser found: " + string);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getFullServiceURL(String string) {
        String string2;
        block3: {
            string2 = null;
            String string3 = "fsassertionmanager";
            try {
                URL uRL = new URL(string);
                URL uRL2 = WebtopNaming.getServiceURL((String)string3, (String)uRL.getProtocol(), (String)uRL.getHost(), (String)Integer.toString(uRL.getPort()));
                string2 = uRL2.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AssertionManager.getFullServiceURL:full remote URL is: " + string2);
                }
            }
            catch (Exception exception) {
                if (!FSUtils.debug.warningEnabled()) break block3;
                FSUtils.debug.warning("AssertionManager.getFullServiceURL:Exception:", (Throwable)exception);
            }
        }
        return string2;
    }
}

