/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnRequestEnvelope;
import com.sun.identity.federation.message.FSIDPList;
import com.sun.identity.federation.message.common.IDPEntries;
import com.sun.identity.federation.message.common.IDPEntry;
import com.sun.identity.federation.message.common.RequestAuthnContext;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.liberty.LibertyManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import sun.misc.BASE64Encoder;

public class FSLoginHelper {
    private static String headerKey = "headerKey";
    private static String responseDataKey = "responseData";
    private static String URLKey = "urlKey";
    private String interSiteURL = null;
    private static String authnReqIDKey = "RequestID";
    private static String providerIDKey = "_liberty_idp";
    private static boolean messageEnabled = false;
    private String amserverURI = null;
    private String authContextString = null;
    private String authnContextProfileClassRef = null;
    private String authnContextStatementRef = null;
    private String respondWithString = null;
    private boolean forceAuthn;
    private boolean isPassive;
    private String nameIDPolicy = null;
    private String hostProviderID = null;
    private String hostEntityID = null;
    private FSLocalConfigurationDescriptor cnfgDesc = null;
    private Set cotSet = null;
    private String protocolProfile = null;
    private static FSAllianceManager allianceManager = null;
    private static String fedCookieName = SystemProperties.get((String)"com.sun.identity.federation.fedCookieName");
    private String errorPage = null;
    private HttpServletRequest request = null;
    private boolean isPassiveQuery = false;
    private String hostProviderRole = null;
    private FSHostedProviderDescriptor hostDescriptor = null;
    private String actionOnNoFedCookie = null;
    private String anonymousOnetime = null;

    public FSLoginHelper(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
        this.amserverURI = FSServiceUtils.getBaseURL(httpServletRequest);
        this.interSiteURL = this.amserverURI + "/" + "IntersiteTransferService";
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHepler::Constructor called. Setting BaseURL to " + this.amserverURI + httpServletRequest.getParameter("metaAlias"));
        }
        String string = httpServletRequest.getParameter("isPassive");
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHepler::isPassive query param" + string);
        }
        if (string != null && string.equals("true")) {
            this.isPassiveQuery = true;
        }
        this.actionOnNoFedCookie = httpServletRequest.getParameter("actionOnNoFedCookie");
        if (this.actionOnNoFedCookie == null || this.actionOnNoFedCookie.length() == 0) {
            this.actionOnNoFedCookie = "passive";
        }
        this.anonymousOnetime = httpServletRequest.getParameter("anonymousOnetime");
    }

    private void setAllianceInfo(String string, String string2) throws FSLoginHelperException {
        block12: {
            try {
                if (allianceManager == null) {
                    FSUtils.debug.error("FSLoginHelper::setAllianceInfo could not get alliane manager handle Cannot proceed so throwing error page");
                    throw new FSLoginHelperException("FSLoginHelper:: could not get alliancemanager handle.");
                }
                this.hostDescriptor = allianceManager.getHostedProviderByMetaAlias(string);
                if (this.hostDescriptor != null) {
                    this.cotSet = this.hostDescriptor.getListOfCOTs();
                    this.hostProviderID = this.hostDescriptor.getProviderID();
                    this.hostEntityID = this.hostDescriptor.getEntityID();
                    this.hostProviderRole = this.hostDescriptor.getProviderRole();
                    this.cnfgDesc = this.hostDescriptor.getLocalConfiguration();
                    this.nameIDPolicy = this.hostDescriptor.getNameIDPolicy();
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLoginHelper::setAllianceInfo: nameIDPolicy=" + this.nameIDPolicy);
                    }
                } else {
                    FSUtils.debug.error("FSLoginHelper::setAllianceInfo getHostedProviderByMetaAlias retured null. Cannot proceed so throwing error page");
                    throw new FSLoginHelperException("FSLoginHelper:: could not get host provider Descriptor handle.");
                }
                if (this.cnfgDesc != null) {
                    this.respondWithString = "lib:AuthenticationStatement";
                    this.forceAuthn = this.cnfgDesc.getForceAuthentication();
                    this.isPassive = this.cnfgDesc.getIsPassive();
                    this.protocolProfile = this.hostDescriptor.getSingleSignOnProtocolProfile();
                    this.authContextString = this.cnfgDesc.getDefaultAuthenticationContext();
                    this.errorPage = this.cnfgDesc.getErrorPageURL(this.request);
                    if (string2 != null) {
                        Map map = this.cnfgDesc.getSPAuthContextInfo();
                        Set set = map.entrySet();
                        Iterator iterator = set.iterator();
                        FSSPAuthenticationContextInfo fSSPAuthenticationContextInfo = null;
                        if (messageEnabled) {
                            FSUtils.debug.message("FSLoginHelper()::authLevel not null");
                        }
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            fSSPAuthenticationContextInfo = (FSSPAuthenticationContextInfo)entry.getValue();
                            Integer n = new Integer(string2);
                            int n2 = n;
                            if (fSSPAuthenticationContextInfo.getAuthenticationLevel() != n2) continue;
                            this.authContextString = fSSPAuthenticationContextInfo.getAuthenticationContext();
                            if (!messageEnabled) break;
                            FSUtils.debug.message("FSLoginHelper():: Found auth context " + this.authContextString + "for auth level " + string2);
                            break;
                        }
                    }
                    if (messageEnabled) {
                        FSUtils.debug.message("FSLoginHelper()::respondWithString: " + this.respondWithString);
                        FSUtils.debug.message("FSLoginHelper()::providerID: " + this.hostProviderID);
                        FSUtils.debug.message("FSLoginHelper()::forceAuthn: " + this.forceAuthn);
                        FSUtils.debug.message("FSLoginHelper()::isPassive: " + this.isPassive);
                    }
                    break block12;
                }
                FSUtils.debug.error("FSLoginHelper:setAllianceInfo failedFSLocalConfigurationDescriptor is null");
                throw new FSLoginHelperException("FSLoginHelper:: could not get local config.");
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSLoginHelper::setAllianceInfo Alliance management Failed." + fSAllianceManagementException.getMessage());
                throw new FSLoginHelperException("FSLoginHelper:: FSAllianceManagementException" + fSAllianceManagementException.getMessage());
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSLoginHelper::setAllianceInfo General Exception caugth.", (Throwable)exception);
                throw new FSLoginHelperException("FSLoginHelper:: FSAllianceManagementException" + exception.getMessage());
            }
        }
    }

    public Map createAuthnRequest(Map map, String string, String string2, String string3, String string4, boolean bl) throws FSLoginHelperException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setAllianceInfo(string3, string2);
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest(): called");
        }
        FSProviderDescriptor fSProviderDescriptor = null;
        if (string4 != null) {
            try {
                fSProviderDescriptor = allianceManager.getProvider(string4, "IDP");
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSLoginHelper::createAuthnRequest AllianceManagement caugth " + fSAllianceManagementException.getMessage());
                throw new FSLoginHelperException("FSLoginHelper:: createAuthnRequest AllianceManagement caugth " + fSAllianceManagementException.getMessage());
            }
        }
        FSAuthnRequest fSAuthnRequest = null;
        fSAuthnRequest = string4 != null ? this.getAuthnReq(map, string, true) : this.getAuthnReq(map, string, false);
        if (fSAuthnRequest == null) {
            FSUtils.debug.error("FSLoginHelper.createAuthnRequest()::AuthnRequest is null");
            String string5 = this.errorPage;
            string5 = string5 + "&" + "federror" + "=" + AMURLEncDec.encode((String)"Unable to create AuthnRequest") + "&" + "fedremark" + "=" + AMURLEncDec.encode((String)"Please check your Federation Configuration.");
            return this.createMap(string5, null, hashMap);
        }
        String string6 = fSAuthnRequest.getRequestID();
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest():: RequestID: " + string6);
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityID);
        fSSessionManager.setAuthnRequest(string6, fSAuthnRequest);
        fSSessionManager.setProviderDescriptor(string6, fSProviderDescriptor);
        String string7 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        Set set = this.getIDPs();
        if (string4 == null) {
            bl3 = true;
        }
        if (set.size() > 1) {
            bl2 = false;
        }
        if (this.isLECPProfile(map)) {
            Object object;
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest(): LECP Request Identified");
            hashMap.put("content-type", "application/vnd.liberty-request+xml");
            String string8 = null;
            try {
                String string9;
                FSAllianceManager fSAllianceManager;
                Object object2;
                object = null;
                String string10 = null;
                boolean bl4 = false;
                FSIDPList fSIDPList = null;
                string10 = this.hostDescriptor.getProviderName();
                String string11 = this.hostDescriptor.getAssertionConsumerServiceURL();
                ArrayList<IDPEntry> arrayList = null;
                String string12 = null;
                String string13 = null;
                String string14 = null;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string12 = (String)iterator.next();
                    if (string12 == null) continue;
                    object2 = allianceManager.getProvider(string12, "IDP");
                    string13 = ((FSProviderDescriptor)object2).getProviderName();
                    string14 = ((FSProviderDescriptor)object2).getSSOServiceURL();
                    if (arrayList == null) {
                        arrayList = new ArrayList<IDPEntry>();
                    }
                    arrayList.add(new IDPEntry(string12, string13, string14));
                }
                object2 = new IDPEntries(arrayList);
                fSIDPList = new FSIDPList((IDPEntries)object2, null);
                fSIDPList.setMinorVersion(this.hostDescriptor.getMinorVersion());
                fSAuthnRequest.setMinorVersion(this.hostDescriptor.getMinorVersion());
                if (FSServiceUtils.isSigningOn() && (fSAllianceManager = FSServiceUtils.getAllianceInstance()).getHostedProvider(string9 = LibertyManager.getProviderID(string3)).getAuthnRequestSigned()) {
                    fSAuthnRequest.signXML(fSAllianceManager.getHostedProvider(string9).getSigningKeyAlias());
                }
                object = new FSAuthnRequestEnvelope(fSAuthnRequest, this.hostEntityID, string10, string11, fSIDPList, bl4);
                ((FSAuthnRequestEnvelope)object).setMinorVersion(this.hostDescriptor.getMinorVersion());
                FSUtils.debug.message("FSLoginHelper.createAuthnRequest: AuthnRequestEnvelope: " + ((FSAuthnRequestEnvelope)object).toXMLString());
                string8 = ((FSAuthnRequestEnvelope)object).toXMLString();
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSLoginHelper.createAuthnRequest(): Exception Occured: " + exception.getMessage());
            }
            object = this.createMap(null, string8, hashMap);
            object.put(authnReqIDKey, string6);
            return object;
        }
        String string15 = this.getTLDURL();
        if (bl3 && string15 != null && !bl2) {
            if (messageEnabled) {
                FSUtils.debug.message("FSLoginHelper:: createAuthnRequest In case where isSSO true and tldURL is true and not single idp. So redirecting to thirdlevel domain");
            }
            string7 = string15 + "?" + "RelayState" + "=" + AMURLEncDec.encode((String)(this.interSiteURL + "?" + authnReqIDKey + "=" + AMURLEncDec.encode((String)string6) + "&" + "metaAlias" + "=" + string3));
        } else {
            if (bl3 && !bl2) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSLoginHelper:: createAuthnRequest  In case where isSSO true and not a single idp so have show common login page");
                }
                Map map2 = this.createMap(null, null, hashMap);
                map2.put(authnReqIDKey, string6);
                return map2;
            }
            boolean bl5 = false;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            if (string4 == null) {
                if (set != null && set.size() > 0) {
                    string4 = (String)set.iterator().next();
                } else {
                    FSUtils.debug.error("FSLoginHelper:: no idps found in config. Cannot proceed.");
                    string7 = this.errorPage;
                    string7 = string7 + "&" + "federror" + "=" + AMURLEncDec.encode((String)"No IDPs Found in Configuration.") + "&" + "fedremark" + "=" + AMURLEncDec.encode((String)"Please configure you Federation Services for an IDP.");
                    bl5 = true;
                }
            }
            if (!bl5) {
                String string16 = LibertyManager.getSuccintID(string4, "IDP");
                if (messageEnabled) {
                    FSUtils.debug.message("FSLoginHelper:: createAuthnRequest  Redirecting to intersiteTransfer URL " + this.interSiteURL + " with providerID and SuccintID. " + string4 + "---" + string16);
                }
                String string17 = SAMLUtils.hexStringToBase64(string16);
                if (!bl) {
                    if (this.actionOnNoFedCookie.equals("commonlogin")) {
                        Map map3 = this.createMap(null, null, hashMap);
                        map3.put(authnReqIDKey, string6);
                        return map3;
                    }
                    if (this.actionOnNoFedCookie.equals("active")) {
                        this.changeToPassiveAuthnRequest(string6, false);
                    } else {
                        this.changeToPassiveAuthnRequest(string6, true);
                    }
                }
                string7 = this.interSiteURL + "?" + authnReqIDKey + "=" + AMURLEncDec.encode((String)string6) + "&" + providerIDKey + "=" + AMURLEncDec.encode((String)string17) + "&" + "metaAlias" + "=" + string3;
            }
        }
        if (this.isPassiveQuery) {
            this.changeToPassiveAuthnRequest(string6, true);
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest()::redirectURL : " + string7);
        }
        if (this.isWMLProfile(map)) {
            hashMap.put("content-type", "text/vnd.wap.wml");
        } else {
            hashMap.put("content-type", "text/html");
        }
        Map map4 = this.createMap(string7, null, hashMap);
        map4.put(authnReqIDKey, string6);
        return map4;
    }

    void changeToPassiveAuthnRequest(String string, boolean bl) {
        FSAuthnRequest fSAuthnRequest;
        FSUtils.debug.message("FSPreLogin.changeToPassiveAuthnRequest called");
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityID);
        if (fSSessionManager == null) {
            FSUtils.debug.message("Session Manager null");
        }
        if ((fSAuthnRequest = fSSessionManager.getAuthnRequest(string)) != null && !fSAuthnRequest.getFederate()) {
            fSAuthnRequest.setIsPassive(bl);
            fSAuthnRequest.setForceAuthn(false);
        }
        fSSessionManager.setAuthnRequest(string, fSAuthnRequest);
    }

    private Set getIDPs() {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "IDP".toLowerCase();
            FSProviderDescriptor fSProviderDescriptor = null;
            Set set = this.cnfgDesc.getTrustedProviders();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    fSProviderDescriptor = allianceManager.getProvider(string, "IDP");
                    if (fSProviderDescriptor == null) continue;
                    string2 = fSProviderDescriptor.getProviderStatus();
                    string3 = fSProviderDescriptor.getProviderRole();
                    string3 = string3.toLowerCase();
                    if (messageEnabled) {
                        FSUtils.debug.message("FSLoginHelper::getIDPs For providerId " + string + " status is " + string2 + " and Role is " + string3);
                    }
                    if (!string2.equals("active") || string3.indexOf(string4) == -1) continue;
                    hashSet.add(string);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSLoginHelper::getIDPs Error in getting idp List", (Throwable)((Object)fSAllianceManagementException));
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper::getIDPs returing idpset as " + hashSet);
        }
        return hashSet;
    }

    private FSAuthnRequest getAuthnReq(Map map, String string, boolean bl) throws FSLoginHelperException {
        FSAuthnRequest fSAuthnRequest = null;
        RequestAuthnContext requestAuthnContext = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = new ArrayList();
        try {
            String string2;
            Object object;
            if (this.isLECPProfile(map)) {
                this.protocolProfile = "http://projectliberty.org/profiles/lecp";
            } else if (this.isWMLProfile(map)) {
                this.protocolProfile = "http://projectliberty.org/profiles/wml-post";
            }
            if (messageEnabled) {
                FSUtils.debug.message("FSLoginHelper::getAuthnReq():Federation profile is:" + this.protocolProfile);
            }
            if (this.respondWithString != null) {
                object = new StringTokenizer(this.respondWithString, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                    arrayList.add(string2);
                }
            } else {
                arrayList = null;
            }
            arrayList2.add(this.authContextString);
            arrayList3 = null;
            object = "minimum";
            requestAuthnContext = new RequestAuthnContext(arrayList2, arrayList3, (String)object);
            string2 = !bl && this.nameIDPolicy.equals("federated") ? "none" : this.nameIDPolicy;
            if (this.anonymousOnetime != null && this.anonymousOnetime.equals("true")) {
                string2 = "onetime";
                bl = true;
            }
            fSAuthnRequest = new FSAuthnRequest(null, arrayList, null, this.hostEntityID, this.forceAuthn, this.isPassive, bl, string2, this.protocolProfile, requestAuthnContext, string, "minimum");
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLoginHelper.getAuthnReq():Error during procesing" + exception.getMessage());
            throw new FSLoginHelperException("FSLoginHelper.getAuthnReq()In Exception " + exception.getMessage());
        }
        return fSAuthnRequest;
    }

    private Map createMap(String string, String string2, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(headerKey, map);
        if (string != null) {
            hashMap.put(URLKey, string);
        } else if (string2 != null) {
            hashMap.put(responseDataKey, string2);
        }
        return hashMap;
    }

    private boolean isLECPProfile(Map map) {
        FSUtils.debug.message("FSLoginHelper.isLECPProfile called");
        if (map != null) {
            String string = (String)map.get("Liberty-Enabled");
            if (string == null) {
                String string2 = "Liberty-Enabled".toLowerCase();
                FSUtils.debug.message("FSLoginHelper.isLECPProfile checking for lower case header: " + string2);
                string = (String)map.get(string2);
            }
            return string != null;
        }
        return false;
    }

    private boolean isWMLProfile(Map map) {
        String string;
        if (map != null && (string = (String)map.get("accept")) != null && string.toLowerCase().indexOf("text/vnd.wap.wml") != -1) {
            FSUtils.debug.message("FSLoginHelper.isWMLProfile() :: true ");
            return true;
        }
        return false;
    }

    private String getTLDURL() {
        String string = null;
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper.getTLDURL() :: called");
        }
        try {
            if (this.cotSet == null || this.cotSet.isEmpty()) {
                FSUtils.debug.error("FSLoginHelper::getTLDURL():Received COT Set is Invalid");
            } else {
                if (this.cotSet.size() > 1) {
                    if (messageEnabled) {
                        FSUtils.debug.message("FSLoginHelper::getTLDURL() Multiple COTs found will do polling ");
                    }
                } else if (messageEnabled) {
                    FSUtils.debug.message("FSLoginHelper::getTLDURL() Single COT found");
                }
                Iterator iterator = this.cotSet.iterator();
                while (iterator.hasNext()) {
                    FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor = allianceManager.getCircleOfTrust((String)iterator.next());
                    if (fSCircleOfTrustDescriptor == null || !fSCircleOfTrustDescriptor.getCircleOfTrustStatus().equalsIgnoreCase("active")) continue;
                    if (messageEnabled) {
                        FSUtils.debug.message("FSLoginHelper::getTLDURL found a active cot with cotid : " + fSCircleOfTrustDescriptor.getCircleOfTrustName());
                    }
                    string = fSCircleOfTrustDescriptor.getReaderServiceURL();
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSLoginHelper.getTLDURL():FSAllianceManagementException:" + fSAllianceManagementException.getMessage());
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLoginHelper.getTLDURL():General Exception:" + exception.getMessage());
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper::getTLDURL().tldURL  " + string);
        }
        return string;
    }

    public String createAuthnRequestEnvelope(HttpServletRequest httpServletRequest) {
        FSUtils.debug.message("FSLoginHelper.createAuthnRequestEnvelope(): called" + httpServletRequest.getParameter("metaAlias"));
        try {
            String string;
            FSAllianceManager fSAllianceManager;
            Object object;
            String string2;
            Object object2;
            String string3 = httpServletRequest.getParameter("metaAlias");
            this.setAllianceInfo(string3, null);
            FSAuthnRequest fSAuthnRequest = null;
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement().toString();
                string2 = httpServletRequest.getHeader((String)object2);
                hashMap.put(object2, string2);
            }
            object2 = this.getIDPs();
            string2 = httpServletRequest.getParameter("RelayState");
            if (string2 == null || string2.equals("")) {
                string2 = LibertyManager.getFederationDonePageURL(this.hostProviderID, "SP", httpServletRequest);
            }
            fSAuthnRequest = this.getAuthnReq(hashMap, string2, true);
            fSAuthnRequest.setMinorVersion(this.hostDescriptor.getMinorVersion());
            if (fSAuthnRequest == null) {
                FSUtils.debug.error("FSLoginHelper.createAuthnRequest()::AuthnRequest is null");
                String string4 = LibertyManager.getProviderID(string3);
                String string5 = this.errorPage;
                string5 = string5 + "&" + "federror" + "=" + AMURLEncDec.encode((String)"Unable to create AuthnRequest") + "&" + "fedremark" + "=" + AMURLEncDec.encode((String)"Please check your Federation Configuration.");
                return string5;
            }
            String string6 = fSAuthnRequest.getRequestID();
            if (messageEnabled) {
                FSUtils.debug.message("FSLoginHelper.createAuthnRequest():: RequestID: " + string6);
            }
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityID);
            fSSessionManager.setAuthnRequest(string6, fSAuthnRequest);
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOToken != null) {
                fSSessionManager.setLocalSSOToken(string6, sSOToken);
            }
            Object var12_15 = null;
            String string7 = null;
            FSAuthnRequestEnvelope fSAuthnRequestEnvelope = null;
            String string8 = null;
            boolean bl = false;
            FSIDPList fSIDPList = null;
            string8 = this.hostDescriptor.getProviderName();
            String string9 = this.hostDescriptor.getAssertionConsumerServiceURL();
            ArrayList<IDPEntry> arrayList = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                string10 = (String)iterator.next();
                if (string10 == null) continue;
                object = allianceManager.getProvider(string10, "IDP");
                string11 = ((FSProviderDescriptor)object).getProviderName();
                string12 = ((FSProviderDescriptor)object).getSSOServiceURL();
                if (arrayList == null) {
                    arrayList = new ArrayList<IDPEntry>();
                }
                arrayList.add(new IDPEntry(string10, string11, string12));
            }
            object = new IDPEntries(arrayList);
            fSIDPList = new FSIDPList((IDPEntries)object, null);
            fSIDPList.setMinorVersion(this.hostDescriptor.getMinorVersion());
            if (FSServiceUtils.isSigningOn() && (fSAllianceManager = FSServiceUtils.getAllianceInstance()).getHostedProvider(string = LibertyManager.getProviderID(string3)).getAuthnRequestSigned()) {
                fSAuthnRequest.signXML(fSAllianceManager.getHostedProvider(string).getSigningKeyAlias());
            }
            fSAuthnRequestEnvelope = new FSAuthnRequestEnvelope(fSAuthnRequest, this.hostEntityID, string8, string9, fSIDPList, bl);
            fSAuthnRequestEnvelope.setMinorVersion(this.hostDescriptor.getMinorVersion());
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest: AuthnRequestEnvelope: " + fSAuthnRequestEnvelope.toXMLString());
            string7 = fSAuthnRequestEnvelope.toXMLString();
            return string7;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLoginHelper.createAuthnRequest(): Exception Occured: " + exception.getMessage());
            return null;
        }
    }

    static {
        if (FSUtils.debug.messageEnabled()) {
            messageEnabled = true;
        }
        allianceManager = FSServiceUtils.getAllianceInstance();
    }
}

