/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.EncryptedNameIdentifier;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.security.SessionSubject;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSDiscoveryBootStrap {
    private AttributeStatement _bootStrapStatement = null;
    private List _assertions = null;
    private SSOToken _ssoToken = null;
    private boolean _hasCredentials = false;

    public FSDiscoveryBootStrap(SSOToken sSOToken, AuthnContext authnContext, FSSubject fSSubject, String string, String string2) throws FSException {
        if (fSSubject == null || string == null) {
            FSUtils.debug.error("FSDiscoBootStrap: null values.");
            throw new FSException("nullInputParameter", null);
        }
        this._ssoToken = sSOToken;
        try {
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            ArrayList<Element> arrayList2 = new ArrayList<Element>();
            Document document = this.getResourceOffering(fSSubject, authnContext, string, string2);
            arrayList2.add(document.getDocumentElement());
            Attribute attribute = new Attribute("DiscoveryResourceOffering", "urn:liberty:disco:2003-08", arrayList2);
            arrayList.add(attribute);
            this._bootStrapStatement = new AttributeStatement(fSSubject, arrayList);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSDiscoBootStrap: Constructorwhile creating discovery bootstrap statement", (Throwable)exception);
            throw new FSException(exception);
        }
    }

    private static synchronized SSOToken getSSOToken() throws SSOException, SessionException {
        return (SSOToken)AccessController.doPrivileged(new AdminTokenAction());
    }

    private Document getResourceOffering(FSSubject fSSubject, AuthnContext authnContext, String string, String string2) throws FSException {
        FSUtils.debug.message("FSDiscoveryBootStrap.getResourceOffering:Init");
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append("saml:").append("AttributeValue").append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"").append(">").append("\n");
        DiscoEntryElement discoEntryElement = DiscoServiceManager.getBootstrappingDiscoEntry();
        if (discoEntryElement == null) {
            throw new FSException("nullDiscoveryOffering", null);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ResourceOfferingType resourceOfferingType = discoEntryElement.getResourceOffering();
            ServiceInstanceType serviceInstanceType = resourceOfferingType.getServiceInstance();
            String string3 = serviceInstanceType.getProviderID();
            if (!DiscoServiceManager.useImpliedResource()) {
                object5 = DiscoServiceManager.getResourceIDMapper(string3);
                if (object5 == null) {
                    object5 = DiscoServiceManager.getDefaultResourceIDMapper();
                }
                object4 = string;
                if (ServiceManager.isConfigMigratedTo70()) {
                    object4 = this._ssoToken.getProperty("sun.am.UniversalIdentifier");
                }
                object3 = new ObjectFactory();
                object2 = object3.createResourceIDType();
                object = object5.getResourceID(string3, (String)object4);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSDiscoveryBootStrap.getResourceOffering: ResourceID Value:" + (String)object);
                }
                object2.setValue((String)object);
                resourceOfferingType.setResourceID((ResourceIDType)object2);
            }
            object5 = new ArrayList();
            object5.add(discoEntryElement);
            object4 = null;
            object4 = DiscoServiceManager.encryptNIinSessionContext() ? new SessionSubject(EncryptedNameIdentifier.getEncryptedNameIdentifier(fSSubject.getNameIdentifier(), string3), fSSubject.getSubjectConfirmation(), fSSubject.getIDPProvidedNameIdentifier()) : new SessionSubject(fSSubject.getNameIdentifier(), fSSubject.getSubjectConfirmation(), fSSubject.getIDPProvidedNameIdentifier());
            object3 = new SessionContext((SessionSubject)object4, authnContext, string3);
            object2 = DiscoUtils.checkPolicyAndHandleDirectives(string, null, (Collection)object5, null, (SessionContext)object3, string2, this._ssoToken);
            object = (List)object2.get("offerings");
            if (object.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSDiscoBootStrap.getResourceOffering:no ResourceOffering");
                }
                throw new FSException("nullDiscoveryOffering", null);
            }
            ResourceOffering resourceOffering = (ResourceOffering)object.get(0);
            this._assertions = (List)object2.get("credentials");
            if (this._assertions != null && this._assertions.size() != 0) {
                this._hasCredentials = true;
            }
            stringBuffer.append(resourceOffering.toString());
            stringBuffer.append("</").append("saml:").append("AttributeValue>");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSDiscoveryBootStap.getResourceOffering:Resource Offering:" + stringBuffer.toString());
            }
            return XMLUtils.toDOMDocument((String)stringBuffer.toString(), null);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSDiscoveryBootStrap.getResourceOffering:Exception while creating resource offering.", (Throwable)exception);
            throw new FSException(exception);
        }
    }

    public boolean hasCredentials() {
        return this._hasCredentials;
    }

    public Advice getCredentials() {
        if (this._assertions != null && this._assertions.size() != 0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this._assertions);
            return new Advice(null, arrayList, null);
        }
        return null;
    }

    public AttributeStatement getBootStrapStatement() {
        return this._bootStrapStatement;
    }
}

