/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSSubject
extends Subject {
    protected IDPProvidedNameIdentifier _idpNameIdentifier;

    protected FSSubject() {
    }

    public FSSubject(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation, IDPProvidedNameIdentifier iDPProvidedNameIdentifier) throws FSMsgException, SAMLException {
        super(nameIdentifier, subjectConfirmation);
        this._idpNameIdentifier = iDPProvidedNameIdentifier;
    }

    public FSSubject(NameIdentifier nameIdentifier, IDPProvidedNameIdentifier iDPProvidedNameIdentifier) throws FSMsgException, SAMLException {
        super(nameIdentifier);
        this._idpNameIdentifier = iDPProvidedNameIdentifier;
    }

    public FSSubject(Element element) throws FSMsgException, SAMLException {
        FSUtils.debug.message("FSSubject(Element): Called");
        int n = 0;
        Element element2 = element;
        String string = element2.getLocalName();
        String string2 = element2.getNamespaceURI();
        if (string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: local name missing");
            }
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!string.equals("Subject")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: invalid root element");
            }
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        if (n2 == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: No sub elements found");
            }
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("emptyElement"));
        }
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1) {
                String string3 = node.getLocalName();
                if (string3.equals("NameIdentifier")) {
                    this.setNameIdentifier(new NameIdentifier((Element)node));
                    ++n;
                } else if (string3.equals("SubjectConfirmation")) {
                    this.setSubjectConfirmation(new SubjectConfirmation((Element)node));
                    ++n;
                } else if (string3.equals("IDPProvidedNameIdentifier")) {
                    this._idpNameIdentifier = new IDPProvidedNameIdentifier((Element)node);
                    ++n;
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSubject: Invalid element encountered.");
                    }
                    throw new FSMsgException(SAMLUtilsCommon.bundle.getString("invalidElement"));
                }
            }
            ++n3;
        }
        if (n > 3) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: more than allowed elements passed");
            }
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("moreElement"));
        }
        FSUtils.debug.message("FSSubject(Element): leaving");
    }

    public FSSubject(SubjectConfirmation subjectConfirmation) throws SAMLException {
        super(subjectConfirmation);
    }

    public boolean setIDPProvidedNameIdentifier(IDPProvidedNameIdentifier iDPProvidedNameIdentifier) {
        if (iDPProvidedNameIdentifier == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject:  null IDPProvidedNameIdentifier specified");
            }
            return false;
        }
        this._idpNameIdentifier = iDPProvidedNameIdentifier;
        return true;
    }

    public IDPProvidedNameIdentifier getIDPProvidedNameIdentifier() {
        return this._idpNameIdentifier;
    }

    public String toXMLString() throws FSMsgException {
        String string = this.toXMLString(true, false);
        return string;
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl) {
            string = "saml:";
            string2 = "lib:";
        }
        if (bl2) {
            string3 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            string4 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        stringBuffer.append("<").append(string).append("Subject").append(" ").append(string3).append(" ").append(string4).append(" ").append("xsi:type").append("=\"").append(string2).append("SubjectType").append("\"").append(">");
        if (this.getNameIdentifier() != null) {
            stringBuffer.append(this.getNameIdentifier().toString(bl, false));
        }
        if (this.getSubjectConfirmation() != null) {
            stringBuffer.append(this.getSubjectConfirmation().toString(bl, false));
        }
        if (this._idpNameIdentifier != null) {
            stringBuffer.append(this._idpNameIdentifier.toXMLString(bl, false));
        }
        stringBuffer.append("</").append(string).append("Subject").append(">");
        return stringBuffer.toString();
    }
}

