/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FSAuthnResponse
extends Response {
    private String providerId = null;
    protected String relayState = null;
    protected String consentURI = null;
    protected int minorVersion = 0;
    protected String id = null;
    protected Element domElement = null;

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String string) {
        this.providerId = string;
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public String getConsentURI() {
        return this.consentURI;
    }

    public void setConsentURI(String string) {
        this.consentURI = string;
    }

    public Element getDOMElement() {
        return this.domElement;
    }

    public FSAuthnResponse(String string, String string2, List list, Status status, List list2, String string3) throws SAMLException {
        super(string, string2, status, list2);
        this.setIssueInstant(new Date());
        this.relayState = string3;
    }

    public FSAuthnResponse(String string, String string2, Status status, List list, String string3) throws SAMLException, FSMsgException {
        super(string, string2, status, list);
        this.setIssueInstant(new Date());
        this.relayState = string3;
    }

    public static FSAuthnResponse parseAuthnResponseXML(String string) throws SAMLException, FSMsgException {
        FSUtils.debug.message("FSAuthnResponse.parseAuthnResponseXML: Called");
        Document document = XMLUtils.toDOMDocument((String)string, (Debug)FSUtils.debug);
        if (document == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse.parseXML:Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null);
        }
        Element element = document.getDocumentElement();
        return new FSAuthnResponse(element);
    }

    public FSAuthnResponse(Element element) throws SAMLException, FSMsgException {
        String string;
        FSUtils.debug.message("FSAuthnResponse(Element): Called");
        if (element == null) {
            FSUtils.debug.message("FSAuthnResponse(Element): Input paramenter (root) is null");
            throw new FSMsgException(FSUtils.bundle.getString("nullInput"));
        }
        String string2 = null;
        string2 = element.getLocalName();
        if (string2 == null || !string2.equals("AuthnResponse")) {
            FSUtils.debug.message("FSAuthnResponse(Element): Root element name is not AuthnResponse");
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        this.domElement = element;
        this.consentURI = element.getAttribute("consent");
        this.id = element.getAttribute("id");
        this.responseID = element.getAttribute("ResponseID");
        if (this.responseID == null || this.responseID.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): AuthnResponse doesn't have ResponseID attribute");
            }
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute"));
        }
        this.inResponseTo = element.getAttribute("InResponseTo");
        if (this.inResponseTo == null && FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnResponse(Element): AuthnResponse doesn't have InResponseTo attribute");
        }
        if ((string = element.getAttribute("IssueInstant")) == null || string.equals("")) {
            FSUtils.debug.message("FSAuthnResponse(Element): missing IssueInstant");
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute"));
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)string);
        }
        catch (ParseException parseException) {
            FSUtils.debug.message("FSAuthnResponse(Element): could not parse IssueInstant", (Throwable)parseException);
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        this.setRecipient(element.getAttribute("Recipient"));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 != null && !string3.equals("Signature")) {
                if (string3.equals("Status")) {
                    if (this.status != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthnResponse(Element): included more than one <Status>");
                        }
                        throw new FSMsgException(FSUtils.bundle.getString("moreElement"));
                    }
                    this.status = new Status((Element)node);
                } else if (string3.equals("Assertion")) {
                    if (this.assertions == Collections.EMPTY_LIST) {
                        this.assertions = new ArrayList();
                    }
                    this.assertions.add(new FSAssertion((Element)node));
                } else if (string3.equals("RelayState")) {
                    if (this.relayState != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthnResponse(Element): should contain only one RelayState.");
                        }
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.relayState = XMLUtils.getElementValue((Element)((Element)node));
                } else if (string3.equals("ProviderID")) {
                    if (this.providerId != null && !this.providerId.equals("")) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthnResponse(Element): shouldcontain only one ProviderID.");
                        }
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.providerId = XMLUtils.getElementValue((Element)((Element)node));
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthnResponse(Element): included wrong element: " + string3);
                    }
                    throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                }
            }
            ++n2;
        }
        if (this.status == null) {
            FSUtils.debug.message("FSAuthnResponse(Element): missing element <Status>.");
            throw new FSMsgException(FSUtils.bundle.getString("missingElement"));
        }
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n3 = list.size();
        if (n3 == 1) {
            Element element2 = (Element)list.get(0);
            this.setSignature(element2);
            this.xmlString = XMLUtils.print((Node)element);
            this.signed = true;
        } else if (n3 != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): included more than one Signature element.");
            }
            throw new FSMsgException(FSUtils.bundle.getString("moreElement"));
        }
    }

    private void parseMajorVersion(String string) throws SAMLException, FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): invalid MajorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnResponse(Element):MajorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException(FSUtils.bundle.getString("responseVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element):MajorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException(FSUtils.bundle.getString("responseVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws SAMLException, FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): invalid MinorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        if (this.minorVersion == 2 || this.minorVersion == 0) {
            return;
        }
        if (this.minorVersion > 2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse.checkMinorVersion: Minor Version of the AuthnResponse is too high.");
            }
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnResponse.checkMinorVersion: Minor Version of the AuthnResponse is too low.");
        }
        throw new FSMsgException("requestVersionTooLow", null);
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        FSUtils.debug.message("FSAuthnResponse.toXMLString(3): Called");
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSAuthnResponse.toXMLString: providerId is null ");
            throw new FSMsgException(FSUtils.bundle.getString("nullProviderID"));
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (bl) {
            string2 = "lib:";
            string = "saml:";
            string3 = "samlp:";
        }
        if (bl2) {
            string6 = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string5 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            string4 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
            string7 = "xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"";
            string8 = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        String string9 = DateUtils.toUTCDateFormat((Date)this.issueInstant);
        if (this.responseID != null && this.inResponseTo != null) {
            stringBuffer.append("<").append(string2).append("AuthnResponse").append(string6).append(string5).append(string4).append(" ").append(string7).append(" ").append(string8).append(" ResponseID=\"").append(this.responseID).append("\" ");
            if (this.inResponseTo != null && !this.inResponseTo.equals("")) {
                stringBuffer.append(" InResponseTo=\"").append(this.inResponseTo).append("\" ");
            }
            if (this.minorVersion == 0 && this.id != null && !this.id.equals("")) {
                stringBuffer.append(" id=\"").append(this.id).append("\"");
            }
            stringBuffer.append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ");
            stringBuffer.append(" IssueInstant=\"").append(string9).append("\"");
            if (this.consentURI != null) {
                stringBuffer.append(" consent=\"").append(this.consentURI).append("\" ");
            }
            if (this.recipient != null && !this.recipient.equals("")) {
                stringBuffer.append(" Recipient=\"").append(this.recipient).append("\" ");
            }
            stringBuffer.append(">");
        }
        if (this.signed) {
            if (this.signatureString != null && !this.signatureString.equals("")) {
                stringBuffer.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print((Node)this.signature);
                stringBuffer.append(this.signatureString);
            }
        }
        if (this.status != null) {
            stringBuffer.append(this.status.toString(bl, false));
        }
        if (this.assertions != null && this.assertions != Collections.EMPTY_LIST) {
            Iterator iterator = this.assertions.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((FSAssertion)iterator.next()).toXMLString(true, bl2));
            }
        }
        stringBuffer.append("<").append(string2).append("ProviderID").append(">").append(this.providerId).append("</").append(string2).append("ProviderID").append(">");
        if (this.relayState != null && !this.relayState.equals("")) {
            stringBuffer.append("<").append(string2).append("RelayState").append(">").append(this.relayState).append("</").append(string2).append("RelayState").append(">");
        }
        stringBuffer.append("</").append(string2).append("AuthnResponse>\n");
        return stringBuffer.toString();
    }

    public static FSAuthnResponse parseBASE64EncodedString(String string) throws FSMsgException, SAMLException {
        FSUtils.debug.message("FSAuthnResponse.parseBASE64EncodedString: Called new");
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        if (string != null) {
            try {
                String string2 = new String(bASE64Decoder.decodeBuffer((InputStream)new ByteArrayInputStream(string.getBytes())));
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnResponse.parseBASE64EncodedString: Decoded AuthnResponse message: \n" + string2);
                }
                return FSAuthnResponse.parseAuthnResponseXML(string2);
            }
            catch (IOException iOException) {
                FSUtils.debug.error("FSAuthnResponse.parseBASE64EncodedString: IOException caused at the time of decoding");
                throw new FSMsgException(iOException, "IOException occured");
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnResponse.parseBASE64EncodedString: null String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public String toBASE64EncodedString() throws FSMsgException {
        FSUtils.debug.message("FSAuthnResponse.toBASE64EncodedString: Called");
        if (this.responseID == null || this.responseID.equals("")) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                FSUtils.debug.error("FSAuthnResponse.toBASE64EncodedString: couldn't generate ResponseID.");
                throw new FSMsgException(FSUtils.bundle.getString("errorGenerateID"));
            }
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(this.toXMLString(true, true).getBytes());
    }

    public void signXML(String string) throws SAMLException {
        FSUtils.debug.message("FSAuthnResponse.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("alreadySigned"));
        }
        if (string == null || string.equals("")) {
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        try {
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "ResponseID", this.getResponseID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception exception) {
            throw new SAMLResponderException(FSUtils.bundle.getString("Exception") + " : " + exception.getMessage());
        }
    }

    public boolean setSignature(Element element) {
        this.signatureString = XMLUtils.print((Node)element);
        return super.setSignature(element);
    }
}

