/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.common.DateUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorityBinding;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.common.SAMLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FSAuthenticationStatement
extends AuthenticationStatement {
    protected Date reauthenticateOnOrAfter;
    protected String sessionIndex = null;
    protected AuthnContext _authnContext;
    protected int minorVersion = 0;

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String string) {
        this.sessionIndex = string;
    }

    public Date getReauthenticateOnOrAfter() {
        return this.reauthenticateOnOrAfter;
    }

    public void setReauthenticateOnOrAfter(Date date) {
        this.reauthenticateOnOrAfter = date;
    }

    public AuthnContext getAuthnContext() {
        return this._authnContext;
    }

    public void setAuthnContext(AuthnContext authnContext) {
        this._authnContext = authnContext;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public FSAuthenticationStatement() {
    }

    public FSAuthenticationStatement(String string, Date date, Subject subject, AuthnContext authnContext) throws FSMsgException, SAMLException {
        super(string, date, subject);
        if (authnContext == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthenticationStatement: missingAuthnContext");
            }
        } else {
            this._authnContext = authnContext;
        }
    }

    public FSAuthenticationStatement(String string, Date date, Subject subject, SubjectLocality subjectLocality, List list, AuthnContext authnContext) throws FSMsgException, SAMLException {
        super(string, date, subject, subjectLocality, list);
        if (authnContext == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthenticationStatement: missingAuthnContext.");
            }
        } else {
            this._authnContext = authnContext;
        }
    }

    public FSAuthenticationStatement(Element element) throws FSMsgException, SAMLException {
        Object object;
        FSUtils.debug.message("FSAuthenticationStatement(Element):  Called");
        if (element == null) {
            FSUtils.debug.message("FSAuthenticationStatement: null input.");
            throw new FSMsgException("nullInput", null);
        }
        int n = 0;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        n = 0;
        while (n < n2) {
            object = namedNodeMap.item(n);
            if (object.getNodeType() == 2) {
                String string = object.getLocalName();
                if (string == null || string.equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthenticationStatement:Attribute name is either null or empty.");
                    }
                    throw new FSMsgException("nullInput", null);
                }
                if (string.equals("AuthenticationMethod")) {
                    this._authenticationMethod = ((Attr)object).getValue().trim();
                } else if (string.equals("AuthenticationInstant")) {
                    try {
                        this._authenticationInstant = DateUtils.stringToDate((String)((Attr)object).getValue());
                    }
                    catch (ParseException parseException) {
                        FSUtils.debug.error("FSAuthenticationStatement:StringToDate: ", (Throwable)parseException);
                        throw new FSMsgException("wrongDateFormat", null);
                    }
                } else if (string.equals("ReauthenticateOnOrAfter")) {
                    try {
                        this.reauthenticateOnOrAfter = DateUtils.stringToDate((String)((Attr)object).getValue());
                    }
                    catch (ParseException parseException) {
                        FSUtils.debug.error("FSAuthenticationStatement:StringToDate: ", (Throwable)parseException);
                        throw new FSMsgException("wrongDateFormat", null);
                    }
                } else if (string.equals("SessionIndex")) {
                    this.sessionIndex = ((Attr)object).getValue().trim();
                }
            }
            ++n;
        }
        object = element.getChildNodes();
        int n3 = object.getLength();
        if (n3 > 0) {
            n = 0;
            while (n < n3) {
                Node node = object.item(n);
                if (node.getNodeType() == 1) {
                    String string = node.getLocalName();
                    String string2 = node.getNamespaceURI();
                    if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthenticationStatement: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new FSMsgException("nullInput", null);
                    }
                    if (string.equals("Subject")) {
                        if (this._subject != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSAuthenticationStatement:should only contain one subject");
                            }
                            throw new FSMsgException("oneElement", null);
                        }
                        this._subject = new FSSubject((Element)node);
                    } else if (string.equals("SubjectLocality")) {
                        if (this._subjectLocality != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSAuthenticationStatementStatement: should at most contain one SubjectLocality.");
                            }
                            throw new FSMsgException("oneElement", null);
                        }
                        this._subjectLocality = new SubjectLocality((Element)node);
                    } else if (string.equals("AuthnContext") && (string2.equals("http://projectliberty.org/schemas/core/2002/12") || string2.equals("urn:liberty:iff:2003-08"))) {
                        if (this._authnContext != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSAuthenticationStatement: should not contain more than one AuthnContext element.");
                            }
                            throw new FSMsgException("oneElement", null);
                        }
                        this._authnContext = new AuthnContext((Element)node);
                    } else if (string.equals("AuthorityBinding")) {
                        if (this._authorityBinding == null) {
                            this._authorityBinding = new ArrayList();
                        }
                        if (!this._authorityBinding.add(new AuthorityBinding((Element)node))) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSAuthenticationStatement: failed to add to the AuthorityBinding list.");
                            }
                            throw new FSMsgException("addListError", null);
                        }
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthenticationStatement:Wrong element " + string + "included.");
                        }
                        throw new FSMsgException("wrongInput", null);
                    }
                }
                ++n;
            }
        }
        if (this._subject == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthenticationStatement should contain one subject.");
            }
            throw new FSMsgException("missingElement", null);
        }
        FSUtils.debug.message("FSAuthenticationStatement(Element): leaving");
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl) {
            string = "saml:";
            string2 = "lib:";
        }
        if (bl2) {
            string4 = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string3 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("AuthenticationStatement").append(string3).append(" ").append(string4).append(" ");
        if (this._authenticationMethod != null && !this._authenticationMethod.equals("")) {
            stringBuffer.append("AuthenticationMethod=\"").append(this._authenticationMethod).append("\" ");
        }
        if (this._authenticationInstant != null) {
            stringBuffer.append("AuthenticationInstant=\"").append(DateUtils.toUTCDateFormat((Date)this._authenticationInstant)).append("\" ");
        }
        if (this.reauthenticateOnOrAfter != null) {
            stringBuffer.append("ReauthenticateOnOrAfter=\"").append(DateUtils.toUTCDateFormat((Date)this.reauthenticateOnOrAfter)).append("\" ");
        }
        if (this.sessionIndex != null) {
            stringBuffer.append("SessionIndex=\"").append(this.sessionIndex).append("\" ");
        }
        stringBuffer.append("xsi:type").append("=\"").append(string2).append("AuthenticationStatementType").append("\"").append(">");
        if (this.getSubject() != null) {
            stringBuffer.append(((FSSubject)this.getSubject()).toXMLString(bl, false));
        }
        if (this._subjectLocality != null) {
            stringBuffer.append(this._subjectLocality.toString(bl, false));
        }
        if (this._authorityBinding != null && !this._authorityBinding.isEmpty()) {
            Iterator iterator = this.getAuthorityBinding().iterator();
            while (iterator.hasNext()) {
                AuthorityBinding authorityBinding = (AuthorityBinding)iterator.next();
                stringBuffer.append(authorityBinding.toString(bl, false));
            }
        }
        if (this._authnContext != null) {
            stringBuffer.append(this._authnContext.toXMLString(bl, false));
        }
        stringBuffer.append("</").append(string).append("AuthenticationStatement").append(">");
        return stringBuffer.toString();
    }
}

