/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.IFSConstants;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.net.URL;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Encoder;

public class FSUtils {
    public static String deploymentURI = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
    public static boolean logStatus = false;
    public static final String BUNDLE_NAME = "amFederation";
    public static IFSConstants sc;
    public static ResourceBundle bundle;
    public static Debug debug;
    private static SecureRandom random;
    public static final String FSID_PREFIX = "f";
    private static BASE64Encoder encoder;
    private static Object lock;

    private FSUtils() {
    }

    public static void setLocale(String string) {
        try {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getLocale((String)string));
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getMessage());
            System.exit(1);
        }
    }

    public static String generateID() {
        if (random == null) {
            return null;
        }
        byte[] byArray = new byte[20];
        random.nextBytes(byArray);
        String string = FSID_PREFIX + FSUtils.byteArrayToHexString(byArray);
        if (debug.messageEnabled()) {
            debug.message("FSUtils.generateID: generated id is " + string);
        }
        return string;
    }

    public static String generateSourceID(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            debug.error("FSUtils.generateSourceID: Exception:", (Throwable)exception);
            return null;
        }
        byte[] byArray = string.getBytes();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        String string2 = null;
        String string3 = null;
        try {
            BASE64Encoder bASE64Encoder = encoder;
            synchronized (bASE64Encoder) {
                string2 = encoder.encodeBuffer(byArray2).trim();
            }
            string3 = string2.substring(0, 20);
        }
        catch (Exception exception) {
            debug.error("FSUtils:generateSourceID: exception:", (Throwable)exception);
        }
        return string3;
    }

    public static String generateAssertionHandle() {
        String string = null;
        String string2 = FSUtils.generateID();
        if (string2 != null) {
            try {
                string = string2.substring(0, 20);
            }
            catch (Exception exception) {
                debug.error("FSUtil.generateAssertionHandle:" + exception.getMessage());
            }
        }
        return string;
    }

    public static byte[] hexStringToByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            String string2 = string.substring(n, n + 2);
            if (string2.equals("FF")) {
                byArray[n2] = -1;
            } else {
                try {
                    byArray[n2] = (byte)Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("FSUtils.hexStringToByteArray: Failed " + numberFormatException.getMessage());
                    return null;
                }
            }
            n += 2;
            ++n2;
        }
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(Integer.toHexString(0xFF & byArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String hexStringToBase64(String string) {
        String string2;
        block7: {
            int n = string.length();
            byte[] byArray = new byte[n / 2];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                string2 = string.substring(n2, n2 + 2);
                byArray[n3] = new Short(Integer.toString(Integer.parseInt(string2, 16))).byteValue();
                ++n2;
                ++n2;
                ++n3;
            }
            string2 = null;
            try {
                BASE64Encoder bASE64Encoder = encoder;
                synchronized (bASE64Encoder) {
                    string2 = encoder.encodeBuffer(byArray).trim();
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block7;
                debug.message("SAMLUtil:hexStringToBase64: exception encode input:", (Throwable)exception);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("base 64 source id is :" + string2);
        }
        return string2;
    }

    public static void checkHTTPRequestLength(HttpServletRequest httpServletRequest) throws ServletException {
        int n = SAMLUtils.getMaxContentLength();
        if (n != 0) {
            int n2 = httpServletRequest.getContentLength();
            if (n2 == -1) {
                throw new ServletException(bundle.getString("unknownLength"));
            }
            if (n2 > n) {
                if (debug.messageEnabled()) {
                    debug.message("FSUtils.checkHTTPRequestLength: content length too large" + n2);
                }
                throw new ServletException(bundle.getString("largeContentLength"));
            }
        }
    }

    public static void forwardRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        Object object;
        debug.message("FSUtils.forwardRequest: called");
        String string2 = null;
        try {
            object = SSOTokenManager.getInstance();
            SSOToken sSOToken = object.createSSOToken(httpServletRequest);
            if (sSOToken != null && object.isValidToken(sSOToken)) {
                string2 = sSOToken.encodeURL(string);
            }
        }
        catch (SSOException sSOException) {
            if (debug.messageEnabled()) {
                debug.message("FSUtils.forwardReqeust: couldn't rewrite url: ");
            }
            string2 = null;
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            object = httpServletRequest.getServerName();
            int n = httpServletRequest.getServerPort();
            debug.message("FSUtils.forwardRequest: SourceHost=" + (String)object + " SourcePort=" + n);
            URL uRL = new URL(string2);
            String string3 = uRL.getHost();
            int n2 = uRL.getPort();
            debug.message("FSUtils.forwardRequest: targetHost=" + string3 + " targetPort=" + n2);
            boolean bl = false;
            String string4 = SystemProperties.get((String)"com.sun.identity.webcontainer");
            if (string4 != null && string4.indexOf("IBM") != -1) {
                bl = true;
            }
            int n3 = string2.indexOf(deploymentURI);
            if (!((String)object).equals(string3) || n != n2 || n3 <= 0 || bl) {
                debug.message("FSUtils.forwardRequest: Source and Target are not on the same container. Redirecting to target");
                httpServletResponse.sendRedirect(string2);
                return;
            }
            String string5 = string2.substring(n3 + deploymentURI.length());
            if (debug.messageEnabled()) {
                debug.message("FSUtils.forwardRequest: Forwarding to :" + string5);
            }
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string5);
            try {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Exception exception) {
                debug.error("FSUtils.forwardRequest: Exception occured while trying to forward to resource" + string5, (Throwable)exception);
            }
        }
        catch (Exception exception) {
            debug.error("FSUtils.forwardRequest: Exception occured", (Throwable)exception);
        }
    }

    public static byte[] generateSuccintID(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return byArray2;
    }

    public static String getProviderIDFromSuccintID(String string) {
        if (string == null) {
            return null;
        }
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProviderBySuccinctID(string);
            if (fSProviderDescriptor != null) {
                return fSProviderDescriptor.getEntityID();
            }
            return null;
        }
        catch (Exception exception) {
            debug.error("FSUtils.getProviderIDFromSuccintID::", (Throwable)exception);
            return null;
        }
    }

    public static String findPreferredIDP(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        String string = httpServletRequest.getParameter("_liberty_idp");
        if (string == null || string.equals("")) {
            if (debug.messageEnabled()) {
                debug.message("FSUtils.findPreferredIDP::Pref IDP not found.");
            }
            return null;
        }
        string = string.trim();
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.length() >= 28) continue;
            string2 = string2 + "+" + stringTokenizer.nextToken();
        }
        string2 = SAMLUtilsCommon.byteArrayToHexString(Base64.decode(string2));
        return FSUtils.getProviderIDFromSuccintID(string2);
    }

    public static String removeNewLineChars(String string) {
        String string2 = null;
        if (string != null && string.length() > 0 && string.indexOf(10) != -1) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c != '\n') {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    public static String getEntityID(String string) {
        int n = string.indexOf("|");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String appendProviderSuffix(String string, String string2) {
        if (string != null && !string.endsWith("|" + string2)) {
            return string + "|" + string2;
        }
        return string;
    }

    static {
        String string = SystemProperties.get((String)"com.iplanet.am.logstatus");
        if (string == null) {
            string = "INACTIVE";
        }
        if (string.equalsIgnoreCase("ACTIVE") && WebtopNaming.isServerMode()) {
            logStatus = true;
        }
        bundle = Locale.getInstallResourceBundle((String)BUNDLE_NAME);
        debug = Debug.getInstance((String)BUNDLE_NAME);
        random = new SecureRandom();
        encoder = new BASE64Encoder();
        lock = new Object();
    }
}

