/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.common;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.common.FSUtils;

public class FSCommonManager {
    private static FSCommonManager instance = new FSCommonManager();
    private SSOToken ssoToken = null;

    private FSCommonManager() {
        try {
            this.setSSOToken();
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSCommonManager", (Throwable)sSOException);
        }
        catch (SessionException sessionException) {
            FSUtils.debug.error("FSCommonManager", (Throwable)sessionException);
        }
    }

    static FSCommonManager getInstance() {
        return instance;
    }

    SSOToken getSSOToken() {
        return this.ssoToken;
    }

    private void setSSOToken() throws SSOException, SessionException {
        String string = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        SessionService sessionService = SessionService.getSessionService();
        Session session = sessionService.getAuthenticationSession(string, null);
        if (session == null) {
            FSUtils.debug.error("FSCommonManager: getSSOToken failed to get auth session");
            throw new SessionException(SessionBundle.rbName, "sessionNotObtained", null);
        }
        session.setProperty("Principal", session.getClientID());
        session.setProperty("Organization", string);
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        this.ssoToken = sSOTokenManager.createSSOToken(session.getID().toString());
    }
}

