/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.common.validation.PositiveIntegerValidator;
import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import java.util.HashMap;
import java.util.Map;

public class FSSPAuthenticationContextInfo {
    private String authenticationContext = null;
    private int authenticationLevel = 1;

    public FSSPAuthenticationContextInfo() {
    }

    FSSPAuthenticationContextInfo(Map map) throws FSAllianceManagementException {
        this.setAuthenticationContext(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authentication-context"));
        this.setAuthenticationLevel(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authentication-context-level"));
    }

    public FSSPAuthenticationContextInfo(String string, int n) throws FSAllianceManagementException {
        this.setAuthenticationContext(string);
        this.setAuthenticationLevel(n);
    }

    public FSSPAuthenticationContextInfo(String string, String string2) throws FSAllianceManagementException {
        this.setAuthenticationContext(string);
        this.setAuthenticationLevel(string2);
    }

    public String getAuthenticationContext() {
        return this.authenticationContext;
    }

    public void setAuthenticationContext(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_auth_context", null);
        }
        this.authenticationContext = string;
    }

    public int getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public void setAuthenticationLevel(int n) throws FSAllianceManagementException {
        if (n < 0) {
            throw new FSAllianceManagementException("alliance_management_invalid_auth_level", null);
        }
        this.authenticationLevel = n;
    }

    public void setAuthenticationLevel(String string) throws FSAllianceManagementException {
        PositiveIntegerValidator positiveIntegerValidator = PositiveIntegerValidator.getInstance();
        try {
            positiveIntegerValidator.validate(string);
            this.authenticationLevel = Integer.parseInt(string);
        }
        catch (ValidationException validationException) {
            throw new FSAllianceManagementException("alliance_management_invalid_auth_level", null);
        }
    }

    Map getAttributes() {
        HashMap hashMap = new HashMap();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authentication-context", this.authenticationContext);
        String string = String.valueOf(this.authenticationLevel);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authentication-context-level", string);
        return hashMap;
    }
}

