/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.common.validation.URLValidator;
import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.common.FSUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class FSOrganization {
    private String orgID = null;
    private Set orgName = null;
    private Set orgDisplayName = null;
    private Set orgURL = null;
    private String extension = "";

    public FSOrganization(String string) throws FSAllianceManagementException {
        this.setOrgID(string);
    }

    FSOrganization(String string, Map map, boolean bl) throws FSAllianceManagementException {
        this.setOrgID(string);
        if (bl) {
            this.setOrgName((Set)map.get("sunIdentityServerProviderOrgName"));
            this.setOrgDisplayName((Set)map.get("sunIdentityServerProviderOrgDisplayName"));
            this.setOrgURL((Set)map.get("sunIdentityServerProviderOrgURL"));
            this.setExtension(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerProviderOrgExtension"));
        } else {
            this.setOrgName((Set)map.get("sunIdentityServerOrgName"));
            this.setOrgDisplayName((Set)map.get("sunIdentityServerOrgDisplayName"));
            this.setOrgURL((Set)map.get("sunIdentityServerOrgURL"));
            this.setExtension(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerOrgExtension"));
        }
    }

    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String string) throws FSInvalidNameException {
        if (string == null || string.trim().length() == 0) {
            throw new FSInvalidNameException(FSUtils.bundle.getString("organization-id-invalid"));
        }
        this.orgID = string;
    }

    public Set getOrgName() {
        return this.orgName;
    }

    public void setOrgName(Set set) throws FSAllianceManagementException {
        if (this.orgName == null) {
            this.orgName = new HashSet();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isOrgNameValid(string)) continue;
            throw new FSAllianceManagementException("organization-name-invalid", null);
        }
        this.orgName = set;
    }

    private boolean isOrgNameValid(String string) {
        boolean bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl2 = bl = stringTokenizer.countTokens() == 2;
        if (bl) {
            String string2 = stringTokenizer.nextToken().trim();
            boolean bl3 = bl = string2.length() > 0;
            if (bl) {
                string2 = stringTokenizer.nextToken().trim();
                bl = string2.length() > 0;
            }
        }
        return bl;
    }

    private boolean isOrgURLValid(String string) {
        boolean bl;
        URLValidator uRLValidator = URLValidator.getInstance();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl2 = bl = stringTokenizer.countTokens() == 2;
        if (bl) {
            String string2 = stringTokenizer.nextToken().trim();
            boolean bl3 = bl = string2.length() > 0;
            if (bl) {
                string2 = stringTokenizer.nextToken().trim();
                try {
                    uRLValidator.validate(string2);
                }
                catch (ValidationException validationException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public Set getOrgDisplayName() {
        return this.orgDisplayName;
    }

    public void setOrgDisplayName(Set set) throws FSAllianceManagementException {
        if (this.orgDisplayName == null) {
            this.orgDisplayName = new HashSet();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isOrgNameValid(string)) continue;
            throw new FSAllianceManagementException("organization-display-name-invalid", null);
        }
        this.orgDisplayName = set;
    }

    public Set getOrgURL() {
        return this.orgURL;
    }

    public void setOrgURL(Set set) throws FSAllianceManagementException {
        if (this.orgURL == null) {
            this.orgURL = new HashSet();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isOrgURLValid(string)) continue;
            throw new FSAllianceManagementException("organization-url-invalid", null);
        }
        this.orgURL = set;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    Map getAttributes(boolean bl) {
        HashMap hashMap = new HashMap();
        if (bl) {
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerProviderOrgName", this.orgName);
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerProviderOrgDisplayName", this.orgDisplayName);
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerProviderOrgURL", this.orgURL);
            FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProviderOrgExtension", this.extension);
        } else {
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerOrgName", this.orgName);
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerOrgDisplayName", this.orgDisplayName);
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerOrgURL", this.orgURL);
            FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerOrgExtension", this.extension);
        }
        return hashMap;
    }
}

